/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.client.editor.processing;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11456;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_637;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.papierkorb2292.command_crafter.client.ClientCommandCrafter;
import net.papierkorb2292.command_crafter.editor.MinecraftLanguageServer;
import net.papierkorb2292.command_crafter.editor.processing.AnalyzingResourceCreator;
import net.papierkorb2292.command_crafter.editor.processing.ContextCompletionProvider;
import net.papierkorb2292.command_crafter.editor.processing.helper.CompletionItemsContainer;
import net.papierkorb2292.command_crafter.helper.UtilKt;
import net.papierkorb2292.command_crafter.parser.DirectiveStringReader;
import net.papierkorb2292.command_crafter.parser.languages.VanillaLanguage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%JE\u00100\u001a\b\u0012\u0004\u0012\u00020/0.2\u0012\u0010'\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030&0\u00182\u0006\u0010)\u001a\u00020(2\u0006\u0010+\u001a\u00020*2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030,H\u0016\u00a2\u0006\u0004\b0\u00101J!\u00102\u001a\b\u0012\u0004\u0012\u00020/0.2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030,H\u0016\u00a2\u0006\u0004\b2\u00103R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00104R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u00105\u00a8\u00066"}, d2={"Lnet/papierkorb2292/command_crafter/client/editor/processing/AnalyzingClientCommandSource;", "Lnet/minecraft/class_2172;", "Lnet/minecraft/class_11456;", "Lnet/minecraft/class_637;", "clientCommandSource", "", "hasNetworkHandler", "<init>", "(Lnet/minecraft/class_637;Z)V", "Lnet/minecraft/class_310;", "minecraftClient", "(Lnet/minecraft/class_310;)V", "", "", "getPlayerNames", "()Ljava/util/Collection;", "getTeamNames", "", "getEntitySuggestions", "Ljava/util/stream/Stream;", "Lnet/minecraft/class_2960;", "getSoundIds", "()Ljava/util/stream/Stream;", "", "Lnet/minecraft/class_5321;", "Lnet/minecraft/class_1937;", "getWorldKeys", "()Ljava/util/Set;", "Lnet/minecraft/class_5455;", "getRegistryManager", "()Lnet/minecraft/class_5455;", "Lnet/minecraft/class_7699;", "getEnabledFeatures", "()Lnet/minecraft/class_7699;", "", "level", "hasPermissionLevel", "(I)Z", "Lnet/minecraft/class_2378;", "registryRef", "Lnet/minecraft/class_2172$class_7078;", "suggestedIdType", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "builder", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "listIdSuggestions", "(Lnet/minecraft/class_5321;Lnet/minecraft/class_2172$class_7078;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;Lcom/mojang/brigadier/context/CommandContext;)Ljava/util/concurrent/CompletableFuture;", "getCompletions", "(Lcom/mojang/brigadier/context/CommandContext;)Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraft/class_637;", "Z", "command-crafter_client"})
@Environment(value=EnvType.CLIENT)
public final class AnalyzingClientCommandSource
implements class_2172,
class_11456 {
    @NotNull
    private final class_637 clientCommandSource;
    private final boolean hasNetworkHandler;

    public AnalyzingClientCommandSource(@NotNull class_637 clientCommandSource, boolean hasNetworkHandler) {
        Intrinsics.checkNotNullParameter((Object)clientCommandSource, (String)"clientCommandSource");
        this.clientCommandSource = clientCommandSource;
        this.hasNetworkHandler = hasNetworkHandler;
    }

    public AnalyzingClientCommandSource(@NotNull class_310 minecraftClient) {
        Intrinsics.checkNotNullParameter((Object)minecraftClient, (String)"minecraftClient");
        class_634 class_6342 = minecraftClient.method_1562();
        if (class_6342 == null || (class_6342 = class_6342.method_2875()) == null) {
            class_6342 = new class_637(null, minecraftClient, true);
        }
        this((class_637)class_6342, minecraftClient.method_1562() != null);
    }

    @NotNull
    public Collection<String> method_9262() {
        Collection collection;
        if (this.hasNetworkHandler) {
            Collection collection2 = this.clientCommandSource.method_9262();
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getPlayerNames(...)");
        } else {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            collection = list;
        }
        return collection;
    }

    @NotNull
    public Collection<String> method_9267() {
        Collection collection;
        if (this.hasNetworkHandler) {
            Collection collection2 = this.clientCommandSource.method_9267();
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getTeamNames(...)");
        } else {
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            collection = list;
        }
        return collection;
    }

    @NotNull
    public Collection<String> method_9269() {
        Collection collection = this.clientCommandSource.method_9269();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEntitySuggestions(...)");
        return collection;
    }

    @NotNull
    public Stream<class_2960> method_9254() {
        Stream stream = this.clientCommandSource.method_9254();
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"getSoundIds(...)");
        return stream;
    }

    @NotNull
    public Set<class_5321<class_1937>> method_29310() {
        Set set = this.clientCommandSource.method_29310();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getWorldKeys(...)");
        return set;
    }

    @NotNull
    public class_5455 method_30497() {
        class_5455 class_54552;
        if (this.hasNetworkHandler) {
            class_5455 class_54553 = this.clientCommandSource.method_30497();
            class_54552 = class_54553;
            Intrinsics.checkNotNullExpressionValue((Object)class_54553, (String)"getRegistryManager(...)");
        } else {
            class_5455.class_6890 class_68902 = class_5455.method_40302((class_2378)class_7923.field_41167);
            Intrinsics.checkNotNullExpressionValue((Object)class_68902, (String)"of(...)");
            class_54552 = (class_5455)class_68902;
        }
        return class_54552;
    }

    @NotNull
    public class_7699 method_45549() {
        class_7699 class_76992;
        if (this.hasNetworkHandler) {
            class_7699 class_76993 = this.clientCommandSource.method_45549();
            class_76992 = class_76993;
            Intrinsics.checkNotNullExpressionValue((Object)class_76993, (String)"getEnabledFeatures(...)");
        } else {
            class_7699 class_76994 = ClientCommandCrafter.INSTANCE.getDefaultFeatureSet();
            class_76992 = class_76994;
            Intrinsics.checkNotNullExpressionValue((Object)class_76994, (String)"<get-defaultFeatureSet>(...)");
        }
        return class_76992;
    }

    public boolean method_9259(int level) {
        return true;
    }

    @NotNull
    public CompletableFuture<Suggestions> method_41213(@NotNull class_5321<? extends class_2378<?>> registryRef, @NotNull class_2172.class_7078 suggestedIdType, @NotNull SuggestionsBuilder builder, @NotNull CommandContext<?> context) {
        CompletableFuture completableFuture;
        Intrinsics.checkNotNullParameter(registryRef, (String)"registryRef");
        Intrinsics.checkNotNullParameter((Object)suggestedIdType, (String)"suggestedIdType");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (this.method_30497().method_46759(registryRef).isPresent()) {
            CompletableFuture completableFuture2 = this.clientCommandSource.method_41213(registryRef, suggestedIdType, builder, context);
            completableFuture = completableFuture2;
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture2, (String)"listIdSuggestions(...)");
        } else {
            completableFuture = this.method_9261(context);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Suggestions> method_9261(@NotNull CommandContext<?> context) {
        ContextCompletionProvider contextCompletionProvider2;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        DirectiveStringReader<AnalyzingResourceCreator> fullInput = UtilKt.getOrNull(VanillaLanguage.Companion.getSUGGESTIONS_FULL_INPUT());
        if (!this.hasNetworkHandler || fullInput == null) {
            CompletableFuture completableFuture = Suggestions.empty();
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"empty(...)");
            return completableFuture;
        }
        Object object = fullInput.getResourceCreator().getLanguageServer();
        ContextCompletionProvider contextCompletionProvider3 = object != null && (object = ((MinecraftLanguageServer)object).getMinecraftServer()) != null ? object.getContextCompletionProvider() : (contextCompletionProvider2 = null);
        if (contextCompletionProvider2 != null) {
            CompletionStage completionStage = contextCompletionProvider2.getCompletions(fullInput).thenApply(arg_0 -> AnalyzingClientCommandSource.getCompletions$lambda$2(AnalyzingClientCommandSource::getCompletions$lambda$1, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
            return completionStage;
        }
        if (!VanillaLanguage.Companion.isReaderEasyNextLine((ImmutableStringReader)fullInput) && !VanillaLanguage.Companion.isReaderInlineResources((ImmutableStringReader)fullInput)) {
            CompletableFuture completableFuture = this.clientCommandSource.method_9261(context);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"getCompletions(...)");
            return completableFuture;
        }
        CompletableFuture completableFuture = Suggestions.empty();
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"empty(...)");
        return completableFuture;
    }

    private static final Suggestions getCompletions$lambda$1(List it) {
        Suggestions suggestions;
        Suggestions $this$getCompletions_u24lambda_u241_u24lambda_u240 = suggestions = new Suggestions(StringRange.at((int)0), CollectionsKt.emptyList());
        boolean bl = false;
        CompletionItemsContainer completionItemsContainer = (CompletionItemsContainer)$this$getCompletions_u24lambda_u241_u24lambda_u240;
        Intrinsics.checkNotNull((Object)it);
        completionItemsContainer.command_crafter$setCompletionItem(it);
        return suggestions;
    }

    private static final Suggestions getCompletions$lambda$2(Function1 $tmp0, Object p0) {
        return (Suggestions)$tmp0.invoke(p0);
    }
}

