/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.debugger;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.papierkorb2292.command_crafter.editor.EditorClientFileFinder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/WorkspaceFileFinder;", "", "Lnet/papierkorb2292/command_crafter/editor/EditorClientFileFinder;", "fileFinder", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/EditorClientFileFinder;)V", "", "pattern", "Ljava/util/concurrent/CompletableFuture;", "findFileWithWorkspace", "(Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "checkCacheForPattern", "Lnet/papierkorb2292/command_crafter/editor/EditorClientFileFinder;", "", "cache", "Ljava/util/Map;", "command-crafter"})
public final class WorkspaceFileFinder {
    @NotNull
    private final EditorClientFileFinder fileFinder;
    @NotNull
    private final Map<String, String> cache;

    public WorkspaceFileFinder(@NotNull EditorClientFileFinder fileFinder) {
        Intrinsics.checkNotNullParameter((Object)fileFinder, (String)"fileFinder");
        this.fileFinder = fileFinder;
        Map map2 = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(...)");
        this.cache = map2;
    }

    @NotNull
    public final CompletableFuture<String> findFileWithWorkspace(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        CharSequence trimmedPattern = pattern;
        CompletionStage<String> future = this.checkCacheForPattern(pattern);
        while (trimmedPattern.length() > 0) {
            CharSequence finalPattern = trimmedPattern;
            Intrinsics.checkNotNullExpressionValue((Object)future.thenCompose(arg_0 -> WorkspaceFileFinder.findFileWithWorkspace$lambda$3(arg_0 -> WorkspaceFileFinder.findFileWithWorkspace$lambda$2(this, finalPattern, arg_0), arg_0)), (String)"thenCompose(...)");
            int segmentEnd = StringsKt.indexOf$default((CharSequence)trimmedPattern, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (segmentEnd == -1) break;
            trimmedPattern = trimmedPattern.subSequence(segmentEnd + 1, trimmedPattern.length());
        }
        CompletionStage completionStage = future.thenApply(arg_0 -> WorkspaceFileFinder.findFileWithWorkspace$lambda$5(arg_0 -> WorkspaceFileFinder.findFileWithWorkspace$lambda$4(this, pattern, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final CompletableFuture<String> checkCacheForPattern(String pattern) {
        String string = this.cache.get(pattern);
        if (string == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        String cached = string;
        CompletionStage completionStage = this.fileFinder.fileExists(cached).thenApply(arg_0 -> WorkspaceFileFinder.checkCacheForPattern$lambda$7(arg_0 -> WorkspaceFileFinder.checkCacheForPattern$lambda$6(cached, this, pattern, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final String findFileWithWorkspace$lambda$2$lambda$0(String[] it) {
        Intrinsics.checkNotNull((Object)it);
        return (String)ArraysKt.firstOrNull((Object[])it);
    }

    private static final String findFileWithWorkspace$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final CompletionStage findFileWithWorkspace$lambda$2(WorkspaceFileFinder this$0, CharSequence $finalPattern, String prev) {
        String string = prev;
        return string != null ? CompletableFuture.completedFuture(string) : this$0.fileFinder.findFiles(((Object)$finalPattern).toString()).thenApply(arg_0 -> WorkspaceFileFinder.findFileWithWorkspace$lambda$2$lambda$1(WorkspaceFileFinder::findFileWithWorkspace$lambda$2$lambda$0, arg_0));
    }

    private static final CompletionStage findFileWithWorkspace$lambda$3(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final String findFileWithWorkspace$lambda$4(WorkspaceFileFinder this$0, String $pattern, String it) {
        if (it != null) {
            this$0.cache.put($pattern, it);
        }
        return it;
    }

    private static final String findFileWithWorkspace$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String checkCacheForPattern$lambda$6(String $cached, WorkspaceFileFinder this$0, String $pattern, Boolean it) {
        String string;
        if (it.booleanValue()) {
            string = $cached;
        } else {
            this$0.cache.remove($pattern);
            string = null;
        }
        return string;
    }

    private static final String checkCacheForPattern$lambda$7(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

