/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.StringRange;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2960;
import net.minecraft.class_9139;
import net.papierkorb2292.command_crafter.editor.CommandCrafterLanguageClient;
import net.papierkorb2292.command_crafter.editor.EditorClientFileFinder;
import net.papierkorb2292.command_crafter.editor.MinecraftLanguageServer;
import net.papierkorb2292.command_crafter.editor.processing.AnalyzingResourceCreator;
import net.papierkorb2292.command_crafter.editor.processing.ArgumentTypeAdditionalDataSerializer;
import net.papierkorb2292.command_crafter.editor.processing.PackContentFileType;
import net.papierkorb2292.command_crafter.editor.processing.TokenType;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.editor.processing.helper.PackContentFileTypeContainer;
import net.papierkorb2292.command_crafter.parser.DirectiveStringReader;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0003\u00a8\u0006\u0013"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/IdArgumentTypeAnalyzer;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "id", "Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;", "packContentFileType", "Lcom/mojang/brigadier/context/StringRange;", "range", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "result", "Lnet/papierkorb2292/command_crafter/parser/DirectiveStringReader;", "Lnet/papierkorb2292/command_crafter/editor/processing/AnalyzingResourceCreator;", "reader", "", "analyzeForId", "(Lnet/minecraft/class_2960;Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;Lcom/mojang/brigadier/context/StringRange;Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;Lnet/papierkorb2292/command_crafter/parser/DirectiveStringReader;)V", "registerFileTypeAdditionalDataType", "command-crafter"})
public final class IdArgumentTypeAnalyzer {
    @NotNull
    public static final IdArgumentTypeAnalyzer INSTANCE = new IdArgumentTypeAnalyzer();

    private IdArgumentTypeAnalyzer() {
    }

    public final void analyzeForId(@NotNull class_2960 id, @NotNull PackContentFileType packContentFileType, @NotNull StringRange range, @NotNull AnalyzingResult result, @NotNull DirectiveStringReader<AnalyzingResourceCreator> reader) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)packContentFileType), (String)"packContentFileType");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        result.getSemanticTokens().addMultiline(range, TokenType.Companion.getPARAMETER(), 0);
        MinecraftLanguageServer minecraftLanguageServer = reader.getResourceCreator().getLanguageServer();
        if (minecraftLanguageServer == null) {
            return;
        }
        MinecraftLanguageServer languageServer = minecraftLanguageServer;
        Range fileRange = result.toFileRange(range);
        result.addHoverProvider(new AnalyzingResult.RangedDataProvider(range, arg_0 -> IdArgumentTypeAnalyzer.analyzeForId$lambda$2(languageServer, id, packContentFileType, fileRange, arg_0)), true);
        result.addDefinitionProvider(new AnalyzingResult.RangedDataProvider(range, arg_0 -> IdArgumentTypeAnalyzer.analyzeForId$lambda$5(languageServer, id, packContentFileType, arg_0)), true);
    }

    public final void registerFileTypeAdditionalDataType() {
        class_2960 class_29602 = class_2960.method_60655((String)"command_crafter", (String)"pack_content_file_type");
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"of(...)");
        Function1 function1 = IdArgumentTypeAnalyzer::registerFileTypeAdditionalDataType$lambda$6;
        Function2 function2 = IdArgumentTypeAnalyzer::registerFileTypeAdditionalDataType$lambda$7;
        class_9139 class_91392 = PackContentFileType.Companion.getPACKET_CODEC().method_56430();
        Intrinsics.checkNotNullExpressionValue((Object)class_91392, (String)"cast(...)");
        Encoder encoder = Codec.STRING.comap(arg_0 -> IdArgumentTypeAnalyzer.registerFileTypeAdditionalDataType$lambda$9(IdArgumentTypeAnalyzer::registerFileTypeAdditionalDataType$lambda$8, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)encoder, (String)"comap(...)");
        ArgumentTypeAdditionalDataSerializer.Companion.registerAdditionalDataType(class_29602, function1, function2, class_91392, encoder);
    }

    private static final CompletionStage analyzeForId$lambda$2$lambda$0(MinecraftLanguageServer $languageServer, Range $fileRange, String documentation) {
        return $languageServer.hoverDocumentation(documentation, $fileRange);
    }

    private static final CompletionStage analyzeForId$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletableFuture analyzeForId$lambda$2(MinecraftLanguageServer $languageServer, class_2960 $id, PackContentFileType $packContentFileType, Range $fileRange, int it) {
        return $languageServer.findFileAndGetDocs($id, $packContentFileType).thenCompose(arg_0 -> IdArgumentTypeAnalyzer.analyzeForId$lambda$2$lambda$1(arg_0 -> IdArgumentTypeAnalyzer.analyzeForId$lambda$2$lambda$0($languageServer, $fileRange, arg_0), arg_0));
    }

    private static final Either analyzeForId$lambda$5$lambda$3(String resource) {
        return Either.forLeft((Object)(resource == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new Location(resource, new Range(new Position(), new Position())))));
    }

    private static final Either analyzeForId$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (Either)$tmp0.invoke(p0);
    }

    private static final CompletableFuture analyzeForId$lambda$5(MinecraftLanguageServer $languageServer, class_2960 $id, PackContentFileType $packContentFileType, int it) {
        CommandCrafterLanguageClient commandCrafterLanguageClient = $languageServer.getClient();
        if (commandCrafterLanguageClient == null) {
            return MinecraftLanguageServer.Companion.getEmptyDefinitionDefault();
        }
        CommandCrafterLanguageClient client = commandCrafterLanguageClient;
        CompletionStage completionStage = PackContentFileType.Companion.findWorkspaceResourceFromIdAndPackContentFileType($id, $packContentFileType, (EditorClientFileFinder)client).thenApply(arg_0 -> IdArgumentTypeAnalyzer.analyzeForId$lambda$5$lambda$4(IdArgumentTypeAnalyzer::analyzeForId$lambda$5$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private static final PackContentFileType registerFileTypeAdditionalDataType$lambda$6(ArgumentType argumentType) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        return argumentType instanceof PackContentFileTypeContainer ? ((PackContentFileTypeContainer)argumentType).command_crafter$getPackContentFileType() : null;
    }

    private static final boolean registerFileTypeAdditionalDataType$lambda$7(ArgumentType argumentType, PackContentFileType packContentFileType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        if (argumentType instanceof PackContentFileTypeContainer) {
            PackContentFileTypeContainer packContentFileTypeContainer = (PackContentFileTypeContainer)argumentType;
            Intrinsics.checkNotNull((Object)((Object)packContentFileType));
            packContentFileTypeContainer.command_crafter$setPackContentFileType(packContentFileType);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final String registerFileTypeAdditionalDataType$lambda$8(PackContentFileType it) {
        return it.toString();
    }

    private static final String registerFileTypeAdditionalDataType$lambda$9(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

