/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_7663;
import net.minecraft.class_7677;
import net.minecraft.class_8617;
import net.papierkorb2292.command_crafter.editor.CommandCrafterLanguageClient;
import net.papierkorb2292.command_crafter.editor.MinecraftLanguageServer;
import net.papierkorb2292.command_crafter.editor.OpenFile;
import net.papierkorb2292.command_crafter.editor.processing.PackMetaAnalyzer;
import net.papierkorb2292.command_crafter.editor.processing.StringRangeTreeJsonResourceAnalyzer;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.editor.processing.helper.FileAnalyseHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u0013\u0012\u0002\b\u00030\u00122\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R$\u0010\u001c\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010 \u00a8\u0006#"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/PackMetaAnalyzer;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/FileAnalyseHandler;", "<init>", "()V", "Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "file", "", "canHandle", "(Lnet/papierkorb2292/command_crafter/editor/OpenFile;)Z", "Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;", "languageServer", "Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "analyzeAsync", "(Lnet/papierkorb2292/command_crafter/editor/OpenFile;Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;)Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraft/class_7677;", "serializer", "optional", "Lcom/mojang/serialization/codecs/RecordCodecBuilder;", "", "toRootCodec", "(Lnet/minecraft/class_7677;Z)Lcom/mojang/serialization/codecs/RecordCodecBuilder;", "", "ANALYZER_CONFIG_PATH", "Ljava/lang/String;", "Lkotlin/Function1;", "", "", "NULL_PROVIDER", "Lkotlin/jvm/functions/Function1;", "Lcom/mojang/serialization/Decoder;", "MERGED_DATAPACK_DECODER", "Lcom/mojang/serialization/Decoder;", "MERGED_RESOURCEPACK_DECODER", "MERGED_UNKNOWN_DECODER", "command-crafter"})
public final class PackMetaAnalyzer
implements FileAnalyseHandler {
    @NotNull
    public static final PackMetaAnalyzer INSTANCE = new PackMetaAnalyzer();
    @NotNull
    private static final String ANALYZER_CONFIG_PATH = ".packmeta";
    @NotNull
    private static final Function1 NULL_PROVIDER = NULL_PROVIDER.1.INSTANCE;
    @NotNull
    private static final Decoder<Unit> MERGED_DATAPACK_DECODER;
    @NotNull
    private static final Decoder<Unit> MERGED_RESOURCEPACK_DECODER;
    @NotNull
    private static final Decoder<Unit> MERGED_UNKNOWN_DECODER;

    private PackMetaAnalyzer() {
    }

    @Override
    public boolean canHandle(@NotNull OpenFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return StringsKt.endsWith$default((String)file.getParsedUri().getPath(), (String)"pack.mcmeta", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public CompletableFuture<AnalyzingResult> analyzeAsync(@NotNull OpenFile file, @NotNull MinecraftLanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
        Path path = Paths.get(file.getParsedUri().getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path packFolder = path.getParent();
        String dataPath = file.getParsedUri().copyWithPath(((Object)packFolder.resolve("data")).toString()).toString();
        String assetsPath = file.getParsedUri().copyWithPath(((Object)packFolder.resolve("assets")).toString()).toString();
        CommandCrafterLanguageClient commandCrafterLanguageClient = languageServer.getClient();
        Intrinsics.checkNotNull((Object)commandCrafterLanguageClient);
        CompletableFuture<String[]> completableFuture = commandCrafterLanguageClient.findFiles(dataPath);
        CommandCrafterLanguageClient commandCrafterLanguageClient2 = languageServer.getClient();
        Intrinsics.checkNotNull((Object)commandCrafterLanguageClient2);
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)completableFuture.thenCombine(commandCrafterLanguageClient2.findFiles(assetsPath), (arg_0, arg_1) -> PackMetaAnalyzer.analyzeAsync$lambda$4(PackMetaAnalyzer::analyzeAsync$lambda$3, arg_0, arg_1))).thenApply(arg_0 -> PackMetaAnalyzer.analyzeAsync$lambda$6(PackMetaAnalyzer::analyzeAsync$lambda$5, arg_0))).thenApply(arg_0 -> PackMetaAnalyzer.analyzeAsync$lambda$8(arg_0 -> PackMetaAnalyzer.analyzeAsync$lambda$7(file, languageServer, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    private final RecordCodecBuilder<Unit, ?> toRootCodec(class_7677<?> serializer, boolean optional) {
        RecordCodecBuilder recordCodecBuilder;
        if (optional) {
            Function1 function1 = NULL_PROVIDER;
            RecordCodecBuilder recordCodecBuilder2 = serializer.comp_3437().optionalFieldOf(serializer.comp_3436()).forGetter(new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            });
            recordCodecBuilder = recordCodecBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)recordCodecBuilder2, (String)"forGetter(...)");
        } else {
            Function1 function1 = NULL_PROVIDER;
            RecordCodecBuilder recordCodecBuilder3 = serializer.comp_3437().fieldOf(serializer.comp_3436()).forGetter(new /* invalid duplicate definition of identical inner class */);
            recordCodecBuilder = recordCodecBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)recordCodecBuilder3, (String)"forGetter(...)");
        }
        return recordCodecBuilder;
    }

    @Override
    @NotNull
    public AnalyzingResult analyze(@NotNull OpenFile file, @NotNull MinecraftLanguageServer languageServer) {
        return FileAnalyseHandler.DefaultImpls.analyze(this, file, languageServer);
    }

    private static final App MERGED_DATAPACK_DECODER$lambda$0(RecordCodecBuilder.Instance it) {
        class_7677 class_76772 = class_3272.method_72356((class_3264)class_3264.field_14190);
        Intrinsics.checkNotNullExpressionValue((Object)class_76772, (String)"getSerializerFor(...)");
        App app = (App)INSTANCE.toRootCodec(class_76772, false);
        class_7677 class_76773 = class_7663.field_39996;
        Intrinsics.checkNotNullExpressionValue((Object)class_76773, (String)"SERIALIZER");
        App app2 = (App)INSTANCE.toRootCodec(class_76773, true);
        class_7677 class_76774 = class_8617.method_72309((class_3264)class_3264.field_14190);
        Intrinsics.checkNotNullExpressionValue((Object)class_76774, (String)"getSerializerFor(...)");
        return it.group(app, app2, (App)INSTANCE.toRootCodec(class_76774, true)).apply((Applicative)it, (Function3)MERGED_DATAPACK_DECODER.1.1.INSTANCE);
    }

    private static final App MERGED_RESOURCEPACK_DECODER$lambda$1(RecordCodecBuilder.Instance it) {
        class_7677 class_76772 = class_3272.method_72356((class_3264)class_3264.field_14188);
        Intrinsics.checkNotNullExpressionValue((Object)class_76772, (String)"getSerializerFor(...)");
        App app = (App)INSTANCE.toRootCodec(class_76772, false);
        class_7677 class_76773 = class_7663.field_39996;
        Intrinsics.checkNotNullExpressionValue((Object)class_76773, (String)"SERIALIZER");
        App app2 = (App)INSTANCE.toRootCodec(class_76773, true);
        class_7677 class_76774 = class_8617.method_72309((class_3264)class_3264.field_14188);
        Intrinsics.checkNotNullExpressionValue((Object)class_76774, (String)"getSerializerFor(...)");
        return it.group(app, app2, (App)INSTANCE.toRootCodec(class_76774, true)).apply((Applicative)it, (Function3)MERGED_RESOURCEPACK_DECODER.1.1.INSTANCE);
    }

    private static final App MERGED_UNKNOWN_DECODER$lambda$2(RecordCodecBuilder.Instance it) {
        class_7677 class_76772 = class_3272.field_61157;
        Intrinsics.checkNotNullExpressionValue((Object)class_76772, (String)"DESCRIPTION_SERIALIZER");
        App app = (App)INSTANCE.toRootCodec(class_76772, false);
        class_7677 class_76773 = class_7663.field_39996;
        Intrinsics.checkNotNullExpressionValue((Object)class_76773, (String)"SERIALIZER");
        return it.group(app, (App)INSTANCE.toRootCodec(class_76773, true)).apply((Applicative)it, (BiFunction)MERGED_UNKNOWN_DECODER.1.1.INSTANCE);
    }

    private static final Pair analyzeAsync$lambda$3(String[] dataFolders, String[] resourceFolders) {
        return TuplesKt.to((Object)dataFolders, (Object)resourceFolders);
    }

    private static final Pair analyzeAsync$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (Pair)$tmp0.invoke(p0, p1);
    }

    private static final Decoder analyzeAsync$lambda$5(Pair pair) {
        String[] dataFolders = (String[])pair.component1();
        String[] resourceFolders = (String[])pair.component2();
        Intrinsics.checkNotNull((Object)dataFolders);
        boolean bl = !(dataFolders.length == 0);
        Intrinsics.checkNotNull((Object)resourceFolders);
        return bl ^ !(resourceFolders.length == 0) ? MERGED_UNKNOWN_DECODER : (!(dataFolders.length == 0) ? MERGED_DATAPACK_DECODER : MERGED_RESOURCEPACK_DECODER);
    }

    private static final Decoder analyzeAsync$lambda$6(Function1 $tmp0, Object p0) {
        return (Decoder)$tmp0.invoke(p0);
    }

    private static final AnalyzingResult analyzeAsync$lambda$7(OpenFile $file, MinecraftLanguageServer $languageServer, Decoder decoder2) {
        Intrinsics.checkNotNull((Object)decoder2);
        AnalyzingResult analyzingResult = StringRangeTreeJsonResourceAnalyzer.Companion.analyze($file, $languageServer, decoder2);
        Object[] objectArray = new String[]{".json.packmeta", ".json", ""};
        analyzingResult.clearDisabledFeatures($languageServer.getFeatureConfig(), CollectionsKt.listOf((Object[])objectArray));
        return analyzingResult;
    }

    private static final AnalyzingResult analyzeAsync$lambda$8(Function1 $tmp0, Object p0) {
        return (AnalyzingResult)$tmp0.invoke(p0);
    }

    static {
        Codec codec2 = RecordCodecBuilder.create(PackMetaAnalyzer::MERGED_DATAPACK_DECODER$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"create(...)");
        MERGED_DATAPACK_DECODER = (Decoder)codec2;
        Codec codec3 = RecordCodecBuilder.create(PackMetaAnalyzer::MERGED_RESOURCEPACK_DECODER$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)codec3, (String)"create(...)");
        MERGED_RESOURCEPACK_DECODER = (Decoder)codec3;
        Codec codec4 = RecordCodecBuilder.create(PackMetaAnalyzer::MERGED_UNKNOWN_DECODER$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)codec4, (String)"create(...)");
        MERGED_UNKNOWN_DECODER = (Decoder)codec4;
    }
}

