/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import com.mojang.brigadier.context.StringRange;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.papierkorb2292.command_crafter.editor.processing.StreamCompletionItemProvider;
import net.papierkorb2292.command_crafter.editor.processing.StringRangeTree;
import net.papierkorb2292.command_crafter.editor.processing.TokenType;
import net.papierkorb2292.command_crafter.editor.processing.helper.UtilKt;
import net.papierkorb2292.command_crafter.parser.DirectiveStringReader;
import net.papierkorb2292.command_crafter.parser.FileMappingInfo;
import net.papierkorb2292.command_crafter.parser.helper.SplitProcessedInputCursorMapper;
import net.papierkorb2292.command_crafter.string_range_gson.JsonReader;
import net.papierkorb2292.command_crafter.string_range_gson.JsonToken;
import net.papierkorb2292.command_crafter.string_range_gson.Strictness;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0004\u001f !\"B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\tJ!\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ;\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001e\u00a8\u0006#"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonReader;", "", "Lkotlin/Function0;", "Lnet/papierkorb2292/command_crafter/string_range_gson/JsonReader;", "jsonReaderProvider", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "Ljava/io/Reader;", "stringReader", "(Ljava/io/Reader;)V", "in", "Lnet/papierkorb2292/command_crafter/string_range_gson/JsonToken;", "peeked", "Lcom/google/gson/JsonElement;", "tryBeginNesting", "(Lnet/papierkorb2292/command_crafter/string_range_gson/JsonReader;Lnet/papierkorb2292/command_crafter/string_range_gson/JsonToken;)Lcom/google/gson/JsonElement;", "readTerminal", "", "startPos", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$Builder;", "builder", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "readOnlyTerminal", "(Lnet/papierkorb2292/command_crafter/string_range_gson/JsonReader;Lnet/papierkorb2292/command_crafter/string_range_gson/JsonToken;ILnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$Builder;)Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "Lnet/papierkorb2292/command_crafter/string_range_gson/Strictness;", "strictness", "", "allowMalformed", "read", "(Lnet/papierkorb2292/command_crafter/string_range_gson/Strictness;Z)Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "Lkotlin/jvm/functions/Function0;", "ReaderStackEntry", "StringRangeTreeSemanticTokenProvider", "StringRangeTreeSuggestionResolver", "StringContentGetter", "command-crafter"})
public final class StringRangeTreeJsonReader {
    @NotNull
    private final Function0<JsonReader> jsonReaderProvider;

    public StringRangeTreeJsonReader(@NotNull Function0<? extends JsonReader> jsonReaderProvider) {
        Intrinsics.checkNotNullParameter(jsonReaderProvider, (String)"jsonReaderProvider");
        this.jsonReaderProvider = jsonReaderProvider;
    }

    public StringRangeTreeJsonReader(@NotNull Reader stringReader) {
        Intrinsics.checkNotNullParameter((Object)stringReader, (String)"stringReader");
        this((Function0<? extends JsonReader>)((Function0)() -> StringRangeTreeJsonReader._init_$lambda$0(stringReader)));
    }

    private final JsonElement tryBeginNesting(JsonReader in, JsonToken peeked) throws IOException {
        return switch (WhenMappings.$EnumSwitchMapping$0[peeked.ordinal()]) {
            case 1 -> {
                in.beginArray();
                yield (JsonElement)new JsonArray();
            }
            case 2 -> {
                in.beginObject();
                yield (JsonElement)new JsonObject();
            }
            default -> null;
        };
    }

    private final JsonElement readTerminal(JsonReader in, JsonToken peeked) throws IOException {
        return switch (WhenMappings.$EnumSwitchMapping$0[peeked.ordinal()]) {
            case 3 -> (JsonElement)new JsonPrimitive(in.nextString());
            case 4 -> {
                String number = in.nextString();
                yield (JsonElement)new JsonPrimitive((Number)new LazilyParsedNumber(number));
            }
            case 5 -> (JsonElement)new JsonPrimitive(Boolean.valueOf(in.nextBoolean()));
            case 6 -> {
                in.nextNull();
                yield (JsonElement)new JsonNull();
            }
            default -> throw new IllegalStateException("Unexpected token: " + peeked);
        };
    }

    private final StringRangeTree<JsonElement> readOnlyTerminal(JsonReader in, JsonToken peeked, int startPos, StringRangeTree.Builder<JsonElement> builder) throws IOException {
        JsonElement terminal = this.readTerminal(in, peeked);
        builder.addNode(terminal, new StringRange(startPos, in.getAbsolutePos()), 0);
        return builder.build(terminal);
    }

    @NotNull
    public final StringRangeTree<JsonElement> read(@NotNull Strictness strictness, boolean allowMalformed) {
        Intrinsics.checkNotNullParameter((Object)((Object)strictness), (String)"strictness");
        JsonReader in = (JsonReader)this.jsonReaderProvider.invoke();
        in.setStrictness(strictness);
        StringRangeTree.Builder<JsonElement> builder = new StringRangeTree.Builder<JsonElement>();
        JsonNull current = null;
        int startAbsolutePos = in.getAbsolutePos();
        int nestedStartPos = 0;
        int nestedAllowedStartPos = 0;
        JsonToken peeked = null;
        try {
            JsonToken jsonToken = in.peek();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jsonToken), (String)"peek(...)");
            peeked = jsonToken;
            nestedStartPos = startAbsolutePos;
            nestedAllowedStartPos = 0;
            JsonElement jsonElement = this.tryBeginNesting(in, peeked);
            if (jsonElement == null) {
                return this.readOnlyTerminal(in, peeked, startAbsolutePos, builder);
            }
            current = jsonElement;
        }
        catch (Throwable e) {
            if (!allowMalformed || !(e instanceof IOException) && !(e instanceof IllegalStateException)) {
                throw e;
            }
            current = new JsonNull();
            builder.addNode((JsonElement)current, new StringRange(startAbsolutePos, in.getAbsolutePos()), startAbsolutePos);
            return builder.build((JsonElement)current);
        }
        builder.addNodeOrder((JsonElement)current);
        Deque stack = new ArrayDeque();
        try {
            while (true) {
                String name;
                block26: {
                    block25: {
                        try {
                            if (in.hasNext()) break block25;
                            if ((!(current instanceof JsonArray) || ((JsonArray)current).size() != 0) && (!(current instanceof JsonObject) || ((JsonObject)current).size() != 0)) break block26;
                            builder.addRangeBetweenInternalNodeEntries((JsonElement)current, new StringRange(in.absoluteEntryEndPos, Math.max(in.absoluteValueStartPos, in.absoluteEntryEndPos)));
                            break block26;
                        }
                        catch (Throwable e) {
                            if (!allowMalformed || !(e instanceof IOException) && !(e instanceof IllegalStateException)) {
                                throw e;
                            }
                            in.pos = Math.max(in.pos - 1, 0);
                            int entryEnd = in.absoluteEntryEndPos;
                            in.skipEntry();
                            if (in.peek() == JsonToken.END_DOCUMENT) continue;
                            int rangeEnd = in.peek() == JsonToken.END_ARRAY || in.peek() == JsonToken.END_OBJECT ? in.getAbsolutePos() - 1 : in.getAbsolutePos();
                            builder.addRangeBetweenInternalNodeEntries((JsonElement)current, new StringRange(entryEnd, rangeEnd));
                            continue;
                        }
                    }
                    builder.addRangeBetweenInternalNodeEntries((JsonElement)current, new StringRange(in.absoluteEntryEndPos, in.absoluteValueStartPos));
                    name = null;
                    if (current instanceof JsonObject) {
                        name = in.nextName();
                        builder.addMapKeyRange((JsonElement)current, (JsonElement)new JsonPrimitive(name), new StringRange(in.absoluteValueStartPos, in.getAbsolutePos()));
                    }
                    boolean isNesting = false;
                    JsonElement value = null;
                    int valueStartPos = 0;
                    int valueEndPos = 0;
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)in.peek()), (String)"peek(...)");
                        value = this.tryBeginNesting(in, peeked);
                        boolean bl = isNesting = value != null;
                        if (value == null) {
                            value = this.readTerminal(in, peeked);
                        }
                        valueStartPos = in.absoluteValueStartPos;
                        valueEndPos = in.getAbsolutePos();
                    }
                    catch (Throwable e) {
                        if (!allowMalformed || !(e instanceof IOException) && !(e instanceof IllegalStateException)) {
                            throw e;
                        }
                        value = (JsonElement)new JsonNull();
                        builder.addPlaceholderNode(value);
                        isNesting = false;
                        in.pos = Math.max(in.pos - 1, 0);
                        valueStartPos = in.getAbsolutePos();
                        in.skipEntry();
                        if (in.getAbsolutePos() > valueStartPos) {
                            valueStartPos = in.getAbsolutePos() - 1;
                        }
                        valueEndPos = valueStartPos;
                    }
                    if (current instanceof JsonArray) {
                        ((JsonArray)current).add(value);
                    } else {
                        JsonNull jsonNull = current;
                        Intrinsics.checkNotNull((Object)jsonNull, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
                        ((JsonObject)jsonNull).add(name, value);
                    }
                    if (isNesting) {
                        stack.addLast(new ReaderStackEntry((JsonElement)current, nestedStartPos, nestedAllowedStartPos));
                        nestedStartPos = in.absoluteValueStartPos;
                        nestedAllowedStartPos = in.absoluteValueStartPosBeforeWhitespace;
                        Intrinsics.checkNotNull((Object)value);
                        builder.addNodeOrder((JsonElement)current);
                        continue;
                    }
                    JsonElement jsonElement = value;
                    Intrinsics.checkNotNull((Object)jsonElement);
                    builder.addNode(jsonElement, new StringRange(valueStartPos, valueEndPos), in.absoluteValueStartPosBeforeWhitespace);
                    continue;
                }
                if (current instanceof JsonArray) {
                    in.endArray();
                } else {
                    in.endObject();
                }
                builder.addNode((JsonElement)current, new StringRange(nestedStartPos, in.getAbsolutePos()), nestedAllowedStartPos);
                if (stack.isEmpty()) {
                    return builder.build((JsonElement)current);
                }
                name = stack.removeLast();
                ReaderStackEntry $this$read_u24lambda_u241 = (ReaderStackEntry)((Object)name);
                boolean bl = false;
                current = $this$read_u24lambda_u241.getElement();
                nestedStartPos = $this$read_u24lambda_u241.getStartPos();
                nestedAllowedStartPos = $this$read_u24lambda_u241.getAllowedStartPos();
                ReaderStackEntry cfr_ignored_0 = (ReaderStackEntry)((Object)name);
            }
        }
        catch (Throwable e) {
            if (!allowMalformed || !(e instanceof IOException) && !(e instanceof IllegalStateException)) {
                throw e;
            }
            Iterator iterator = stack.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                ReaderStackEntry entry = (ReaderStackEntry)iterator2.next();
                builder.addNode(entry.getElement(), new StringRange(entry.getStartPos(), in.getAbsolutePos()), entry.getAllowedStartPos());
            }
            builder.addNode((JsonElement)current, new StringRange(nestedStartPos, in.getAbsolutePos()), nestedAllowedStartPos);
            ReaderStackEntry readerStackEntry = (ReaderStackEntry)stack.peekLast();
            if (readerStackEntry == null || (readerStackEntry = readerStackEntry.getElement()) == null) {
                readerStackEntry = (JsonElement)current;
            }
            return builder.build((JsonElement)readerStackEntry);
        }
    }

    public static /* synthetic */ StringRangeTree read$default(StringRangeTreeJsonReader stringRangeTreeJsonReader, Strictness strictness, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            strictness = Strictness.STRICT;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return stringRangeTreeJsonReader.read(strictness, bl);
    }

    private static final JsonReader _init_$lambda$0(Reader $stringReader) {
        return new JsonReader($stringReader);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\fJ\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001a\u001a\u0004\b\u001c\u0010\f\u00a8\u0006\u001d"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonReader$ReaderStackEntry;", "", "Lcom/google/gson/JsonElement;", "element", "", "startPos", "allowedStartPos", "<init>", "(Lcom/google/gson/JsonElement;II)V", "component1", "()Lcom/google/gson/JsonElement;", "component2", "()I", "component3", "copy", "(Lcom/google/gson/JsonElement;II)Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonReader$ReaderStackEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lcom/google/gson/JsonElement;", "getElement", "I", "getStartPos", "getAllowedStartPos", "command-crafter"})
    private static final class ReaderStackEntry {
        @NotNull
        private final JsonElement element;
        private final int startPos;
        private final int allowedStartPos;

        public ReaderStackEntry(@NotNull JsonElement element, int startPos, int allowedStartPos) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.element = element;
            this.startPos = startPos;
            this.allowedStartPos = allowedStartPos;
        }

        @NotNull
        public final JsonElement getElement() {
            return this.element;
        }

        public final int getStartPos() {
            return this.startPos;
        }

        public final int getAllowedStartPos() {
            return this.allowedStartPos;
        }

        @NotNull
        public final JsonElement component1() {
            return this.element;
        }

        public final int component2() {
            return this.startPos;
        }

        public final int component3() {
            return this.allowedStartPos;
        }

        @NotNull
        public final ReaderStackEntry copy(@NotNull JsonElement element, int startPos, int allowedStartPos) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return new ReaderStackEntry(element, startPos, allowedStartPos);
        }

        public static /* synthetic */ ReaderStackEntry copy$default(ReaderStackEntry readerStackEntry, JsonElement jsonElement, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                jsonElement = readerStackEntry.element;
            }
            if ((n3 & 2) != 0) {
                n = readerStackEntry.startPos;
            }
            if ((n3 & 4) != 0) {
                n2 = readerStackEntry.allowedStartPos;
            }
            return readerStackEntry.copy(jsonElement, n, n2);
        }

        @NotNull
        public String toString() {
            return "ReaderStackEntry(element=" + this.element + ", startPos=" + this.startPos + ", allowedStartPos=" + this.allowedStartPos + ")";
        }

        public int hashCode() {
            int result = this.element.hashCode();
            result = result * 31 + Integer.hashCode(this.startPos);
            result = result * 31 + Integer.hashCode(this.allowedStartPos);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReaderStackEntry)) {
                return false;
            }
            ReaderStackEntry readerStackEntry = (ReaderStackEntry)other;
            if (!Intrinsics.areEqual((Object)this.element, (Object)readerStackEntry.element)) {
                return false;
            }
            if (this.startPos != readerStackEntry.startPos) {
                return false;
            }
            return this.allowedStartPos == readerStackEntry.allowedStartPos;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\"\u0012\u0004\u0012\u00020\u0002\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00030\u0001B\u001d\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ,\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonReader$StringContentGetter;", "Lkotlin/Function1;", "Lcom/google/gson/JsonElement;", "Lkotlin/Triple;", "", "Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$StringEscaper;", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "tree", "input", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;Ljava/lang/String;)V", "p1", "invoke", "(Lcom/google/gson/JsonElement;)Lkotlin/Triple;", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "getTree", "()Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "Ljava/lang/String;", "getInput", "()Ljava/lang/String;", "command-crafter"})
    public static final class StringContentGetter
    implements Function1<JsonElement, Triple<? extends String, ? extends SplitProcessedInputCursorMapper, ? extends StringRangeTree.StringEscaper>> {
        @NotNull
        private final StringRangeTree<JsonElement> tree;
        @NotNull
        private final String input;

        public StringContentGetter(@NotNull StringRangeTree<JsonElement> tree, @NotNull String input) {
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this.tree = tree;
            this.input = input;
        }

        @NotNull
        public final StringRangeTree<JsonElement> getTree() {
            return this.tree;
        }

        @NotNull
        public final String getInput() {
            return this.input;
        }

        @Nullable
        public Triple<String, SplitProcessedInputCursorMapper, StringRangeTree.StringEscaper> invoke(@NotNull JsonElement p1) {
            String string;
            boolean isQuoted;
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            if (!(p1 instanceof JsonPrimitive) || !((JsonPrimitive)p1).isString()) {
                return null;
            }
            StringRange stringRange = this.tree.getRanges().get(p1);
            Intrinsics.checkNotNull((Object)stringRange);
            StringRange range = stringRange;
            char firstChar = this.input.charAt(range.getStart());
            boolean bl = isQuoted = firstChar == '\"' || firstChar == '\'';
            if (isQuoted) {
                if (range.getEnd() - 1 > range.getStart()) {
                    String string2 = this.input.substring(range.getStart() + 1, range.getEnd() - 1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    String string3 = this.input.substring(range.getStart() + 1, range.getEnd());
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                }
            } else {
                String string4 = this.input.substring(range.getStart(), range.getEnd());
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            }
            String sourceString = string;
            return new Triple((Object)((JsonPrimitive)p1).getAsString(), (Object)UtilKt.createCursorMapperForEscapedCharacters(sourceString, range.getStart() + 1), (Object)(isQuoted ? StringRangeTree.StringEscaper.Companion.escapeForQuotes(String.valueOf(firstChar)) : (StringRangeTree.StringEscaper)StringRangeTree.StringEscaper.Identity.INSTANCE));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\bJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonReader$StringRangeTreeSemanticTokenProvider;", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$SemanticTokenProvider;", "Lcom/google/gson/JsonElement;", "<init>", "()V", "map", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$TokenInfo;", "getMapNameTokenInfo", "(Lcom/google/gson/JsonElement;)Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$TokenInfo;", "node", "getNodeTokenInfo", "", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$AdditionalToken;", "getAdditionalTokens", "(Lcom/google/gson/JsonElement;)Ljava/util/List;", "command-crafter"})
    public static final class StringRangeTreeSemanticTokenProvider
    implements StringRangeTree.SemanticTokenProvider<JsonElement> {
        @NotNull
        public static final StringRangeTreeSemanticTokenProvider INSTANCE = new StringRangeTreeSemanticTokenProvider();

        private StringRangeTreeSemanticTokenProvider() {
        }

        @Override
        @NotNull
        public StringRangeTree.TokenInfo getMapNameTokenInfo(@NotNull JsonElement map2) {
            Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
            return new StringRangeTree.TokenInfo(TokenType.Companion.getPARAMETER(), 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Nullable
        public StringRangeTree.TokenInfo getNodeTokenInfo(@NotNull JsonElement node) {
            StringRangeTree.TokenInfo tokenInfo;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            JsonElement jsonElement = node;
            if (jsonElement instanceof JsonPrimitive) {
                if (((JsonPrimitive)node).isBoolean()) {
                    tokenInfo = new StringRangeTree.TokenInfo(TokenType.Companion.getENUM_MEMBER(), 0);
                    return tokenInfo;
                } else if (((JsonPrimitive)node).isNumber()) {
                    tokenInfo = new StringRangeTree.TokenInfo(TokenType.Companion.getNUMBER(), 0);
                    return tokenInfo;
                } else {
                    if (!((JsonPrimitive)node).isString()) throw new IllegalArgumentException("Unexpected JsonPrimitive type: " + node);
                    tokenInfo = new StringRangeTree.TokenInfo(TokenType.Companion.getSTRING(), 0);
                }
                return tokenInfo;
            } else {
                if (!(jsonElement instanceof JsonNull)) return null;
                tokenInfo = new StringRangeTree.TokenInfo(TokenType.Companion.getKEYWORD(), 0);
            }
            return tokenInfo;
        }

        @NotNull
        public List<StringRangeTree.AdditionalToken> getAdditionalTokens(@NotNull JsonElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0015\b\u0016\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\u0006\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\rJQ\u0010\u001b\u001a\u00020\u001a2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJQ\u0010\u001e\u001a\u00020\u001a2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001cR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonReader$StringRangeTreeSuggestionResolver;", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$SuggestionResolver;", "Lcom/google/gson/JsonElement;", "Lkotlin/Function0;", "Ljava/io/Reader;", "readerProvider", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "Lnet/papierkorb2292/command_crafter/parser/DirectiveStringReader;", "directiveReader", "(Lnet/papierkorb2292/command_crafter/parser/DirectiveStringReader;)V", "", "inputString", "(Ljava/lang/String;)V", "", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$SuggestionProvider;", "suggestionProviders", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "tree", "node", "Lcom/mojang/brigadier/context/StringRange;", "suggestionRange", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "mappingInfo", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$StringEscaper;", "stringEscaper", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$ResolvedSuggestion;", "resolveNodeSuggestion", "(Ljava/util/Collection;Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;Lcom/google/gson/JsonElement;Lcom/mojang/brigadier/context/StringRange;Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$StringEscaper;)Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$ResolvedSuggestion;", "map", "resolveMapKeySuggestion", "Lkotlin/jvm/functions/Function0;", "Lkotlin/Function1;", "", "keyEndParser", "Lkotlin/jvm/functions/Function1;", "command-crafter"})
    public static final class StringRangeTreeSuggestionResolver
    implements StringRangeTree.SuggestionResolver<JsonElement> {
        @NotNull
        private final Function0<Reader> readerProvider;
        @NotNull
        private final Function1<StringRange, Integer> keyEndParser;

        public StringRangeTreeSuggestionResolver(@NotNull Function0<? extends Reader> readerProvider) {
            Intrinsics.checkNotNullParameter(readerProvider, (String)"readerProvider");
            this.readerProvider = readerProvider;
            this.keyEndParser = net.papierkorb2292.command_crafter.helper.UtilKt.memoizeLast(arg_0 -> StringRangeTreeSuggestionResolver.keyEndParser$lambda$2(this, arg_0));
        }

        public StringRangeTreeSuggestionResolver(@NotNull DirectiveStringReader<?> directiveReader) {
            Intrinsics.checkNotNullParameter(directiveReader, (String)"directiveReader");
            this((Function0<? extends Reader>)((Function0)() -> StringRangeTreeSuggestionResolver._init_$lambda$0(directiveReader)));
        }

        public StringRangeTreeSuggestionResolver(@NotNull String inputString) {
            Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
            this((Function0<? extends Reader>)((Function0)() -> StringRangeTreeSuggestionResolver._init_$lambda$1(inputString)));
        }

        @Override
        @NotNull
        public StringRangeTree.ResolvedSuggestion resolveNodeSuggestion(@NotNull Collection<? extends StringRangeTree.SuggestionProvider<JsonElement>> suggestionProviders, @NotNull StringRangeTree<JsonElement> tree, @NotNull JsonElement node, @NotNull StringRange suggestionRange, @NotNull FileMappingInfo mappingInfo, @NotNull StringRangeTree.StringEscaper stringEscaper) {
            Intrinsics.checkNotNullParameter(suggestionProviders, (String)"suggestionProviders");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
            Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
            Intrinsics.checkNotNullParameter((Object)stringEscaper, (String)"stringEscaper");
            StringRange stringRange = tree.getRanges().get(node);
            Intrinsics.checkNotNull((Object)stringRange);
            int replaceEnd = stringRange.getEnd();
            return new StringRangeTree.ResolvedSuggestion(replaceEnd, (Function1<? super Integer, ? extends CompletableFuture<List<CompletionItem>>>)((Function1)new StreamCompletionItemProvider(suggestionRange.getEnd(), (Function0<Integer>)((Function0)() -> StringRangeTreeSuggestionResolver.resolveNodeSuggestion$lambda$3(replaceEnd)), mappingInfo, CompletionItemKind.Value, (Function0<? extends Stream<StreamCompletionItemProvider.Completion>>)((Function0)() -> StringRangeTreeSuggestionResolver.resolveNodeSuggestion$lambda$8(suggestionProviders, stringEscaper)))));
        }

        @Override
        @NotNull
        public StringRangeTree.ResolvedSuggestion resolveMapKeySuggestion(@NotNull Collection<? extends StringRangeTree.SuggestionProvider<JsonElement>> suggestionProviders, @NotNull StringRangeTree<JsonElement> tree, @NotNull JsonElement map2, @NotNull StringRange suggestionRange, @NotNull FileMappingInfo mappingInfo, @NotNull StringRangeTree.StringEscaper stringEscaper) {
            Intrinsics.checkNotNullParameter(suggestionProviders, (String)"suggestionProviders");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
            Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
            Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
            Intrinsics.checkNotNullParameter((Object)stringEscaper, (String)"stringEscaper");
            int replaceEnd = ((Number)this.keyEndParser.invoke((Object)suggestionRange)).intValue();
            return new StringRangeTree.ResolvedSuggestion(replaceEnd, (Function1<? super Integer, ? extends CompletableFuture<List<CompletionItem>>>)((Function1)new StreamCompletionItemProvider(suggestionRange.getEnd(), (Function0<Integer>)((Function0)() -> StringRangeTreeSuggestionResolver.resolveMapKeySuggestion$lambda$9(replaceEnd)), mappingInfo, CompletionItemKind.Property, (Function0<? extends Stream<StreamCompletionItemProvider.Completion>>)((Function0)() -> StringRangeTreeSuggestionResolver.resolveMapKeySuggestion$lambda$14(suggestionProviders, stringEscaper)))));
        }

        private static final Reader _init_$lambda$0(DirectiveStringReader $directiveReader) {
            return $directiveReader.copy().asReader();
        }

        private static final Reader _init_$lambda$1(String $inputString) {
            return new StringReader($inputString);
        }

        private static final int keyEndParser$lambda$2(StringRangeTreeSuggestionResolver this$0, StringRange suggestionRange) {
            Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
            Reader inputReader = (Reader)this$0.readerProvider.invoke();
            inputReader.skip(suggestionRange.getEnd());
            JsonReader jsonReader = new JsonReader(inputReader);
            jsonReader.setStrictness(Strictness.LENIENT);
            jsonReader.stack[0] = 3;
            try {
                jsonReader.nextName();
                try {
                    int c = jsonReader.nextNonWhitespace(true);
                    if (c == 58) {
                        jsonReader.nextNonWhitespace(true);
                    }
                    int n = jsonReader.pos;
                    jsonReader.pos = n + -1;
                    Integer n2 = n;
                }
                catch (Exception ignored) {
                    Unit unit = Unit.INSTANCE;
                }
            }
            catch (Exception e) {
                int n = jsonReader.pos;
                jsonReader.pos = n + -1;
            }
            return suggestionRange.getEnd() + Math.max(jsonReader.getAbsolutePos(), 0);
        }

        private static final Integer resolveNodeSuggestion$lambda$3(int $replaceEnd) {
            return $replaceEnd;
        }

        private static final Stream resolveNodeSuggestion$lambda$8$lambda$4(StringRangeTree.SuggestionProvider it) {
            return it.createSuggestions();
        }

        private static final Stream resolveNodeSuggestion$lambda$8$lambda$5(Function1 $tmp0, Object p0) {
            return (Stream)$tmp0.invoke(p0);
        }

        private static final StreamCompletionItemProvider.Completion resolveNodeSuggestion$lambda$8$lambda$6(StringRangeTree.StringEscaper $stringEscaper, StringRangeTree.Suggestion suggestion) {
            String string = ((JsonElement)suggestion.getElement()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new StreamCompletionItemProvider.Completion($stringEscaper.escape(string), null, 2, null);
        }

        private static final StreamCompletionItemProvider.Completion resolveNodeSuggestion$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
            return (StreamCompletionItemProvider.Completion)$tmp0.invoke(p0);
        }

        private static final Stream resolveNodeSuggestion$lambda$8(Collection $suggestionProviders, StringRangeTree.StringEscaper $stringEscaper) {
            Stream<StreamCompletionItemProvider.Completion> stream = $suggestionProviders.stream().flatMap(arg_0 -> StringRangeTreeSuggestionResolver.resolveNodeSuggestion$lambda$8$lambda$5(StringRangeTreeSuggestionResolver::resolveNodeSuggestion$lambda$8$lambda$4, arg_0)).map(arg_0 -> StringRangeTreeSuggestionResolver.resolveNodeSuggestion$lambda$8$lambda$7(arg_0 -> StringRangeTreeSuggestionResolver.resolveNodeSuggestion$lambda$8$lambda$6($stringEscaper, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
            return stream;
        }

        private static final Integer resolveMapKeySuggestion$lambda$9(int $replaceEnd) {
            return $replaceEnd;
        }

        private static final Stream resolveMapKeySuggestion$lambda$14$lambda$10(StringRangeTree.SuggestionProvider it) {
            return it.createSuggestions();
        }

        private static final Stream resolveMapKeySuggestion$lambda$14$lambda$11(Function1 $tmp0, Object p0) {
            return (Stream)$tmp0.invoke(p0);
        }

        private static final StreamCompletionItemProvider.Completion resolveMapKeySuggestion$lambda$14$lambda$12(StringRangeTree.StringEscaper $stringEscaper, StringRangeTree.Suggestion suggestion) {
            JsonElement element = (JsonElement)suggestion.getElement();
            String key = element.isJsonPrimitive() ? element.getAsString() : element.toString();
            String string = $stringEscaper.escape("\"" + key + "\": ");
            Intrinsics.checkNotNull((Object)key);
            return new StreamCompletionItemProvider.Completion(string, key);
        }

        private static final StreamCompletionItemProvider.Completion resolveMapKeySuggestion$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
            return (StreamCompletionItemProvider.Completion)$tmp0.invoke(p0);
        }

        private static final Stream resolveMapKeySuggestion$lambda$14(Collection $suggestionProviders, StringRangeTree.StringEscaper $stringEscaper) {
            Stream<StreamCompletionItemProvider.Completion> stream = $suggestionProviders.stream().flatMap(arg_0 -> StringRangeTreeSuggestionResolver.resolveMapKeySuggestion$lambda$14$lambda$11(StringRangeTreeSuggestionResolver::resolveMapKeySuggestion$lambda$14$lambda$10, arg_0)).map(arg_0 -> StringRangeTreeSuggestionResolver.resolveMapKeySuggestion$lambda$14$lambda$13(arg_0 -> StringRangeTreeSuggestionResolver.resolveMapKeySuggestion$lambda$14$lambda$12($stringEscaper, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
            return stream;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.BEGIN_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.BEGIN_OBJECT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.NUMBER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.BOOLEAN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.NULL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

