/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.mixin.editor.processing;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_151;
import net.minecraft.class_2172;
import net.minecraft.class_2284;
import net.minecraft.class_2960;
import net.papierkorb2292.command_crafter.editor.processing.AnalyzingResourceCreator;
import net.papierkorb2292.command_crafter.editor.processing.IdArgumentTypeAnalyzer;
import net.papierkorb2292.command_crafter.editor.processing.PackContentFileType;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingCommandNode;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.editor.processing.helper.CustomCompletionsCommandNode;
import net.papierkorb2292.command_crafter.parser.DirectiveStringReader;
import net.papierkorb2292.command_crafter.parser.helper.AnalyzedFunctionArgument;
import net.papierkorb2292.command_crafter.parser.languages.VanillaLanguage;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={class_2284.class})
public class CommandFunctionArgumentTypeMixin
implements AnalyzingCommandNode,
CustomCompletionsCommandNode {
    @Override
    public void command_crafter$analyze(@NotNull CommandContext<class_2172> context, @NotNull StringRange range, @NotNull DirectiveStringReader<AnalyzingResourceCreator> reader, @NotNull AnalyzingResult result, @NotNull String name) throws CommandSyntaxException {
        class_2284.class_2285 argument = (class_2284.class_2285)context.getArgument(name, class_2284.class_2285.class);
        if (argument instanceof AnalyzedFunctionArgument) {
            AnalyzedFunctionArgument analyzedArgument = (AnalyzedFunctionArgument)argument;
            result.combineWith(analyzedArgument.getResult());
            return;
        }
        String stringArgument = range.get(reader.getString());
        boolean isTag = stringArgument.startsWith("#");
        try {
            class_2960 id = class_2960.method_60654((String)(isTag ? stringArgument.substring(1) : stringArgument));
            PackContentFileType fileType = isTag ? PackContentFileType.FUNCTION_TAGS_FILE_TYPE : PackContentFileType.FUNCTIONS_FILE_TYPE;
            IdArgumentTypeAnalyzer.INSTANCE.analyzeForId(id, fileType, range, result, reader);
        }
        catch (class_151 id) {
            // empty catch block
        }
        if (VanillaLanguage.Companion.isReaderInlineResources((ImmutableStringReader)reader)) {
            DirectiveStringReader<AnalyzingResourceCreator> readerCopy = reader.copy();
            readerCopy.setCursor(range.getStart());
            AnalyzedFunctionArgument function = VanillaLanguage.Companion.analyzeImprovedFunctionReference(readerCopy, (class_2172)context.getSource(), true);
            if (function != null) {
                result.combineWith(function.getResult());
            }
        }
    }

    @Override
    public boolean command_crafter$hasCustomCompletions(@NotNull CommandContext<class_2172> context, @NotNull String name) {
        return true;
    }
}

