/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.parser.helper;

import com.mojang.brigadier.context.StringRange;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.papierkorb2292.command_crafter.helper.IntList;
import net.papierkorb2292.command_crafter.helper.UtilKt;
import net.papierkorb2292.command_crafter.parser.helper.OffsetProcessedInputCursorMapper;
import net.papierkorb2292.command_crafter.parser.helper.ProcessedInputCursorMapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\fJ\r\u0010\u0010\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u001f\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J/\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001f\u0010\u001eJ'\u0010 \u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b \u0010!J\u0015\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000\u00a2\u0006\u0004\b$\u0010&J\r\u0010'\u001a\u00020\u0000\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010*\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0000\u00a2\u0006\u0004\b*\u0010+R\u0017\u0010,\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u0017\u00100\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b0\u0010-\u001a\u0004\b1\u0010/R\u0017\u00102\u001a\u00020\u00168\u0006\u00a2\u0006\f\n\u0004\b2\u0010-\u001a\u0004\b3\u0010/R\u0017\u00105\u001a\u0002048\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R\"\u00109\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\"\u0010?\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010:\u001a\u0004\b@\u0010<\"\u0004\bA\u0010>\u00a8\u0006B"}, d2={"Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;", "Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;", "<init>", "()V", "", "sourceCursor", "targetCursor", "length", "", "addMapping", "(III)V", "addFollowingMapping", "(II)V", "startCursor", "endCursor", "addExpandedChar", "removeNegativeTargetCursors", "", "clampInGaps", "mapToTarget", "(IZ)I", "mapToSource", "Lnet/papierkorb2292/command_crafter/helper/IntList;", "inputCursors", "outputCursors", "inputCursor", "map", "(Lnet/papierkorb2292/command_crafter/helper/IntList;Lnet/papierkorb2292/command_crafter/helper/IntList;IZ)I", "endInclusive", "containsSourceCursor", "(IZ)Z", "containsTargetCursor", "containsCursor", "(ILnet/papierkorb2292/command_crafter/helper/IntList;Z)Z", "Lnet/papierkorb2292/command_crafter/parser/helper/OffsetProcessedInputCursorMapper;", "targetMapper", "combineWith", "(Lnet/papierkorb2292/command_crafter/parser/helper/OffsetProcessedInputCursorMapper;)Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;", "(Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;)Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;", "copy", "()Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;", "other", "copyFrom", "(Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;)V", "sourceCursors", "Lnet/papierkorb2292/command_crafter/helper/IntList;", "getSourceCursors", "()Lnet/papierkorb2292/command_crafter/helper/IntList;", "targetCursors", "getTargetCursors", "lengths", "getLengths", "Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "expandedCharEnds", "Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "getExpandedCharEnds", "()Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "prevSourceEnd", "I", "getPrevSourceEnd", "()I", "setPrevSourceEnd", "(I)V", "prevTargetEnd", "getPrevTargetEnd", "setPrevTargetEnd", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nSplitProcessedInputCursorMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitProcessedInputCursorMapper.kt\nnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class SplitProcessedInputCursorMapper
implements ProcessedInputCursorMapper {
    @NotNull
    private final IntList sourceCursors = new IntList();
    @NotNull
    private final IntList targetCursors = new IntList();
    @NotNull
    private final IntList lengths = new IntList();
    @NotNull
    private final Int2IntOpenHashMap expandedCharEnds = new Int2IntOpenHashMap();
    private int prevSourceEnd;
    private int prevTargetEnd;

    @NotNull
    public final IntList getSourceCursors() {
        return this.sourceCursors;
    }

    @NotNull
    public final IntList getTargetCursors() {
        return this.targetCursors;
    }

    @NotNull
    public final IntList getLengths() {
        return this.lengths;
    }

    @NotNull
    public final Int2IntOpenHashMap getExpandedCharEnds() {
        return this.expandedCharEnds;
    }

    public final int getPrevSourceEnd() {
        return this.prevSourceEnd;
    }

    public final void setPrevSourceEnd(int n) {
        this.prevSourceEnd = n;
    }

    public final int getPrevTargetEnd() {
        return this.prevTargetEnd;
    }

    public final void setPrevTargetEnd(int n) {
        this.prevTargetEnd = n;
    }

    public final void addMapping(int sourceCursor, int targetCursor, int length) {
        if (!(this.sourceCursors.isEmpty() || sourceCursor >= this.prevSourceEnd && targetCursor >= this.prevTargetEnd)) {
            boolean bl = false;
            String string = "Mappings must be added in order";
            throw new IllegalArgumentException(string.toString());
        }
        this.sourceCursors.add(sourceCursor);
        this.targetCursors.add(targetCursor);
        this.lengths.add(length);
        this.prevSourceEnd = sourceCursor + length;
        this.prevTargetEnd = targetCursor + length;
    }

    public final void addFollowingMapping(int sourceCursor, int length) {
        this.addMapping(sourceCursor, this.prevTargetEnd, length);
    }

    public final void addExpandedChar(int startCursor, int endCursor) {
        Integer n = startCursor;
        Integer n2 = endCursor;
        ((Map)this.expandedCharEnds).put(n, n2);
    }

    public final void removeNegativeTargetCursors() {
        while (!this.lengths.isEmpty()) {
            int targetCursor = this.targetCursors.get(0);
            int length = this.lengths.get(0);
            if (this.lengths.getSize() == 1 || this.targetCursors.get(1) >= 0 || targetCursor + length >= 0) {
                if (targetCursor >= 0) break;
                int newLength = Math.max(length + targetCursor, 0);
                this.lengths.set(0, newLength);
                IntList intList = this.sourceCursors;
                intList.set(0, intList.get(0) - targetCursor);
                this.targetCursors.set(0, 0);
                break;
            }
            this.sourceCursors.remove(0);
            this.targetCursors.remove(0);
            this.lengths.remove(0);
        }
    }

    @Override
    public int mapToTarget(int sourceCursor, boolean clampInGaps) {
        return this.map(this.sourceCursors, this.targetCursors, sourceCursor, clampInGaps);
    }

    @Override
    public int mapToSource(int targetCursor, boolean clampInGaps) {
        return this.map(this.targetCursors, this.sourceCursors, targetCursor, clampInGaps);
    }

    private final int map(IntList inputCursors, IntList outputCursors, int inputCursor, boolean clampInGaps) {
        int mappingIndex = UtilKt.binarySearch$default(inputCursors, 0, 0, arg_0 -> SplitProcessedInputCursorMapper.map$lambda$1(inputCursors, inputCursor, this, arg_0), 3, null);
        if (mappingIndex < 0) {
            if (mappingIndex == -1) {
                return inputCursor;
            }
            mappingIndex = -(mappingIndex + 2);
            if (clampInGaps) {
                return outputCursors.get(mappingIndex) + this.lengths.get(mappingIndex);
            }
        }
        int startInputCursor = inputCursors.get(mappingIndex);
        int relativeCursor = inputCursor - startInputCursor;
        return outputCursors.get(mappingIndex) + relativeCursor;
    }

    public final boolean containsSourceCursor(int sourceCursor, boolean endInclusive) {
        return this.containsCursor(sourceCursor, this.sourceCursors, endInclusive);
    }

    public static /* synthetic */ boolean containsSourceCursor$default(SplitProcessedInputCursorMapper splitProcessedInputCursorMapper, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return splitProcessedInputCursorMapper.containsSourceCursor(n, bl);
    }

    public final boolean containsTargetCursor(int targetCursor, boolean endInclusive) {
        return this.containsCursor(targetCursor, this.targetCursors, endInclusive);
    }

    public static /* synthetic */ boolean containsTargetCursor$default(SplitProcessedInputCursorMapper splitProcessedInputCursorMapper, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return splitProcessedInputCursorMapper.containsTargetCursor(n, bl);
    }

    private final boolean containsCursor(int inputCursor, IntList inputCursors, boolean endInclusive) {
        int endInclusiveOffset = endInclusive ? 1 : 0;
        return 0 <= UtilKt.binarySearch$default(inputCursors, 0, 0, arg_0 -> SplitProcessedInputCursorMapper.containsCursor$lambda$2(inputCursors, inputCursor, this, endInclusiveOffset, arg_0), 3, null);
    }

    @NotNull
    public final SplitProcessedInputCursorMapper combineWith(@NotNull OffsetProcessedInputCursorMapper targetMapper) {
        Intrinsics.checkNotNullParameter((Object)targetMapper, (String)"targetMapper");
        SplitProcessedInputCursorMapper result = new SplitProcessedInputCursorMapper();
        if (this.sourceCursors.isEmpty() || this.sourceCursors.get(0) > 0) {
            result.addMapping(0, targetMapper.getOffset(), 0);
        }
        int n = this.sourceCursors.getSize();
        for (int i2 = 0; i2 < n; ++i2) {
            result.addMapping(this.sourceCursors.get(i2), this.targetCursors.get(i2) + targetMapper.getOffset(), this.lengths.get(i2));
        }
        return result;
    }

    @NotNull
    public final SplitProcessedInputCursorMapper combineWith(@NotNull SplitProcessedInputCursorMapper targetMapper) {
        Intrinsics.checkNotNullParameter((Object)targetMapper, (String)"targetMapper");
        SplitProcessedInputCursorMapper result = new SplitProcessedInputCursorMapper();
        if (this.sourceCursors.isEmpty()) {
            int n = targetMapper.sourceCursors.getSize();
            for (int i2 = 0; i2 < n; ++i2) {
                result.addMapping(targetMapper.sourceCursors.get(i2), targetMapper.targetCursors.get(i2), 0);
            }
            for (Map.Entry entry : ((Map)targetMapper.expandedCharEnds).entrySet()) {
                Integer start = (Integer)entry.getKey();
                Integer end = (Integer)entry.getValue();
                Intrinsics.checkNotNull((Object)start);
                int n2 = start;
                Intrinsics.checkNotNull((Object)end);
                result.addExpandedChar(n2, end);
            }
            return result;
        }
        int currentOtherIndex = targetMapper.lengths.isEmpty() ? -1 : 0;
        int start = this.sourceCursors.getSize();
        for (int i3 = 0; i3 < start; ++i3) {
            int sourceCursor = this.sourceCursors.get(i3);
            int targetCursor = this.targetCursors.get(i3);
            while (currentOtherIndex != -1 && targetMapper.sourceCursors.get(currentOtherIndex) + targetMapper.lengths.get(currentOtherIndex) < targetCursor) {
                currentOtherIndex = targetMapper.lengths.getSize() > currentOtherIndex + 1 ? currentOtherIndex + 1 : -1;
            }
            if (currentOtherIndex == -1 || targetMapper.sourceCursors.get(currentOtherIndex) > targetCursor) {
                if (targetMapper.sourceCursors.isEmpty() || currentOtherIndex == 0) {
                    result.addMapping(sourceCursor, targetCursor, 0);
                } else {
                    int prevOtherIndex = currentOtherIndex == -1 ? targetMapper.sourceCursors.getSize() - 1 : currentOtherIndex - 1;
                    int translation = targetMapper.targetCursors.get(prevOtherIndex) - targetMapper.sourceCursors.get(prevOtherIndex);
                    result.addMapping(sourceCursor, targetCursor + translation, 0);
                }
            }
            if (currentOtherIndex == -1) continue;
            int nextMappingMinSourceStart = sourceCursor;
            while (currentOtherIndex != -1 && (targetMapper.sourceCursors.get(currentOtherIndex) <= targetCursor + this.lengths.get(i3) || i3 == this.sourceCursors.getSize() - 1)) {
                int mappedOtherStart = targetMapper.sourceCursors.get(currentOtherIndex) - targetCursor + sourceCursor;
                int sourceStart = Math.max(mappedOtherStart, sourceCursor);
                int mappingLength = Math.min(Math.min(mappedOtherStart - sourceCursor, 0) + targetMapper.lengths.get(currentOtherIndex), Math.max(sourceCursor + this.lengths.get(i3) - nextMappingMinSourceStart, 0));
                result.addMapping(sourceStart, targetMapper.targetCursors.get(currentOtherIndex) - mappedOtherStart + sourceStart, mappingLength);
                nextMappingMinSourceStart = sourceStart + mappingLength;
                currentOtherIndex = targetMapper.lengths.getSize() > currentOtherIndex + 1 ? currentOtherIndex + 1 : -1;
            }
            if (currentOtherIndex == -1) {
                currentOtherIndex = targetMapper.sourceCursors.getSize() - 1;
                continue;
            }
            --currentOtherIndex;
        }
        IntIterator intIterator = ((IntSet)targetMapper.expandedCharEnds.keySet()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator expandedCharCursors = intIterator;
        while (expandedCharCursors.hasNext()) {
            int startCursor = expandedCharCursors.nextInt();
            int endCursor = targetMapper.expandedCharEnds.get(startCursor);
            int mappedStart = this.mapToSource(startCursor, false);
            int mappedEnd = this.mapToSource(endCursor, false);
            result.addExpandedChar(mappedStart, mappedEnd);
        }
        return result;
    }

    @NotNull
    public final SplitProcessedInputCursorMapper copy() {
        SplitProcessedInputCursorMapper result = new SplitProcessedInputCursorMapper();
        result.copyFrom(this);
        return result;
    }

    public final void copyFrom(@NotNull SplitProcessedInputCursorMapper other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.sourceCursors.clear();
        this.targetCursors.clear();
        this.lengths.clear();
        this.expandedCharEnds.clear();
        this.sourceCursors.addAll(other.sourceCursors);
        this.targetCursors.addAll(other.targetCursors);
        this.lengths.addAll(other.lengths);
        this.expandedCharEnds.putAll((Map)other.expandedCharEnds);
        this.prevSourceEnd = other.prevSourceEnd;
        this.prevTargetEnd = other.prevTargetEnd;
    }

    @Override
    @NotNull
    public StringRange mapToTarget(@NotNull StringRange sourceRange, boolean clampInGaps) {
        return ProcessedInputCursorMapper.DefaultImpls.mapToTarget(this, sourceRange, clampInGaps);
    }

    @Override
    @NotNull
    public StringRange mapToSource(@NotNull StringRange targetRange, boolean clampInGaps) {
        return ProcessedInputCursorMapper.DefaultImpls.mapToSource(this, targetRange, clampInGaps);
    }

    private static final int map$lambda$1(IntList $inputCursors, int $inputCursor, SplitProcessedInputCursorMapper this$0, int index) {
        return $inputCursors.get(index) > $inputCursor ? 1 : ($inputCursors.get(index) + this$0.lengths.get(index) <= $inputCursor ? -1 : 0);
    }

    private static final int containsCursor$lambda$2(IntList $inputCursors, int $inputCursor, SplitProcessedInputCursorMapper this$0, int $endInclusiveOffset, int index) {
        return $inputCursors.get(index) > $inputCursor ? 1 : ($inputCursors.get(index) + this$0.lengths.get(index) + $endInclusiveOffset <= $inputCursor ? -1 : 0);
    }
}

