/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.client.editor.debugger;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_8710;
import net.papierkorb2292.command_crafter.client.NetworkServerConnection;
import net.papierkorb2292.command_crafter.editor.debugger.variables.VariablesReferencer;
import net.papierkorb2292.command_crafter.networking.packets.GetVariablesRequestC2SPacket;
import net.papierkorb2292.command_crafter.networking.packets.SetVariableRequestC2SPacket;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.Variable;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\n2\u0006\u0010\t\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lnet/papierkorb2292/command_crafter/client/editor/debugger/NetworkVariablesReferencer;", "Lnet/papierkorb2292/command_crafter/editor/debugger/variables/VariablesReferencer;", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "packetSender", "Ljava/util/UUID;", "pauseId", "<init>", "(Lnet/fabricmc/fabric/api/networking/v1/PacketSender;Ljava/util/UUID;)V", "Lorg/eclipse/lsp4j/debug/VariablesArguments;", "args", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/eclipse/lsp4j/debug/Variable;", "getVariables", "(Lorg/eclipse/lsp4j/debug/VariablesArguments;)Ljava/util/concurrent/CompletableFuture;", "Lorg/eclipse/lsp4j/debug/SetVariableArguments;", "Lnet/papierkorb2292/command_crafter/editor/debugger/variables/VariablesReferencer$SetVariableResult;", "setVariable", "(Lorg/eclipse/lsp4j/debug/SetVariableArguments;)Ljava/util/concurrent/CompletableFuture;", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "getPacketSender", "()Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "Ljava/util/UUID;", "getPauseId", "()Ljava/util/UUID;", "command-crafter_client"})
@Environment(value=EnvType.CLIENT)
public final class NetworkVariablesReferencer
implements VariablesReferencer {
    @NotNull
    private final PacketSender packetSender;
    @NotNull
    private final UUID pauseId;

    public NetworkVariablesReferencer(@NotNull PacketSender packetSender, @NotNull UUID pauseId) {
        Intrinsics.checkNotNullParameter((Object)packetSender, (String)"packetSender");
        Intrinsics.checkNotNullParameter((Object)pauseId, (String)"pauseId");
        this.packetSender = packetSender;
        this.pauseId = pauseId;
    }

    @NotNull
    public final PacketSender getPacketSender() {
        return this.packetSender;
    }

    @NotNull
    public final UUID getPauseId() {
        return this.pauseId;
    }

    @Override
    @NotNull
    public CompletableFuture<Variable[]> getVariables(@NotNull VariablesArguments args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        UUID requestId = UUID.randomUUID();
        CompletableFuture<Variable[]> future = new CompletableFuture<Variable[]>();
        NetworkServerConnection.Companion.getCurrentGetVariablesRequests().put(requestId, future);
        Intrinsics.checkNotNull((Object)requestId);
        this.packetSender.sendPacket((class_8710)new GetVariablesRequestC2SPacket(this.pauseId, requestId, args));
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<VariablesReferencer.SetVariableResult> setVariable(@NotNull SetVariableArguments args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        UUID requestId = UUID.randomUUID();
        CompletableFuture<VariablesReferencer.SetVariableResult> future = new CompletableFuture<VariablesReferencer.SetVariableResult>();
        NetworkServerConnection.Companion.getCurrentSetVariableRequests().put(requestId, future);
        Intrinsics.checkNotNull((Object)requestId);
        this.packetSender.sendPacket((class_8710)new SetVariableRequestC2SPacket(this.pauseId, requestId, args));
        return future;
    }
}

