/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.papierkorb2292.command_crafter.CommandCrafter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010!\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u000f\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R*\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00028\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR&\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\r0\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lnet/papierkorb2292/command_crafter/config/CommandCrafterConfig;", "", "", "servicesPort", "", "runDedicatedServerServices", "Ljava/nio/file/Path;", "configPath", "<init>", "(IZLjava/nio/file/Path;)V", "", "saveToFile", "()V", "Lkotlin/Function1;", "listener", "addServicesPortChangedListener", "(Lkotlin/jvm/functions/Function1;)V", "Z", "getRunDedicatedServerServices", "()Z", "Ljava/nio/file/Path;", "getConfigPath", "()Ljava/nio/file/Path;", "value", "I", "getServicesPort", "()I", "setServicesPort", "(I)V", "", "servicesPortChangedListeners", "Ljava/util/List;", "Companion", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nCommandCrafterConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandCrafterConfig.kt\nnet/papierkorb2292/command_crafter/config/CommandCrafterConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1869#2,2:105\n*S KotlinDebug\n*F\n+ 1 CommandCrafterConfig.kt\nnet/papierkorb2292/command_crafter/config/CommandCrafterConfig\n*L\n22#1:105,2\n*E\n"})
public final class CommandCrafterConfig {
    @NotNull
    public static final Companion Companion;
    private final boolean runDedicatedServerServices;
    @NotNull
    private final Path configPath;
    private int servicesPort;
    @NotNull
    private final List<Function1<Integer, Unit>> servicesPortChangedListeners;
    private static final Path DEFAULT_CONFIG_PATH;
    @NotNull
    private static final String SERVICES_PORT_NAME;
    private static final int DEFAULT_SERVICES_PORT;
    @NotNull
    private static final String RUN_DEDICATED_SERVER_SERVICES_NAME;
    private static final boolean DEFAULT_RUN_DEDICATED_SERVER_SERVICES;
    @NotNull
    private static final Properties CONFIG_DEFAULTS;

    private CommandCrafterConfig(int servicesPort, boolean runDedicatedServerServices, Path configPath) {
        this.runDedicatedServerServices = runDedicatedServerServices;
        this.configPath = configPath;
        this.servicesPort = servicesPort;
        this.servicesPortChangedListeners = new ArrayList();
    }

    public final boolean getRunDedicatedServerServices() {
        return this.runDedicatedServerServices;
    }

    @NotNull
    public final Path getConfigPath() {
        return this.configPath;
    }

    public final int getServicesPort() {
        return this.servicesPort;
    }

    public final void setServicesPort(int value) {
        this.servicesPort = value;
        this.saveToFile();
        Iterable $this$forEach$iv = this.servicesPortChangedListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)value);
        }
    }

    public final void saveToFile() {
        try {
            Comparable<Path> comparable = this.configPath.getParent();
            if (comparable != null && (comparable = comparable.toFile()) != null) {
                ((File)comparable).mkdirs();
            }
            Path path = this.configPath;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Charset charset = Charsets.UTF_8;
            OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset);
            writer.append("v" + CommandCrafter.INSTANCE.getVERSION() + "\n");
            Properties properties = new Properties();
            properties.setProperty(SERVICES_PORT_NAME, String.valueOf(this.servicesPort));
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                properties.setProperty(RUN_DEDICATED_SERVER_SERVICES_NAME, String.valueOf(this.runDedicatedServerServices));
            }
            properties.store(writer, "CommandCrafter Config");
        }
        catch (IOException e) {
            CommandCrafter.INSTANCE.getLOGGER().error("Failed to save config file", (Throwable)e);
        }
    }

    public final void addServicesPortChangedListener(@NotNull Function1<? super Integer, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        ((Collection)this.servicesPortChangedListeners).add(listener);
    }

    public /* synthetic */ CommandCrafterConfig(int servicesPort, boolean runDedicatedServerServices, Path configPath, DefaultConstructorMarker $constructor_marker) {
        this(servicesPort, runDedicatedServerServices, configPath);
    }

    static {
        Properties properties;
        Companion = new Companion(null);
        DEFAULT_CONFIG_PATH = Path.of("config/command_crafter.properties", new String[0]);
        SERVICES_PORT_NAME = "services-port";
        DEFAULT_SERVICES_PORT = 52853;
        RUN_DEDICATED_SERVER_SERVICES_NAME = "run-dedicated-server-services";
        Properties $this$CONFIG_DEFAULTS_u24lambda_u241 = properties = new Properties();
        boolean bl = false;
        $this$CONFIG_DEFAULTS_u24lambda_u241.setProperty(SERVICES_PORT_NAME, String.valueOf(DEFAULT_SERVICES_PORT));
        $this$CONFIG_DEFAULTS_u24lambda_u241.setProperty(RUN_DEDICATED_SERVER_SERVICES_NAME, String.valueOf(DEFAULT_RUN_DEDICATED_SERVER_SERVICES));
        CONFIG_DEFAULTS = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000eR\u001f\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00060\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\b8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0015\u001a\u0004\b\u001c\u0010\u0017R\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lnet/papierkorb2292/command_crafter/config/CommandCrafterConfig$Companion;", "", "<init>", "()V", "Ljava/util/Properties;", "properties", "Ljava/nio/file/Path;", "configPath", "", "configVersion", "Lnet/papierkorb2292/command_crafter/config/CommandCrafterConfig;", "fromProperties", "(Ljava/util/Properties;Ljava/nio/file/Path;Ljava/lang/String;)Lnet/papierkorb2292/command_crafter/config/CommandCrafterConfig;", "fromFile", "(Ljava/nio/file/Path;)Lnet/papierkorb2292/command_crafter/config/CommandCrafterConfig;", "kotlin.jvm.PlatformType", "DEFAULT_CONFIG_PATH", "Ljava/nio/file/Path;", "getDEFAULT_CONFIG_PATH", "()Ljava/nio/file/Path;", "SERVICES_PORT_NAME", "Ljava/lang/String;", "getSERVICES_PORT_NAME", "()Ljava/lang/String;", "", "DEFAULT_SERVICES_PORT", "I", "RUN_DEDICATED_SERVER_SERVICES_NAME", "getRUN_DEDICATED_SERVER_SERVICES_NAME", "", "DEFAULT_RUN_DEDICATED_SERVER_SERVICES", "Z", "CONFIG_DEFAULTS", "Ljava/util/Properties;", "command-crafter"})
    public static final class Companion {
        private Companion() {
        }

        public final Path getDEFAULT_CONFIG_PATH() {
            return DEFAULT_CONFIG_PATH;
        }

        @NotNull
        public final String getSERVICES_PORT_NAME() {
            return SERVICES_PORT_NAME;
        }

        @NotNull
        public final String getRUN_DEDICATED_SERVER_SERVICES_NAME() {
            return RUN_DEDICATED_SERVER_SERVICES_NAME;
        }

        @NotNull
        public final CommandCrafterConfig fromProperties(@NotNull Properties properties, @NotNull Path configPath, @NotNull String configVersion) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
            Intrinsics.checkNotNullParameter((Object)configVersion, (String)"configVersion");
            String string = properties.getProperty(this.getSERVICES_PORT_NAME());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            Integer servicesPort = StringsKt.toIntOrNull((String)string);
            if (servicesPort == null) {
                servicesPort = DEFAULT_SERVICES_PORT;
                CommandCrafter.INSTANCE.getLOGGER().warn("Encountered invalid services port in config file, using default value " + servicesPort);
            }
            String string2 = properties.getProperty(this.getRUN_DEDICATED_SERVER_SERVICES_NAME());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
            Boolean runServersideServices = StringsKt.toBooleanStrictOrNull((String)string2);
            if (runServersideServices == null) {
                runServersideServices = DEFAULT_RUN_DEDICATED_SERVER_SERVICES;
                CommandCrafter.INSTANCE.getLOGGER().warn("Encountered invalid run-serverside-services value in config file, using default value " + DEFAULT_RUN_DEDICATED_SERVER_SERVICES);
            }
            CommandCrafterConfig config = new CommandCrafterConfig(servicesPort, runServersideServices, configPath, null);
            if (!Intrinsics.areEqual((Object)configVersion, (Object)CommandCrafter.INSTANCE.getVERSION())) {
                CommandCrafter.INSTANCE.getLOGGER().info("Updating old config file to new version: " + CommandCrafter.INSTANCE.getVERSION());
                config.saveToFile();
            }
            return config;
        }

        @NotNull
        public final CommandCrafterConfig fromFile(@NotNull Path configPath) {
            Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
            Properties properties = new Properties(CONFIG_DEFAULTS);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(configPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                CommandCrafterConfig config = new CommandCrafterConfig(DEFAULT_SERVICES_PORT, DEFAULT_RUN_DEDICATED_SERVER_SERVICES, configPath, null);
                config.saveToFile();
                return config;
            }
            try {
                String string;
                Object object = configPath;
                OpenOption[] openOptionArray = new OpenOption[]{};
                Charset charset = Charsets.UTF_8;
                object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset);
                int n = 8192;
                BufferedReader reader = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                reader.mark(16);
                int firstChar = reader.read();
                if (firstChar == 118) {
                    string = reader.readLine();
                } else {
                    reader.reset();
                    string = CommandCrafter.INSTANCE.getVERSION();
                }
                String configVersion = string;
                properties.load(reader);
                Intrinsics.checkNotNull((Object)configVersion);
                return this.fromProperties(properties, configPath, configVersion);
            }
            catch (IOException e) {
                CommandCrafter.INSTANCE.getLOGGER().error("Failed to load config file", (Throwable)e);
                return this.fromProperties(new Properties(CONFIG_DEFAULTS), configPath, CommandCrafter.INSTANCE.getVERSION());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

