/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor;

import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import net.papierkorb2292.command_crafter.CommandCrafter;
import net.papierkorb2292.command_crafter.editor.EditorConnection;
import net.papierkorb2292.command_crafter.editor.EditorConnectionAcceptor;
import net.papierkorb2292.command_crafter.editor.EditorService;
import net.papierkorb2292.command_crafter.editor.FeatureConfig;
import net.papierkorb2292.command_crafter.editor.MinecraftClientConnection;
import net.papierkorb2292.command_crafter.editor.MinecraftServerConnection;
import net.papierkorb2292.command_crafter.helper.CallbackExecutorService;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.jsonrpc.debug.json.DebugMessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.debug.messages.DebugRequestMessage;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageProducer;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.services.LanguageClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0005:;<=>B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0015\u0010\u0010J'\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u000e\u00a2\u0006\u0004\b \u0010\u0010J\u0015\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010$R\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010'R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010(R2\u0010/\u001a \u0012\u0004\u0012\u00020*\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0-0+0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0018\u00102\u001a\u0004\u0018\u0001018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R*\u0010\u0005\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00048\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u00105\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006?"}, d2={"Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager;", "", "Lnet/papierkorb2292/command_crafter/editor/EditorConnectionAcceptor;", "connectionAcceptor", "Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;", "minecraftServerConnection", "Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;", "minecraftClientConnection", "", "", "Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceLauncher;", "serviceLaunchers", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/EditorConnectionAcceptor;Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;Ljava/util/Map;)V", "", "startServer", "()V", "Lnet/papierkorb2292/command_crafter/editor/EditorConnection;", "editorConnection", "handleConnection", "(Lnet/papierkorb2292/command_crafter/editor/EditorConnection;)V", "stopServer", "connection", "serviceLauncher", "Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;", "featureConfig", "startService", "(Lnet/papierkorb2292/command_crafter/editor/EditorConnection;Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceLauncher;Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;)V", "Lorg/eclipse/lsp4j/MessageParams;", "message", "showMessage", "(Lorg/eclipse/lsp4j/MessageParams;)V", "leave", "newConnectionAcceptor", "copyForNewConnectionAcceptor", "(Lnet/papierkorb2292/command_crafter/editor/EditorConnectionAcceptor;)Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager;", "Lnet/papierkorb2292/command_crafter/editor/EditorConnectionAcceptor;", "Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;", "getMinecraftClientConnection", "()Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;", "Ljava/util/Map;", "Ljava/util/concurrent/ConcurrentMap;", "Lnet/papierkorb2292/command_crafter/editor/EditorService;", "Lkotlin/Pair;", "Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceClient;", "Ljava/util/concurrent/Future;", "Ljava/lang/Void;", "runningServices", "Ljava/util/concurrent/ConcurrentMap;", "Ljava/lang/Thread;", "connector", "Ljava/lang/Thread;", "value", "Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;", "getMinecraftServerConnection", "()Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;", "setMinecraftServerConnection", "(Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;)V", "ServiceLauncher", "ServiceClient", "LaunchedService", "ServiceRemover", "ConnectToServiceArgs", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nEditorConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConnectionManager.kt\nnet/papierkorb2292/command_crafter/editor/EditorConnectionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nnet/papierkorb2292/command_crafter/helper/UtilKt\n*L\n1#1,149:1\n1#2:150\n105#3:151\n*S KotlinDebug\n*F\n+ 1 EditorConnectionManager.kt\nnet/papierkorb2292/command_crafter/editor/EditorConnectionManager\n*L\n56#1:151\n*E\n"})
public final class EditorConnectionManager {
    @NotNull
    private final EditorConnectionAcceptor connectionAcceptor;
    @Nullable
    private final MinecraftClientConnection minecraftClientConnection;
    @NotNull
    private final Map<String, ServiceLauncher> serviceLaunchers;
    @NotNull
    private final ConcurrentMap<EditorService, Pair<ServiceClient, Future<Void>>> runningServices;
    @Nullable
    private Thread connector;
    @NotNull
    private MinecraftServerConnection minecraftServerConnection;

    public EditorConnectionManager(@NotNull EditorConnectionAcceptor connectionAcceptor, @NotNull MinecraftServerConnection minecraftServerConnection, @Nullable MinecraftClientConnection minecraftClientConnection, @NotNull Map<String, ? extends ServiceLauncher> serviceLaunchers2) {
        Intrinsics.checkNotNullParameter((Object)connectionAcceptor, (String)"connectionAcceptor");
        Intrinsics.checkNotNullParameter((Object)minecraftServerConnection, (String)"minecraftServerConnection");
        Intrinsics.checkNotNullParameter(serviceLaunchers2, (String)"serviceLaunchers");
        this.connectionAcceptor = connectionAcceptor;
        this.minecraftClientConnection = minecraftClientConnection;
        this.serviceLaunchers = serviceLaunchers2;
        this.runningServices = new ConcurrentHashMap();
        this.minecraftServerConnection = minecraftServerConnection;
    }

    @Nullable
    public final MinecraftClientConnection getMinecraftClientConnection() {
        return this.minecraftClientConnection;
    }

    @NotNull
    public final MinecraftServerConnection getMinecraftServerConnection() {
        return this.minecraftServerConnection;
    }

    public final void setMinecraftServerConnection(@NotNull MinecraftServerConnection value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.minecraftServerConnection = value;
        for (EditorService server : this.runningServices.keySet()) {
            server.setMinecraftServerConnection(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void startServer() {
        void $this$startServer_u24lambda_u241;
        Thread thread;
        this.stopServer();
        this.connectionAcceptor.start();
        Thread thread2 = thread = new Thread(() -> EditorConnectionManager.startServer$lambda$0(this));
        EditorConnectionManager editorConnectionManager = this;
        boolean bl = false;
        $this$startServer_u24lambda_u241.start();
        editorConnectionManager.connector = thread;
    }

    private final void handleConnection(EditorConnection editorConnection) {
        InputStream inputStream = editorConnection.getInputStream();
        Type[] typeArray = new Type[1];
        boolean $i$f$getType = false;
        Intrinsics.checkNotNullExpressionValue((Object)new TypeToken<Either<String, ConnectToServiceArgs>>(){}.getType(), (String)"getType(...)");
        StreamMessageProducer connectorMessageReader = new StreamMessageProducer(inputStream, (MessageJsonHandler)new DebugMessageJsonHandler(MapsKt.mapOf((Pair)TuplesKt.to((Object)"connectToService", (Object)JsonRpcMethod.notification((String)"connectToService", (Type[])typeArray)))));
        connectorMessageReader.listen(arg_0 -> EditorConnectionManager.handleConnection$lambda$6(this, connectorMessageReader, editorConnection, arg_0));
    }

    public final void stopServer() {
        Thread thread = this.connector;
        if (thread != null) {
            thread.interrupt();
        }
        this.connector = null;
        Iterator iterator = this.runningServices.values().iterator();
        while (iterator.hasNext()) {
            Future connection = (Future)((Pair)iterator.next()).component2();
            connection.cancel(true);
        }
        this.runningServices.clear();
        this.connectionAcceptor.stop();
    }

    private final void startService(EditorConnection connection, ServiceLauncher serviceLauncher, FeatureConfig featureConfig) {
        ServiceRemover serviceRemover = new ServiceRemover((Map)this.runningServices, null);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        LaunchedService launchedService = serviceLauncher.launch(this.minecraftServerConnection, this.minecraftClientConnection, connection, new CallbackExecutorService(executorService, (Function0<Unit>)((Function0)serviceRemover)), featureConfig);
        serviceRemover.setService(launchedService.getServer());
        ((Map)this.runningServices).put(launchedService.getServer(), TuplesKt.to((Object)launchedService.getClient(), launchedService.getProcess()));
    }

    public final void showMessage(@NotNull MessageParams message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Iterator iterator = this.runningServices.values().iterator();
        while (iterator.hasNext()) {
            ServiceClient serviceClient = (ServiceClient)((Pair)iterator.next()).component1();
            Object object = serviceClient.getClient();
            LanguageClient languageClient = object instanceof LanguageClient ? (LanguageClient)object : null;
            if (languageClient == null) continue;
            languageClient.showMessage(message);
        }
    }

    public final void leave() {
        for (EditorService editorServer : this.runningServices.keySet()) {
            editorServer.leave();
        }
    }

    @NotNull
    public final EditorConnectionManager copyForNewConnectionAcceptor(@NotNull EditorConnectionAcceptor newConnectionAcceptor) {
        Intrinsics.checkNotNullParameter((Object)newConnectionAcceptor, (String)"newConnectionAcceptor");
        return new EditorConnectionManager(newConnectionAcceptor, this.minecraftServerConnection, this.minecraftClientConnection, this.serviceLaunchers);
    }

    private static final void startServer$lambda$0(EditorConnectionManager this$0) {
        while (this$0.connectionAcceptor.isRunning()) {
            EditorConnection editorConnection;
            if (this$0.connectionAcceptor.accept() == null) continue;
            try {
                this$0.handleConnection(editorConnection);
            }
            catch (Exception e) {
                editorConnection.close();
                CommandCrafter.INSTANCE.getLOGGER().error("Error while connecting to editor", (Throwable)e);
            }
        }
    }

    private static final String handleConnection$lambda$6$lambda$2(String it) {
        return it;
    }

    private static final String handleConnection$lambda$6$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String handleConnection$lambda$6$lambda$4(ConnectToServiceArgs it) {
        return it.getService();
    }

    private static final String handleConnection$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void handleConnection$lambda$6(EditorConnectionManager this$0, StreamMessageProducer $connectorMessageReader, EditorConnection $editorConnection, Message msg) {
        if (!(msg instanceof DebugRequestMessage)) {
            return;
        }
        if (!Intrinsics.areEqual((Object)((DebugRequestMessage)msg).getMethod(), (Object)"connectToService")) {
            return;
        }
        Object object = ((DebugRequestMessage)msg).getParams();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.eclipse.lsp4j.jsonrpc.messages.Either<kotlin.String, net.papierkorb2292.command_crafter.editor.EditorConnectionManager.ConnectToServiceArgs>");
        Either serviceArgs = (Either)object;
        String serviceName = (String)serviceArgs.map(arg_0 -> EditorConnectionManager.handleConnection$lambda$6$lambda$3(EditorConnectionManager::handleConnection$lambda$6$lambda$2, arg_0), arg_0 -> EditorConnectionManager.handleConnection$lambda$6$lambda$5(EditorConnectionManager::handleConnection$lambda$6$lambda$4, arg_0));
        Object object2 = (ConnectToServiceArgs)serviceArgs.getRight();
        if (object2 == null || (object2 = ((ConnectToServiceArgs)object2).getFeatureConfig()) == null) {
            object2 = MapsKt.emptyMap();
        }
        FeatureConfig featureConfig = new FeatureConfig((Map<String, ? extends FeatureConfig.Entry>)object2);
        ServiceLauncher serviceCreator = this$0.serviceLaunchers.get(serviceName);
        if (serviceCreator != null) {
            $connectorMessageReader.close();
            this$0.startService($editorConnection, serviceCreator, featureConfig);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR0\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ConnectToServiceArgs;", "", "", "service", "", "Lnet/papierkorb2292/command_crafter/editor/FeatureConfig$Entry;", "featureConfig", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "()V", "Ljava/lang/String;", "getService", "()Ljava/lang/String;", "setService", "(Ljava/lang/String;)V", "Ljava/util/Map;", "getFeatureConfig", "()Ljava/util/Map;", "setFeatureConfig", "(Ljava/util/Map;)V", "command-crafter"})
    public static final class ConnectToServiceArgs {
        @NotNull
        private String service;
        @Nullable
        private Map<String, ? extends FeatureConfig.Entry> featureConfig;

        public ConnectToServiceArgs(@NotNull String service, @Nullable Map<String, ? extends FeatureConfig.Entry> featureConfig) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            this.service = service;
            this.featureConfig = featureConfig;
        }

        @NotNull
        public final String getService() {
            return this.service;
        }

        public final void setService(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.service = string;
        }

        @Nullable
        public final Map<String, FeatureConfig.Entry> getFeatureConfig() {
            return this.featureConfig;
        }

        public final void setFeatureConfig(@Nullable Map<String, ? extends FeatureConfig.Entry> map2) {
            this.featureConfig = map2;
        }

        public ConnectToServiceArgs() {
            this("", null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$LaunchedService;", "", "Lnet/papierkorb2292/command_crafter/editor/EditorService;", "server", "Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceClient;", "client", "Ljava/util/concurrent/Future;", "Ljava/lang/Void;", "process", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/EditorService;Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceClient;Ljava/util/concurrent/Future;)V", "Lnet/papierkorb2292/command_crafter/editor/EditorService;", "getServer", "()Lnet/papierkorb2292/command_crafter/editor/EditorService;", "Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceClient;", "getClient", "()Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceClient;", "Ljava/util/concurrent/Future;", "getProcess", "()Ljava/util/concurrent/Future;", "command-crafter"})
    public static final class LaunchedService {
        @NotNull
        private final EditorService server;
        @NotNull
        private final ServiceClient client;
        @NotNull
        private final Future<Void> process;

        public LaunchedService(@NotNull EditorService server, @NotNull ServiceClient client, @NotNull Future<Void> process) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(process, (String)"process");
            this.server = server;
            this.client = client;
            this.process = process;
        }

        @NotNull
        public final EditorService getServer() {
            return this.server;
        }

        @NotNull
        public final ServiceClient getClient() {
            return this.client;
        }

        @NotNull
        public final Future<Void> getProcess() {
            return this.process;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0017\u0010\u0002\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceClient;", "", "client", "<init>", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getClient", "()Ljava/lang/Object;", "command-crafter"})
    public static final class ServiceClient {
        @NotNull
        private final Object client;

        public ServiceClient(@NotNull Object client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            this.client = client;
        }

        @NotNull
        public final Object getClient() {
            return this.client;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J9\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH&\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceLauncher;", "", "Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;", "serverConnection", "Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;", "clientConnection", "Lnet/papierkorb2292/command_crafter/editor/EditorConnection;", "editorConnection", "Ljava/util/concurrent/ExecutorService;", "executorService", "Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;", "featureConfig", "Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$LaunchedService;", "launch", "(Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;Lnet/papierkorb2292/command_crafter/editor/EditorConnection;Ljava/util/concurrent/ExecutorService;Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;)Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$LaunchedService;", "command-crafter"})
    public static interface ServiceLauncher {
        @NotNull
        public LaunchedService launch(@NotNull MinecraftServerConnection var1, @Nullable MinecraftClientConnection var2, @NotNull EditorConnection var3, @NotNull ExecutorService var4, @NotNull FeatureConfig var5);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u001e\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000bR$\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lnet/papierkorb2292/command_crafter/editor/EditorConnectionManager$ServiceRemover;", "Lkotlin/Function0;", "", "", "Lnet/papierkorb2292/command_crafter/editor/EditorService;", "runningServices", "service", "<init>", "(Ljava/util/Map;Lnet/papierkorb2292/command_crafter/editor/EditorService;)V", "invoke", "()V", "Ljava/util/Map;", "Lnet/papierkorb2292/command_crafter/editor/EditorService;", "getService", "()Lnet/papierkorb2292/command_crafter/editor/EditorService;", "setService", "(Lnet/papierkorb2292/command_crafter/editor/EditorService;)V", "command-crafter"})
    public static final class ServiceRemover
    implements Function0<Unit> {
        @NotNull
        private final Map<EditorService, ?> runningServices;
        @Nullable
        private EditorService service;

        public ServiceRemover(@NotNull Map<EditorService, ?> runningServices, @Nullable EditorService service) {
            Intrinsics.checkNotNullParameter(runningServices, (String)"runningServices");
            this.runningServices = runningServices;
            this.service = service;
        }

        @Nullable
        public final EditorService getService() {
            return this.service;
        }

        public final void setService(@Nullable EditorService editorService) {
            this.service = editorService;
        }

        public void invoke() {
            EditorService editorService = this.service;
            if (editorService != null) {
                editorService.onClosed();
            }
            Map<EditorService, ?> map2 = this.runningServices;
            EditorService editorService2 = this.service;
            TypeIntrinsics.asMutableMap(map2).remove(editorService2);
        }
    }
}

