/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor;

import java.net.URLDecoder;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B;\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0014\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lnet/papierkorb2292/command_crafter/editor/EditorURI;", "", "", "scheme", "authority", "path", "query", "fragment", "", "strict", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "copyWithPath", "(Ljava/lang/String;)Lnet/papierkorb2292/command_crafter/editor/EditorURI;", "toPatternMatch", "()Ljava/lang/String;", "toString", "Ljava/lang/String;", "getAuthority", "getQuery", "getFragment", "getScheme", "getPath", "Companion", "command-crafter"})
public final class EditorURI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String authority;
    @NotNull
    private final String query;
    @NotNull
    private final String fragment;
    @NotNull
    private final String scheme;
    @NotNull
    private final String path;
    @NotNull
    private static final Regex uriRegex = new Regex("^(([^:/?#]+?):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    @NotNull
    private static final Regex encodedAsHex = new Regex("(%[0-9A-Za-z][0-9A-Za-z])+");

    private EditorURI(String scheme, String authority, String path, String query, String fragment, boolean strict) {
        this.authority = authority;
        this.query = query;
        this.fragment = fragment;
        this.scheme = Companion.schemeFix(scheme, strict);
        this.path = Companion.referenceResolution(scheme, path);
    }

    /* synthetic */ EditorURI(String string, String string2, String string3, String string4, String string5, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(string, string2, string3, string4, string5, bl);
    }

    @NotNull
    public final String getAuthority() {
        return this.authority;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    @NotNull
    public final String getFragment() {
        return this.fragment;
    }

    @NotNull
    public final String getScheme() {
        return this.scheme;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final EditorURI copyWithPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new EditorURI(this.scheme, this.authority, path, this.query, this.fragment, false, 32, null);
    }

    @NotNull
    public final String toPatternMatch() {
        String[] stringArray = new String[]{"/"};
        List segments = StringsKt.split$default((CharSequence)this.path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String pathRegex = CollectionsKt.joinToString$default((Iterable)segments, (CharSequence)"/", null, null, (int)0, null, EditorURI::toPatternMatch$lambda$1, (int)30, null);
        String scheme = Pattern.quote(this.scheme);
        String authority = Pattern.quote(this.authority);
        return scheme + "://" + authority + pathRegex;
    }

    @NotNull
    public String toString() {
        String query = ((CharSequence)this.query).length() == 0 ? "" : "?" + this.query;
        String fragment = ((CharSequence)this.fragment).length() == 0 ? "" : "#" + this.fragment;
        return this.scheme + "://" + this.authority + this.path + query + fragment;
    }

    private static final CharSequence toPatternMatch$lambda$1$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = Pattern.quote(it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quote(...)");
        return string;
    }

    private static final CharSequence toPatternMatch$lambda$1(String segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        if (Intrinsics.areEqual((Object)segment, (Object)"**")) {
            return ".+";
        }
        String[] stringArray = new String[]{"*"};
        List literalParts = StringsKt.split$default((CharSequence)segment, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return CollectionsKt.joinToString$default((Iterable)literalParts, (CharSequence)"[^/]+", null, null, (int)0, null, EditorURI::toPatternMatch$lambda$1$lambda$0, (int)30, null);
    }

    public /* synthetic */ EditorURI(String scheme, String authority, String path, String query, String fragment, boolean strict, DefaultConstructorMarker $constructor_marker) {
        this(scheme, authority, path, query, fragment, strict);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lnet/papierkorb2292/command_crafter/editor/EditorURI$Companion;", "", "<init>", "()V", "", "uri", "", "strict", "Lnet/papierkorb2292/command_crafter/editor/EditorURI;", "parseURI", "(Ljava/lang/String;Z)Lnet/papierkorb2292/command_crafter/editor/EditorURI;", "str", "percentDecode", "(Ljava/lang/String;)Ljava/lang/String;", "decodeURIComponentGraceful", "scheme", "schemeFix", "(Ljava/lang/String;Z)Ljava/lang/String;", "path", "referenceResolution", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Lkotlin/text/Regex;", "uriRegex", "Lkotlin/text/Regex;", "encodedAsHex", "command-crafter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorURI parseURI(@NotNull String uri, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            MatchResult matchResult = uriRegex.matchEntire((CharSequence)uri);
            if (matchResult == null) {
                return new EditorURI("", "", "", "", "", false, 32, null);
            }
            MatchResult match = matchResult;
            String scheme = (String)match.getGroupValues().get(2);
            String authority = this.percentDecode((String)match.getGroupValues().get(4));
            String path = this.percentDecode((String)match.getGroupValues().get(5));
            String query = this.percentDecode((String)match.getGroupValues().get(7));
            String fragment = this.percentDecode((String)match.getGroupValues().get(9));
            return new EditorURI(scheme, authority, path, query, fragment, strict, null);
        }

        public static /* synthetic */ EditorURI parseURI$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.parseURI(string, bl);
        }

        @NotNull
        public final String percentDecode(@NotNull String str) {
            String string;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            CharSequence charSequence = str;
            if (!encodedAsHex.containsMatchIn(charSequence)) {
                string = str;
            } else {
                charSequence = str;
                Regex regex = encodedAsHex;
                Function1 function1 = Companion::percentDecode$lambda$0;
                string = regex.replace(charSequence, function1);
            }
            return string;
        }

        @NotNull
        public final String decodeURIComponentGraceful(@NotNull String str) {
            String string;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            try {
                string = URLDecoder.decode(str, "UTF-8");
                Intrinsics.checkNotNull((Object)string);
            }
            catch (Exception e) {
                Object object;
                if (str.length() > 3) {
                    String string2 = str.substring(0, 3);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String string3 = str.substring(3);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    object = string2 + this.decodeURIComponentGraceful(string3);
                } else {
                    object = str;
                }
                string = object;
            }
            return string;
        }

        @NotNull
        public final String schemeFix(@NotNull String scheme, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            return ((CharSequence)scheme).length() == 0 && !strict ? "file" : scheme;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final String referenceResolution(@NotNull String scheme, @NotNull String path) {
            block7: {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                var3_3 = scheme;
                switch (var3_3.hashCode()) {
                    case 3143036: {
                        if (!var3_3.equals("file")) {
                            break;
                        }
                        ** GOTO lbl15
                    }
                    case 3213448: {
                        if (!var3_3.equals("http")) {
                            break;
                        }
                        ** GOTO lbl15
                    }
                    case 99617003: {
                        if (!var3_3.equals("https")) break;
lbl15:
                        // 3 sources

                        v0 = ((CharSequence)path).length() == 0 ? "/" : (path.charAt(0) != '/' ? "/" + path : path);
                        break block7;
                    }
                }
                v0 = path;
            }
            return v0;
        }

        private static final CharSequence percentDecode$lambda$0(MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Companion.decodeURIComponentGraceful(it.getValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

