/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.StringRange;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.papierkorb2292.command_crafter.editor.CommandCrafterLanguageClient;
import net.papierkorb2292.command_crafter.editor.EditorClientFileFinder;
import net.papierkorb2292.command_crafter.editor.FeatureConfig;
import net.papierkorb2292.command_crafter.editor.MinecraftClientConnection;
import net.papierkorb2292.command_crafter.editor.MinecraftLanguageServer;
import net.papierkorb2292.command_crafter.editor.MinecraftServerConnectedLanguageServer;
import net.papierkorb2292.command_crafter.editor.MinecraftServerConnection;
import net.papierkorb2292.command_crafter.editor.OpenFile;
import net.papierkorb2292.command_crafter.editor.ReloadResourcesParams;
import net.papierkorb2292.command_crafter.editor.console.Channel;
import net.papierkorb2292.command_crafter.editor.console.CommandExecutor;
import net.papierkorb2292.command_crafter.editor.console.ConsoleCommand;
import net.papierkorb2292.command_crafter.editor.console.ConsoleMessage;
import net.papierkorb2292.command_crafter.editor.console.Log;
import net.papierkorb2292.command_crafter.editor.console.PreLaunchLogListener;
import net.papierkorb2292.command_crafter.editor.console.RemoveChannelNotification;
import net.papierkorb2292.command_crafter.editor.processing.PackContentFileType;
import net.papierkorb2292.command_crafter.editor.processing.TokenModifier;
import net.papierkorb2292.command_crafter.editor.processing.TokenType;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.editor.processing.helper.EditorClientAware;
import net.papierkorb2292.command_crafter.editor.processing.helper.FileAnalyseHandler;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.DeleteParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileChangeType;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileEvent;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileNotFoundError;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileStat;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemRemoveWatchParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemResult;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemWatchParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.LoadStorageNamespaceParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.LoadableStorageNamespaces;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.ReadDirectoryResultEntry;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.ReadFileResult;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.RenameParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.ScoreboardStorageFileSystem;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.UriParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.WriteFileParams;
import net.papierkorb2292.command_crafter.helper.SizeLimitedCallbackLinkedBlockingQueue;
import net.papierkorb2292.command_crafter.mixin.editor.processing.IdentifierAccessor;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentDiagnosticParams;
import org.eclipse.lsp4j.DocumentDiagnosticReport;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FileOperationFilter;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationPattern;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RelatedFullDocumentDiagnosticReport;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00f1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0005*\u0001t\u0018\u0000 w2\u00020\u00012\u00020\u0002:\u0001wB!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0010J\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010&\u001a\u00020%H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020(H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010-\u001a\u00020\f2\u0006\u0010,\u001a\u00020+H\u0007\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020/H\u0007\u00a2\u0006\u0004\b0\u00101J\u0017\u00104\u001a\u00020\f2\u0006\u00103\u001a\u000202H\u0016\u00a2\u0006\u0004\b4\u00105J\u0017\u00109\u001a\u0004\u0018\u0001082\u0006\u00107\u001a\u000206\u00a2\u0006\u0004\b9\u0010:J\u000f\u0010;\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b;\u0010\u0010J\u001b\u0010=\u001a\b\u0012\u0004\u0012\u0002060\u00142\u0006\u0010<\u001a\u000206\u00a2\u0006\u0004\b=\u0010>J#\u0010D\u001a\b\u0012\u0004\u0012\u00020C0\u00142\u0006\u0010@\u001a\u00020?2\u0006\u0010B\u001a\u00020A\u00a2\u0006\u0004\bD\u0010EJ%\u0010D\u001a\b\u0012\u0004\u0012\u00020C0\u00142\b\u0010<\u001a\u0004\u0018\u0001062\u0006\u0010B\u001a\u00020A\u00a2\u0006\u0004\bD\u0010FJ'\u0010K\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010?0\u00142\u0006\u0010H\u001a\u00020G2\u0006\u0010J\u001a\u00020I\u00a2\u0006\u0004\bK\u0010LJ%\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001060\u00142\u0006\u0010H\u001a\u00020G2\u0006\u0010J\u001a\u00020I\u00a2\u0006\u0004\bM\u0010LJ-\u0010K\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010?0\u00142\u0006\u0010H\u001a\u00020G2\f\u0010O\u001a\b\u0012\u0004\u0012\u0002060N\u00a2\u0006\u0004\bK\u0010PJ+\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001060\u00142\u0006\u0010H\u001a\u00020G2\f\u0010O\u001a\b\u0012\u0004\u0012\u0002060N\u00a2\u0006\u0004\bM\u0010PJ\u001f\u0010Q\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010?0\u00142\u0006\u00107\u001a\u000206\u00a2\u0006\u0004\bQ\u0010>R\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010R\u001a\u0004\bS\u0010TR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010U\u001a\u0004\bV\u0010WR$\u0010\u0004\u001a\u00020\u00032\u0006\u0010X\u001a\u00020\u00038\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0004\u0010Y\u001a\u0004\bZ\u0010[R(\u00103\u001a\u0004\u0018\u0001022\b\u0010X\u001a\u0004\u0018\u0001028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b3\u0010\\\u001a\u0004\b]\u0010^R(\u0010`\u001a\u0004\u0018\u00010_2\b\u0010X\u001a\u0004\u0018\u00010_8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b`\u0010a\u001a\u0004\bb\u0010cR\u0011\u0010g\u001a\u00020d8F\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0018\u0010i\u001a\u0004\u0018\u00010h8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u0016\u0010l\u001a\u00020k8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bl\u0010mR \u0010o\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u0002080n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bo\u0010pR\u0018\u0010r\u001a\u0004\u0018\u00010q8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\br\u0010sR\u0014\u0010u\u001a\u00020t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bu\u0010v\u00a8\u0006x"}, d2={"Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;", "Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnectedLanguageServer;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/EditorClientAware;", "Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;", "minecraftServer", "Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;", "minecraftClient", "Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;", "featureConfig", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;)V", "connection", "", "setMinecraftServerConnection", "(Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;)V", "connectServerConsole", "()V", "analyzeAllFiles", "Lorg/eclipse/lsp4j/InitializeParams;", "params", "Ljava/util/concurrent/CompletableFuture;", "Lorg/eclipse/lsp4j/InitializeResult;", "initialize", "(Lorg/eclipse/lsp4j/InitializeParams;)Ljava/util/concurrent/CompletableFuture;", "Lorg/eclipse/lsp4j/InitializedParams;", "initialized", "(Lorg/eclipse/lsp4j/InitializedParams;)V", "", "shutdown", "()Ljava/util/concurrent/CompletableFuture;", "exit", "Lorg/eclipse/lsp4j/services/TextDocumentService;", "getTextDocumentService", "()Lorg/eclipse/lsp4j/services/TextDocumentService;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/ScoreboardStorageFileSystem;", "getScoreboardStorageFileSystem", "()Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/ScoreboardStorageFileSystem;", "Lorg/eclipse/lsp4j/services/WorkspaceService;", "getWorkspaceService", "()Lorg/eclipse/lsp4j/services/WorkspaceService;", "Lorg/eclipse/lsp4j/SetTraceParams;", "setTrace", "(Lorg/eclipse/lsp4j/SetTraceParams;)V", "Lnet/papierkorb2292/command_crafter/editor/console/ConsoleCommand;", "message", "runCommand", "(Lnet/papierkorb2292/command_crafter/editor/console/ConsoleCommand;)V", "Lnet/papierkorb2292/command_crafter/editor/ReloadResourcesParams;", "reloadResources", "(Lnet/papierkorb2292/command_crafter/editor/ReloadResourcesParams;)V", "Lnet/papierkorb2292/command_crafter/editor/CommandCrafterLanguageClient;", "client", "connect", "(Lnet/papierkorb2292/command_crafter/editor/CommandCrafterLanguageClient;)V", "", "uri", "Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "getOpenFile", "(Ljava/lang/String;)Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "onClosed", "documentation", "markDocumentation", "(Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "analyzingResult", "Lorg/eclipse/lsp4j/Range;", "fileRange", "Lorg/eclipse/lsp4j/Hover;", "hoverDocumentation", "(Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;Lorg/eclipse/lsp4j/Range;)Ljava/util/concurrent/CompletableFuture;", "(Ljava/lang/String;Lorg/eclipse/lsp4j/Range;)Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraft/class_2960;", "id", "Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;", "packContentFileType", "findFileAndAnalyze", "(Lnet/minecraft/class_2960;Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;)Ljava/util/concurrent/CompletableFuture;", "findFileAndGetDocs", "", "packContentKeywords", "(Lnet/minecraft/class_2960;Ljava/util/Set;)Ljava/util/concurrent/CompletableFuture;", "analyzeFileFromUri", "Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;", "getMinecraftClient", "()Lnet/papierkorb2292/command_crafter/editor/MinecraftClientConnection;", "Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;", "getFeatureConfig", "()Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;", "value", "Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;", "getMinecraftServer", "()Lnet/papierkorb2292/command_crafter/editor/MinecraftServerConnection;", "Lnet/papierkorb2292/command_crafter/editor/CommandCrafterLanguageClient;", "getClient", "()Lnet/papierkorb2292/command_crafter/editor/CommandCrafterLanguageClient;", "Lorg/eclipse/lsp4j/ClientCapabilities;", "clientCapabilities", "Lorg/eclipse/lsp4j/ClientCapabilities;", "getClientCapabilities", "()Lorg/eclipse/lsp4j/ClientCapabilities;", "Lnet/minecraft/class_5455;", "getDynamicRegistryManager", "()Lnet/minecraft/class_5455;", "dynamicRegistryManager", "Lorg/eclipse/lsp4j/jsonrpc/Endpoint;", "remote", "Lorg/eclipse/lsp4j/jsonrpc/Endpoint;", "", "running", "Z", "", "openFiles", "Ljava/util/Map;", "Lnet/papierkorb2292/command_crafter/editor/console/CommandExecutor;", "serverCommandExecutor", "Lnet/papierkorb2292/command_crafter/editor/console/CommandExecutor;", "net/papierkorb2292/command_crafter/editor/MinecraftLanguageServer.scoreboardStorageFileSystem.1", "scoreboardStorageFileSystem", "Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer$scoreboardStorageFileSystem$1;", "Companion", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nMinecraftLanguageServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinecraftLanguageServer.kt\nnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,577:1\n170#2,6:578\n37#3:584\n36#3,3:585\n*S KotlinDebug\n*F\n+ 1 MinecraftLanguageServer.kt\nnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer\n*L\n484#1:578,6\n501#1:584\n501#1:585,3\n*E\n"})
public final class MinecraftLanguageServer
implements MinecraftServerConnectedLanguageServer,
EditorClientAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final MinecraftClientConnection minecraftClient;
    @NotNull
    private final FeatureConfig featureConfig;
    @NotNull
    private MinecraftServerConnection minecraftServer;
    @Nullable
    private CommandCrafterLanguageClient client;
    @Nullable
    private ClientCapabilities clientCapabilities;
    @Nullable
    private Endpoint remote;
    private boolean running;
    @NotNull
    private final Map<String, OpenFile> openFiles;
    @Nullable
    private CommandExecutor serverCommandExecutor;
    @NotNull
    private final scoreboardStorageFileSystem.1 scoreboardStorageFileSystem;
    @NotNull
    private static final List<FileAnalyseHandler> analyzers = new ArrayList();
    @NotNull
    private static final CompletableFuture<Hover> emptyHoverDefault;
    @NotNull
    private static final CompletableFuture<Either<List<Location>, List<LocationLink>>> emptyDefinitionDefault;
    @NotNull
    private static final CompletableFuture<Either<List<CompletionItem>, CompletionList>> emptyCompletionsDefault;
    @NotNull
    public static final String AUTO_RELOAD_DATAPACK_FUNCTIONS_CONFIG_PATH = "autoreload.datapack_functions";
    @NotNull
    public static final String AUTO_RELOAD_DATAPACK_JSON_CONFIG_PATH = "autoreload.datapack_json";
    @NotNull
    public static final String AUTO_RELOAD_RESOURCEPACK_CONFIG_PATH = "autoreload.resourcepack";
    @NotNull
    public static final String CLIENT_LOG_CHANNEL = "client";

    public MinecraftLanguageServer(@NotNull MinecraftServerConnection minecraftServer, @Nullable MinecraftClientConnection minecraftClient, @NotNull FeatureConfig featureConfig) {
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"minecraftServer");
        Intrinsics.checkNotNullParameter((Object)featureConfig, (String)"featureConfig");
        this.minecraftClient = minecraftClient;
        this.featureConfig = featureConfig;
        this.minecraftServer = minecraftServer;
        this.running = true;
        this.openFiles = new HashMap();
        this.scoreboardStorageFileSystem = new ScoreboardStorageFileSystem(minecraftServer, this){
            private final FileSystemResult NO_SERVER_SUPPORT_ERROR;
            private final Int2ObjectMap<FileSystemWatchParams> watches;
            private Function1<? super FileEvent[], Unit> onDidChangeFileCallback;
            private ScoreboardStorageFileSystem delegateFileSystem;
            final /* synthetic */ MinecraftLanguageServer this$0;
            {
                this.this$0 = $receiver;
                this.NO_SERVER_SUPPORT_ERROR = new FileSystemResult<TResultType>(new FileNotFoundError("Server does not support scoreboard storage file system"));
                this.watches = (Int2ObjectMap)new Int2ObjectArrayMap();
                this.delegateFileSystem = $minecraftServer.createScoreboardStorageFileSystem();
            }

            public void setOnDidChangeFileCallback(Function1<? super FileEvent[], Unit> callback) {
                block0: {
                    Intrinsics.checkNotNullParameter(callback, (String)"callback");
                    this.onDidChangeFileCallback = callback;
                    ScoreboardStorageFileSystem scoreboardStorageFileSystem2 = this.delegateFileSystem;
                    if (scoreboardStorageFileSystem2 == null) break block0;
                    scoreboardStorageFileSystem2.setOnDidChangeFileCallback(callback);
                }
            }

            public void watch(FileSystemWatchParams params) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    ((Map)this.watches).put(params.getWatcherId(), params);
                    ScoreboardStorageFileSystem scoreboardStorageFileSystem2 = this.delegateFileSystem;
                    if (scoreboardStorageFileSystem2 == null) break block0;
                    scoreboardStorageFileSystem2.watch(params);
                }
            }

            public void removeWatch(FileSystemRemoveWatchParams params) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    this.watches.remove(params.getWatcherId());
                    ScoreboardStorageFileSystem scoreboardStorageFileSystem2 = this.delegateFileSystem;
                    if (scoreboardStorageFileSystem2 == null) break block0;
                    scoreboardStorageFileSystem2.removeWatch(params);
                }
            }

            public CompletableFuture<FileSystemResult<FileStat>> stat(UriParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Object object = this.delegateFileSystem;
                if (object == null || (object = object.stat(params)) == null) {
                    CompletableFuture<FileSystemResult> completableFuture = CompletableFuture.completedFuture(this.NO_SERVER_SUPPORT_ERROR);
                    object = completableFuture;
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                }
                return object;
            }

            public CompletableFuture<FileSystemResult<ReadDirectoryResultEntry[]>> readDirectory(UriParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Object object = this.delegateFileSystem;
                if (object == null || (object = object.readDirectory(params)) == null) {
                    CompletableFuture<FileSystemResult> completableFuture = CompletableFuture.completedFuture(this.NO_SERVER_SUPPORT_ERROR);
                    object = completableFuture;
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                }
                return object;
            }

            public CompletableFuture<FileSystemResult<Unit>> createDirectory(UriParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Object object = this.delegateFileSystem;
                if (object == null || (object = object.createDirectory(params)) == null) {
                    CompletableFuture<FileSystemResult> completableFuture = CompletableFuture.completedFuture(this.NO_SERVER_SUPPORT_ERROR);
                    object = completableFuture;
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                }
                return object;
            }

            public CompletableFuture<FileSystemResult<ReadFileResult>> readFile(UriParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Object object = this.delegateFileSystem;
                if (object == null || (object = object.readFile(params)) == null) {
                    CompletableFuture<FileSystemResult> completableFuture = CompletableFuture.completedFuture(this.NO_SERVER_SUPPORT_ERROR);
                    object = completableFuture;
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                }
                return object;
            }

            public CompletableFuture<FileSystemResult<Unit>> writeFile(WriteFileParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Object object = this.delegateFileSystem;
                if (object == null || (object = object.writeFile(params)) == null) {
                    CompletableFuture<FileSystemResult> completableFuture = CompletableFuture.completedFuture(this.NO_SERVER_SUPPORT_ERROR);
                    object = completableFuture;
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                }
                return object;
            }

            public CompletableFuture<FileSystemResult<Unit>> delete(DeleteParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Object object = this.delegateFileSystem;
                if (object == null || (object = object.delete(params)) == null) {
                    CompletableFuture<FileSystemResult> completableFuture = CompletableFuture.completedFuture(this.NO_SERVER_SUPPORT_ERROR);
                    object = completableFuture;
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                }
                return object;
            }

            public CompletableFuture<FileSystemResult<Unit>> rename(RenameParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Object object = this.delegateFileSystem;
                if (object == null || (object = object.rename(params)) == null) {
                    CompletableFuture<FileSystemResult> completableFuture = CompletableFuture.completedFuture(this.NO_SERVER_SUPPORT_ERROR);
                    object = completableFuture;
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                }
                return object;
            }

            public CompletableFuture<LoadableStorageNamespaces> getLoadableStorageNamespaces(Unit params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                Object object = this.delegateFileSystem;
                if (object == null || (object = object.getLoadableStorageNamespaces(params)) == null) {
                    CompletableFuture<LoadableStorageNamespaces> completableFuture = CompletableFuture.completedFuture(new LoadableStorageNamespaces(new String[0]));
                    object = completableFuture;
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                }
                return object;
            }

            public void loadStorageNamespace(LoadStorageNamespaceParams params) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    ScoreboardStorageFileSystem scoreboardStorageFileSystem2 = this.delegateFileSystem;
                    if (scoreboardStorageFileSystem2 == null) break block0;
                    scoreboardStorageFileSystem2.loadStorageNamespace(params);
                }
            }

            public final void onChangeServerConnection() {
                ObjectIterator objectIterator;
                ScoreboardStorageFileSystem fileSystem;
                this.delegateFileSystem = fileSystem = this.this$0.getMinecraftServer().createScoreboardStorageFileSystem();
                Function1<? super FileEvent[], Unit> onDidChangeFileCallback = this.onDidChangeFileCallback;
                if (onDidChangeFileCallback != null) {
                    if (!this.watches.isEmpty()) {
                        objectIterator = new ObjectIterator[]{new FileEvent("scoreboardStorage:///", FileChangeType.Deleted), new FileEvent("scoreboardStorage:///", FileChangeType.Created)};
                        onDidChangeFileCallback.invoke((Object)objectIterator);
                    }
                    ScoreboardStorageFileSystem scoreboardStorageFileSystem2 = fileSystem;
                    if (scoreboardStorageFileSystem2 != null) {
                        scoreboardStorageFileSystem2.setOnDidChangeFileCallback(onDidChangeFileCallback);
                    }
                }
                if (fileSystem != null) {
                    ObjectIterator objectIterator2 = ((ObjectCollection)this.watches.values()).iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)objectIterator2, (String)"iterator(...)");
                    objectIterator = objectIterator2;
                    while (objectIterator.hasNext()) {
                        FileSystemWatchParams watch = (FileSystemWatchParams)objectIterator.next();
                        Intrinsics.checkNotNull((Object)watch);
                        fileSystem.watch(watch);
                    }
                }
            }
        };
    }

    @Nullable
    public final MinecraftClientConnection getMinecraftClient() {
        return this.minecraftClient;
    }

    @NotNull
    public final FeatureConfig getFeatureConfig() {
        return this.featureConfig;
    }

    @NotNull
    public final MinecraftServerConnection getMinecraftServer() {
        return this.minecraftServer;
    }

    @Nullable
    public final CommandCrafterLanguageClient getClient() {
        return this.client;
    }

    @Nullable
    public final ClientCapabilities getClientCapabilities() {
        return this.clientCapabilities;
    }

    @NotNull
    public final class_5455 getDynamicRegistryManager() {
        return this.minecraftServer.getDynamicRegistryManager();
    }

    @Override
    public void setMinecraftServerConnection(@NotNull MinecraftServerConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        CommandCrafterLanguageClient commandCrafterLanguageClient = this.client;
        if (commandCrafterLanguageClient == null) {
            return;
        }
        CommandCrafterLanguageClient client = commandCrafterLanguageClient;
        Log prevConsole = this.minecraftServer.getServerLog();
        if (prevConsole != null) {
            client.removeChannel(new RemoveChannelNotification(prevConsole.getName()));
        }
        this.minecraftServer = connection;
        this.scoreboardStorageFileSystem.onChangeServerConnection();
        this.connectServerConsole();
        this.analyzeAllFiles();
    }

    private final void connectServerConsole() {
        CommandExecutor commandExecutor2;
        CommandCrafterLanguageClient commandCrafterLanguageClient = this.client;
        if (commandCrafterLanguageClient == null) {
            return;
        }
        CommandCrafterLanguageClient client = commandCrafterLanguageClient;
        Log console = this.minecraftServer.getServerLog();
        this.serverCommandExecutor = commandExecutor2 = this.minecraftServer.getCommandExecutor();
        if (console != null) {
            String serverChannel = console.getName();
            client.createChannel(new Channel(serverChannel, commandExecutor2 != null, null, 4, null));
            console.addMessageCallback(new SizeLimitedCallbackLinkedBlockingQueue.Callback<String>(client, serverChannel, this){
                final /* synthetic */ CommandCrafterLanguageClient $client;
                final /* synthetic */ String $serverChannel;
                final /* synthetic */ MinecraftLanguageServer this$0;
                {
                    this.$client = $client;
                    this.$serverChannel = $serverChannel;
                    this.this$0 = $receiver;
                }

                public void onElementAdded(String e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$client.logMinecraftMessage(new ConsoleMessage(this.$serverChannel, e));
                }

                public boolean shouldRemoveCallback() {
                    return !MinecraftLanguageServer.access$getRunning$p(this.this$0);
                }
            });
        }
        client.updateChannel(new Channel(CLIENT_LOG_CHANNEL, this.serverCommandExecutor != null, null, 4, null));
    }

    private final void analyzeAllFiles() {
        for (OpenFile file : this.openFiles.values()) {
            file.setAnalyzingResult(null);
            file.analyzeFile(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<InitializeResult> initialize(@NotNull InitializeParams params) {
        void $this$initialize_u24lambda_u244_u24lambda_u243_u24lambda_u242;
        void $this$initialize_u24lambda_u244_u24lambda_u243;
        CompletionOptions $this$initialize_u24lambda_u244_u24lambda_u241_u24lambda_u240;
        CompletionOptions completionOptions;
        TextDocumentSyncOptions $this$initialize_u24lambda_u244_u24lambda_u241;
        TextDocumentSyncOptions textDocumentSyncOptions;
        ServerCapabilities serverCapabilities;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.clientCapabilities = params.getCapabilities();
        ServerCapabilities $this$initialize_u24lambda_u244 = serverCapabilities = new ServerCapabilities();
        boolean bl = false;
        TextDocumentSyncOptions textDocumentSyncOptions2 = textDocumentSyncOptions = new TextDocumentSyncOptions();
        ServerCapabilities serverCapabilities2 = $this$initialize_u24lambda_u244;
        boolean bl2 = false;
        $this$initialize_u24lambda_u244_u24lambda_u241.setChange(TextDocumentSyncKind.Incremental);
        $this$initialize_u24lambda_u244_u24lambda_u241.setOpenClose(Boolean.valueOf(true));
        $this$initialize_u24lambda_u244.setHoverProvider(Either.forLeft((Object)true));
        $this$initialize_u24lambda_u244.setDefinitionProvider(Either.forLeft((Object)true));
        $this$initialize_u24lambda_u244_u24lambda_u241.setSave(Either.forLeft((Object)true));
        CompletionOptions completionOptions2 = completionOptions = new CompletionOptions();
        ServerCapabilities serverCapabilities3 = $this$initialize_u24lambda_u244;
        boolean bl3 = false;
        $this$initialize_u24lambda_u244_u24lambda_u241_u24lambda_u240.setResolveProvider(Boolean.valueOf(true));
        serverCapabilities3.setCompletionProvider(completionOptions);
        serverCapabilities2.setTextDocumentSync(textDocumentSyncOptions);
        $this$initialize_u24lambda_u244_u24lambda_u241 = textDocumentSyncOptions = new WorkspaceServerCapabilities();
        serverCapabilities2 = $this$initialize_u24lambda_u244;
        boolean bl4 = false;
        $this$initialize_u24lambda_u244_u24lambda_u241_u24lambda_u240 = completionOptions = new FileOperationsServerCapabilities();
        serverCapabilities3 = $this$initialize_u24lambda_u244_u24lambda_u243;
        boolean bl5 = false;
        $this$initialize_u24lambda_u244_u24lambda_u243_u24lambda_u242.setDidDelete(new FileOperationOptions(CollectionsKt.listOf((Object)new FileOperationFilter(new FileOperationPattern("**")))));
        serverCapabilities3.setFileOperations((FileOperationsServerCapabilities)completionOptions);
        serverCapabilities2.setWorkspace((WorkspaceServerCapabilities)textDocumentSyncOptions);
        $this$initialize_u24lambda_u244.setSemanticTokensProvider(new SemanticTokensWithRegistrationOptions(new SemanticTokensLegend(TokenType.Companion.getTYPES(), TokenModifier.Companion.getMODIFIERS()), Boolean.valueOf(true)));
        ServerInfo serverInfo = new ServerInfo("Minecraft Language Server");
        ServerCapabilities serverCapabilities4 = serverCapabilities;
        CompletableFuture<InitializeResult> completableFuture = CompletableFuture.completedFuture(new InitializeResult(serverCapabilities4, serverInfo));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    public void initialized(@NotNull InitializedParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CommandCrafterLanguageClient commandCrafterLanguageClient = this.client;
        if (commandCrafterLanguageClient == null) {
            return;
        }
        CommandCrafterLanguageClient client = commandCrafterLanguageClient;
        client.createChannel(new Channel(CLIENT_LOG_CHANNEL, false, null, 4, null));
        PreLaunchLogListener.INSTANCE.addLogListener(new SizeLimitedCallbackLinkedBlockingQueue.Callback<String>(client, this){
            final /* synthetic */ CommandCrafterLanguageClient $client;
            final /* synthetic */ MinecraftLanguageServer this$0;
            {
                this.$client = $client;
                this.this$0 = $receiver;
            }

            public void onElementAdded(String e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$client.logMinecraftMessage(new ConsoleMessage("client", e));
            }

            public boolean shouldRemoveCallback() {
                return !MinecraftLanguageServer.access$getRunning$p(this.this$0);
            }
        });
        this.connectServerConsole();
    }

    @NotNull
    public CompletableFuture<Object> shutdown() {
        this.running = false;
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    public void exit() {
    }

    @NotNull
    public TextDocumentService getTextDocumentService() {
        return new TextDocumentService(this){
            private final Set<PackContentFileType> shaderFileTypes;
            private final Set<PackContentFileType> relodableDatapackFileTypes;
            final /* synthetic */ MinecraftLanguageServer this$0;
            {
                this.this$0 = $receiver;
                SpreadBuilder spreadBuilder = new SpreadBuilder[]{PackContentFileType.CORE_SHADERS_FILE_TYPE, PackContentFileType.POST_SHADERS_FILE_TYPE, PackContentFileType.INCLUDE_SHADERS_FILE_TYPE, PackContentFileType.POST_EFFECTS_FILE_TYPE};
                this.shaderFileTypes = SetsKt.setOf((Object[])spreadBuilder);
                spreadBuilder = new SpreadBuilder(7);
                spreadBuilder.addSpread((Object)PackContentFileType.Companion.getTagTypes());
                spreadBuilder.add((Object)((Object)PackContentFileType.LOOT_TABLES_FILE_TYPE));
                spreadBuilder.add((Object)((Object)PackContentFileType.PREDICATES_FILE_TYPE));
                spreadBuilder.add((Object)((Object)PackContentFileType.ITEM_MODIFIER_FILE_TYPE));
                spreadBuilder.add((Object)((Object)PackContentFileType.RECIPES_FILE_TYPE));
                spreadBuilder.add((Object)((Object)PackContentFileType.FUNCTIONS_FILE_TYPE));
                spreadBuilder.add((Object)((Object)PackContentFileType.ADVANCEMENTS_FILE_TYPE));
                this.relodableDatapackFileTypes = SetsKt.setOf((Object[])spreadBuilder.toArray((Object[])new PackContentFileType[spreadBuilder.size()]));
            }

            public void didOpen(DidOpenTextDocumentParams params) {
                if (params == null) {
                    return;
                }
                TextDocumentItem textDocument = params.getTextDocument();
                Map map2 = MinecraftLanguageServer.access$getOpenFiles$p(this.this$0);
                String string = textDocument.getUri();
                String string2 = textDocument.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUri(...)");
                String string3 = textDocument.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                OpenFile openFile = new OpenFile(string2, OpenFile.Companion.linesFromString(string3), textDocument.getVersion());
                MinecraftLanguageServer minecraftLanguageServer = this.this$0;
                OpenFile it = openFile;
                boolean bl = false;
                it.analyzeFile(minecraftLanguageServer);
                map2.put(string, openFile);
            }

            public void didChange(DidChangeTextDocumentParams params) {
                if (params == null) {
                    return;
                }
                OpenFile openFile = (OpenFile)MinecraftLanguageServer.access$getOpenFiles$p(this.this$0).get(params.getTextDocument().getUri());
                if (openFile == null) {
                    return;
                }
                OpenFile file = openFile;
                file.setAnalyzingResult(null);
                Integer n = params.getTextDocument().getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getVersion(...)");
                file.setVersion(((Number)n).intValue());
                for (TextDocumentContentChangeEvent change : params.getContentChanges()) {
                    Intrinsics.checkNotNull((Object)change);
                    file.applyContentChange(change);
                }
                file.analyzeFile(this.this$0);
            }

            public void didClose(DidCloseTextDocumentParams params) {
                block1: {
                    if (params == null) {
                        return;
                    }
                    OpenFile openFile = (OpenFile)MinecraftLanguageServer.access$getOpenFiles$p(this.this$0).remove(params.getTextDocument().getUri());
                    if (openFile == null) break block1;
                    OpenFile $this$didClose_u24lambda_u241 = openFile;
                    boolean bl = false;
                    $this$didClose_u24lambda_u241.setAnalyzingResult(null);
                }
            }

            public void didSave(DidSaveTextDocumentParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                OpenFile openFile = (OpenFile)MinecraftLanguageServer.access$getOpenFiles$p(this.this$0).get(params.getTextDocument().getUri());
                if (openFile == null) {
                    return;
                }
                OpenFile file = openFile;
                Object object = PackContentFileType.Companion.parsePath(file.getParsedUri().getPath());
                if (object == null || (object = ((PackContentFileType.ParsedPath)object).getType()) == null) {
                    return;
                }
                Object packContentFileType = object;
                switch (getTextDocumentService.WhenMappings.$EnumSwitchMapping$0[((PackContentFileType)((Object)packContentFileType)).getPackType().ordinal()]) {
                    case 1: {
                        String configPath;
                        String string = configPath = packContentFileType == PackContentFileType.FUNCTIONS_FILE_TYPE ? "autoreload.datapack_functions" : "autoreload.datapack_json";
                        if (!this.this$0.getFeatureConfig().isEnabled(configPath, false)) {
                            return;
                        }
                        if (!this.relodableDatapackFileTypes.contains(packContentFileType)) {
                            MinecraftClientConnection minecraftClientConnection = this.this$0.getMinecraftClient();
                            if (!(minecraftClientConnection != null ? !minecraftClientConnection.isConnectedToServer() : false)) {
                                CommandCrafterLanguageClient commandCrafterLanguageClient = this.this$0.getClient();
                                Intrinsics.checkNotNull((Object)commandCrafterLanguageClient);
                                String[] stringArray = new String[]{"green"};
                                commandCrafterLanguageClient.logMinecraftMessage(new ConsoleMessage("client", AnsiEscape.createSequence((String[])stringArray) + "[AutoReload] World has to be restarted to reload saved file"));
                            }
                            return;
                        }
                        Function0<Unit> function0 = this.this$0.getMinecraftServer().getDatapackReloader();
                        if (function0 != null) {
                            function0.invoke();
                        }
                        break;
                    }
                    case 2: {
                        if (!this.this$0.getFeatureConfig().isEnabled("autoreload.resourcepack", false)) {
                            return;
                        }
                        MinecraftClientConnection minecraftClientConnection = this.this$0.getMinecraftClient();
                        if (minecraftClientConnection != null) {
                            minecraftClientConnection.reloadResources(new ReloadResourcesParams(this.shaderFileTypes.contains(packContentFileType)));
                        }
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                OpenFile openFile = (OpenFile)MinecraftLanguageServer.access$getOpenFiles$p(this.this$0).get(position.getTextDocument().getUri());
                if (openFile == null) {
                    return MinecraftLanguageServer.Companion.getEmptyCompletionsDefault();
                }
                OpenFile file = openFile;
                CompletableFuture<AnalyzingResult> completableFuture = file.analyzeFile(this.this$0);
                if (completableFuture == null) {
                    return MinecraftLanguageServer.Companion.getEmptyCompletionsDefault();
                }
                CompletableFuture<AnalyzingResult> analyzer = completableFuture;
                Iterable iterable = file.getLines();
                AnalyzingResult.Companion companion = AnalyzingResult.Companion;
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StringBuffer stringBuffer = (StringBuffer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    collection.add(string);
                }
                Position position2 = position.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getPosition(...)");
                int cursor = AnalyzingResult.Companion.getCursorFromPosition$default(companion, (List)destination$iv$iv, position2, false, 4, null);
                CompletionStage completionStage = analyzer.thenCompose(arg_0 -> getTextDocumentService.1.completion$lambda$11(arg_0 -> getTextDocumentService.1.completion$lambda$10(cursor, this.this$0, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
                return completionStage;
            }

            public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
                Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
                CompletableFuture<CompletionItem> completableFuture = CompletableFuture.completedFuture(unresolved);
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                return completableFuture;
            }

            public CompletableFuture<SemanticTokens> semanticTokensFull(SemanticTokensParams params) {
                if (params == null) {
                    CompletableFuture<SemanticTokens> completableFuture = CompletableFuture.completedFuture(new SemanticTokens());
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                    return completableFuture;
                }
                OpenFile openFile = (OpenFile)MinecraftLanguageServer.access$getOpenFiles$p(this.this$0).get(params.getTextDocument().getUri());
                if (openFile == null) {
                    CompletableFuture<SemanticTokens> completableFuture = CompletableFuture.completedFuture(new SemanticTokens());
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                    return completableFuture;
                }
                OpenFile file = openFile;
                CompletableFuture<AnalyzingResult> completableFuture = file.analyzeFile(this.this$0);
                if (completableFuture == null) {
                    CompletableFuture<SemanticTokens> completableFuture2 = CompletableFuture.completedFuture(new SemanticTokens());
                    Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                    return completableFuture2;
                }
                CompletableFuture<AnalyzingResult> analyzer = completableFuture;
                CompletionStage completionStage = analyzer.thenApply(arg_0 -> getTextDocumentService.1.semanticTokensFull$lambda$13(getTextDocumentService.1::semanticTokensFull$lambda$12, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
                return completionStage;
            }

            public CompletableFuture<DocumentDiagnosticReport> diagnostic(DocumentDiagnosticParams params) {
                if (params == null) {
                    CompletableFuture<DocumentDiagnosticReport> completableFuture = CompletableFuture.completedFuture(new DocumentDiagnosticReport(new RelatedFullDocumentDiagnosticReport()));
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                    return completableFuture;
                }
                OpenFile openFile = (OpenFile)MinecraftLanguageServer.access$getOpenFiles$p(this.this$0).get(params.getTextDocument().getUri());
                if (openFile == null) {
                    CompletableFuture<DocumentDiagnosticReport> completableFuture = CompletableFuture.completedFuture(new DocumentDiagnosticReport(new RelatedFullDocumentDiagnosticReport()));
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
                    return completableFuture;
                }
                OpenFile file = openFile;
                CompletableFuture<AnalyzingResult> completableFuture = file.analyzeFile(this.this$0);
                if (completableFuture == null) {
                    CompletableFuture<DocumentDiagnosticReport> completableFuture2 = CompletableFuture.completedFuture(new DocumentDiagnosticReport(new RelatedFullDocumentDiagnosticReport()));
                    Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
                    return completableFuture2;
                }
                CompletableFuture<AnalyzingResult> analyzer = completableFuture;
                CompletionStage completionStage = analyzer.thenApply(arg_0 -> getTextDocumentService.1.diagnostic$lambda$15(getTextDocumentService.1::diagnostic$lambda$14, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
                return completionStage;
            }

            /*
             * WARNING - void declaration
             */
            public CompletableFuture<Hover> hover(HoverParams params) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                OpenFile openFile = (OpenFile)MinecraftLanguageServer.access$getOpenFiles$p(this.this$0).get(params.getTextDocument().getUri());
                if (openFile == null) {
                    return MinecraftLanguageServer.Companion.getEmptyHoverDefault();
                }
                OpenFile file = openFile;
                CompletableFuture<AnalyzingResult> completableFuture = file.analyzeFile(this.this$0);
                if (completableFuture == null) {
                    return MinecraftLanguageServer.Companion.getEmptyHoverDefault();
                }
                CompletableFuture<AnalyzingResult> analyzer = completableFuture;
                Iterable iterable = file.getLines();
                AnalyzingResult.Companion companion = AnalyzingResult.Companion;
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StringBuffer stringBuffer = (StringBuffer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    collection.add(string);
                }
                Position position = params.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getPosition(...)");
                int cursor = AnalyzingResult.Companion.getCursorFromPosition$default(companion, (List)destination$iv$iv, position, false, 4, null);
                CompletionStage completionStage = analyzer.thenCompose(arg_0 -> getTextDocumentService.1.hover$lambda$18(arg_0 -> getTextDocumentService.1.hover$lambda$17(cursor, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
                return completionStage;
            }

            /*
             * WARNING - void declaration
             */
            public CompletableFuture<Either<List<Location>, List<LocationLink>>> definition(DefinitionParams params) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                OpenFile openFile = (OpenFile)MinecraftLanguageServer.access$getOpenFiles$p(this.this$0).get(params.getTextDocument().getUri());
                if (openFile == null) {
                    return MinecraftLanguageServer.Companion.getEmptyDefinitionDefault();
                }
                OpenFile file = openFile;
                CompletableFuture<AnalyzingResult> completableFuture = file.analyzeFile(this.this$0);
                if (completableFuture == null) {
                    return MinecraftLanguageServer.Companion.getEmptyDefinitionDefault();
                }
                CompletableFuture<AnalyzingResult> analyzer = completableFuture;
                Iterable iterable = file.getLines();
                AnalyzingResult.Companion companion = AnalyzingResult.Companion;
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StringBuffer stringBuffer = (StringBuffer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    collection.add(string);
                }
                Position position = params.getPosition();
                Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getPosition(...)");
                int cursor = AnalyzingResult.Companion.getCursorFromPosition$default(companion, (List)destination$iv$iv, position, false, 4, null);
                CompletionStage completionStage = analyzer.thenCompose(arg_0 -> getTextDocumentService.1.definition$lambda$21(arg_0 -> getTextDocumentService.1.definition$lambda$20(cursor, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
                return completionStage;
            }

            private static final TextEdit completion$lambda$10$lambda$8$lambda$7$lambda$3(TextEdit textEdit) {
                return textEdit;
            }

            private static final TextEdit completion$lambda$10$lambda$8$lambda$7$lambda$4(Function1 $tmp0, Object p0) {
                return (TextEdit)$tmp0.invoke(p0);
            }

            private static final TextEdit completion$lambda$10$lambda$8$lambda$7$lambda$5(InsertReplaceEdit insertReplaceEdit) {
                return new TextEdit(insertReplaceEdit.getInsert(), insertReplaceEdit.getNewText());
            }

            private static final TextEdit completion$lambda$10$lambda$8$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
                return (TextEdit)$tmp0.invoke(p0);
            }

            /*
             * WARNING - void declaration
             */
            private static final Either completion$lambda$10$lambda$8(MinecraftLanguageServer this$0, List it) {
                List list;
                ClientCapabilities clientCapabilities = this$0.getClientCapabilities();
                Intrinsics.checkNotNull((Object)clientCapabilities);
                if (clientCapabilities.getTextDocument().getCompletion().getCompletionItem().getInsertReplaceSupport().booleanValue()) {
                    list = it;
                } else {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNull((Object)it);
                    Iterable $this$map$iv = it;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void completionItem;
                        CompletionItem completionItem2 = (CompletionItem)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        completionItem.setTextEdit(Either.forLeft((Object)completionItem.getTextEdit().map(arg_0 -> getTextDocumentService.1.completion$lambda$10$lambda$8$lambda$7$lambda$4(getTextDocumentService.1::completion$lambda$10$lambda$8$lambda$7$lambda$3, arg_0), arg_0 -> getTextDocumentService.1.completion$lambda$10$lambda$8$lambda$7$lambda$6(getTextDocumentService.1::completion$lambda$10$lambda$8$lambda$7$lambda$5, arg_0))));
                        collection.add(completionItem);
                    }
                    list = (List)destination$iv$iv;
                }
                return Either.forLeft((Object)list);
            }

            private static final Either completion$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
                return (Either)$tmp0.invoke(p0);
            }

            private static final CompletionStage completion$lambda$10(int $cursor, MinecraftLanguageServer this$0, AnalyzingResult analyzingResult) {
                AnalyzingResult.RangedDataProvider<CompletableFuture<List<CompletionItem>>> rangedDataProvider = analyzingResult.getCompletionProviderForCursor($cursor);
                if (rangedDataProvider == null) {
                    return MinecraftLanguageServer.Companion.getEmptyCompletionsDefault();
                }
                AnalyzingResult.RangedDataProvider<CompletableFuture<List<CompletionItem>>> provider = rangedDataProvider;
                return ((CompletableFuture)provider.getDataProvider().invoke((Object)$cursor)).thenApply(arg_0 -> getTextDocumentService.1.completion$lambda$10$lambda$9(arg_0 -> getTextDocumentService.1.completion$lambda$10$lambda$8(this$0, arg_0), arg_0));
            }

            private static final CompletionStage completion$lambda$11(Function1 $tmp0, Object p0) {
                return (CompletionStage)$tmp0.invoke(p0);
            }

            private static final SemanticTokens semanticTokensFull$lambda$12(AnalyzingResult it) {
                return it.getSemanticTokens().build();
            }

            private static final SemanticTokens semanticTokensFull$lambda$13(Function1 $tmp0, Object p0) {
                return (SemanticTokens)$tmp0.invoke(p0);
            }

            private static final DocumentDiagnosticReport diagnostic$lambda$14(AnalyzingResult it) {
                MinecraftLanguageServer.Companion.fillDiagnosticsSource(it.getDiagnostics());
                return new DocumentDiagnosticReport(new RelatedFullDocumentDiagnosticReport(it.getDiagnostics()));
            }

            private static final DocumentDiagnosticReport diagnostic$lambda$15(Function1 $tmp0, Object p0) {
                return (DocumentDiagnosticReport)$tmp0.invoke(p0);
            }

            private static final CompletionStage hover$lambda$17(int $cursor, AnalyzingResult it) {
                AnalyzingResult.RangedDataProvider<CompletableFuture<Hover>> rangedDataProvider = it.getHoverProviderForCursor($cursor);
                if (rangedDataProvider == null) {
                    return MinecraftLanguageServer.Companion.getEmptyHoverDefault();
                }
                AnalyzingResult.RangedDataProvider<CompletableFuture<Hover>> provider = rangedDataProvider;
                return (CompletionStage)provider.getDataProvider().invoke((Object)$cursor);
            }

            private static final CompletionStage hover$lambda$18(Function1 $tmp0, Object p0) {
                return (CompletionStage)$tmp0.invoke(p0);
            }

            private static final CompletionStage definition$lambda$20(int $cursor, AnalyzingResult it) {
                AnalyzingResult.RangedDataProvider<CompletableFuture<Either<List<Location>, List<LocationLink>>>> rangedDataProvider = it.getDefinitionProviderForCursor($cursor);
                if (rangedDataProvider == null) {
                    return MinecraftLanguageServer.Companion.getEmptyDefinitionDefault();
                }
                AnalyzingResult.RangedDataProvider<CompletableFuture<Either<List<Location>, List<LocationLink>>>> provider = rangedDataProvider;
                return (CompletionStage)provider.getDataProvider().invoke((Object)$cursor);
            }

            private static final CompletionStage definition$lambda$21(Function1 $tmp0, Object p0) {
                return (CompletionStage)$tmp0.invoke(p0);
            }
        };
    }

    @JsonDelegate
    @NotNull
    public final ScoreboardStorageFileSystem getScoreboardStorageFileSystem() {
        return this.scoreboardStorageFileSystem;
    }

    @NotNull
    public WorkspaceService getWorkspaceService() {
        return new WorkspaceService(this){
            final /* synthetic */ MinecraftLanguageServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void didChangeConfiguration(DidChangeConfigurationParams params) {
            }

            public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
            }

            /*
             * WARNING - void declaration
             */
            public void didDeleteFiles(DeleteFilesParams params) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                List list = params.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFiles(...)");
                Iterable iterable = list;
                MinecraftLanguageServer minecraftLanguageServer = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    FileDelete it = (FileDelete)element$iv;
                    boolean bl = false;
                    CommandCrafterLanguageClient commandCrafterLanguageClient = minecraftLanguageServer.getClient();
                    if (commandCrafterLanguageClient == null) continue;
                    commandCrafterLanguageClient.publishDiagnostics(new PublishDiagnosticsParams(it.getUri(), CollectionsKt.emptyList()));
                }
            }
        };
    }

    public void setTrace(@NotNull SetTraceParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
    }

    @JsonNotification
    public final void runCommand(@NotNull ConsoleCommand message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String channel = message.getChannel();
        CommandExecutor serverCommandExecutor = this.serverCommandExecutor;
        Log serverConsole = this.minecraftServer.getServerLog();
        if (serverCommandExecutor != null && (Intrinsics.areEqual((Object)channel, (Object)CLIENT_LOG_CHANNEL) || serverConsole != null && Intrinsics.areEqual((Object)channel, (Object)serverConsole.getName()))) {
            serverCommandExecutor.executeCommand(message.getCommand());
        }
    }

    @JsonNotification
    public final void reloadResources(@NotNull ReloadResourcesParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CommandCrafterLanguageClient commandCrafterLanguageClient = this.client;
        if (commandCrafterLanguageClient == null) {
            return;
        }
        CommandCrafterLanguageClient client = commandCrafterLanguageClient;
        MinecraftClientConnection minecraftClient = this.minecraftClient;
        if (minecraftClient == null) {
            client.showMessage(new MessageParams(MessageType.Error, "Can't reload resources, not connected to Minecraft client"));
            return;
        }
        minecraftClient.reloadResources(params);
    }

    @Override
    public void connect(@NotNull CommandCrafterLanguageClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)CLIENT_LOG_CHANNEL);
        this.client = client;
        this.scoreboardStorageFileSystem.setOnDidChangeFileCallback((Function1<? super FileEvent[], Unit>)((Function1)arg_0 -> MinecraftLanguageServer.connect$lambda$5(client, arg_0)));
    }

    @Nullable
    public final OpenFile getOpenFile(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.openFiles.get(uri);
    }

    @Override
    public void onClosed() {
        this.running = false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<String> markDocumentation(@NotNull String documentation) {
        Intrinsics.checkNotNullParameter((Object)documentation, (String)"documentation");
        CommandCrafterLanguageClient commandCrafterLanguageClient = this.client;
        if (commandCrafterLanguageClient == null) {
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(documentation);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CommandCrafterLanguageClient client = commandCrafterLanguageClient;
        StringReader reader = new StringReader(documentation);
        List replacements = new ArrayList();
        while (reader.canRead()) {
            int n;
            block7: {
                void $this$indexOfLast$iv;
                int i2 = reader.getCursor();
                char c = reader.read();
                if (c == '@') {
                    while (reader.canRead() && reader.peek() != ' ' && reader.peek() != '\n') {
                        reader.skip();
                    }
                    int end = reader.getCursor();
                    ((Collection)replacements).add(CompletableFuture.completedFuture(TuplesKt.to((Object)new StringRange(i2, end), (Object)("**" + reader.getString().subSequence(i2, end) + "**"))));
                    continue;
                }
                if (c != ':') continue;
                CharSequence charSequence = documentation.subSequence(0, i2);
                boolean $i$f$indexOfLast = false;
                int n2 = $this$indexOfLast$iv.length() + -1;
                if (0 <= n2) {
                    do {
                        int index$iv = n2--;
                        char it = $this$indexOfLast$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(!IdentifierAccessor.callIsNamespaceCharacterValid(it))) continue;
                        n = index$iv;
                        break block7;
                    } while (0 <= n2);
                }
                n = -1;
            }
            int idStart = n + 1;
            while (reader.canRead() && class_2960.method_29184((char)reader.peek())) {
                reader.skip();
            }
            int idEnd = reader.getCursor();
            String string = reader.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            Set resourceSearchKeywords = CollectionsKt.toSet((Iterable)PackContentFileType.Companion.parseKeywords(string, idStart, idEnd));
            StringRange range = new StringRange(idStart, idEnd);
            Collection collection = replacements;
            String string2 = documentation.substring(idStart, idEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            class_2960 class_29602 = class_2960.method_60654((String)string2);
            Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"of(...)");
            CompletionStage completionStage = PackContentFileType.Companion.findWorkspaceResourceFromId(class_29602, (EditorClientFileFinder)client, (Set<String>)resourceSearchKeywords).thenApply(arg_0 -> MinecraftLanguageServer.markDocumentation$lambda$8(arg_0 -> MinecraftLanguageServer.markDocumentation$lambda$7(range, reader, arg_0), arg_0));
            collection.add(completionStage);
        }
        Collection $this$toTypedArray$iv = replacements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletionStage completionStage = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).thenApply(arg_0 -> MinecraftLanguageServer.markDocumentation$lambda$10(arg_0 -> MinecraftLanguageServer.markDocumentation$lambda$9(documentation, replacements, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<Hover> hoverDocumentation(@NotNull AnalyzingResult analyzingResult, @NotNull Range fileRange) {
        Intrinsics.checkNotNullParameter((Object)analyzingResult, (String)"analyzingResult");
        Intrinsics.checkNotNullParameter((Object)fileRange, (String)"fileRange");
        return this.hoverDocumentation(analyzingResult.getDocumentation(), fileRange);
    }

    @NotNull
    public final CompletableFuture<Hover> hoverDocumentation(@Nullable String documentation, @NotNull Range fileRange) {
        Intrinsics.checkNotNullParameter((Object)fileRange, (String)"fileRange");
        if (documentation == null) {
            CompletableFuture<Hover> completableFuture = CompletableFuture.completedFuture(new Hover(CollectionsKt.emptyList(), fileRange));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletionStage completionStage = this.markDocumentation(documentation).thenApply(arg_0 -> MinecraftLanguageServer.hoverDocumentation$lambda$12(arg_0 -> MinecraftLanguageServer.hoverDocumentation$lambda$11(fileRange, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<? extends AnalyzingResult> findFileAndAnalyze(@NotNull class_2960 id, @NotNull PackContentFileType packContentFileType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)packContentFileType), (String)"packContentFileType");
        CommandCrafterLanguageClient commandCrafterLanguageClient = this.client;
        if (commandCrafterLanguageClient == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CommandCrafterLanguageClient client = commandCrafterLanguageClient;
        Function1 function1 = arg_0 -> MinecraftLanguageServer.findFileAndAnalyze$lambda$13(this, arg_0);
        CompletionStage completionStage = PackContentFileType.Companion.findWorkspaceResourceFromIdAndPackContentFileType(id, packContentFileType, (EditorClientFileFinder)client).thenCompose(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<String> findFileAndGetDocs(@NotNull class_2960 id, @NotNull PackContentFileType packContentFileType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)packContentFileType), (String)"packContentFileType");
        CompletionStage completionStage = this.findFileAndAnalyze(id, packContentFileType).thenApply(arg_0 -> MinecraftLanguageServer.findFileAndGetDocs$lambda$14(findFileAndGetDocs.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<? extends AnalyzingResult> findFileAndAnalyze(@NotNull class_2960 id, @NotNull Set<String> packContentKeywords) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(packContentKeywords, (String)"packContentKeywords");
        CommandCrafterLanguageClient commandCrafterLanguageClient = this.client;
        if (commandCrafterLanguageClient == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CommandCrafterLanguageClient client = commandCrafterLanguageClient;
        Function1 function1 = arg_0 -> MinecraftLanguageServer.findFileAndAnalyze$lambda$15(this, arg_0);
        CompletionStage completionStage = PackContentFileType.Companion.findWorkspaceResourceFromId(id, (EditorClientFileFinder)client, packContentKeywords).thenCompose(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<String> findFileAndGetDocs(@NotNull class_2960 id, @NotNull Set<String> packContentKeywords) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(packContentKeywords, (String)"packContentKeywords");
        CompletionStage completionStage = this.findFileAndAnalyze(id, packContentKeywords).thenApply(arg_0 -> MinecraftLanguageServer.findFileAndGetDocs$lambda$16(findFileAndGetDocs.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<? extends AnalyzingResult> analyzeFileFromUri(@NotNull String uri) {
        CompletionStage<AnalyzingResult> completionStage;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        CommandCrafterLanguageClient commandCrafterLanguageClient = this.client;
        if (commandCrafterLanguageClient == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CommandCrafterLanguageClient client = commandCrafterLanguageClient;
        OpenFile openFile = this.openFiles.get(uri);
        if (openFile != null) {
            completionStage = openFile.analyzeFile(this);
            if (completionStage == null) {
                completionStage = CompletableFuture.completedFuture(null);
            }
        } else {
            completionStage = client.getFileContent(uri).thenCompose(arg_0 -> MinecraftLanguageServer.analyzeFileFromUri$lambda$18(arg_0 -> MinecraftLanguageServer.analyzeFileFromUri$lambda$17(uri, this, arg_0), arg_0));
        }
        CompletableFuture<AnalyzingResult> completableFuture = completionStage;
        Intrinsics.checkNotNull(completableFuture);
        return completableFuture;
    }

    @Override
    public void leave() {
        MinecraftServerConnectedLanguageServer.DefaultImpls.leave(this);
    }

    private static final Unit connect$lambda$5(CommandCrafterLanguageClient $client, FileEvent[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $client.onDidChangeScoreboardStorage(new CommandCrafterLanguageClient.OnDidChangeScoreboardStorageParams(it));
        return Unit.INSTANCE;
    }

    private static final Pair markDocumentation$lambda$7(StringRange $range, StringReader $reader, Pair resource) {
        return TuplesKt.to((Object)$range, (Object)(resource == null ? "`" + $range.get($reader.getString()) + "`" : "[" + $range.get($reader.getString()) + "](" + resource.getSecond() + ")"));
    }

    private static final Pair markDocumentation$lambda$8(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }

    private static final String markDocumentation$lambda$9(String $documentation, List $replacements, Void it) {
        StringBuilder newDocumentation = new StringBuilder($documentation);
        for (CompletableFuture replacement : $replacements) {
            Pair pair = (Pair)replacement.get();
            StringRange range = (StringRange)pair.component1();
            String replacementContent = (String)pair.component2();
            if (replacementContent == null) continue;
            int offset = newDocumentation.length() - $documentation.length();
            newDocumentation.replace(range.getStart() + offset, range.getEnd() + offset, replacementContent);
        }
        return newDocumentation.toString();
    }

    private static final String markDocumentation$lambda$10(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Hover hoverDocumentation$lambda$11(Range $fileRange, String it) {
        return new Hover(new MarkupContent("markdown", it), $fileRange);
    }

    private static final Hover hoverDocumentation$lambda$12(Function1 $tmp0, Object p0) {
        return (Hover)$tmp0.invoke(p0);
    }

    private static final CompletionStage findFileAndAnalyze$lambda$13(MinecraftLanguageServer this$0, String fileUri) {
        if (fileUri == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this$0.analyzeFileFromUri(fileUri);
    }

    private static final String findFileAndGetDocs$lambda$14(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final CompletionStage findFileAndAnalyze$lambda$15(MinecraftLanguageServer this$0, Pair fileUri) {
        if (fileUri == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this$0.analyzeFileFromUri((String)fileUri.getSecond());
    }

    private static final String findFileAndGetDocs$lambda$16(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final CompletionStage analyzeFileFromUri$lambda$17(String $uri, MinecraftLanguageServer this$0, String content) {
        Intrinsics.checkNotNull((Object)content);
        CompletableFuture<AnalyzingResult> completableFuture = OpenFile.Companion.fromString($uri, content, 0).analyzeFile(this$0);
        return completableFuture != null ? (CompletionStage)completableFuture : (CompletionStage)CompletableFuture.completedFuture(null);
    }

    private static final CompletionStage analyzeFileFromUri$lambda$18(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$getRunning$p(MinecraftLanguageServer $this) {
        return $this.running;
    }

    public static final /* synthetic */ Map access$getOpenFiles$p(MinecraftLanguageServer $this) {
        return $this.openFiles;
    }

    static {
        CompletableFuture<Hover> completableFuture = CompletableFuture.completedFuture(new Hover(CollectionsKt.emptyList()));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        emptyHoverDefault = completableFuture;
        CompletableFuture<Either> completableFuture2 = CompletableFuture.completedFuture(Either.forLeft((Object)CollectionsKt.emptyList()));
        Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"completedFuture(...)");
        emptyDefinitionDefault = completableFuture2;
        CompletableFuture<Either> completableFuture3 = CompletableFuture.completedFuture(Either.forLeft((Object)CollectionsKt.emptyList()));
        Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"completedFuture(...)");
        emptyCompletionsDefault = completableFuture3;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\f\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R5\u0010\u001c\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\t0\u00190\u00138\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0016\u001a\u0004\b\u001d\u0010\u0018R/\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\t\u0012\u0004\u0012\u00020\u001f0\u00190\u00138\u0006\u00a2\u0006\f\n\u0004\b \u0010\u0016\u001a\u0004\b!\u0010\u0018R\u0014\u0010#\u001a\u00020\"8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\"8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010$R\u0014\u0010&\u001a\u00020\"8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010$R\u0014\u0010'\u001a\u00020\"8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010$\u00a8\u0006("}, d2={"Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer$Companion;", "", "<init>", "()V", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/FileAnalyseHandler;", "analyzer", "", "addAnalyzer", "(Lnet/papierkorb2292/command_crafter/editor/processing/helper/FileAnalyseHandler;)V", "", "Lorg/eclipse/lsp4j/Diagnostic;", "diagnostics", "fillDiagnosticsSource", "(Ljava/util/List;)V", "", "analyzers", "Ljava/util/List;", "getAnalyzers", "()Ljava/util/List;", "Ljava/util/concurrent/CompletableFuture;", "Lorg/eclipse/lsp4j/Hover;", "emptyHoverDefault", "Ljava/util/concurrent/CompletableFuture;", "getEmptyHoverDefault", "()Ljava/util/concurrent/CompletableFuture;", "Lorg/eclipse/lsp4j/jsonrpc/messages/Either;", "Lorg/eclipse/lsp4j/Location;", "Lorg/eclipse/lsp4j/LocationLink;", "emptyDefinitionDefault", "getEmptyDefinitionDefault", "Lorg/eclipse/lsp4j/CompletionItem;", "Lorg/eclipse/lsp4j/CompletionList;", "emptyCompletionsDefault", "getEmptyCompletionsDefault", "", "AUTO_RELOAD_DATAPACK_FUNCTIONS_CONFIG_PATH", "Ljava/lang/String;", "AUTO_RELOAD_DATAPACK_JSON_CONFIG_PATH", "AUTO_RELOAD_RESOURCEPACK_CONFIG_PATH", "CLIENT_LOG_CHANNEL", "command-crafter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FileAnalyseHandler> getAnalyzers() {
            return analyzers;
        }

        @NotNull
        public final CompletableFuture<Hover> getEmptyHoverDefault() {
            return emptyHoverDefault;
        }

        @NotNull
        public final CompletableFuture<Either<List<Location>, List<LocationLink>>> getEmptyDefinitionDefault() {
            return emptyDefinitionDefault;
        }

        @NotNull
        public final CompletableFuture<Either<List<CompletionItem>, CompletionList>> getEmptyCompletionsDefault() {
            return emptyCompletionsDefault;
        }

        public final void addAnalyzer(@NotNull FileAnalyseHandler analyzer) {
            Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
            ((Collection)this.getAnalyzers()).add(analyzer);
        }

        public final void fillDiagnosticsSource(@NotNull List<? extends Diagnostic> diagnostics) {
            Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
            for (Diagnostic diagnostic : diagnostics) {
                diagnostic.setSource("CommandCrafter");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

