/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.papierkorb2292.command_crafter.CommandCrafter;
import net.papierkorb2292.command_crafter.editor.EditorConnection;
import net.papierkorb2292.command_crafter.editor.EditorConnectionAcceptor;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lnet/papierkorb2292/command_crafter/editor/SocketEditorConnectionType;", "Lnet/papierkorb2292/command_crafter/editor/EditorConnectionAcceptor;", "", "port", "<init>", "(I)V", "Lnet/papierkorb2292/command_crafter/editor/EditorConnection;", "accept", "()Lnet/papierkorb2292/command_crafter/editor/EditorConnection;", "", "isRunning", "()Z", "", "start", "()V", "stop", "I", "getPort", "()I", "Ljava/net/ServerSocket;", "serverSocket", "Ljava/net/ServerSocket;", "command-crafter"})
public final class SocketEditorConnectionType
implements EditorConnectionAcceptor {
    private final int port;
    @Nullable
    private ServerSocket serverSocket;

    public SocketEditorConnectionType(int port) {
        this.port = port;
    }

    public final int getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public EditorConnection accept() {
        Closeable closeable;
        try {
            Closeable closeable2 = this.serverSocket;
            if (closeable2 == null || (closeable2 = closeable2.accept()) == null) {
                throw new IllegalStateException("Server socket is not running");
            }
            closeable = closeable2;
        }
        catch (SocketException e) {
            if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"Socket closed")) {
                return null;
            }
            CommandCrafter.INSTANCE.getLOGGER().error("Error accepting editor connection", (Throwable)e);
            return null;
        }
        Closeable socket = closeable;
        return new EditorConnection((Socket)socket){
            final /* synthetic */ Socket $socket;
            {
                this.$socket = $socket;
            }

            public InputStream getInputStream() {
                InputStream inputStream = this.$socket.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                return inputStream;
            }

            public OutputStream getOutputStream() {
                OutputStream outputStream = this.$socket.getOutputStream();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
                return outputStream;
            }

            public void close() {
                this.$socket.close();
            }
        };
    }

    @Override
    public boolean isRunning() {
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket == null) {
            return false;
        }
        return !serverSocket.isClosed();
    }

    @Override
    public void start() {
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (Exception e) {
            CommandCrafter.INSTANCE.getLOGGER().error("Failed to start server socket for editor connections on port " + this.port, (Throwable)e);
        }
    }

    @Override
    public void stop() {
        ServerSocket serverSocket = this.serverSocket;
        if (serverSocket != null) {
            serverSocket.close();
        }
        this.serverSocket = null;
    }
}

