/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.debugger.server;

import com.mojang.brigadier.context.StringRange;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.server.MinecraftServer;
import net.papierkorb2292.command_crafter.editor.PackagedId;
import net.papierkorb2292.command_crafter.editor.debugger.MinecraftDebuggerServer;
import net.papierkorb2292.command_crafter.editor.debugger.helper.EditorDebugConnection;
import net.papierkorb2292.command_crafter.editor.debugger.server.breakpoints.DebugHandler;
import net.papierkorb2292.command_crafter.editor.debugger.server.breakpoints.DebugHandlerFactory;
import net.papierkorb2292.command_crafter.editor.debugger.server.breakpoints.ServerBreakpoint;
import net.papierkorb2292.command_crafter.editor.debugger.server.breakpoints.UnparsedServerBreakpoint;
import net.papierkorb2292.command_crafter.editor.debugger.server.functions.FunctionDebugHandler;
import net.papierkorb2292.command_crafter.editor.debugger.server.functions.tags.FunctionTagDebugHandler;
import net.papierkorb2292.command_crafter.editor.processing.PackContentFileType;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.debug.Breakpoint;
import org.eclipse.lsp4j.debug.SourceBreakpoint;
import org.eclipse.lsp4j.debug.SourceResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 =2\u00020\u0001:\u0003=>?B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JE\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001a\u0010\u001bJ-\u0010 \u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001e\u00a2\u0006\u0004\b \u0010!J!\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0014\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b#\u0010$J'\u0010'\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010)\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010+R\u0017\u0010-\u001a\u00020,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u0017\u00102\u001a\u0002018\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R \u00108\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u000207068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R \u0010<\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020;0:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u00109\u00a8\u0006@"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager;", "", "Lnet/minecraft/server/MinecraftServer;", "server", "<init>", "(Lnet/minecraft/server/MinecraftServer;)V", "", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/breakpoints/UnparsedServerBreakpoint;", "breakpoints", "Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;", "fileType", "Lnet/papierkorb2292/command_crafter/editor/PackagedId;", "id", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection;", "debuggerConnector", "", "sourceReference", "Lorg/eclipse/lsp4j/debug/Breakpoint;", "setBreakpoints", "([Lnet/papierkorb2292/command_crafter/editor/debugger/server/breakpoints/UnparsedServerBreakpoint;Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;Lnet/papierkorb2292/command_crafter/editor/PackagedId;Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection;Ljava/lang/Integer;)[Lorg/eclipse/lsp4j/debug/Breakpoint;", "debugConnection", "", "removeDebugConnection", "(Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection;)V", "onReload", "()V", "removeSourceReference", "(Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection;I)V", "Lkotlin/Function1;", "Lorg/eclipse/lsp4j/debug/SourceResponse;", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/SourceReferenceSupplier;", "response", "addSourceReference", "(Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection;Lkotlin/jvm/functions/Function1;)I", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager$SourceReferenceGenerator;", "getSourceReferenceEntry", "(Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection;Ljava/lang/Integer;)Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager$SourceReferenceGenerator;", "", "", "getSourceReferenceLines", "(Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection;Ljava/lang/Integer;)Ljava/util/List;", "retrieveSourceReference", "(Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection;I)Lorg/eclipse/lsp4j/debug/SourceResponse;", "Lnet/minecraft/server/MinecraftServer;", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/functions/FunctionDebugHandler;", "functionDebugHandler", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/functions/FunctionDebugHandler;", "getFunctionDebugHandler", "()Lnet/papierkorb2292/command_crafter/editor/debugger/server/functions/FunctionDebugHandler;", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/functions/tags/FunctionTagDebugHandler;", "functionTagDebugHandler", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/functions/tags/FunctionTagDebugHandler;", "getFunctionTagDebugHandler", "()Lnet/papierkorb2292/command_crafter/editor/debugger/server/functions/tags/FunctionTagDebugHandler;", "", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/breakpoints/DebugHandler;", "debugHandlers", "Ljava/util/Map;", "", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager$PlayerSourceReferences;", "sourceReferencesMap", "Companion", "PlayerSourceReferences", "SourceReferenceGenerator", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nServerDebugManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerDebugManager.kt\nnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n465#2:131\n415#2:132\n384#2,7:141\n1252#3,4:133\n1869#3,2:137\n1869#3,2:139\n*S KotlinDebug\n*F\n+ 1 ServerDebugManager.kt\nnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager\n*L\n50#1:131\n50#1:132\n90#1:141,7\n50#1:133,4\n73#1:137,2\n78#1:139,2\n*E\n"})
public final class ServerDebugManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final FunctionDebugHandler functionDebugHandler;
    @NotNull
    private final FunctionTagDebugHandler functionTagDebugHandler;
    @NotNull
    private final Map<PackContentFileType, DebugHandler> debugHandlers;
    @NotNull
    private final Map<EditorDebugConnection, PlayerSourceReferences> sourceReferencesMap;
    @Nullable
    private static final Integer INITIAL_SOURCE_REFERENCE;
    @NotNull
    private static final Map<PackContentFileType, DebugHandlerFactory> additionalDebugHandlers;

    /*
     * WARNING - void declaration
     */
    public ServerDebugManager(@NotNull MinecraftServer server) {
        Map map2;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.functionDebugHandler = new FunctionDebugHandler(this.server);
        this.functionTagDebugHandler = new FunctionTagDebugHandler(this.server);
        Object object = new Pair[]{TuplesKt.to((Object)((Object)PackContentFileType.FUNCTIONS_FILE_TYPE), (Object)this.functionDebugHandler), TuplesKt.to((Object)((Object)PackContentFileType.FUNCTION_TAGS_FILE_TYPE), (Object)this.functionTagDebugHandler)};
        Map map3 = MapsKt.mapOf((Pair[])object);
        object = additionalDebugHandlers;
        Map map4 = map3;
        ServerDebugManager serverDebugManager = this;
        boolean $i$f$mapValues = false;
        void var4_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map5 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map2 = map5;
            boolean bl2 = false;
            DebugHandlerFactory factory = (DebugHandlerFactory)entry2.getValue();
            DebugHandler debugHandler = factory.createDebugHandler(this.server);
            map2.put(k, debugHandler);
        }
        map2 = destination$iv$iv;
        serverDebugManager.debugHandlers = MapsKt.plus((Map)map4, (Map)map2);
        this.sourceReferencesMap = new LinkedHashMap();
    }

    @NotNull
    public final FunctionDebugHandler getFunctionDebugHandler() {
        return this.functionDebugHandler;
    }

    @NotNull
    public final FunctionTagDebugHandler getFunctionTagDebugHandler() {
        return this.functionTagDebugHandler;
    }

    @NotNull
    public final Breakpoint[] setBreakpoints(@NotNull UnparsedServerBreakpoint[] breakpoints, @NotNull PackContentFileType fileType, @NotNull PackagedId id, @NotNull EditorDebugConnection debuggerConnector, @Nullable Integer sourceReference) {
        Intrinsics.checkNotNullParameter((Object)breakpoints, (String)"breakpoints");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)debuggerConnector, (String)"debuggerConnector");
        DebugHandler debugHandler = this.debugHandlers.get((Object)fileType);
        if (debugHandler == null) {
            return MinecraftDebuggerServer.Companion.rejectAllBreakpoints$default(MinecraftDebuggerServer.Companion, breakpoints, "File type not supported by server", null, 4, null);
        }
        DebugHandler debugHandler2 = debugHandler;
        return debugHandler2.setBreakpoints(breakpoints, id, debuggerConnector, sourceReference);
    }

    public static /* synthetic */ Breakpoint[] setBreakpoints$default(ServerDebugManager serverDebugManager, UnparsedServerBreakpoint[] unparsedServerBreakpointArray, PackContentFileType packContentFileType, PackagedId packagedId, EditorDebugConnection editorDebugConnection2, Integer n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        return serverDebugManager.setBreakpoints(unparsedServerBreakpointArray, packContentFileType, packagedId, editorDebugConnection2, n);
    }

    public final void removeDebugConnection(@NotNull EditorDebugConnection debugConnection) {
        Intrinsics.checkNotNullParameter((Object)debugConnection, (String)"debugConnection");
        Iterable $this$forEach$iv = this.debugHandlers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugHandler it = (DebugHandler)element$iv;
            boolean bl = false;
            it.removeDebugConnection(debugConnection);
        }
        this.sourceReferencesMap.remove(debugConnection);
    }

    public final void onReload() {
        Iterable $this$forEach$iv = this.debugHandlers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugHandler it = (DebugHandler)element$iv;
            boolean bl = false;
            it.onReload();
        }
    }

    public final void removeSourceReference(@NotNull EditorDebugConnection debugConnection, int sourceReference) {
        Intrinsics.checkNotNullParameter((Object)debugConnection, (String)"debugConnection");
        PlayerSourceReferences playerSourceReferences = this.sourceReferencesMap.get(debugConnection);
        if (playerSourceReferences == null) {
            return;
        }
        PlayerSourceReferences playerReferences = playerSourceReferences;
        playerReferences.getSources().remove(sourceReference);
        for (DebugHandler debugHandler : this.debugHandlers.values()) {
            debugHandler.removeSourceReference(debugConnection, sourceReference);
        }
        if (playerReferences.getSources().isEmpty()) {
            this.sourceReferencesMap.remove(debugConnection);
        }
    }

    public final int addSourceReference(@NotNull EditorDebugConnection debugConnection, @NotNull Function1<? super Integer, ? extends SourceResponse> response) {
        PlayerSourceReferences playerSourceReferences;
        Intrinsics.checkNotNullParameter((Object)debugConnection, (String)"debugConnection");
        Intrinsics.checkNotNullParameter(response, (String)"response");
        Map<EditorDebugConnection, PlayerSourceReferences> $this$getOrPut$iv = this.sourceReferencesMap;
        boolean $i$f$getOrPut = false;
        PlayerSourceReferences value$iv = $this$getOrPut$iv.get(debugConnection);
        if (value$iv == null) {
            boolean bl = false;
            PlayerSourceReferences answer$iv = new PlayerSourceReferences(null, 1, null);
            $this$getOrPut$iv.put(debugConnection, answer$iv);
            playerSourceReferences = answer$iv;
        } else {
            playerSourceReferences = value$iv;
        }
        PlayerSourceReferences references = playerSourceReferences;
        int id = debugConnection.getNextSourceReference();
        debugConnection.onSourceReferenceAdded();
        Integer n = id;
        ((Map)references.getSources()).put(n, new SourceReferenceGenerator(response));
        return id;
    }

    @Nullable
    public final SourceReferenceGenerator getSourceReferenceEntry(@NotNull EditorDebugConnection debugConnection, @Nullable Integer sourceReference) {
        Intrinsics.checkNotNullParameter((Object)debugConnection, (String)"debugConnection");
        PlayerSourceReferences playerSourceReferences = this.sourceReferencesMap.get(debugConnection);
        if (playerSourceReferences == null) {
            return null;
        }
        PlayerSourceReferences sourceReferences = playerSourceReferences;
        Integer n = sourceReference;
        if (n == null) {
            return null;
        }
        return (SourceReferenceGenerator)sourceReferences.getSources().get(n.intValue());
    }

    @Nullable
    public final List<String> getSourceReferenceLines(@NotNull EditorDebugConnection debugConnection, @Nullable Integer sourceReference) {
        Intrinsics.checkNotNullParameter((Object)debugConnection, (String)"debugConnection");
        PlayerSourceReferences playerSourceReferences = this.sourceReferencesMap.get(debugConnection);
        if (playerSourceReferences == null) {
            return null;
        }
        PlayerSourceReferences sourceReferences = playerSourceReferences;
        Integer n = sourceReference;
        if (n == null) {
            return null;
        }
        int sourceReferenceId = n;
        SourceReferenceGenerator sourceReferenceGenerator = (SourceReferenceGenerator)sourceReferences.getSources().get(sourceReferenceId);
        return sourceReferenceGenerator != null ? sourceReferenceGenerator.getLinesOrGenerate(sourceReferenceId) : null;
    }

    @Nullable
    public final SourceResponse retrieveSourceReference(@NotNull EditorDebugConnection debugConnection, int sourceReference) {
        Intrinsics.checkNotNullParameter((Object)debugConnection, (String)"debugConnection");
        PlayerSourceReferences playerSourceReferences = this.sourceReferencesMap.get(debugConnection);
        if (playerSourceReferences == null) {
            return null;
        }
        PlayerSourceReferences sourceReferences = playerSourceReferences;
        SourceReferenceGenerator sourceReferenceGenerator = (SourceReferenceGenerator)sourceReferences.getSources().get(sourceReference);
        return sourceReferenceGenerator != null ? sourceReferenceGenerator.generateSourceReference(sourceReference) : null;
    }

    static {
        additionalDebugHandlers = new LinkedHashMap();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u000b\u001a\u00020\n\"\u0004\b\u0000\u0010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\u0019\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager$Companion;", "", "<init>", "()V", "TBreakpointLocation", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/breakpoints/ServerBreakpoint;", "breakpoint", "", "", "lines", "Lcom/mojang/brigadier/context/StringRange;", "getFileBreakpointRange", "(Lnet/papierkorb2292/command_crafter/editor/debugger/server/breakpoints/ServerBreakpoint;Ljava/util/List;)Lcom/mojang/brigadier/context/StringRange;", "", "INITIAL_SOURCE_REFERENCE", "Ljava/lang/Integer;", "getINITIAL_SOURCE_REFERENCE", "()Ljava/lang/Integer;", "", "Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/breakpoints/DebugHandlerFactory;", "additionalDebugHandlers", "Ljava/util/Map;", "command-crafter"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Integer getINITIAL_SOURCE_REFERENCE() {
            return INITIAL_SOURCE_REFERENCE;
        }

        @NotNull
        public final <TBreakpointLocation> StringRange getFileBreakpointRange(@NotNull ServerBreakpoint<TBreakpointLocation> breakpoint, @NotNull List<String> lines) {
            StringRange stringRange;
            Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            SourceBreakpoint sourceBreakpoint = breakpoint.getUnparsed().getSourceBreakpoint();
            Integer column = sourceBreakpoint.getColumn();
            if (column == null) {
                stringRange = AnalyzingResult.Companion.getLineCursorRange(sourceBreakpoint.getLine(), lines);
            } else {
                int breakpointCursor = AnalyzingResult.Companion.getCursorFromPosition(lines, new Position(sourceBreakpoint.getLine(), column.intValue()), false);
                StringRange stringRange2 = StringRange.at((int)breakpointCursor);
                Intrinsics.checkNotNull((Object)stringRange2);
                stringRange = stringRange2;
            }
            return stringRange;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager$PlayerSourceReferences;", "", "Lit/unimi/dsi/fastutil/ints/Int2ReferenceMap;", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager$SourceReferenceGenerator;", "sources", "<init>", "(Lit/unimi/dsi/fastutil/ints/Int2ReferenceMap;)V", "Lit/unimi/dsi/fastutil/ints/Int2ReferenceMap;", "getSources", "()Lit/unimi/dsi/fastutil/ints/Int2ReferenceMap;", "command-crafter"})
    public static final class PlayerSourceReferences {
        @NotNull
        private final Int2ReferenceMap<SourceReferenceGenerator> sources;

        public PlayerSourceReferences(@NotNull Int2ReferenceMap<SourceReferenceGenerator> sources) {
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            this.sources = sources;
        }

        public /* synthetic */ PlayerSourceReferences(Int2ReferenceMap int2ReferenceMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                int2ReferenceMap = (Int2ReferenceMap)new Int2ReferenceOpenHashMap();
            }
            this((Int2ReferenceMap<SourceReferenceGenerator>)int2ReferenceMap);
        }

        @NotNull
        public final Int2ReferenceMap<SourceReferenceGenerator> getSources() {
            return this.sources;
        }

        public PlayerSourceReferences() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fR$\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0010R(\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerDebugManager$SourceReferenceGenerator;", "", "Lkotlin/Function1;", "", "Lorg/eclipse/lsp4j/debug/SourceResponse;", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/SourceReferenceSupplier;", "responseCallback", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "id", "generateSourceReference", "(I)Lorg/eclipse/lsp4j/debug/SourceResponse;", "", "", "getLinesOrGenerate", "(I)Ljava/util/List;", "Lkotlin/jvm/functions/Function1;", "value", "generatedResponse", "Lorg/eclipse/lsp4j/debug/SourceResponse;", "getGeneratedResponse", "()Lorg/eclipse/lsp4j/debug/SourceResponse;", "getGeneratedLines", "()Ljava/util/List;", "generatedLines", "command-crafter"})
    public static final class SourceReferenceGenerator {
        @NotNull
        private final Function1<Integer, SourceResponse> responseCallback;
        @Nullable
        private SourceResponse generatedResponse;

        public SourceReferenceGenerator(@NotNull Function1<? super Integer, ? extends SourceResponse> responseCallback) {
            Intrinsics.checkNotNullParameter(responseCallback, (String)"responseCallback");
            this.responseCallback = responseCallback;
        }

        @Nullable
        public final SourceResponse getGeneratedResponse() {
            return this.generatedResponse;
        }

        @Nullable
        public final List<String> getGeneratedLines() {
            Object object = this.generatedResponse;
            return object != null && (object = object.getContent()) != null ? StringsKt.lines((CharSequence)((CharSequence)object)) : null;
        }

        @NotNull
        public final SourceResponse generateSourceReference(int id) {
            SourceResponse sourceResponse = this.generatedResponse;
            if (sourceResponse == null) {
                Object object = this.responseCallback.invoke((Object)id);
                SourceResponse response = (SourceResponse)object;
                boolean bl = false;
                this.generatedResponse = response;
                sourceResponse = (SourceResponse)object;
            }
            return sourceResponse;
        }

        @NotNull
        public final List<String> getLinesOrGenerate(int id) {
            List list = this.getGeneratedLines();
            if (list == null) {
                String string = this.generateSourceReference(id).getContent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getContent(...)");
                list = StringsKt.lines((CharSequence)string);
            }
            return list;
        }
    }
}

