/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.debugger.server;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;
import net.papierkorb2292.command_crafter.editor.NetworkServerConnectionHandler;
import net.papierkorb2292.command_crafter.editor.debugger.DebugPauseActions;
import net.papierkorb2292.command_crafter.editor.debugger.helper.EditorDebugConnection;
import net.papierkorb2292.command_crafter.editor.debugger.helper.MinecraftStackFrame;
import net.papierkorb2292.command_crafter.editor.debugger.variables.VariablesReferencer;
import net.papierkorb2292.command_crafter.networking.packets.DebuggerExitS2CPacket;
import net.papierkorb2292.command_crafter.networking.packets.DebuggerOutputS2CPacket;
import net.papierkorb2292.command_crafter.networking.packets.PausedUpdateS2CPacket;
import net.papierkorb2292.command_crafter.networking.packets.PopStackFramesS2CPacket;
import net.papierkorb2292.command_crafter.networking.packets.PushStackFramesS2CPacket;
import net.papierkorb2292.command_crafter.networking.packets.ReserveBreakpointIdsRequestS2CPacket;
import net.papierkorb2292.command_crafter.networking.packets.SourceReferenceAddedS2CPacket;
import net.papierkorb2292.command_crafter.networking.packets.UpdateReloadedBreakpointS2CPacket;
import org.eclipse.lsp4j.debug.BreakpointEventArguments;
import org.eclipse.lsp4j.debug.ExitedEventArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001QB7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ!\u0010\"\u001a\f\u0012\b\u0012\u00060\bj\u0002`!0 2\u0006\u0010\u001f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010)\u001a\u00020\u00142\f\u0010$\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020+H\u0016\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b.\u0010\u0018J\u000f\u00100\u001a\u00020/H\u0016\u00a2\u0006\u0004\b0\u00101R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00102\u001a\u0004\b3\u00104R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u00105\u001a\u0004\b6\u00107R\"\u0010\t\u001a\u00020\b8\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\t\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010&R\u001a\u0010\u000b\u001a\u00020\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010<\u001a\u0004\b=\u0010\u001aR\u001a\u0010?\u001a\u00020>8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010BR(\u0010D\u001a\u0004\u0018\u00010\u00042\b\u0010C\u001a\u0004\u0018\u00010\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bD\u00102\u001a\u0004\bE\u00104R\u0017\u0010G\u001a\u00020F8\u0006\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010JR\u001c\u0010M\u001a\n L*\u0004\u0018\u00010K0K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u001c\u0010O\u001a\n L*\u0004\u0018\u00010/0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010P\u00a8\u0006R"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerNetworkDebugConnection;", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection;", "Lnet/minecraft/class_3222;", "player", "Ljava/util/UUID;", "clientEditorDebugConnection", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection$DebugTarget;", "oneTimeDebugTarget", "", "nextSourceReference", "", "suspendServer", "<init>", "(Lnet/minecraft/class_3222;Ljava/util/UUID;Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection$DebugTarget;IZ)V", "Lnet/papierkorb2292/command_crafter/editor/debugger/DebugPauseActions;", "actions", "Lorg/eclipse/lsp4j/debug/StoppedEventArguments;", "args", "Lnet/papierkorb2292/command_crafter/editor/debugger/variables/VariablesReferencer;", "variables", "", "pauseStarted", "(Lnet/papierkorb2292/command_crafter/editor/debugger/DebugPauseActions;Lorg/eclipse/lsp4j/debug/StoppedEventArguments;Lnet/papierkorb2292/command_crafter/editor/debugger/variables/VariablesReferencer;)V", "pauseEnded", "()V", "isPaused", "()Z", "Lorg/eclipse/lsp4j/debug/BreakpointEventArguments;", "update", "updateReloadedBreakpoint", "(Lorg/eclipse/lsp4j/debug/BreakpointEventArguments;)V", "count", "Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/ReservedBreakpointIdStart;", "reserveBreakpointIds", "(I)Ljava/util/concurrent/CompletableFuture;", "stackFrames", "popStackFrames", "(I)V", "", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/MinecraftStackFrame;", "pushStackFrames", "(Ljava/util/List;)V", "Lorg/eclipse/lsp4j/debug/OutputEventArguments;", "output", "(Lorg/eclipse/lsp4j/debug/OutputEventArguments;)V", "onSourceReferenceAdded", "", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getClientEditorDebugConnection", "()Ljava/util/UUID;", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection$DebugTarget;", "getOneTimeDebugTarget", "()Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection$DebugTarget;", "I", "getNextSourceReference", "()I", "setNextSourceReference", "Z", "getSuspendServer", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection$Lifecycle;", "lifecycle", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection$Lifecycle;", "getLifecycle", "()Lnet/papierkorb2292/command_crafter/editor/debugger/helper/EditorDebugConnection$Lifecycle;", "value", "currentPauseId", "getCurrentPauseId", "Lnet/minecraft/class_3244;", "networkHandler", "Lnet/minecraft/class_3244;", "getNetworkHandler", "()Lnet/minecraft/class_3244;", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "kotlin.jvm.PlatformType", "packetSender", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "playerName", "Ljava/lang/String;", "DebugPauseInformation", "command-crafter"})
public final class ServerNetworkDebugConnection
implements EditorDebugConnection {
    @NotNull
    private final UUID clientEditorDebugConnection;
    @Nullable
    private final EditorDebugConnection.DebugTarget oneTimeDebugTarget;
    private int nextSourceReference;
    private final boolean suspendServer;
    @NotNull
    private final EditorDebugConnection.Lifecycle lifecycle;
    @Nullable
    private UUID currentPauseId;
    @NotNull
    private final class_3244 networkHandler;
    private final PacketSender packetSender;
    private final String playerName;

    public ServerNetworkDebugConnection(@NotNull class_3222 player, @NotNull UUID clientEditorDebugConnection, @Nullable EditorDebugConnection.DebugTarget oneTimeDebugTarget, int nextSourceReference, boolean suspendServer) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)clientEditorDebugConnection, (String)"clientEditorDebugConnection");
        this.clientEditorDebugConnection = clientEditorDebugConnection;
        this.oneTimeDebugTarget = oneTimeDebugTarget;
        this.nextSourceReference = nextSourceReference;
        this.suspendServer = suspendServer;
        this.lifecycle = new EditorDebugConnection.Lifecycle();
        class_3244 class_32442 = player.field_13987;
        Intrinsics.checkNotNullExpressionValue((Object)class_32442, (String)"networkHandler");
        this.networkHandler = class_32442;
        this.packetSender = ServerPlayNetworking.getSender((class_3222)player);
        this.playerName = player.method_5477().getString();
        this.getLifecycle().getShouldExitEvent().thenAccept(arg_0 -> ServerNetworkDebugConnection._init_$lambda$1(arg_0 -> ServerNetworkDebugConnection._init_$lambda$0(this, arg_0), arg_0));
    }

    public /* synthetic */ ServerNetworkDebugConnection(class_3222 class_32222, UUID uUID, EditorDebugConnection.DebugTarget debugTarget, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            debugTarget = null;
        }
        if ((n2 & 8) != 0) {
            n = 1;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        this(class_32222, uUID, debugTarget, n, bl);
    }

    @NotNull
    public final UUID getClientEditorDebugConnection() {
        return this.clientEditorDebugConnection;
    }

    @Override
    @Nullable
    public EditorDebugConnection.DebugTarget getOneTimeDebugTarget() {
        return this.oneTimeDebugTarget;
    }

    @Override
    public int getNextSourceReference() {
        return this.nextSourceReference;
    }

    public void setNextSourceReference(int n) {
        this.nextSourceReference = n;
    }

    @Override
    public boolean getSuspendServer() {
        return this.suspendServer;
    }

    @Override
    @NotNull
    public EditorDebugConnection.Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Nullable
    public final UUID getCurrentPauseId() {
        return this.currentPauseId;
    }

    @NotNull
    public final class_3244 getNetworkHandler() {
        return this.networkHandler;
    }

    @Override
    public void pauseStarted(@NotNull DebugPauseActions actions, @NotNull StoppedEventArguments args, @NotNull VariablesReferencer variables) {
        UUID pauseId;
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        this.currentPauseId = pauseId = NetworkServerConnectionHandler.INSTANCE.addServerDebugPause(new DebugPauseInformation(actions, variables, this.clientEditorDebugConnection));
        this.packetSender.sendPacket((class_8710)new PausedUpdateS2CPacket(this.clientEditorDebugConnection, (Pair<UUID, ? extends StoppedEventArguments>)TuplesKt.to((Object)pauseId, (Object)args)));
    }

    @Override
    public void pauseEnded() {
        UUID uUID = this.currentPauseId;
        if (uUID != null) {
            UUID $this$pauseEnded_u24lambda_u242 = uUID;
            boolean bl = false;
            NetworkServerConnectionHandler.INSTANCE.removeServerDebugPauseHandler($this$pauseEnded_u24lambda_u242);
        }
        this.currentPauseId = null;
        this.packetSender.sendPacket((class_8710)new PausedUpdateS2CPacket(this.clientEditorDebugConnection, null));
    }

    @Override
    public boolean isPaused() {
        return this.currentPauseId != null;
    }

    @Override
    public void updateReloadedBreakpoint(@NotNull BreakpointEventArguments update) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        this.packetSender.sendPacket((class_8710)new UpdateReloadedBreakpointS2CPacket(update, this.clientEditorDebugConnection));
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> reserveBreakpointIds(int count) {
        UUID requestId = UUID.randomUUID();
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        Intrinsics.checkNotNull((Object)requestId);
        this.packetSender.sendPacket((class_8710)new ReserveBreakpointIdsRequestS2CPacket(count, this.clientEditorDebugConnection, requestId));
        NetworkServerConnectionHandler.INSTANCE.getCurrentBreakpointIdsRequests().put(requestId, future);
        return future;
    }

    @Override
    public void popStackFrames(int stackFrames) {
        this.packetSender.sendPacket((class_8710)new PopStackFramesS2CPacket(stackFrames, this.clientEditorDebugConnection));
    }

    @Override
    public void pushStackFrames(@NotNull List<MinecraftStackFrame> stackFrames) {
        Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
        this.packetSender.sendPacket((class_8710)new PushStackFramesS2CPacket(stackFrames, this.clientEditorDebugConnection));
    }

    @Override
    public void output(@NotNull OutputEventArguments args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.packetSender.sendPacket((class_8710)new DebuggerOutputS2CPacket(args, this.clientEditorDebugConnection));
    }

    @Override
    public void onSourceReferenceAdded() {
        int n = this.getNextSourceReference();
        this.setNextSourceReference(n + 1);
        this.packetSender.sendPacket((class_8710)new SourceReferenceAddedS2CPacket(this.clientEditorDebugConnection));
    }

    @NotNull
    public String toString() {
        return "ServerNetworkDebugConnection(player=" + this.playerName + ")";
    }

    private static final Unit _init_$lambda$0(ServerNetworkDebugConnection this$0, ExitedEventArguments it) {
        PacketSender packetSender = this$0.packetSender;
        Intrinsics.checkNotNull((Object)it);
        packetSender.sendPacket((class_8710)new DebuggerExitS2CPacket(it, this$0.clientEditorDebugConnection));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/ServerNetworkDebugConnection$DebugPauseInformation;", "", "Lnet/papierkorb2292/command_crafter/editor/debugger/DebugPauseActions;", "actions", "Lnet/papierkorb2292/command_crafter/editor/debugger/variables/VariablesReferencer;", "pauseContext", "Ljava/util/UUID;", "clientEditorDebugConnection", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/debugger/DebugPauseActions;Lnet/papierkorb2292/command_crafter/editor/debugger/variables/VariablesReferencer;Ljava/util/UUID;)V", "Lnet/papierkorb2292/command_crafter/editor/debugger/DebugPauseActions;", "getActions", "()Lnet/papierkorb2292/command_crafter/editor/debugger/DebugPauseActions;", "Lnet/papierkorb2292/command_crafter/editor/debugger/variables/VariablesReferencer;", "getPauseContext", "()Lnet/papierkorb2292/command_crafter/editor/debugger/variables/VariablesReferencer;", "Ljava/util/UUID;", "getClientEditorDebugConnection", "()Ljava/util/UUID;", "command-crafter"})
    public static final class DebugPauseInformation {
        @NotNull
        private final DebugPauseActions actions;
        @NotNull
        private final VariablesReferencer pauseContext;
        @NotNull
        private final UUID clientEditorDebugConnection;

        public DebugPauseInformation(@NotNull DebugPauseActions actions, @NotNull VariablesReferencer pauseContext, @NotNull UUID clientEditorDebugConnection) {
            Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
            Intrinsics.checkNotNullParameter((Object)pauseContext, (String)"pauseContext");
            Intrinsics.checkNotNullParameter((Object)clientEditorDebugConnection, (String)"clientEditorDebugConnection");
            this.actions = actions;
            this.pauseContext = pauseContext;
            this.clientEditorDebugConnection = clientEditorDebugConnection;
        }

        @NotNull
        public final DebugPauseActions getActions() {
            return this.actions;
        }

        @NotNull
        public final VariablesReferencer getPauseContext() {
            return this.pauseContext;
        }

        @NotNull
        public final UUID getClientEditorDebugConnection() {
            return this.clientEditorDebugConnection;
        }
    }
}

