/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.papierkorb2292.command_crafter.editor.processing.StringRangeTree;
import net.papierkorb2292.command_crafter.helper.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002:\u0001\u0018B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J9\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r\"\u0004\b\u0001\u0010\b2\u0006\u0010\t\u001a\u00028\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJC\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00110\r\"\b\b\u0001\u0010\b*\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/CodecSuggestionWrapper;", "A", "Lcom/mojang/serialization/Codec;", "delegate", "Lnet/papierkorb2292/command_crafter/editor/processing/CodecSuggestionWrapper$SuggestionsProvider;", "suggestionsProvider", "<init>", "(Lcom/mojang/serialization/Codec;Lnet/papierkorb2292/command_crafter/editor/processing/CodecSuggestionWrapper$SuggestionsProvider;)V", "T", "input", "Lcom/mojang/serialization/DynamicOps;", "ops", "prefix", "Lcom/mojang/serialization/DataResult;", "encode", "(Ljava/lang/Object;Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "", "Lcom/mojang/datafixers/util/Pair;", "decode", "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "Lcom/mojang/serialization/Codec;", "Lnet/papierkorb2292/command_crafter/editor/processing/CodecSuggestionWrapper$SuggestionsProvider;", "getSuggestionsProvider", "()Lnet/papierkorb2292/command_crafter/editor/processing/CodecSuggestionWrapper$SuggestionsProvider;", "SuggestionsProvider", "command-crafter"})
public final class CodecSuggestionWrapper<A>
implements Codec<A> {
    @NotNull
    private final Codec<A> delegate;
    @NotNull
    private final SuggestionsProvider suggestionsProvider;

    public CodecSuggestionWrapper(@NotNull Codec<A> delegate, @NotNull SuggestionsProvider suggestionsProvider) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)suggestionsProvider, (String)"suggestionsProvider");
        this.delegate = delegate;
        this.suggestionsProvider = suggestionsProvider;
    }

    @NotNull
    public final SuggestionsProvider getSuggestionsProvider() {
        return this.suggestionsProvider;
    }

    @NotNull
    public <T> DataResult<T> encode(A input, @NotNull DynamicOps<T> ops, T prefix) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        DataResult dataResult = this.delegate.encode(input, ops, prefix);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"encode(...)");
        return dataResult;
    }

    @NotNull
    public <T> DataResult<Pair<A, T>> decode(@NotNull DynamicOps<T> ops, @Nullable T input) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        if (input == null) {
            DataResult dataResult = this.delegate.decode(ops, null);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"decode(...)");
            return dataResult;
        }
        StringRangeTree.AnalyzingDynamicOps<?> analyzingDynamicOps = UtilKt.getOrNull(StringRangeTree.AnalyzingDynamicOps.Companion.getCURRENT_ANALYZING_OPS());
        if (analyzingDynamicOps != null) {
            StringRangeTree.AnalyzingDynamicOps<?> analyzingOps = analyzingDynamicOps;
            boolean bl = false;
            StringRangeTree.AnalyzingDynamicOps<?> castedOps = analyzingOps;
            castedOps.getNodeStartSuggestions(input).add(() -> CodecSuggestionWrapper.decode$lambda$3$lambda$2(this, ops));
        }
        DataResult dataResult = this.delegate.decode(ops, input);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"decode(...)");
        return dataResult;
    }

    private static final StringRangeTree.Suggestion decode$lambda$3$lambda$2$lambda$0(Object it) {
        return new StringRangeTree.Suggestion(it, false, 2, null);
    }

    private static final StringRangeTree.Suggestion decode$lambda$3$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (StringRangeTree.Suggestion)$tmp0.invoke(p0);
    }

    private static final Stream decode$lambda$3$lambda$2(CodecSuggestionWrapper this$0, DynamicOps $ops) {
        Stream<StringRangeTree.Suggestion> stream = this$0.suggestionsProvider.getSuggestions($ops).map(arg_0 -> CodecSuggestionWrapper.decode$lambda$3$lambda$2$lambda$1(CodecSuggestionWrapper::decode$lambda$3$lambda$2$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
        return stream;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J)\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\"\u0004\b\u0001\u0010\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H&\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/CodecSuggestionWrapper$SuggestionsProvider;", "", "T", "Lcom/mojang/serialization/DynamicOps;", "ops", "Ljava/util/stream/Stream;", "getSuggestions", "(Lcom/mojang/serialization/DynamicOps;)Ljava/util/stream/Stream;", "command-crafter"})
    public static interface SuggestionsProvider {
        @NotNull
        public <T> Stream<T> getSuggestions(@NotNull DynamicOps<T> var1);
    }
}

