/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.editor.processing.helper.UtilKt;
import net.papierkorb2292.command_crafter.parser.FileMappingInfo;
import net.papierkorb2292.command_crafter.parser.helper.ProcessedInputCursorMapper;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u0001j\u0002`\u0006BE\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J$\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0019R\u0014\u0010\t\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001aR\u001c\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u001cR\u0014\u0010\u000e\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0019R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/SimpleCompletionItemProvider;", "Lkotlin/Function1;", "", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/eclipse/lsp4j/CompletionItem;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingCompletionProvider;", "", "text", "insertStart", "Lkotlin/Function0;", "replaceEndProvider", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "mappingInfo", "label", "Lorg/eclipse/lsp4j/CompletionItemKind;", "kind", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function0;Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;Ljava/lang/String;Lorg/eclipse/lsp4j/CompletionItemKind;)V", "offset", "invoke", "(I)Ljava/util/concurrent/CompletableFuture;", "sourceCursor", "createCompletionItem", "(I)Lorg/eclipse/lsp4j/CompletionItem;", "Ljava/lang/String;", "I", "Lkotlin/jvm/functions/Function0;", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "Lorg/eclipse/lsp4j/CompletionItemKind;", "command-crafter"})
public final class SimpleCompletionItemProvider
implements Function1<Integer, CompletableFuture<List<? extends CompletionItem>>> {
    @NotNull
    private final String text;
    private final int insertStart;
    @NotNull
    private final Function0<Integer> replaceEndProvider;
    @NotNull
    private final FileMappingInfo mappingInfo;
    @NotNull
    private final String label;
    @Nullable
    private final CompletionItemKind kind;

    public SimpleCompletionItemProvider(@NotNull String text, int insertStart, @NotNull Function0<Integer> replaceEndProvider, @NotNull FileMappingInfo mappingInfo, @NotNull String label, @Nullable CompletionItemKind kind) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(replaceEndProvider, (String)"replaceEndProvider");
        Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.text = text;
        this.insertStart = insertStart;
        this.replaceEndProvider = replaceEndProvider;
        this.mappingInfo = mappingInfo;
        this.label = label;
        this.kind = kind;
    }

    public /* synthetic */ SimpleCompletionItemProvider(String string, int n, Function0 function0, FileMappingInfo fileMappingInfo, String string2, CompletionItemKind completionItemKind, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            string2 = string;
        }
        if ((n2 & 0x20) != 0) {
            completionItemKind = null;
        }
        this(string, n, (Function0<Integer>)function0, fileMappingInfo, string2, completionItemKind);
    }

    @NotNull
    public CompletableFuture<List<CompletionItem>> invoke(int offset) {
        CompletableFuture<List<CompletionItem>> completableFuture = CompletableFuture.completedFuture(CollectionsKt.listOf((Object)this.createCompletionItem(offset)));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @NotNull
    public final CompletionItem createCompletionItem(int sourceCursor) {
        CompletionItem completionItem;
        int adjustedInsertStart = Math.min(ProcessedInputCursorMapper.DefaultImpls.mapToSource$default((ProcessedInputCursorMapper)this.mappingInfo.getCursorMapper(), this.insertStart + this.mappingInfo.getReadSkippingChars(), false, 2, null), sourceCursor);
        Position insertStartPos = AnalyzingResult.Companion.getPositionFromCursor$default(AnalyzingResult.Companion, adjustedInsertStart, this.mappingInfo, false, 4, null);
        Position insertEndPos = AnalyzingResult.Companion.getPositionFromCursor$default(AnalyzingResult.Companion, sourceCursor, this.mappingInfo, false, 4, null);
        Position clampedInsertStartPos = UtilKt.clampCompletionToCursor$default(insertStartPos, insertEndPos.getLine(), sourceCursor, this.mappingInfo, false, 8, null);
        Integer n = (Integer)this.replaceEndProvider.invoke();
        if (n == null) {
            CompletionItem completionItem2;
            CompletionItem it = completionItem2 = new CompletionItem();
            boolean bl = false;
            it.setLabel(this.label);
            it.setKind(this.kind);
            it.setSortText(" " + this.label);
            it.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(clampedInsertStartPos, insertEndPos), this.text)));
            return completionItem2;
        }
        int replaceEnd = n;
        Position replaceEndPos = AnalyzingResult.Companion.getPositionFromCursor$default(AnalyzingResult.Companion, ProcessedInputCursorMapper.DefaultImpls.mapToSource$default((ProcessedInputCursorMapper)this.mappingInfo.getCursorMapper(), replaceEnd + this.mappingInfo.getReadSkippingChars(), false, 2, null), this.mappingInfo, false, 4, null);
        Position clampedReplaceEndPos = UtilKt.clampCompletionToCursor$default(replaceEndPos, insertEndPos.getLine(), sourceCursor, this.mappingInfo, false, 8, null);
        CompletionItem it = completionItem = new CompletionItem();
        boolean bl = false;
        it.setLabel(this.label);
        it.setFilterText(this.text);
        it.setSortText(" " + this.label);
        it.setKind(this.kind);
        it.setTextEdit(Either.forRight((Object)new InsertReplaceEdit(this.text, new Range(clampedInsertStartPos, insertEndPos), new Range(clampedInsertStartPos, clampedReplaceEndPos))));
        return completionItem;
    }
}

