/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing.helper;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mojang.brigadier.context.StringRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.papierkorb2292.command_crafter.editor.FeatureConfig;
import net.papierkorb2292.command_crafter.editor.processing.SemanticTokensBuilder;
import net.papierkorb2292.command_crafter.helper.UtilKt;
import net.papierkorb2292.command_crafter.parser.FileMappingInfo;
import net.papierkorb2292.command_crafter.parser.helper.ProcessedInputCursorMapper;
import net.papierkorb2292.command_crafter.parser.helper.SplitProcessedInputCursorMapper;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010%\n\u0002\b\u0007\u0018\u0000 k2\u00020\u0001:\u0002klB;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eB)\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\r\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0017\u0010\u0018J7\u0010!\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b0\u001a2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"J/\u0010#\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000b2\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b0\u001a\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002\u00a2\u0006\u0004\b'\u0010(J)\u0010*\u001a\u00020\u00122\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u001b0\u001a2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b*\u0010+JA\u0010/\u001a\u00020\u00122*\u0010\u001e\u001a&\u0012\"\u0012 \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u001c0,0\u001b0\u001a2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b/\u0010+J)\u00101\u001a\u0016\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b\u0018\u00010\u001a2\u0006\u00100\u001a\u00020%\u00a2\u0006\u0004\b1\u00102J#\u00104\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u001b\u0018\u00010\u001a2\u0006\u00103\u001a\u00020%\u00a2\u0006\u0004\b4\u00102J;\u00105\u001a(\u0012\"\u0012 \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u001c0,0\u001b\u0018\u00010\u001a2\u0006\u00103\u001a\u00020%\u00a2\u0006\u0004\b5\u00102J\r\u00106\u001a\u00020\u0000\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u00020\u0000\u00a2\u0006\u0004\b8\u00107J\r\u00109\u001a\u00020\u0000\u00a2\u0006\u0004\b9\u00107J#\u0010=\u001a\u00020\u00122\u0006\u0010;\u001a\u00020:2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c\u00a2\u0006\u0004\b=\u0010>J/\u0010@\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b0\u001a0\u00062\u0006\u0010?\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b@\u0010AJ=\u0010E\u001a\u00020\u0012\"\u0004\b\u0000\u0010B2\u0012\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u00062\u0012\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u001cH\u0002\u00a2\u0006\u0004\bE\u0010FJ7\u0010G\u001a\u00020\u0012\"\u0004\b\u0000\u0010B2\u0012\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0002\u00a2\u0006\u0004\bG\u0010HJ7\u0010J\u001a\u00020\u0012\"\u0004\b\u0000\u0010B2\u0012\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u00062\f\u0010I\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0002\u00a2\u0006\u0004\bJ\u0010HJ-\u0010K\u001a\u00020\u00122\u0010\u0010C\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u001c2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002\u00a2\u0006\u0004\bK\u0010HJC\u0010N\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001a\"\u0004\b\u0000\u0010B2\u0012\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001a0\u001c2\u0006\u00103\u001a\u00020%2\b\b\u0002\u0010M\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\bN\u0010OJ\u0015\u0010S\u001a\u00020R2\u0006\u0010Q\u001a\u00020P\u00a2\u0006\u0004\bS\u0010TR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010U\u001a\u0004\bV\u0010WR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010X\u001a\u0004\bY\u0010ZR\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010[\u001a\u0004\b\\\u0010]R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010^\u001a\u0004\b_\u0010`R$\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010a\u001a\u0004\bb\u0010c\"\u0004\bd\u0010eR8\u0010g\u001a&\u0012\u0004\u0012\u00020\u000b\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b0\u001a0\u00060f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bg\u0010hR&\u0010i\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u001b0\u001a0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bi\u0010[R>\u0010j\u001a,\u0012(\u0012&\u0012\"\u0012 \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0\u001c0,0\u001b0\u001a0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bj\u0010[\u00a8\u0006m"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "mappingInfo", "Lnet/papierkorb2292/command_crafter/editor/processing/SemanticTokensBuilder;", "semanticTokens", "", "Lorg/eclipse/lsp4j/Diagnostic;", "diagnostics", "Lorg/eclipse/lsp4j/Position;", "filePosition", "", "documentation", "<init>", "(Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;Lnet/papierkorb2292/command_crafter/editor/processing/SemanticTokensBuilder;Ljava/util/List;Lorg/eclipse/lsp4j/Position;Ljava/lang/String;)V", "reader", "(Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;Lorg/eclipse/lsp4j/Position;Ljava/util/List;)V", "other", "", "combineWith", "(Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;)V", "combineWithExceptCompletions", "channelSuffix", "combineWithCompletionProviders", "(Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;Ljava/lang/String;)V", "completionChannelName", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult$RangedDataProvider;", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/eclipse/lsp4j/CompletionItem;", "provider", "", "shouldMap", "addCompletionProvider", "(Ljava/lang/String;Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult$RangedDataProvider;Z)V", "addCompletionProviderWithContinuosMapping", "(Ljava/lang/String;Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult$RangedDataProvider;)V", "", "targetCursor", "getEarliestSourceCursorWithInclusiveEndMapping", "(I)I", "Lorg/eclipse/lsp4j/Hover;", "addHoverProvider", "(Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult$RangedDataProvider;Z)V", "Lorg/eclipse/lsp4j/jsonrpc/messages/Either;", "Lorg/eclipse/lsp4j/Location;", "Lorg/eclipse/lsp4j/LocationLink;", "addDefinitionProvider", "filterCursor", "getCompletionProviderForCursor", "(I)Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult$RangedDataProvider;", "cursor", "getHoverProviderForCursor", "getDefinitionProviderForCursor", "copyInput", "()Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "copy", "copyExceptCompletions", "Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;", "featureConfig", "analyzerNameInserts", "clearDisabledFeatures", "(Lnet/papierkorb2292/command_crafter/editor/FeatureConfig;Ljava/util/List;)V", "channel", "getOrPutCompletionProvidersForChannel", "(Ljava/lang/String;)Ljava/util/List;", "TData", "dest", "source", "addRangedDataProviders", "(Ljava/util/List;Ljava/util/List;)V", "addRangedDataProvider", "(Ljava/util/List;Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult$RangedDataProvider;)V", "unmappedProvider", "addMappedRangedDataProvider", "checkCanAddRangedDataProvider", "providers", "inclusiveRangeEnd", "getRangedDataProviderForCursor", "(Ljava/util/List;IZ)Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult$RangedDataProvider;", "Lcom/mojang/brigadier/context/StringRange;", "stringRange", "Lorg/eclipse/lsp4j/Range;", "toFileRange", "(Lcom/mojang/brigadier/context/StringRange;)Lorg/eclipse/lsp4j/Range;", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "getMappingInfo", "()Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "Lnet/papierkorb2292/command_crafter/editor/processing/SemanticTokensBuilder;", "getSemanticTokens", "()Lnet/papierkorb2292/command_crafter/editor/processing/SemanticTokensBuilder;", "Ljava/util/List;", "getDiagnostics", "()Ljava/util/List;", "Lorg/eclipse/lsp4j/Position;", "getFilePosition", "()Lorg/eclipse/lsp4j/Position;", "Ljava/lang/String;", "getDocumentation", "()Ljava/lang/String;", "setDocumentation", "(Ljava/lang/String;)V", "", "completionProviders", "Ljava/util/Map;", "hoverProviders", "definitionProviders", "Companion", "RangedDataProvider", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nAnalyzingResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzingResult.kt\nnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,343:1\n136#2,9:344\n216#2:353\n217#2:355\n145#2:356\n1#3:354\n2322#4,7:357\n1563#5:364\n1634#5,3:365\n1563#5:368\n1634#5,3:369\n1563#5:372\n1634#5,3:373\n1563#5:376\n1634#5,3:377\n1563#5:380\n1634#5,3:381\n1563#5:397\n1634#5,3:398\n384#6,7:384\n10135#7:391\n10557#7,5:392\n37#8:401\n36#8,3:402\n*S KotlinDebug\n*F\n+ 1 AnalyzingResult.kt\nnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult\n*L\n118#1:344,9\n118#1:353\n118#1:355\n118#1:356\n118#1:354\n121#1:357,7\n147#1:364\n147#1:365,3\n149#1:368\n149#1:369,3\n151#1:372\n151#1:373,3\n153#1:376\n153#1:377,3\n155#1:380\n155#1:381,3\n123#1:397\n123#1:398,3\n160#1:384,7\n124#1:391\n124#1:392,5\n123#1:401\n123#1:402,3\n*E\n"})
public final class AnalyzingResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileMappingInfo mappingInfo;
    @NotNull
    private final SemanticTokensBuilder semanticTokens;
    @NotNull
    private final List<Diagnostic> diagnostics;
    @NotNull
    private final Position filePosition;
    @Nullable
    private String documentation;
    @NotNull
    private final Map<String, List<RangedDataProvider<CompletableFuture<List<CompletionItem>>>>> completionProviders;
    @NotNull
    private final List<RangedDataProvider<CompletableFuture<Hover>>> hoverProviders;
    @NotNull
    private final List<RangedDataProvider<CompletableFuture<Either<List<Location>, List<LocationLink>>>>> definitionProviders;
    @NotNull
    public static final String LANGUAGE_COMPLETION_CHANNEL = "language";
    @NotNull
    public static final String DIRECTIVE_COMPLETION_CHANNEL = "directive";

    public AnalyzingResult(@NotNull FileMappingInfo mappingInfo, @NotNull SemanticTokensBuilder semanticTokens, @NotNull List<Diagnostic> diagnostics, @NotNull Position filePosition, @Nullable String documentation) {
        Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
        Intrinsics.checkNotNullParameter((Object)semanticTokens, (String)"semanticTokens");
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        Intrinsics.checkNotNullParameter((Object)filePosition, (String)"filePosition");
        this.mappingInfo = mappingInfo;
        this.semanticTokens = semanticTokens;
        this.diagnostics = diagnostics;
        this.filePosition = filePosition;
        this.documentation = documentation;
        this.completionProviders = new LinkedHashMap();
        this.hoverProviders = new ArrayList();
        this.definitionProviders = new ArrayList();
    }

    public /* synthetic */ AnalyzingResult(FileMappingInfo fileMappingInfo, SemanticTokensBuilder semanticTokensBuilder, List list, Position position, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        this(fileMappingInfo, semanticTokensBuilder, (List<Diagnostic>)list, position, string);
    }

    @NotNull
    public final FileMappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    @NotNull
    public final SemanticTokensBuilder getSemanticTokens() {
        return this.semanticTokens;
    }

    @NotNull
    public final List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final Position getFilePosition() {
        return this.filePosition;
    }

    @Nullable
    public final String getDocumentation() {
        return this.documentation;
    }

    public final void setDocumentation(@Nullable String string) {
        this.documentation = string;
    }

    public AnalyzingResult(@NotNull FileMappingInfo reader, @NotNull Position filePosition, @NotNull List<Diagnostic> diagnostics) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)filePosition, (String)"filePosition");
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        this(reader, new SemanticTokensBuilder(reader), diagnostics, filePosition, null, 16, null);
    }

    public /* synthetic */ AnalyzingResult(FileMappingInfo fileMappingInfo, Position position, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        this(fileMappingInfo, position, list);
    }

    public final void combineWith(@NotNull AnalyzingResult other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.combineWithExceptCompletions(other);
        AnalyzingResult.combineWithCompletionProviders$default(this, other, null, 2, null);
    }

    public final void combineWithExceptCompletions(@NotNull AnalyzingResult other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.semanticTokens.combineWith(other.semanticTokens);
        CollectionsKt.addAll((Collection)this.diagnostics, (Iterable)other.diagnostics);
        this.addRangedDataProviders(this.hoverProviders, other.hoverProviders);
        this.addRangedDataProviders(this.definitionProviders, other.definitionProviders);
    }

    public final void combineWithCompletionProviders(@NotNull AnalyzingResult other, @NotNull String channelSuffix) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)channelSuffix, (String)"channelSuffix");
        for (Map.Entry<String, List<RangedDataProvider<CompletableFuture<List<CompletionItem>>>>> entry : other.completionProviders.entrySet()) {
            String channel = entry.getKey();
            List<RangedDataProvider<CompletableFuture<List<CompletionItem>>>> providers = entry.getValue();
            this.addRangedDataProviders(this.getOrPutCompletionProvidersForChannel(channel + channelSuffix), providers);
        }
    }

    public static /* synthetic */ void combineWithCompletionProviders$default(AnalyzingResult analyzingResult, AnalyzingResult analyzingResult2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        analyzingResult.combineWithCompletionProviders(analyzingResult2, string);
    }

    public final void addCompletionProvider(@NotNull String completionChannelName, @NotNull RangedDataProvider<? extends CompletableFuture<List<CompletionItem>>> provider, boolean shouldMap) {
        Intrinsics.checkNotNullParameter((Object)completionChannelName, (String)"completionChannelName");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        List channel = this.getOrPutCompletionProvidersForChannel(completionChannelName);
        if (shouldMap) {
            this.addMappedRangedDataProvider(channel, provider);
            return;
        }
        this.addRangedDataProvider(channel, provider);
    }

    public final void addCompletionProviderWithContinuosMapping(@NotNull String completionChannelName, @NotNull RangedDataProvider<? extends CompletableFuture<List<CompletionItem>>> provider) {
        Intrinsics.checkNotNullParameter((Object)completionChannelName, (String)"completionChannelName");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        int mappedStart = this.getEarliestSourceCursorWithInclusiveEndMapping(provider.getCursorRange().getStart() + this.mappingInfo.getReadSkippingChars());
        int mappedEnd = ProcessedInputCursorMapper.DefaultImpls.mapToSource$default((ProcessedInputCursorMapper)this.mappingInfo.getCursorMapper(), provider.getCursorRange().getEnd() + this.mappingInfo.getReadSkippingChars(), false, 2, null);
        this.addCompletionProvider(completionChannelName, new RangedDataProvider<CompletableFuture<List<CompletionItem>>>(new StringRange(mappedStart, mappedEnd), provider.getDataProvider()), false);
    }

    private final int getEarliestSourceCursorWithInclusiveEndMapping(int targetCursor) {
        int mappingIndex = UtilKt.binarySearch$default(this.mappingInfo.getCursorMapper().getTargetCursors(), 0, 0, arg_0 -> AnalyzingResult.getEarliestSourceCursorWithInclusiveEndMapping$lambda$0(this, targetCursor, arg_0), 3, null);
        if (mappingIndex < 0) {
            if (mappingIndex == -1) {
                return targetCursor;
            }
            mappingIndex = -(mappingIndex + 2);
        }
        while (mappingIndex > 0 && this.mappingInfo.getCursorMapper().getTargetCursors().get(mappingIndex - 1) + this.mappingInfo.getCursorMapper().getLengths().get(mappingIndex - 1) >= targetCursor) {
            --mappingIndex;
        }
        int startInputCursor = this.mappingInfo.getCursorMapper().getTargetCursors().get(mappingIndex);
        int relativeCursor = targetCursor - startInputCursor;
        return this.mappingInfo.getCursorMapper().getSourceCursors().get(mappingIndex) + relativeCursor;
    }

    public final void addHoverProvider(@NotNull RangedDataProvider<? extends CompletableFuture<Hover>> provider, boolean shouldMap) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        if (shouldMap) {
            this.addMappedRangedDataProvider(this.hoverProviders, provider);
            return;
        }
        this.addRangedDataProvider(this.hoverProviders, provider);
    }

    public final void addDefinitionProvider(@NotNull RangedDataProvider<? extends CompletableFuture<Either<List<Location>, List<LocationLink>>>> provider, boolean shouldMap) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        if (shouldMap) {
            this.addMappedRangedDataProvider(this.definitionProviders, provider);
            return;
        }
        this.addRangedDataProvider(this.definitionProviders, provider);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final RangedDataProvider<CompletableFuture<List<CompletionItem>>> getCompletionProviderForCursor(int filterCursor) {
        void $this$mapNotNullTo$iv$iv;
        Map<String, List<RangedDataProvider<CompletableFuture<List<CompletionItem>>>>> $this$mapNotNull$iv = this.completionProviders;
        boolean $i$f$mapNotNull = false;
        Map<String, List<RangedDataProvider<CompletableFuture<List<CompletionItem>>>>> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        StringRange $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            RangedDataProvider it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if (this.getRangedDataProviderForCursor((List)it.getValue(), filterCursor, true) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List providers = (List)destination$iv$iv;
        if (providers.isEmpty()) {
            return null;
        }
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)providers), AnalyzingResult::getCompletionProviderForCursor$lambda$2);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            $this$forEach$iv$iv$iv = (StringRange)iterator$iv.next();
            StringRange p0 = (StringRange)accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringRange.encompassing((StringRange)p0, (StringRange)p1);
        }
        StringRange completeStringRange = (StringRange)accumulator$iv;
        Intrinsics.checkNotNull((Object)completeStringRange);
        return new RangedDataProvider<CompletableFuture<List<CompletionItem>>>(completeStringRange, arg_0 -> AnalyzingResult.getCompletionProviderForCursor$lambda$7(providers, arg_0));
    }

    @Nullable
    public final RangedDataProvider<CompletableFuture<Hover>> getHoverProviderForCursor(int cursor) {
        return AnalyzingResult.getRangedDataProviderForCursor$default(this, this.hoverProviders, cursor, false, 4, null);
    }

    @Nullable
    public final RangedDataProvider<CompletableFuture<Either<List<Location>, List<LocationLink>>>> getDefinitionProviderForCursor(int cursor) {
        RangedDataProvider rangedDataProvider = AnalyzingResult.getRangedDataProviderForCursor$default(this, this.definitionProviders, cursor, false, 4, null);
        if (rangedDataProvider == null) {
            rangedDataProvider = AnalyzingResult.getRangedDataProviderForCursor$default(this, this.definitionProviders, cursor - 1, false, 4, null);
        }
        return rangedDataProvider;
    }

    @NotNull
    public final AnalyzingResult copyInput() {
        FileMappingInfo newMappingInfo = this.mappingInfo.copy();
        return new AnalyzingResult(newMappingInfo, new SemanticTokensBuilder(newMappingInfo), (List<Diagnostic>)new ArrayList(), this.filePosition, this.documentation);
    }

    @NotNull
    public final AnalyzingResult copy() {
        AnalyzingResult analyzingResult;
        AnalyzingResult it = analyzingResult = this.copyInput();
        boolean bl = false;
        it.combineWith(this);
        return analyzingResult;
    }

    @NotNull
    public final AnalyzingResult copyExceptCompletions() {
        AnalyzingResult analyzingResult;
        AnalyzingResult it = analyzingResult = this.copyInput();
        boolean bl = false;
        it.combineWithExceptCompletions(this);
        return analyzingResult;
    }

    public final void clearDisabledFeatures(@NotNull FeatureConfig featureConfig, @NotNull List<String> analyzerNameInserts) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)featureConfig, (String)"featureConfig");
        Intrinsics.checkNotNullParameter(analyzerNameInserts, (String)"analyzerNameInserts");
        Iterable iterable = analyzerNameInserts;
        FeatureConfig featureConfig2 = featureConfig;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("analyzer" + it + ".completions");
        }
        if (!featureConfig2.isEnabled((List)destination$iv$iv, true)) {
            this.completionProviders.clear();
        }
        $this$map$iv = analyzerNameInserts;
        featureConfig2 = featureConfig;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("analyzer" + it + ".hovers");
        }
        if (!featureConfig2.isEnabled((List)destination$iv$iv, true)) {
            this.hoverProviders.clear();
        }
        $this$map$iv = analyzerNameInserts;
        featureConfig2 = featureConfig;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("analyzer" + it + ".definitions");
        }
        if (!featureConfig2.isEnabled((List)destination$iv$iv, true)) {
            this.definitionProviders.clear();
        }
        $this$map$iv = analyzerNameInserts;
        featureConfig2 = featureConfig;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("analyzer" + it + ".diagnostics");
        }
        if (!featureConfig2.isEnabled((List)destination$iv$iv, true)) {
            this.diagnostics.clear();
        }
        $this$map$iv = analyzerNameInserts;
        featureConfig2 = featureConfig;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add("analyzer" + it + ".semanticTokens");
        }
        if (!featureConfig2.isEnabled((List)destination$iv$iv, true)) {
            this.semanticTokens.clear();
        }
    }

    private final List<RangedDataProvider<CompletableFuture<List<CompletionItem>>>> getOrPutCompletionProvidersForChannel(String channel) {
        List list;
        Map<String, List<RangedDataProvider<CompletableFuture<List<CompletionItem>>>>> $this$getOrPut$iv = this.completionProviders;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(channel);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(channel, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        return list;
    }

    private final <TData> void addRangedDataProviders(List<RangedDataProvider<TData>> dest, List<? extends RangedDataProvider<? extends TData>> source) {
        for (RangedDataProvider<TData> rangedDataProvider : source) {
            this.addRangedDataProvider(dest, rangedDataProvider);
        }
    }

    private final <TData> void addRangedDataProvider(List<RangedDataProvider<TData>> dest, RangedDataProvider<? extends TData> provider) {
        this.checkCanAddRangedDataProvider(dest, provider);
        dest.add(provider);
    }

    private final <TData> void addMappedRangedDataProvider(List<RangedDataProvider<TData>> dest, RangedDataProvider<? extends TData> unmappedProvider) {
        int startCursor = unmappedProvider.getCursorRange().getStart() + this.mappingInfo.getReadSkippingChars();
        SplitProcessedInputCursorMapper cursorMapper = this.mappingInfo.getCursorMapper();
        int mappingIndex = UtilKt.binarySearch$default(cursorMapper.getTargetCursors(), 0, 0, arg_0 -> AnalyzingResult.addMappedRangedDataProvider$lambda$16(cursorMapper, startCursor, arg_0), 3, null);
        if (mappingIndex < 0) {
            mappingIndex = -(mappingIndex + 2);
        }
        int mappingRelativeCursor = startCursor;
        if (mappingIndex >= 0) {
            mappingRelativeCursor -= cursorMapper.getTargetCursors().get(mappingIndex);
        }
        int remainingLength = unmappedProvider.getCursorRange().getLength();
        while (mappingIndex < cursorMapper.getTargetCursors().getSize()) {
            int remainingLengthCoveredByMapping = mappingIndex >= 0 && mappingRelativeCursor < cursorMapper.getLengths().get(mappingIndex) ? Math.min(remainingLength, cursorMapper.getLengths().get(mappingIndex) - mappingRelativeCursor) : remainingLength;
            int mappingAbsoluteStart = mappingIndex >= 0 ? cursorMapper.getSourceCursors().get(mappingIndex) + mappingRelativeCursor : mappingRelativeCursor;
            int mappedStartPosition = startCursor + unmappedProvider.getCursorRange().getLength() - remainingLength;
            this.addRangedDataProvider(dest, new RangedDataProvider(new StringRange(mappingAbsoluteStart, mappingAbsoluteStart + remainingLengthCoveredByMapping), arg_0 -> AnalyzingResult.addMappedRangedDataProvider$lambda$17(mappingAbsoluteStart, unmappedProvider, mappedStartPosition, arg_0)));
            if (remainingLengthCoveredByMapping >= remainingLength) break;
            remainingLength -= remainingLengthCoveredByMapping;
            mappingRelativeCursor = 0;
            ++mappingIndex;
        }
    }

    private final void checkCanAddRangedDataProvider(List<? extends RangedDataProvider<?>> dest, RangedDataProvider<?> provider) {
        RangedDataProvider rangedDataProvider = (RangedDataProvider)CollectionsKt.lastOrNull(dest);
        if (rangedDataProvider == null) {
            return;
        }
        RangedDataProvider last = rangedDataProvider;
        if (last.getCursorRange().getEnd() > provider.getCursorRange().getStart()) {
            throw new IllegalArgumentException("Ranged data providers must be added in order and not overlap");
        }
    }

    private final <TData> RangedDataProvider<TData> getRangedDataProviderForCursor(List<? extends RangedDataProvider<? extends TData>> providers, int cursor, boolean inclusiveRangeEnd) {
        int index = CollectionsKt.binarySearch$default(providers, (int)0, (int)0, arg_0 -> AnalyzingResult.getRangedDataProviderForCursor$lambda$18(cursor, inclusiveRangeEnd, arg_0), (int)3, null);
        return index >= 0 ? (inclusiveRangeEnd && index + 1 < providers.size() && cursor == providers.get(index + 1).getCursorRange().getStart() ? providers.get(index + 1) : providers.get(index)) : null;
    }

    static /* synthetic */ RangedDataProvider getRangedDataProviderForCursor$default(AnalyzingResult analyzingResult, List list, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return analyzingResult.getRangedDataProviderForCursor(list, n, bl);
    }

    @NotNull
    public final Range toFileRange(@NotNull StringRange stringRange) {
        Intrinsics.checkNotNullParameter((Object)stringRange, (String)"stringRange");
        int startCursor = stringRange.getStart() + this.mappingInfo.getReadSkippingChars();
        int endCursor = stringRange.getEnd() + this.mappingInfo.getReadSkippingChars();
        return new Range(net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult$Companion.getPositionFromCursor$default(Companion, ProcessedInputCursorMapper.DefaultImpls.mapToSource$default((ProcessedInputCursorMapper)this.mappingInfo.getCursorMapper(), startCursor, false, 2, null), this.mappingInfo.getLines(), false, 4, null), net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult$Companion.getPositionFromCursor$default(Companion, ProcessedInputCursorMapper.DefaultImpls.mapToSource$default((ProcessedInputCursorMapper)this.mappingInfo.getCursorMapper(), endCursor, false, 2, null), this.mappingInfo.getLines(), false, 4, null));
    }

    private static final int getEarliestSourceCursorWithInclusiveEndMapping$lambda$0(AnalyzingResult this$0, int $targetCursor, int index) {
        return this$0.mappingInfo.getCursorMapper().getTargetCursors().get(index) > $targetCursor ? 1 : (this$0.mappingInfo.getCursorMapper().getTargetCursors().get(index) + this$0.mappingInfo.getCursorMapper().getLengths().get(index) <= $targetCursor ? -1 : 0);
    }

    private static final StringRange getCompletionProviderForCursor$lambda$2(RangedDataProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCursorRange();
    }

    /*
     * WARNING - void declaration
     */
    private static final List getCompletionProviderForCursor$lambda$7$lambda$5(CompletableFuture[] $completions, Void it) {
        void $this$flatMapTo$iv$iv;
        CompletableFuture[] $this$flatMap$iv = $completions;
        boolean $i$f$flatMap = false;
        CompletableFuture[] completableFutureArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it2 = element$iv$iv = $this$flatMapTo$iv$iv[j];
            boolean bl = false;
            Object t = it2.join();
            Intrinsics.checkNotNullExpressionValue(t, (String)"join(...)");
            Iterable list$iv$iv = (Iterable)t;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List getCompletionProviderForCursor$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture getCompletionProviderForCursor$lambda$7(List $providers, int providerCursor) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $providers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RangedDataProvider rangedDataProvider = (RangedDataProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CompletableFuture)it.getDataProvider().invoke((Object)providerCursor));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completions = thisCollection$iv.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(Arrays.copyOf(completions, completions.length)).thenApply(arg_0 -> AnalyzingResult.getCompletionProviderForCursor$lambda$7$lambda$6(arg_0 -> AnalyzingResult.getCompletionProviderForCursor$lambda$7$lambda$5(completions, arg_0), arg_0));
    }

    private static final int addMappedRangedDataProvider$lambda$16(SplitProcessedInputCursorMapper $cursorMapper, int $startCursor, int index) {
        return $cursorMapper.getTargetCursors().get(index) + $cursorMapper.getLengths().get(index) <= $startCursor ? -1 : ($cursorMapper.getTargetCursors().get(index) > $startCursor ? 1 : 0);
    }

    private static final Object addMappedRangedDataProvider$lambda$17(int $mappingAbsoluteStart, RangedDataProvider $unmappedProvider, int $mappedStartPosition, int it) {
        int mappingRelative = it - $mappingAbsoluteStart;
        return $unmappedProvider.getDataProvider().invoke((Object)(mappingRelative + $mappedStartPosition));
    }

    private static final int getRangedDataProviderForCursor$lambda$18(int $cursor, boolean $inclusiveRangeEnd, RangedDataProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $cursor < it.getCursorRange().getStart() ? 1 : ($cursor > it.getCursorRange().getEnd() || !$inclusiveRangeEnd && $cursor == it.getCursorRange().getEnd() ? -1 : 0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ-\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\u0010J'\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0012\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0014J~\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2K\u0010\u001d\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c0\u0017H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\"\u0010#J#\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\"\u0010$R\u0014\u0010%\u001a\u00020\u000e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u000e8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010&\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult$Companion;", "", "<init>", "()V", "", "cursor", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "mappingInfo", "", "zeroBased", "Lorg/eclipse/lsp4j/Position;", "getPositionFromCursor", "(ILnet/papierkorb2292/command_crafter/parser/FileMappingInfo;Z)Lorg/eclipse/lsp4j/Position;", "", "", "lines", "(ILjava/util/List;Z)Lorg/eclipse/lsp4j/Position;", "position", "getCursorFromPosition", "(Lorg/eclipse/lsp4j/Position;Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;Z)I", "(Ljava/util/List;Lorg/eclipse/lsp4j/Position;Z)I", "startCursor", "endCursor", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "line", "length", "", "rangeConsumer", "getInlineRangesBetweenCursors", "(IILjava/util/List;Lkotlin/jvm/functions/Function3;)V", "lineNumber", "Lcom/mojang/brigadier/context/StringRange;", "getLineCursorRange", "(ILnet/papierkorb2292/command_crafter/parser/FileMappingInfo;)Lcom/mojang/brigadier/context/StringRange;", "(ILjava/util/List;)Lcom/mojang/brigadier/context/StringRange;", "LANGUAGE_COMPLETION_CHANNEL", "Ljava/lang/String;", "DIRECTIVE_COMPLETION_CHANNEL", "command-crafter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Position getPositionFromCursor(int cursor, @NotNull FileMappingInfo mappingInfo, boolean zeroBased) {
            Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
            return this.getPositionFromCursor(cursor, mappingInfo.getLines(), zeroBased);
        }

        public static /* synthetic */ Position getPositionFromCursor$default(Companion companion, int n, FileMappingInfo fileMappingInfo, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = true;
            }
            return companion.getPositionFromCursor(n, fileMappingInfo, bl);
        }

        @NotNull
        public final Position getPositionFromCursor(int cursor, @NotNull List<String> lines, boolean zeroBased) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            if (lines.isEmpty()) {
                return new Position();
            }
            int charactersLeft = cursor;
            Iterator iterator = ((Iterable)lines).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                String line = (String)iterator.next();
                int length = line.length() + 1;
                if (charactersLeft < length) {
                    return zeroBased ? new Position(index, charactersLeft) : new Position(index + 1, charactersLeft + 1);
                }
                charactersLeft -= length;
            }
            int lastLineNumber = lines.size();
            int lastColumnNumber = ((String)CollectionsKt.last(lines)).length();
            return zeroBased ? new Position(lastLineNumber - 1, lastColumnNumber) : new Position(lastLineNumber, lastColumnNumber + 1);
        }

        public static /* synthetic */ Position getPositionFromCursor$default(Companion companion, int n, List list, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = true;
            }
            return companion.getPositionFromCursor(n, list, bl);
        }

        public final int getCursorFromPosition(@NotNull Position position, @NotNull FileMappingInfo mappingInfo, boolean zeroBased) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
            return this.getCursorFromPosition(mappingInfo.getLines(), position, zeroBased);
        }

        public static /* synthetic */ int getCursorFromPosition$default(Companion companion, Position position, FileMappingInfo fileMappingInfo, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.getCursorFromPosition(position, fileMappingInfo, bl);
        }

        public final int getCursorFromPosition(@NotNull List<String> lines, @NotNull Position position, boolean zeroBased) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            if (lines.isEmpty()) {
                return 0;
            }
            int cursor = 0;
            int lineIndex = zeroBased ? position.getLine() : position.getLine() - 1;
            Iterator iterator = ((Iterable)lines).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                String line = (String)iterator.next();
                if (index == lineIndex) {
                    return cursor + position.getCharacter();
                }
                cursor += line.length() + 1;
            }
            return cursor;
        }

        public static /* synthetic */ int getCursorFromPosition$default(Companion companion, List list, Position position, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.getCursorFromPosition(list, position, bl);
        }

        public final void getInlineRangesBetweenCursors(int startCursor, int endCursor, @NotNull List<String> lines, @NotNull Function3<? super Integer, ? super Integer, ? super Integer, Unit> rangeConsumer) {
            int lineLength;
            int startCharactersLeft;
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(rangeConsumer, (String)"rangeConsumer");
            boolean $i$f$getInlineRangesBetweenCursors = false;
            int line = 0;
            for (startCharactersLeft = startCursor; lines.size() > line && startCharactersLeft >= lines.get(line).length() + 1; startCharactersLeft -= lines.get(line++).length() + 1) {
            }
            for (int rangeCharactersLeft = endCursor - startCursor; lines.size() > line && rangeCharactersLeft > 0; ++line, rangeCharactersLeft -= lineLength - startCharactersLeft) {
                lineLength = lines.get(line).length() + 1;
                if (lineLength >= rangeCharactersLeft + startCharactersLeft) {
                    rangeConsumer.invoke((Object)line, (Object)startCharactersLeft, (Object)rangeCharactersLeft);
                    return;
                }
                rangeConsumer.invoke((Object)line, (Object)startCharactersLeft, (Object)lineLength);
                startCharactersLeft = 0;
            }
        }

        @NotNull
        public final StringRange getLineCursorRange(int lineNumber, @NotNull FileMappingInfo mappingInfo) {
            Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
            return this.getLineCursorRange(lineNumber, mappingInfo.getLines());
        }

        @NotNull
        public final StringRange getLineCursorRange(int lineNumber, @NotNull List<String> lines) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            int cursor = 0;
            int lineIndex = lineNumber - 1;
            Iterator iterator = ((Iterable)lines).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                String currentText = (String)iterator.next();
                if (index == lineIndex) {
                    return new StringRange(cursor, cursor + currentText.length());
                }
                cursor += currentText.length() + 1;
            }
            return new StringRange(cursor, cursor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B-\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u001c\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000b\u001a\u0004\b\f\u0010\rR0\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u00078\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult$RangedDataProvider;", "TData", "", "Lcom/mojang/brigadier/context/StringRange;", "cursorRange", "Lkotlin/Function1;", "", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingDataProvider;", "dataProvider", "<init>", "(Lcom/mojang/brigadier/context/StringRange;Lkotlin/jvm/functions/Function1;)V", "Lcom/mojang/brigadier/context/StringRange;", "getCursorRange", "()Lcom/mojang/brigadier/context/StringRange;", "Lkotlin/jvm/functions/Function1;", "getDataProvider", "()Lkotlin/jvm/functions/Function1;", "command-crafter"})
    public static final class RangedDataProvider<TData> {
        @NotNull
        private final StringRange cursorRange;
        @JsonIgnore
        @NotNull
        private final Function1<Integer, TData> dataProvider;

        public RangedDataProvider(@NotNull StringRange cursorRange, @NotNull Function1<? super Integer, ? extends TData> dataProvider) {
            Intrinsics.checkNotNullParameter((Object)cursorRange, (String)"cursorRange");
            Intrinsics.checkNotNullParameter(dataProvider, (String)"dataProvider");
            this.cursorRange = cursorRange;
            this.dataProvider = dataProvider;
            if (this.cursorRange.getStart() > this.cursorRange.getEnd()) {
                throw new IllegalArgumentException("Start cursor must not be greater than end cursor");
            }
        }

        @NotNull
        public final StringRange getCursorRange() {
            return this.cursorRange;
        }

        @NotNull
        public final Function1<Integer, TData> getDataProvider() {
            return this.dataProvider;
        }
    }
}

