/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer;

import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3244;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_4565;
import net.minecraft.class_5218;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_9011;
import net.minecraft.class_9015;
import net.minecraft.class_9022;
import net.minecraft.class_9024;
import net.minecraft.server.MinecraftServer;
import net.papierkorb2292.command_crafter.editor.EditorURI;
import net.papierkorb2292.command_crafter.editor.processing.StringRangeTree;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.ServerScoreboardStorageFileSystem;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.DeleteParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileChangeType;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileEvent;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileNotFoundError;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileStat;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemRemoveWatchParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemResult;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemWatchParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileType;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.LoadStorageNamespaceParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.LoadableStorageNamespaces;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.ReadDirectoryResultEntry;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.ReadFileResult;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.RenameParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.ScoreboardStorageFileSystem;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.UriParams;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.WriteFileParams;
import net.papierkorb2292.command_crafter.helper.UtilKt;
import net.papierkorb2292.command_crafter.mixin.editor.scoreboardStorageViewer.DataCommandStorageAccessor;
import net.papierkorb2292.command_crafter.mixin.editor.scoreboardStorageViewer.ScoreboardAccessor;
import net.papierkorb2292.command_crafter.mixin.editor.scoreboardStorageViewer.ScoreboardObjectiveAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 Z2\u00020\u0001:\u0007Z[\\]^_`B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u000b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J)\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00070\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u0019J#\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u0019J#\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u0019J#\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J%\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J%\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b(\u0010'J#\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00160\u00152\u0006\u0010\u000e\u001a\u00020)H\u0016\u00a2\u0006\u0004\b*\u0010+J#\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00160\u00152\u0006\u0010\u000e\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.J\u001d\u00100\u001a\b\u0012\u0004\u0012\u00020/0\u00152\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b0\u00101J\u0017\u00103\u001a\u00020\t2\u0006\u0010\u000e\u001a\u000202H\u0016\u00a2\u0006\u0004\b3\u00104J\u001d\u00107\u001a\b\u0012\u0004\u0012\u00020\"0\u00162\u0006\u00106\u001a\u000205H\u0002\u00a2\u0006\u0004\b7\u00108J'\u0010=\u001a\u0002052\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u0002052\u0006\u0010<\u001a\u000205H\u0002\u00a2\u0006\u0004\b=\u0010>J%\u0010?\u001a\b\u0012\u0004\u0012\u00020$0\u00162\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u000205H\u0002\u00a2\u0006\u0004\b?\u0010@J%\u0010D\u001a\u00020\t2\u0006\u0010:\u001a\u0002092\u0006\u0010A\u001a\u0002052\u0006\u0010C\u001a\u00020B\u00a2\u0006\u0004\bD\u0010EJ\r\u0010F\u001a\u00020\t\u00a2\u0006\u0004\bF\u0010GR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010H\u001a\u0004\bI\u0010JR\u001a\u0010M\u001a\b\u0012\u0004\u0012\u00020L0K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR$\u0010P\u001a\u0010\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u000205\u0018\u00010O8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0018\u0010R\u001a\u0004\u0018\u00010$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR*\u0010T\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t\u0018\u00010\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bT\u0010UR\u001a\u0010X\u001a\b\u0012\u0004\u0012\u00020W0V8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bX\u0010Y\u00a8\u0006a"}, d2={"Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/ScoreboardStorageFileSystem;", "Lnet/minecraft/server/MinecraftServer;", "server", "<init>", "(Lnet/minecraft/server/MinecraftServer;)V", "Lkotlin/Function1;", "", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileEvent;", "", "callback", "setOnDidChangeFileCallback", "(Lkotlin/jvm/functions/Function1;)V", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileSystemWatchParams;", "params", "watch", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileSystemWatchParams;)V", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileSystemRemoveWatchParams;", "removeWatch", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileSystemRemoveWatchParams;)V", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/UriParams;", "Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileSystemResult;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileStat;", "stat", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/UriParams;)Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/ReadDirectoryResultEntry;", "readDirectory", "createDirectory", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/ReadFileResult;", "readFile", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/WriteFileParams;", "writeFile", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/WriteFileParams;)Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ResolvedPath;", "resolvedPath", "", "content", "updateScoreboardData", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ResolvedPath;[B)Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileSystemResult;", "updateStorageData", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/DeleteParams;", "delete", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/DeleteParams;)Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/RenameParams;", "rename", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/RenameParams;)Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/LoadableStorageNamespaces;", "getLoadableStorageNamespaces", "(Lkotlin/Unit;)Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/LoadStorageNamespaceParams;", "loadStorageNamespace", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/LoadStorageNamespaceParams;)V", "", "uri", "resolveUri", "(Ljava/lang/String;)Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileSystemResult;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;", "directory", "fileName", "fileExtension", "createUrl", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "getFileContent", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;Ljava/lang/String;)Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileSystemResult;", "objectName", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileChangeType;", "updateType", "onFileUpdate", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;Ljava/lang/String;Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileChangeType;)V", "flushQueuedFileUpdates", "()V", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Watch;", "watches", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lkotlin/Pair;", "lastFileCacheId", "Lkotlin/Pair;", "lastFileCacheContent", "[B", "onDidChangeFileCallback", "Lkotlin/jvm/functions/Function1;", "", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$FileUpdate;", "queuedFileUpdates", "Ljava/util/Set;", "Companion", "Directory", "ResolvedPath", "Watch", "FileUpdate", "ObjectiveData", "ObjectiveFile", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nServerScoreboardStorageFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerScoreboardStorageFileSystem.kt\nnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 FileSystemResult.kt\nnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileSystemResult\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,553:1\n11228#2:554\n11563#2,3:555\n11228#2:601\n11563#2,3:602\n11546#2,9:616\n13472#2:625\n13473#2:630\n11555#2:631\n66#3,5:558\n66#3,5:563\n66#3,5:568\n66#3,5:586\n66#3,5:591\n66#3,5:596\n1056#4:573\n1563#4:574\n1634#4,3:575\n774#4:605\n865#4,2:606\n1056#4:612\n1374#4:613\n1460#4,2:614\n1761#4,3:626\n1462#4,3:632\n37#5:578\n36#5,3:579\n37#5:582\n36#5,3:583\n37#5:608\n36#5,3:609\n37#5:635\n36#5,3:636\n1#6:629\n*S KotlinDebug\n*F\n+ 1 ServerScoreboardStorageFileSystem.kt\nnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem\n*L\n201#1:554\n201#1:555,3\n382#1:601\n382#1:602,3\n508#1:616,9\n508#1:625\n508#1:630\n508#1:631\n216#1:558,5\n222#1:563,5\n231#1:568,5\n267#1:586,5\n273#1:591,5\n282#1:596,5\n242#1:573\n242#1:574\n242#1:575,3\n384#1:605\n384#1:606,2\n430#1:612\n498#1:613\n498#1:614,2\n509#1:626,3\n498#1:632,3\n244#1:578\n244#1:579,3\n255#1:582\n255#1:583,3\n385#1:608\n385#1:609,3\n515#1:635\n515#1:636,3\n508#1:629\n*E\n"})
public final class ServerScoreboardStorageFileSystem
implements ScoreboardStorageFileSystem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final Int2ObjectMap<Watch> watches;
    @Nullable
    private kotlin.Pair<? extends Directory, String> lastFileCacheId;
    @Nullable
    private byte[] lastFileCacheContent;
    @Nullable
    private Function1<? super FileEvent[], Unit> onDidChangeFileCallback;
    @NotNull
    private final Set<FileUpdate> queuedFileUpdates;
    @NotNull
    private static final String SCOREBOARDS_DIRECTORY = "scoreboards";
    @NotNull
    private static final String STORAGES_DIRECTORY = "storages";
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private static final List<Function0<Unit>> DATA_UPDATE_QUEUE = new ArrayList();
    private static long lastFileUpdateTimeMs;
    @NotNull
    private static final Map<class_3244, Map<UUID, ServerScoreboardStorageFileSystem>> createdFileSystems;
    @NotNull
    private static final Companion.CRITERION_CODEC.1 CRITERION_CODEC;
    @NotNull
    private static final Companion.NUMBER_FORMAT_CODEC.1 NUMBER_FORMAT_CODEC;
    @NotNull
    private static final Codec<ObjectiveData> OBJECTIVE_DATA_CODEC;
    @NotNull
    private static final Codec<Map<String, Integer>> ENTRIES_CODEC;
    @NotNull
    private static final Codec<ObjectiveFile> OBJECTIVE_CODEC;

    public ServerScoreboardStorageFileSystem(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.watches = (Int2ObjectMap)new Int2ObjectArrayMap();
        this.queuedFileUpdates = new LinkedHashSet();
    }

    @NotNull
    public final MinecraftServer getServer() {
        return this.server;
    }

    @Override
    public void setOnDidChangeFileCallback(@NotNull Function1<? super FileEvent[], Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.onDidChangeFileCallback = callback;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void watch(@NotNull FileSystemWatchParams params) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String uriRegex = EditorURI.Companion.parseURI$default(EditorURI.Companion, params.getUri(), false, 2, null).toPatternMatch();
        Pattern uriPattern = Pattern.compile(params.getRecursive() ? "^" + uriRegex : "^" + uriRegex + "$");
        String[] $this$map$iv = params.getExcludes();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var13_12 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char c = '^';
            String string = EditorURI.Companion.parseURI$default(EditorURI.Companion, (String)it, false, 2, null).toPatternMatch();
            collection.add(Pattern.compile(c + string));
        }
        List excludePatterns = (List)destination$iv$iv;
        Map map2 = (Map)this.watches;
        Integer n2 = params.getWatcherId();
        Intrinsics.checkNotNull((Object)uriPattern);
        map2.put(n2, new Watch(uriPattern, excludePatterns));
    }

    @Override
    public void removeWatch(@NotNull FileSystemRemoveWatchParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.watches.remove(params.getWatcherId());
    }

    @Override
    @NotNull
    public CompletableFuture<FileSystemResult<FileStat>> stat(@NotNull UriParams params) {
        FileSystemResult<byte[]> contentResult;
        FileSystemResult<ResolvedPath> resolvedPathResult;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        FileSystemResult<ResolvedPath> this_$iv = resolvedPathResult = this.resolveUri(params.getUri());
        boolean $i$f$handleErrorAndGetResult = false;
        if (this_$iv.getType() != FileSystemResult.ResultType.SUCCESS) {
            Intrinsics.checkNotNull(this_$iv, (String)"null cannot be cast to non-null type net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemResult<kotlin.Nothing>");
            FileSystemResult<ResolvedPath> it = this_$iv;
            boolean bl = false;
            CompletableFuture<FileSystemResult<FileStat>> completableFuture = CompletableFuture.completedFuture(it);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ResolvedPath resolvedPath = this_$iv.getResult();
        if (resolvedPath.getFileName() == null) {
            CompletableFuture<FileSystemResult<FileStat>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult<FileStat>(new FileStat(FileType.Companion.getDIRECTORY-kha_Om8(), 0, (int)class_156.method_659(), 1, null, 16, null)));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        FileSystemResult<byte[]> this_$iv2 = contentResult = this.getFileContent(resolvedPath.getDirectory(), resolvedPath.getFileName());
        boolean $i$f$handleErrorAndGetResult2 = false;
        if (this_$iv2.getType() != FileSystemResult.ResultType.SUCCESS) {
            Intrinsics.checkNotNull(this_$iv2, (String)"null cannot be cast to non-null type net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemResult<kotlin.Nothing>");
            FileSystemResult<byte[]> it = this_$iv2;
            boolean bl = false;
            CompletableFuture<FileSystemResult<FileStat>> completableFuture = CompletableFuture.completedFuture(it);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        byte[] content = this_$iv2.getResult();
        int contentSize = content.length;
        CompletableFuture<FileSystemResult<FileStat>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult<FileStat>(new FileStat(FileType.Companion.getFILE-kha_Om8(), 0, (int)class_156.method_659(), contentSize, null, 16, null)));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<FileSystemResult<ReadDirectoryResultEntry[]>> readDirectory(@NotNull UriParams params) {
        FileSystemResult<ResolvedPath> resolvedPathResult;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        FileSystemResult<ResolvedPath> this_$iv = resolvedPathResult = this.resolveUri(params.getUri());
        boolean $i$f$handleErrorAndGetResult = false;
        if (this_$iv.getType() != FileSystemResult.ResultType.SUCCESS) {
            Intrinsics.checkNotNull(this_$iv, (String)"null cannot be cast to non-null type net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemResult<kotlin.Nothing>");
            FileSystemResult<ResolvedPath> it = this_$iv;
            boolean bl = false;
            CompletableFuture<FileSystemResult<ReadDirectoryResultEntry[]>> completableFuture = CompletableFuture.completedFuture(it);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ResolvedPath resolvedPath = this_$iv.getResult();
        if (resolvedPath.getFileName() != null) {
            CompletableFuture<FileSystemResult<ReadDirectoryResultEntry[]>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult(new FileNotFoundError("readDirectory can only be called on directories")));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ReadDirectoryResultEntry[] entries = switch (WhenMappings.$EnumSwitchMapping$0[resolvedPath.getDirectory().ordinal()]) {
            case 1 -> {
                ReadDirectoryResultEntry[] bl = new ReadDirectoryResultEntry[]{new ReadDirectoryResultEntry(SCOREBOARDS_DIRECTORY, FileType.Companion.getDIRECTORY-kha_Om8(), null), new ReadDirectoryResultEntry(STORAGES_DIRECTORY, FileType.Companion.getDIRECTORY-kha_Om8(), null)};
                yield bl;
            }
            case 2 -> {
                Collection<Object> $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                Collection v3 = this.server.method_3845().method_1151();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getObjectives(...)");
                Iterable $this$sortedBy$iv = v3;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        class_266 it = (class_266)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.method_1113());
                        it = (class_266)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.method_1113())));
                    }
                });
                boolean $i$f$map = false;
                void var9_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    class_266 var14_15 = (class_266)item$iv$iv;
                    Collection var16_17 = destination$iv$iv;
                    boolean $i$a$-map-ServerScoreboardStorageFileSystem$readDirectory$entries$2 = false;
                    String v4 = it.method_1113();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getName(...)");
                    var16_17.add(new ReadDirectoryResultEntry(this.createUrl(Directory.SCOREBOARDS, v4, ".json"), FileType.Companion.getFILE-kha_Om8(), null));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection<Object> thisCollection$iv = $this$toTypedArray$iv;
                yield thisCollection$iv.toArray(new ReadDirectoryResultEntry[0]);
            }
            case 3 -> {
                Collection<Object> $this$toTypedArray$iv = this.server.method_22827().method_22542().sorted((arg_0, arg_1) -> ServerScoreboardStorageFileSystem.readDirectory$lambda$7(ServerScoreboardStorageFileSystem::readDirectory$lambda$6, arg_0, arg_1)).flatMap(arg_0 -> ServerScoreboardStorageFileSystem.readDirectory$lambda$9(arg_0 -> ServerScoreboardStorageFileSystem.readDirectory$lambda$8(this, arg_0), arg_0)).toList();
                Intrinsics.checkNotNullExpressionValue($this$toTypedArray$iv, (String)"toList(...)");
                $this$toTypedArray$iv = $this$toTypedArray$iv;
                boolean $i$f$toTypedArray = false;
                Collection<Object> thisCollection$iv = $this$toTypedArray$iv;
                yield thisCollection$iv.toArray(new ReadDirectoryResultEntry[0]);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        CompletableFuture<FileSystemResult<ReadDirectoryResultEntry[]>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult<ReadDirectoryResultEntry[]>(entries));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<FileSystemResult<Unit>> createDirectory(@NotNull UriParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture<FileSystemResult<Unit>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult<Unit>(Unit.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<FileSystemResult<ReadFileResult>> readFile(@NotNull UriParams params) {
        FileSystemResult<byte[]> contentResult;
        FileSystemResult<ResolvedPath> resolvedPathResult;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        FileSystemResult<ResolvedPath> this_$iv = resolvedPathResult = this.resolveUri(params.getUri());
        boolean $i$f$handleErrorAndGetResult = false;
        if (this_$iv.getType() != FileSystemResult.ResultType.SUCCESS) {
            Intrinsics.checkNotNull(this_$iv, (String)"null cannot be cast to non-null type net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemResult<kotlin.Nothing>");
            FileSystemResult<ResolvedPath> it = this_$iv;
            boolean bl = false;
            CompletableFuture<FileSystemResult<ReadFileResult>> completableFuture = CompletableFuture.completedFuture(it);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ResolvedPath resolvedPath = this_$iv.getResult();
        if (resolvedPath.getFileName() == null) {
            CompletableFuture<FileSystemResult<ReadFileResult>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult(new FileNotFoundError("readFile can only be called on files")));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        FileSystemResult<byte[]> this_$iv2 = contentResult = this.getFileContent(resolvedPath.getDirectory(), resolvedPath.getFileName());
        boolean $i$f$handleErrorAndGetResult2 = false;
        if (this_$iv2.getType() != FileSystemResult.ResultType.SUCCESS) {
            Intrinsics.checkNotNull(this_$iv2, (String)"null cannot be cast to non-null type net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemResult<kotlin.Nothing>");
            FileSystemResult<byte[]> it = this_$iv2;
            boolean bl = false;
            CompletableFuture<FileSystemResult<ReadFileResult>> completableFuture = CompletableFuture.completedFuture(it);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        byte[] content = this_$iv2.getResult();
        byte[] byArray = Base64.getEncoder().encode(content);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        String base64Content = StringsKt.decodeToString((byte[])byArray);
        CompletableFuture<FileSystemResult<ReadFileResult>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult<ReadFileResult>(new ReadFileResult(base64Content)));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<FileSystemResult<Unit>> writeFile(@NotNull WriteFileParams params) {
        FileSystemResult<ResolvedPath> resolvedPathResult;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        FileSystemResult<ResolvedPath> this_$iv = resolvedPathResult = this.resolveUri(params.getUri());
        boolean $i$f$handleErrorAndGetResult = false;
        if (this_$iv.getType() != FileSystemResult.ResultType.SUCCESS) {
            Intrinsics.checkNotNull(this_$iv, (String)"null cannot be cast to non-null type net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.api.FileSystemResult<kotlin.Nothing>");
            FileSystemResult<ResolvedPath> it = this_$iv;
            boolean bl = false;
            CompletableFuture<FileSystemResult<Unit>> completableFuture = CompletableFuture.completedFuture(it);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        ResolvedPath resolvedPath = this_$iv.getResult();
        if (resolvedPath.getFileName() == null) {
            CompletableFuture<FileSystemResult<Unit>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult(new FileNotFoundError("writeFile can only be called on files")));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        byte[] content = Base64.getDecoder().decode(params.getContentBase64());
        CompletableFuture<FileSystemResult<Unit>> future = new CompletableFuture<FileSystemResult<Unit>>();
        Companion.queueDataUpdate((Function0<Unit>)((Function0)() -> ServerScoreboardStorageFileSystem.writeFile$lambda$13(resolvedPath, this, content, future)));
        return future;
    }

    private final FileSystemResult<Unit> updateScoreboardData(ResolvedPath resolvedPath, byte[] content) {
        Object json;
        String string = resolvedPath.getFileName();
        Intrinsics.checkNotNull((Object)string);
        if (!StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null)) {
            return new FileSystemResult<Unit>(new FileNotFoundError("Only JSON files in scoreboards directory"));
        }
        class_2995 class_29952 = this.server.method_3845();
        String string2 = resolvedPath.getFileName().substring(0, resolvedPath.getFileName().length() - 5);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        class_266 class_2662 = class_29952.method_1170(string2);
        if (class_2662 == null) {
            return new FileSystemResult<Unit>(new FileNotFoundError("Objective " + resolvedPath.getFileName() + " not found"));
        }
        class_266 objective = class_2662;
        try {
            json = (JsonObject)GSON.fromJson(StringsKt.decodeToString((byte[])content), JsonObject.class);
            json = (ObjectiveFile)((Pair)OBJECTIVE_CODEC.decode((DynamicOps)JsonOps.INSTANCE, json).getOrThrow()).getFirst();
        }
        catch (Exception exception) {
            String string3 = objective.method_1113();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            this.onFileUpdate(Directory.SCOREBOARDS, string3, FileChangeType.Changed);
            return new FileSystemResult<Unit>(Unit.INSTANCE);
        }
        Object objectiveFile = json;
        if (objective.method_1116().method_1226()) {
            String string4 = objective.method_1113();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            this.onFileUpdate(Directory.SCOREBOARDS, string4, FileChangeType.Changed);
            return new FileSystemResult<Unit>(Unit.INSTANCE);
        }
        for (Map.Entry entry : ((ObjectiveFile)objectiveFile).getScores().entrySet()) {
            String owner = (String)entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            this.server.method_3845().method_1180(class_9015.method_55422((String)owner), objective).method_55410(value);
        }
        for (class_9011 class_90112 : this.server.method_3845().method_1184(objective)) {
            if (((ObjectiveFile)objectiveFile).getScores().containsKey(class_90112.comp_2127())) continue;
            this.server.method_3845().method_1155(class_9015.method_55422((String)class_90112.comp_2127()), objective);
        }
        if (!Intrinsics.areEqual((Object)objective.method_1116(), (Object)((ObjectiveFile)objectiveFile).getObjectiveData().getCriterion())) {
            class_2995 class_29953 = this.server.method_3845();
            Intrinsics.checkNotNull((Object)class_29953, (String)"null cannot be cast to non-null type net.papierkorb2292.command_crafter.mixin.editor.scoreboardStorageViewer.ScoreboardAccessor");
            Reference2ObjectMap<class_274, List<class_266>> objectivesByCriterion = ((ScoreboardAccessor)class_29953).getObjectivesByCriterion();
            List list = (List)objectivesByCriterion.get((Object)objective.method_1116());
            if (list != null) {
                list.remove(objective);
            }
            ((List)objectivesByCriterion.computeIfAbsent((Object)((ObjectiveFile)objectiveFile).getObjectiveData().getCriterion(), ServerScoreboardStorageFileSystem::updateScoreboardData$lambda$14)).add(objective);
            ((ScoreboardObjectiveAccessor)objective).setCriterion(((ObjectiveFile)objectiveFile).getObjectiveData().getCriterion());
        }
        if (!Intrinsics.areEqual((Object)objective.method_1114(), (Object)((ObjectiveFile)objectiveFile).getObjectiveData().getDisplayName())) {
            objective.method_1121(((ObjectiveFile)objectiveFile).getObjectiveData().getDisplayName());
        }
        if (objective.method_1118() != ((ObjectiveFile)objectiveFile).getObjectiveData().getRenderType()) {
            objective.method_1115(((ObjectiveFile)objectiveFile).getObjectiveData().getRenderType());
        }
        class_9022 newNumberFormat = ((ObjectiveFile)objectiveFile).getObjectiveData().getNumberFormat().orElse(null);
        if (!Intrinsics.areEqual((Object)objective.method_55384(), (Object)newNumberFormat)) {
            objective.method_55382(newNumberFormat);
        }
        if (objective.method_55383() != ((ObjectiveFile)objectiveFile).getObjectiveData().getDisplayAutoUpdate()) {
            objective.method_55381(((ObjectiveFile)objectiveFile).getObjectiveData().getDisplayAutoUpdate());
        }
        return new FileSystemResult<Unit>(Unit.INSTANCE);
    }

    private final FileSystemResult<Unit> updateStorageData(ResolvedPath resolvedPath, byte[] content) {
        class_2487 class_24872;
        String string = resolvedPath.getFileName();
        Intrinsics.checkNotNull((Object)string);
        boolean isNbt = StringsKt.endsWith$default((String)string, (String)".nbt", (boolean)false, (int)2, null);
        if (!isNbt && !StringsKt.endsWith$default((String)resolvedPath.getFileName(), (String)".snbt", (boolean)false, (int)2, null)) {
            return new FileSystemResult<Unit>(new FileNotFoundError("Only NBT/SNBT files in storages directory"));
        }
        String string2 = resolvedPath.getFileName().substring(0, resolvedPath.getFileName().length() - (isNbt ? 4 : 5));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        class_2960 class_29602 = class_2960.method_12829((String)string2);
        if (class_29602 == null) {
            return new FileSystemResult<Unit>(new FileNotFoundError("Storage " + resolvedPath.getFileName() + " not found"));
        }
        class_2960 id = class_29602;
        try {
            class_24872 = !isNbt ? class_2522.method_67315((String)StringsKt.decodeToString((byte[])content)) : class_2507.method_10627((DataInput)((DataInput)ByteStreams.newDataInput((byte[])content)));
        }
        catch (Exception e) {
            return new FileSystemResult<Unit>(new FileNotFoundError("Invalid NBT content"));
        }
        class_2487 nbtCompound = class_24872;
        this.server.method_22827().method_22547(id, nbtCompound);
        return new FileSystemResult<Unit>(Unit.INSTANCE);
    }

    @Override
    @NotNull
    public CompletableFuture<FileSystemResult<Unit>> delete(@NotNull DeleteParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture<FileSystemResult<Unit>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult<Unit>(Unit.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<FileSystemResult<Unit>> rename(@NotNull RenameParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture<FileSystemResult<Unit>> completableFuture = CompletableFuture.completedFuture(new FileSystemResult<Unit>(Unit.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<LoadableStorageNamespaces> getLoadableStorageNamespaces(@NotNull Unit params) {
        void $this$filterTo$iv$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String storagePrefix = "command_storage_";
        String storageSuffix = ".dat";
        class_4565 class_45652 = this.server.method_22827();
        Intrinsics.checkNotNull((Object)class_45652, (String)"null cannot be cast to non-null type net.papierkorb2292.command_crafter.mixin.editor.scoreboardStorageViewer.DataCommandStorageAccessor");
        Set<String> loadedNamespaces = ((DataCommandStorageAccessor)class_45652).getStorages().keySet();
        File dataDirectory = this.server.method_27050(class_5218.field_24188).resolve("data").toFile();
        File[] fileArray = dataDirectory.listFiles(arg_0 -> ServerScoreboardStorageFileSystem.getLoadableStorageNamespaces$lambda$15(storagePrefix, storageSuffix, arg_0));
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$map = false;
            void var11_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                String string;
                void it;
                void item$iv$iv;
                void var17_24 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"getName(...)");
                int n2 = storagePrefix.length();
                int n3 = it.getName().length() - storageSuffix.length();
                String string2 = string.substring(n2, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                collection.add(string2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List fileNamespaces = list;
        Iterable $this$filter$iv = fileNamespaces;
        boolean $i$f$filter = false;
        Iterable $i$f$map = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!loadedNamespaces.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List loadableNamespaces = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = loadableNamespaces;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture<LoadableStorageNamespaces> completableFuture = CompletableFuture.completedFuture(new LoadableStorageNamespaces(thisCollection$iv.toArray(new String[0])));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    @Override
    public void loadStorageNamespace(@NotNull LoadStorageNamespaceParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.server.method_22827().method_22546(class_2960.method_60655((String)params.getNamespace(), (String)""));
    }

    private final FileSystemResult<ResolvedPath> resolveUri(String uri) {
        Directory directory;
        String path = StringsKt.removePrefix((String)EditorURI.Companion.parseURI$default(EditorURI.Companion, uri, false, 2, null).getPath(), (CharSequence)"/");
        if (((CharSequence)path).length() == 0) {
            return new FileSystemResult<ResolvedPath>(new ResolvedPath(Directory.ROOT, null));
        }
        Object object = new char[]{'/'};
        List parts = StringsKt.split$default((CharSequence)path, (char[])object, (boolean)false, (int)0, (int)6, null);
        if (parts.size() == 1) {
            object = (String)parts.get(0);
            return Intrinsics.areEqual((Object)object, (Object)SCOREBOARDS_DIRECTORY) ? new FileSystemResult<ResolvedPath>(new ResolvedPath(Directory.SCOREBOARDS, null)) : (Intrinsics.areEqual((Object)object, (Object)STORAGES_DIRECTORY) ? new FileSystemResult<ResolvedPath>(new ResolvedPath(Directory.STORAGES, null)) : new FileSystemResult(new FileNotFoundError("No files outside of scoreboard/storage directories")));
        }
        if (parts.size() != 2) {
            return new FileSystemResult<ResolvedPath>(new FileNotFoundError("No files outside of scoreboard/storage directories"));
        }
        String string = (String)parts.get(0);
        if (Intrinsics.areEqual((Object)string, (Object)SCOREBOARDS_DIRECTORY)) {
            directory = Directory.SCOREBOARDS;
        } else if (Intrinsics.areEqual((Object)string, (Object)STORAGES_DIRECTORY)) {
            directory = Directory.STORAGES;
        } else {
            return new FileSystemResult<ResolvedPath>(new FileNotFoundError("No directories besides scoreboards and storages"));
        }
        Directory directory2 = directory;
        String fileName = (String)parts.get(1);
        return new FileSystemResult<ResolvedPath>(new ResolvedPath(directory2, ((CharSequence)fileName).length() == 0 ? null : fileName));
    }

    private final String createUrl(Directory directory, String fileName, String fileExtension) {
        return "scoreboardStorage:///" + directory.toFolderName() + "/" + fileName + fileExtension;
    }

    private final FileSystemResult<byte[]> getFileContent(Directory directory, String fileName) {
        FileSystemResult<byte[]> fileSystemResult;
        kotlin.Pair fileId = new kotlin.Pair((Object)directory, (Object)fileName);
        if (Intrinsics.areEqual((Object)fileId, this.lastFileCacheId)) {
            Intrinsics.checkNotNull((Object)this.lastFileCacheContent);
            return new FileSystemResult<byte[]>(this.lastFileCacheContent);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[directory.ordinal()]) {
            case 2: {
                if (!StringsKt.endsWith$default((String)fileName, (String)".json", (boolean)false, (int)2, null)) {
                    return new FileSystemResult<byte[]>(new FileNotFoundError("Only JSON files in scoreboards directory"));
                }
                class_2995 class_29952 = this.server.method_3845();
                String string = fileName.substring(0, fileName.length() - 5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                class_266 class_2662 = class_29952.method_1170(string);
                if (class_2662 == null) {
                    return new FileSystemResult<byte[]>(new FileNotFoundError("Objective " + fileName + " not found"));
                }
                class_266 objective = class_2662;
                LinkedHashMap scoresMap = new LinkedHashMap();
                Collection collection = this.server.method_3845().method_1184(objective);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getScoreboardEntries(...)");
                Iterable $this$sortedBy$iv = collection;
                boolean $i$f$sortedBy = false;
                for (class_9011 entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        class_9011 it = (class_9011)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.comp_2127());
                        it = (class_9011)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.comp_2127())));
                    }
                })) {
                    ((Map)scoresMap).put(entry.comp_2127(), entry.comp_2128());
                }
                class_274 class_2742 = objective.method_1116();
                Intrinsics.checkNotNullExpressionValue((Object)class_2742, (String)"getCriterion(...)");
                class_2561 class_25612 = objective.method_1114();
                Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"getDisplayName(...)");
                class_274.class_275 class_2752 = objective.method_1118();
                Intrinsics.checkNotNullExpressionValue((Object)class_2752, (String)"getRenderType(...)");
                Optional<class_9022> optional = Optional.ofNullable(objective.method_55384());
                Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
                ObjectiveData objectiveData = new ObjectiveData(class_2742, class_25612, class_2752, optional, objective.method_55383());
                ObjectiveFile objectiveFile = new ObjectiveFile(scoresMap, objectiveData);
                JsonElement json = (JsonElement)OBJECTIVE_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)objectiveFile).getOrThrow();
                StringWriter stringWriter = new StringWriter();
                JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
                jsonWriter.setIndent("  ");
                GSON.toJson(json, jsonWriter);
                String string2 = stringWriter.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                fileSystemResult = new FileSystemResult<byte[]>(StringsKt.encodeToByteArray((String)string2));
                break;
            }
            case 3: {
                boolean isNbt = StringsKt.endsWith$default((String)fileName, (String)".nbt", (boolean)false, (int)2, null);
                if (!isNbt && !StringsKt.endsWith$default((String)fileName, (String)".snbt", (boolean)false, (int)2, null)) {
                    return new FileSystemResult<byte[]>(new FileNotFoundError("Only NBT/SNBT files in storages directory"));
                }
                String string = fileName.substring(0, fileName.length() - (isNbt ? 4 : 5));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                class_2960 class_29602 = class_2960.method_12829((String)string);
                if (class_29602 == null) {
                    return new FileSystemResult<byte[]>(new FileNotFoundError("Storage " + fileName + " not found"));
                }
                class_2960 id = class_29602;
                class_2487 class_24872 = this.server.method_22827().method_22546(id);
                if (class_24872 == null) {
                    return new FileSystemResult<byte[]>(new FileNotFoundError("Storage " + fileName + " not found"));
                }
                class_2487 nbtCompound = class_24872;
                if (!isNbt) {
                    String string3 = nbtCompound.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                    String snbt = string3;
                    fileSystemResult = new FileSystemResult<byte[]>(StringsKt.encodeToByteArray((String)snbt));
                    break;
                }
                ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
                class_2507.method_10628((class_2487)nbtCompound, (DataOutput)((DataOutput)dataOutput));
                fileSystemResult = new FileSystemResult<byte[]>(dataOutput.toByteArray());
                break;
            }
            default: {
                return new FileSystemResult<byte[]>(new FileNotFoundError("No files outside of scoreboard/storage directories"));
            }
        }
        FileSystemResult<byte[]> content = fileSystemResult;
        if (content.getType() == FileSystemResult.ResultType.SUCCESS) {
            this.lastFileCacheId = fileId;
            byte[] byArray = content.getResult();
            Intrinsics.checkNotNull((Object)byArray);
            this.lastFileCacheContent = byArray;
        }
        return content;
    }

    public final void onFileUpdate(@NotNull Directory directory, @NotNull String objectName, @NotNull FileChangeType updateType) {
        Intrinsics.checkNotNullParameter((Object)((Object)directory), (String)"directory");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)((Object)updateType), (String)"updateType");
        ((Collection)this.queuedFileUpdates).add(new FileUpdate(directory, objectName, updateType));
    }

    /*
     * WARNING - void declaration
     */
    public final void flushQueuedFileUpdates() {
        void $this$flatMapTo$iv$iv;
        Function1<? super FileEvent[], Unit> onDidChangeFileCallback;
        if (this.queuedFileUpdates.isEmpty()) {
            return;
        }
        kotlin.Pair<? extends Directory, String> lastFileCacheId = this.lastFileCacheId;
        for (FileUpdate update : this.queuedFileUpdates) {
            kotlin.Pair<? extends Directory, String> pair = lastFileCacheId;
            if ((pair != null ? (Directory)((Object)pair.getFirst()) : null) == Directory.SCOREBOARDS && update.getDirectory() == Directory.SCOREBOARDS && Intrinsics.areEqual((Object)lastFileCacheId.getSecond(), (Object)(update.getObjectName() + ".json"))) {
                this.lastFileCacheId = null;
                break;
            }
            kotlin.Pair<? extends Directory, String> pair2 = lastFileCacheId;
            if ((pair2 != null ? (Directory)((Object)pair2.getFirst()) : null) != Directory.STORAGES || update.getDirectory() != Directory.STORAGES || !Intrinsics.areEqual((Object)lastFileCacheId.getSecond(), (Object)(update.getObjectName() + ".nbt")) && !Intrinsics.areEqual((Object)lastFileCacheId.getSecond(), (Object)(update.getObjectName() + ".snbt"))) continue;
            this.lastFileCacheId = null;
            break;
        }
        if ((onDidChangeFileCallback = this.onDidChangeFileCallback) == null) {
            this.queuedFileUpdates.clear();
            return;
        }
        Iterable $this$flatMap$iv = this.queuedFileUpdates;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            String[] fileUris;
            String[] stringArray;
            FileUpdate it = (FileUpdate)element$iv$iv;
            boolean bl = false;
            if (it.getDirectory() == Directory.SCOREBOARDS) {
                var13_13 = new String[]{this.createUrl(Directory.SCOREBOARDS, it.getObjectName(), ".json")};
                stringArray = var13_13;
            } else {
                var13_13 = new String[]{this.createUrl(Directory.STORAGES, it.getObjectName(), ".nbt"), this.createUrl(Directory.STORAGES, it.getObjectName(), ".snbt")};
                stringArray = var13_13;
            }
            String[] $this$mapNotNull$iv = fileUris = stringArray;
            boolean $i$f$mapNotNull = false;
            String[] stringArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                FileEvent it$iv$iv;
                boolean bl2;
                void uri;
                block11: {
                    void element$iv$iv$iv;
                    void element$iv$iv2 = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                    boolean bl3 = false;
                    uri = element$iv$iv2;
                    boolean bl4 = false;
                    Collection collection = this.watches.values();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
                    Iterable $this$any$iv = collection;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Watch watch = (Watch)element$iv;
                            boolean bl5 = false;
                            if (!watch.matches((String)uri)) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                }
                if ((bl2 ? new FileEvent((String)uri, it.getUpdateType()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List fileEvents = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = fileEvents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        onDidChangeFileCallback.invoke((Object)thisCollection$iv.toArray(new FileEvent[0]));
        this.queuedFileUpdates.clear();
    }

    private static final int readDirectory$lambda$6(class_2960 id1, class_2960 id2) {
        String string = id1.method_12836();
        String string2 = id2.method_12836();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNamespace(...)");
        int namespaceCmp = string.compareTo(string2);
        if (namespaceCmp != 0) {
            return namespaceCmp;
        }
        String string3 = id1.method_12832();
        String string4 = id2.method_12832();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
        return string3.compareTo(string4);
    }

    private static final int readDirectory$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final Stream readDirectory$lambda$8(ServerScoreboardStorageFileSystem this$0, class_2960 it) {
        ReadDirectoryResultEntry[] readDirectoryResultEntryArray = new ReadDirectoryResultEntry[2];
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        readDirectoryResultEntryArray[0] = new ReadDirectoryResultEntry(this$0.createUrl(Directory.STORAGES, string, ".nbt"), FileType.Companion.getFILE-kha_Om8(), null);
        String string2 = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        readDirectoryResultEntryArray[1] = new ReadDirectoryResultEntry(this$0.createUrl(Directory.STORAGES, string2, ".snbt"), FileType.Companion.getFILE-kha_Om8(), null);
        return Stream.of(readDirectoryResultEntryArray);
    }

    private static final Stream readDirectory$lambda$9(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Unit writeFile$lambda$13(ResolvedPath $resolvedPath, ServerScoreboardStorageFileSystem this$0, byte[] $content, CompletableFuture $future) {
        FileSystemResult<Unit> result;
        switch (WhenMappings.$EnumSwitchMapping$0[$resolvedPath.getDirectory().ordinal()]) {
            case 2: {
                Intrinsics.checkNotNull((Object)$content);
                FileSystemResult<Unit> fileSystemResult = this$0.updateScoreboardData($resolvedPath, $content);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)$content);
                FileSystemResult<Unit> fileSystemResult = this$0.updateStorageData($resolvedPath, $content);
                break;
            }
            default: {
                FileSystemResult<Unit> fileSystemResult = result = new FileSystemResult<Unit>(new FileNotFoundError("No files outside of scoreboard/storage directories"));
            }
        }
        if (result.getType() == FileSystemResult.ResultType.SUCCESS && Intrinsics.areEqual(this$0.lastFileCacheId, (Object)new kotlin.Pair((Object)$resolvedPath.getDirectory(), (Object)$resolvedPath.getFileName()))) {
            this$0.lastFileCacheId = null;
        }
        $future.complete(result);
        return Unit.INSTANCE;
    }

    private static final ArrayList updateScoreboardData$lambda$14(class_274 it) {
        return Lists.newArrayList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getLoadableStorageNamespaces$lambda$15(String $storagePrefix, String $storageSuffix, File file) {
        if (!file.isFile()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)$storagePrefix, (boolean)false, (int)2, null)) return false;
        String string2 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)$storageSuffix, (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final class_274 OBJECTIVE_DATA_CODEC$lambda$27$lambda$22(KProperty1 $tmp0, ObjectiveData p0) {
        return (class_274)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final class_2561 OBJECTIVE_DATA_CODEC$lambda$27$lambda$23(KProperty1 $tmp0, ObjectiveData p0) {
        return (class_2561)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final class_274.class_275 OBJECTIVE_DATA_CODEC$lambda$27$lambda$24(KProperty1 $tmp0, ObjectiveData p0) {
        return (class_274.class_275)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional OBJECTIVE_DATA_CODEC$lambda$27$lambda$25(KProperty1 $tmp0, ObjectiveData p0) {
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean OBJECTIVE_DATA_CODEC$lambda$27$lambda$26(KProperty1 $tmp0, ObjectiveData p0) {
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App OBJECTIVE_DATA_CODEC$lambda$27(RecordCodecBuilder.Instance it) {
        return it.group((App)CRITERION_CODEC.fieldOf("criterion").forGetter(arg_0 -> ServerScoreboardStorageFileSystem.OBJECTIVE_DATA_CODEC$lambda$27$lambda$22((KProperty1)Companion.OBJECTIVE_DATA_CODEC.1.1.INSTANCE, arg_0)), (App)class_8824.field_46597.fieldOf("displayName").forGetter(arg_0 -> ServerScoreboardStorageFileSystem.OBJECTIVE_DATA_CODEC$lambda$27$lambda$23((KProperty1)Companion.OBJECTIVE_DATA_CODEC.1.2.INSTANCE, arg_0)), (App)class_274.class_275.field_41683.fieldOf("renderType").forGetter(arg_0 -> ServerScoreboardStorageFileSystem.OBJECTIVE_DATA_CODEC$lambda$27$lambda$24((KProperty1)Companion.OBJECTIVE_DATA_CODEC.1.3.INSTANCE, arg_0)), (App)NUMBER_FORMAT_CODEC.fieldOf("numberFormat").forGetter(arg_0 -> ServerScoreboardStorageFileSystem.OBJECTIVE_DATA_CODEC$lambda$27$lambda$25((KProperty1)Companion.OBJECTIVE_DATA_CODEC.1.4.INSTANCE, arg_0)), (App)Codec.BOOL.fieldOf("displayAutoUpdate").forGetter(arg_0 -> ServerScoreboardStorageFileSystem.OBJECTIVE_DATA_CODEC$lambda$27$lambda$26((KProperty1)Companion.OBJECTIVE_DATA_CODEC.1.5.INSTANCE, arg_0))).apply((Applicative)it, ObjectiveData::new);
    }

    private static final Map OBJECTIVE_CODEC$lambda$30$lambda$28(KProperty1 $tmp0, ObjectiveFile p0) {
        return (Map)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final ObjectiveData OBJECTIVE_CODEC$lambda$30$lambda$29(KProperty1 $tmp0, ObjectiveFile p0) {
        return (ObjectiveData)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App OBJECTIVE_CODEC$lambda$30(RecordCodecBuilder.Instance it) {
        return it.group((App)ENTRIES_CODEC.fieldOf("entries").forGetter(arg_0 -> ServerScoreboardStorageFileSystem.OBJECTIVE_CODEC$lambda$30$lambda$28((KProperty1)Companion.OBJECTIVE_CODEC.1.1.INSTANCE, arg_0)), (App)OBJECTIVE_DATA_CODEC.fieldOf("objective").forGetter(arg_0 -> ServerScoreboardStorageFileSystem.OBJECTIVE_CODEC$lambda$30$lambda$29((KProperty1)Companion.OBJECTIVE_CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)it, ObjectiveFile::new);
    }

    static {
        createdFileSystems = new LinkedHashMap();
        CRITERION_CODEC = new Codec<class_274>(){

            public <T> DataResult<T> encode(class_274 input, DynamicOps<T> ops, T prefix) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter(ops, (String)"ops");
                return DataResult.success((Object)ops.createString(input.method_1225()));
            }

            public <T> DataResult<Pair<class_274, T>> decode(DynamicOps<T> ops, T input) {
                Intrinsics.checkNotNullParameter(ops, (String)"ops");
                Intrinsics.checkNotNullParameter(input, (String)"input");
                StringRangeTree.AnalyzingDynamicOps<?> analyzingOps = UtilKt.getOrNull(StringRangeTree.AnalyzingDynamicOps.Companion.getCURRENT_ANALYZING_OPS());
                if (analyzingOps != null) {
                    analyzingOps.getNodeStartSuggestions(input).add(() -> Companion.CRITERION_CODEC.1.decode$lambda$4(this, ops));
                }
                DataResult dataResult = ops.getStringValue(input).flatMap(arg_0 -> Companion.CRITERION_CODEC.1.decode$lambda$9(arg_0 -> Companion.CRITERION_CODEC.1.decode$lambda$8(ops, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"flatMap(...)");
                return dataResult;
            }

            private final <T> Stream<String> getStatNames(class_3448<T> statType) {
                Stream<String> stream = statType.method_14959().method_10220().map(arg_0 -> Companion.CRITERION_CODEC.1.getStatNames$lambda$11(arg_0 -> Companion.CRITERION_CODEC.1.getStatNames$lambda$10(statType, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
                return stream;
            }

            private static final Stream decode$lambda$4$lambda$0(Companion.CRITERION_CODEC.1 this$0, class_3448 it) {
                Intrinsics.checkNotNull((Object)it);
                return this$0.getStatNames(it);
            }

            private static final Stream decode$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
                return (Stream)$tmp0.invoke(p0);
            }

            private static final StringRangeTree.Suggestion decode$lambda$4$lambda$2(DynamicOps $ops, String it) {
                return new StringRangeTree.Suggestion<TNode>($ops.createString(it), false, 2, null);
            }

            private static final StringRangeTree.Suggestion decode$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
                return (StringRangeTree.Suggestion)$tmp0.invoke(p0);
            }

            private static final Stream decode$lambda$4(Companion.CRITERION_CODEC.1 this$0, DynamicOps $ops) {
                Stream<StringRangeTree.Suggestion> stream = Stream.concat(class_274.method_37271().stream(), class_7923.field_41193.method_10220().flatMap(arg_0 -> Companion.CRITERION_CODEC.1.decode$lambda$4$lambda$1(arg_0 -> Companion.CRITERION_CODEC.1.decode$lambda$4$lambda$0(this$0, arg_0), arg_0))).map(arg_0 -> Companion.CRITERION_CODEC.1.decode$lambda$4$lambda$3(arg_0 -> Companion.CRITERION_CODEC.1.decode$lambda$4$lambda$2($ops, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
                return stream;
            }

            private static final DataResult decode$lambda$8$lambda$5(DynamicOps $ops, class_274 it) {
                return DataResult.success((Object)new Pair((Object)it, $ops.empty()));
            }

            private static final DataResult decode$lambda$8$lambda$6(Function1 $tmp0, Object p0) {
                return (DataResult)$tmp0.invoke(p0);
            }

            private static final String decode$lambda$8$lambda$7(String $criterionName) {
                return "Unknown criterion '" + $criterionName + "'";
            }

            private static final DataResult decode$lambda$8(DynamicOps $ops, String criterionName) {
                return class_274.method_1224((String)criterionName).map(arg_0 -> Companion.CRITERION_CODEC.1.decode$lambda$8$lambda$6(arg_0 -> Companion.CRITERION_CODEC.1.decode$lambda$8$lambda$5($ops, arg_0), arg_0)).orElse(DataResult.error(() -> Companion.CRITERION_CODEC.1.decode$lambda$8$lambda$7(criterionName)));
            }

            private static final DataResult decode$lambda$9(Function1 $tmp0, Object p0) {
                return (DataResult)$tmp0.invoke(p0);
            }

            private static final String getStatNames$lambda$10(class_3448 $statType, Object it) {
                return class_3445.method_14950((class_3448)$statType, (Object)it);
            }

            private static final String getStatNames$lambda$11(Function1 $tmp0, Object p0) {
                return (String)$tmp0.invoke(p0);
            }
        };
        NUMBER_FORMAT_CODEC = new Codec<Optional<class_9022>>(){
            private final String DEFAULT_TYPE;
            {
                this.DEFAULT_TYPE = "default";
            }

            public <T> DataResult<T> encode(Optional<class_9022> input, DynamicOps<T> ops, T prefix) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                Intrinsics.checkNotNullParameter(ops, (String)"ops");
                if (input.isEmpty()) {
                    DataResult dataResult = ops.mergeToMap(prefix, ops.createString("type"), ops.createString(this.DEFAULT_TYPE));
                    Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"mergeToMap(...)");
                    return dataResult;
                }
                DataResult dataResult = class_9024.field_47564.encode((Object)input.get(), ops, prefix).flatMap(arg_0 -> Companion.NUMBER_FORMAT_CODEC.1.encode$lambda$1(arg_0 -> Companion.NUMBER_FORMAT_CODEC.1.encode$lambda$0(ops, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"flatMap(...)");
                return dataResult;
            }

            public <T> DataResult<Pair<Optional<class_9022>, T>> decode(DynamicOps<T> ops, T input) {
                Intrinsics.checkNotNullParameter(ops, (String)"ops");
                Intrinsics.checkNotNullParameter(input, (String)"input");
                DataResult numberFormat = class_9024.field_47564.decode(ops, input).map(arg_0 -> Companion.NUMBER_FORMAT_CODEC.1.decode$lambda$5(Companion.NUMBER_FORMAT_CODEC.1::decode$lambda$4, arg_0));
                Optional optional = ops.getMap(input).result();
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"result(...)");
                Object object = (MapLike)OptionalsKt.getOrNull((Optional)optional);
                if (object == null || (object = object.get("type")) == null) {
                    Intrinsics.checkNotNull((Object)numberFormat);
                    return numberFormat;
                }
                Object type = object;
                StringRangeTree.AnalyzingDynamicOps<?> analyzingOps = UtilKt.getOrNull(StringRangeTree.AnalyzingDynamicOps.Companion.getCURRENT_ANALYZING_OPS());
                if (analyzingOps != null) {
                    analyzingOps.getNodeStartSuggestions(type).add(() -> Companion.NUMBER_FORMAT_CODEC.1.decode$lambda$6(ops, this));
                }
                Optional optional2 = ops.getStringValue(type).result();
                Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"result(...)");
                String parsedType = (String)OptionalsKt.getOrNull((Optional)optional2);
                if (Intrinsics.areEqual((Object)parsedType, (Object)this.DEFAULT_TYPE)) {
                    DataResult dataResult = DataResult.success((Object)new Pair(Optional.empty(), input));
                    Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"success(...)");
                    return dataResult;
                }
                Intrinsics.checkNotNull((Object)numberFormat);
                return numberFormat;
            }

            private static final DataResult encode$lambda$0(DynamicOps $ops, Object encoded) {
                T t = $ops.getMap(encoded).result().get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                MapLike encodedMap = (MapLike)t;
                RecordBuilder mapBuilder = $ops.mapBuilder();
                mapBuilder.add("type", encodedMap.get("type"));
                Iterator<T> iterator = encodedMap.entries().iterator();
                while (iterator.hasNext()) {
                    Pair entry = (Pair)iterator.next();
                    if (Intrinsics.areEqual($ops.getStringValue(entry.getFirst()).result().get(), (Object)"type")) continue;
                    mapBuilder.add(entry.getFirst(), entry.getSecond());
                }
                return mapBuilder.build($ops.empty());
            }

            private static final DataResult encode$lambda$1(Function1 $tmp0, Object p0) {
                return (DataResult)$tmp0.invoke(p0);
            }

            private static final Optional decode$lambda$4$lambda$2(class_9022 it) {
                return Optional.of(it);
            }

            private static final Optional decode$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
                return (Optional)$tmp0.invoke(p0);
            }

            private static final Pair decode$lambda$4(Pair pair) {
                return pair.mapFirst(arg_0 -> Companion.NUMBER_FORMAT_CODEC.1.decode$lambda$4$lambda$3(Companion.NUMBER_FORMAT_CODEC.1::decode$lambda$4$lambda$2, arg_0));
            }

            private static final Pair decode$lambda$5(Function1 $tmp0, Object p0) {
                return (Pair)$tmp0.invoke(p0);
            }

            private static final Stream decode$lambda$6(DynamicOps $ops, Companion.NUMBER_FORMAT_CODEC.1 this$0) {
                Stream<StringRangeTree.Suggestion<TNode>> stream = Stream.of(new StringRangeTree.Suggestion<TNode>($ops.createString(this$0.DEFAULT_TYPE), false, 2, null));
                Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
                return stream;
            }
        };
        Codec codec2 = RecordCodecBuilder.create(ServerScoreboardStorageFileSystem::OBJECTIVE_DATA_CODEC$lambda$27);
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"create(...)");
        OBJECTIVE_DATA_CODEC = codec2;
        class_5699.class_8783 class_87832 = class_5699.method_53703((Codec)((Codec)Codec.STRING), (Codec)((Codec)Codec.INT));
        Intrinsics.checkNotNullExpressionValue((Object)class_87832, (String)"strictUnboundedMap(...)");
        ENTRIES_CODEC = (Codec)class_87832;
        Codec codec3 = RecordCodecBuilder.create(ServerScoreboardStorageFileSystem::OBJECTIVE_CODEC$lambda$30);
        Intrinsics.checkNotNullExpressionValue((Object)codec3, (String)"create(...)");
        OBJECTIVE_CODEC = codec3;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0002'*\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J%\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0010\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0003R\u0014\u0010\u0013\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R \u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR/\u0010#\u001a\u001a\u0012\u0004\u0012\u00020 \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\u001f0\u001f8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R&\u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u000202010-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00100R\u001d\u00105\u001a\b\u0012\u0004\u0012\u0002040-8\u0006\u00a2\u0006\f\n\u0004\b5\u00100\u001a\u0004\b6\u00107\u00a8\u00068"}, d2={"Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Companion;", "", "<init>", "()V", "", "runUpdates", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;", "directory", "", "objectName", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileChangeType;", "updateType", "onFileUpdate", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;Ljava/lang/String;Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileChangeType;)V", "Lkotlin/Function0;", "update", "queueDataUpdate", "(Lkotlin/jvm/functions/Function0;)V", "registerTickUpdateRunner", "SCOREBOARDS_DIRECTORY", "Ljava/lang/String;", "STORAGES_DIRECTORY", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "", "DATA_UPDATE_QUEUE", "Ljava/util/List;", "", "lastFileUpdateTimeMs", "J", "", "Lnet/minecraft/class_3244;", "Ljava/util/UUID;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem;", "createdFileSystems", "Ljava/util/Map;", "getCreatedFileSystems", "()Ljava/util/Map;", "net/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem.Companion.CRITERION_CODEC.1", "CRITERION_CODEC", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Companion$CRITERION_CODEC$1;", "net/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem.Companion.NUMBER_FORMAT_CODEC.1", "NUMBER_FORMAT_CODEC", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Companion$NUMBER_FORMAT_CODEC$1;", "Lcom/mojang/serialization/Codec;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ObjectiveData;", "OBJECTIVE_DATA_CODEC", "Lcom/mojang/serialization/Codec;", "", "", "ENTRIES_CODEC", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ObjectiveFile;", "OBJECTIVE_CODEC", "getOBJECTIVE_CODEC", "()Lcom/mojang/serialization/Codec;", "command-crafter"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<class_3244, Map<UUID, ServerScoreboardStorageFileSystem>> getCreatedFileSystems() {
            return createdFileSystems;
        }

        @NotNull
        public final Codec<ObjectiveFile> getOBJECTIVE_CODEC() {
            return OBJECTIVE_CODEC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void runUpdates() {
            List list = DATA_UPDATE_QUEUE;
            synchronized (list) {
                boolean bl = false;
                for (Function0 update : DATA_UPDATE_QUEUE) {
                    update.invoke();
                }
                DATA_UPDATE_QUEUE.clear();
                Unit unit = Unit.INSTANCE;
            }
            long timeMs = class_156.method_659();
            if (timeMs - lastFileUpdateTimeMs < 2000L) {
                return;
            }
            lastFileUpdateTimeMs = timeMs;
            for (Map map2 : this.getCreatedFileSystems().values()) {
                for (ServerScoreboardStorageFileSystem fileSystem : map2.values()) {
                    fileSystem.flushQueuedFileUpdates();
                }
            }
        }

        public final void onFileUpdate(@NotNull Directory directory, @NotNull String objectName, @NotNull FileChangeType updateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)directory), (String)"directory");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            Intrinsics.checkNotNullParameter((Object)((Object)updateType), (String)"updateType");
            for (Map<UUID, ServerScoreboardStorageFileSystem> playerFileSystems : this.getCreatedFileSystems().values()) {
                for (ServerScoreboardStorageFileSystem fileSystem : playerFileSystems.values()) {
                    fileSystem.onFileUpdate(directory, objectName, updateType);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void queueDataUpdate(@NotNull Function0<Unit> update) {
            Intrinsics.checkNotNullParameter(update, (String)"update");
            List list = DATA_UPDATE_QUEUE;
            synchronized (list) {
                boolean bl = false;
                ((Collection)DATA_UPDATE_QUEUE).add(update);
                Unit unit = Unit.INSTANCE;
            }
        }

        public final void registerTickUpdateRunner() {
            ServerTickEvents.END_SERVER_TICK.register(Companion::registerTickUpdateRunner$lambda$2);
        }

        private static final void registerTickUpdateRunner$lambda$2(MinecraftServer it) {
            Companion.runUpdates();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;", "", "<init>", "(Ljava/lang/String;I)V", "", "toFolderName", "()Ljava/lang/String;", "ROOT", "SCOREBOARDS", "STORAGES", "command-crafter"})
    public static final class Directory
    extends Enum<Directory> {
        public static final /* enum */ Directory ROOT = new Directory();
        public static final /* enum */ Directory SCOREBOARDS = new Directory();
        public static final /* enum */ Directory STORAGES = new Directory();
        private static final /* synthetic */ Directory[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final String toFolderName() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> "";
                case 2 -> ServerScoreboardStorageFileSystem.SCOREBOARDS_DIRECTORY;
                case 3 -> ServerScoreboardStorageFileSystem.STORAGES_DIRECTORY;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public static Directory[] values() {
            return (Directory[])$VALUES.clone();
        }

        public static Directory valueOf(String value) {
            return Enum.valueOf(Directory.class, value);
        }

        @NotNull
        public static EnumEntries<Directory> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directoryArray = new Directory[]{Directory.ROOT, Directory.SCOREBOARDS, Directory.STORAGES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Directory.values().length];
                try {
                    nArray[Directory.ROOT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Directory.SCOREBOARDS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Directory.STORAGES.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010\u000f\u00a8\u0006 "}, d2={"Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$FileUpdate;", "", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;", "directory", "", "objectName", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileChangeType;", "updateType", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;Ljava/lang/String;Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileChangeType;)V", "component1", "()Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;", "component2", "()Ljava/lang/String;", "component3", "()Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileChangeType;", "copy", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;Ljava/lang/String;Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileChangeType;)Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$FileUpdate;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;", "getDirectory", "Ljava/lang/String;", "getObjectName", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/api/FileChangeType;", "getUpdateType", "command-crafter"})
    public static final class FileUpdate {
        @NotNull
        private final Directory directory;
        @NotNull
        private final String objectName;
        @NotNull
        private final FileChangeType updateType;

        public FileUpdate(@NotNull Directory directory, @NotNull String objectName, @NotNull FileChangeType updateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)directory), (String)"directory");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            Intrinsics.checkNotNullParameter((Object)((Object)updateType), (String)"updateType");
            this.directory = directory;
            this.objectName = objectName;
            this.updateType = updateType;
        }

        @NotNull
        public final Directory getDirectory() {
            return this.directory;
        }

        @NotNull
        public final String getObjectName() {
            return this.objectName;
        }

        @NotNull
        public final FileChangeType getUpdateType() {
            return this.updateType;
        }

        @NotNull
        public final Directory component1() {
            return this.directory;
        }

        @NotNull
        public final String component2() {
            return this.objectName;
        }

        @NotNull
        public final FileChangeType component3() {
            return this.updateType;
        }

        @NotNull
        public final FileUpdate copy(@NotNull Directory directory, @NotNull String objectName, @NotNull FileChangeType updateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)directory), (String)"directory");
            Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
            Intrinsics.checkNotNullParameter((Object)((Object)updateType), (String)"updateType");
            return new FileUpdate(directory, objectName, updateType);
        }

        public static /* synthetic */ FileUpdate copy$default(FileUpdate fileUpdate, Directory directory, String string, FileChangeType fileChangeType, int n, Object object) {
            if ((n & 1) != 0) {
                directory = fileUpdate.directory;
            }
            if ((n & 2) != 0) {
                string = fileUpdate.objectName;
            }
            if ((n & 4) != 0) {
                fileChangeType = fileUpdate.updateType;
            }
            return fileUpdate.copy(directory, string, fileChangeType);
        }

        @NotNull
        public String toString() {
            return "FileUpdate(directory=" + this.directory + ", objectName=" + this.objectName + ", updateType=" + this.updateType + ")";
        }

        public int hashCode() {
            int result = this.directory.hashCode();
            result = result * 31 + this.objectName.hashCode();
            result = result * 31 + this.updateType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileUpdate)) {
                return false;
            }
            FileUpdate fileUpdate = (FileUpdate)other;
            if (this.directory != fileUpdate.directory) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.objectName, (Object)fileUpdate.objectName)) {
                return false;
            }
            return this.updateType == fileUpdate.updateType;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ObjectiveData;", "", "Lnet/minecraft/class_274;", "criterion", "Lnet/minecraft/class_2561;", "displayName", "Lnet/minecraft/class_274$class_275;", "renderType", "Ljava/util/Optional;", "Lnet/minecraft/class_9022;", "numberFormat", "", "displayAutoUpdate", "<init>", "(Lnet/minecraft/class_274;Lnet/minecraft/class_2561;Lnet/minecraft/class_274$class_275;Ljava/util/Optional;Z)V", "Lnet/minecraft/class_274;", "getCriterion", "()Lnet/minecraft/class_274;", "Lnet/minecraft/class_2561;", "getDisplayName", "()Lnet/minecraft/class_2561;", "Lnet/minecraft/class_274$class_275;", "getRenderType", "()Lnet/minecraft/class_274$class_275;", "Ljava/util/Optional;", "getNumberFormat", "()Ljava/util/Optional;", "Z", "getDisplayAutoUpdate", "()Z", "command-crafter"})
    public static final class ObjectiveData {
        @NotNull
        private final class_274 criterion;
        @NotNull
        private final class_2561 displayName;
        @NotNull
        private final class_274.class_275 renderType;
        @NotNull
        private final Optional<class_9022> numberFormat;
        private final boolean displayAutoUpdate;

        public ObjectiveData(@NotNull class_274 criterion, @NotNull class_2561 displayName, @NotNull class_274.class_275 renderType, @NotNull Optional<class_9022> numberFormat, boolean displayAutoUpdate) {
            Intrinsics.checkNotNullParameter((Object)criterion, (String)"criterion");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)renderType, (String)"renderType");
            Intrinsics.checkNotNullParameter(numberFormat, (String)"numberFormat");
            this.criterion = criterion;
            this.displayName = displayName;
            this.renderType = renderType;
            this.numberFormat = numberFormat;
            this.displayAutoUpdate = displayAutoUpdate;
        }

        @NotNull
        public final class_274 getCriterion() {
            return this.criterion;
        }

        @NotNull
        public final class_2561 getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final class_274.class_275 getRenderType() {
            return this.renderType;
        }

        @NotNull
        public final Optional<class_9022> getNumberFormat() {
            return this.numberFormat;
        }

        public final boolean getDisplayAutoUpdate() {
            return this.displayAutoUpdate;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ObjectiveFile;", "", "", "", "", "scores", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ObjectiveData;", "objectiveData", "<init>", "(Ljava/util/Map;Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ObjectiveData;)V", "Ljava/util/Map;", "getScores", "()Ljava/util/Map;", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ObjectiveData;", "getObjectiveData", "()Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ObjectiveData;", "command-crafter"})
    public static final class ObjectiveFile {
        @NotNull
        private final Map<String, Integer> scores;
        @NotNull
        private final ObjectiveData objectiveData;

        public ObjectiveFile(@NotNull Map<String, Integer> scores, @NotNull ObjectiveData objectiveData) {
            Intrinsics.checkNotNullParameter(scores, (String)"scores");
            Intrinsics.checkNotNullParameter((Object)objectiveData, (String)"objectiveData");
            this.scores = scores;
            this.objectiveData = objectiveData;
        }

        @NotNull
        public final Map<String, Integer> getScores() {
            return this.scores;
        }

        @NotNull
        public final ObjectiveData getObjectiveData() {
            return this.objectiveData;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$ResolvedPath;", "", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;", "directory", "", "fileName", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;Ljava/lang/String;)V", "Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;", "getDirectory", "()Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Directory;", "Ljava/lang/String;", "getFileName", "()Ljava/lang/String;", "command-crafter"})
    public static final class ResolvedPath {
        @NotNull
        private final Directory directory;
        @Nullable
        private final String fileName;

        public ResolvedPath(@NotNull Directory directory, @Nullable String fileName) {
            Intrinsics.checkNotNullParameter((Object)((Object)directory), (String)"directory");
            this.directory = directory;
            this.fileName = fileName;
        }

        @NotNull
        public final Directory getDirectory() {
            return this.directory;
        }

        @Nullable
        public final String getFileName() {
            return this.fileName;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Watch;", "", "Ljava/util/regex/Pattern;", "uriPattern", "", "excludeUriPatterns", "<init>", "(Ljava/util/regex/Pattern;Ljava/util/List;)V", "", "uri", "", "matches", "(Ljava/lang/String;)Z", "Ljava/util/regex/Pattern;", "Ljava/util/List;", "command-crafter"})
    @SourceDebugExtension(value={"SMAP\nServerScoreboardStorageFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerScoreboardStorageFileSystem.kt\nnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Watch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,553:1\n1740#2,3:554\n*S KotlinDebug\n*F\n+ 1 ServerScoreboardStorageFileSystem.kt\nnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ServerScoreboardStorageFileSystem$Watch\n*L\n539#1:554,3\n*E\n"})
    public static final class Watch {
        @NotNull
        private final Pattern uriPattern;
        @NotNull
        private final List<Pattern> excludeUriPatterns;

        public Watch(@NotNull Pattern uriPattern, @NotNull List<Pattern> excludeUriPatterns) {
            Intrinsics.checkNotNullParameter((Object)uriPattern, (String)"uriPattern");
            Intrinsics.checkNotNullParameter(excludeUriPatterns, (String)"excludeUriPatterns");
            this.uriPattern = uriPattern;
            this.excludeUriPatterns = excludeUriPatterns;
        }

        public final boolean matches(@NotNull String uri) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                if (!this.uriPattern.matcher(uri).find()) {
                    return false;
                }
                Iterable $this$all$iv = this.excludeUriPatterns;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Pattern it = (Pattern)element$iv;
                        boolean bl2 = false;
                        if (!it.matcher(uri).find()) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Directory.values().length];
            try {
                nArray[Directory.ROOT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Directory.SCOREBOARDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Directory.STORAGES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

