/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u0001!B\u0011\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u000b\u001a\u00020\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\n2\u0006\u0010\r\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u000fJ\u000f\u0010\u0019\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR \u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lnet/papierkorb2292/command_crafter/helper/SizeLimitedCallbackLinkedBlockingQueue;", "", "T", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "sizeLimit", "<init>", "(I)V", "Lnet/papierkorb2292/command_crafter/helper/SizeLimitedCallbackLinkedBlockingQueue$Callback;", "callback", "", "addCallback", "(Lnet/papierkorb2292/command_crafter/helper/SizeLimitedCallbackLinkedBlockingQueue$Callback;)V", "e", "put", "(Ljava/lang/Object;)V", "", "offer", "(Ljava/lang/Object;)Z", "", "timeout", "Ljava/util/concurrent/TimeUnit;", "unit", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z", "alertCallbacks", "reduceToSizeLimit", "()V", "I", "getSizeLimit", "()I", "", "callbacks", "Ljava/util/List;", "Callback", "command-crafter"})
public final class SizeLimitedCallbackLinkedBlockingQueue<T>
extends LinkedBlockingQueue<T> {
    private final int sizeLimit;
    @NotNull
    private final List<Callback<T>> callbacks;

    public SizeLimitedCallbackLinkedBlockingQueue(int sizeLimit) {
        this.sizeLimit = sizeLimit;
        this.callbacks = new ArrayList();
    }

    public /* synthetic */ SizeLimitedCallbackLinkedBlockingQueue(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 256;
        }
        this(n);
    }

    public final int getSizeLimit() {
        return this.sizeLimit;
    }

    public final void addCallback(@NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Iterator iterator = this.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNull(e);
            callback.onElementAdded(e);
        }
        this.callbacks.add(callback);
    }

    @Override
    public void put(@NotNull T e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        super.put(e);
        this.alertCallbacks(e);
        this.reduceToSizeLimit();
    }

    @Override
    public boolean offer(@NotNull T e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        boolean successful = super.offer(e);
        if (successful) {
            this.alertCallbacks(e);
            this.reduceToSizeLimit();
        }
        return successful;
    }

    @Override
    public boolean offer(@NotNull T e, long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        boolean successful = super.offer(e, timeout, unit);
        if (successful) {
            this.alertCallbacks(e);
            this.reduceToSizeLimit();
        }
        return successful;
    }

    private final void alertCallbacks(T e) {
        Iterator<Callback<T>> iterator = this.callbacks.iterator();
        while (iterator.hasNext()) {
            Callback<T> callback = iterator.next();
            if (callback.shouldRemoveCallback()) {
                iterator.remove();
                continue;
            }
            callback.onElementAdded(e);
        }
    }

    private final void reduceToSizeLimit() {
        while (this.size() > this.sizeLimit) {
            this.poll();
        }
    }

    public SizeLimitedCallbackLinkedBlockingQueue() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00028\u0001H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/papierkorb2292/command_crafter/helper/SizeLimitedCallbackLinkedBlockingQueue$Callback;", "T", "", "e", "", "onElementAdded", "(Ljava/lang/Object;)V", "", "shouldRemoveCallback", "()Z", "command-crafter"})
    public static interface Callback<T> {
        public void onElementAdded(T var1);

        public boolean shouldRemoveCallback();
    }
}

