/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.mixin.editor.debugger;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import net.minecraft.class_10618;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_3050;
import net.minecraft.class_8839;
import net.minecraft.class_8853;
import net.minecraft.class_8855;
import net.minecraft.class_8935;
import net.minecraft.class_8936;
import net.papierkorb2292.command_crafter.editor.debugger.helper.CommandExecutionContextContinueCallback;
import net.papierkorb2292.command_crafter.editor.debugger.server.PauseContext;
import net.papierkorb2292.command_crafter.editor.debugger.server.functions.ExitDebugFrameCommandAction;
import net.papierkorb2292.command_crafter.editor.debugger.server.functions.FunctionDebugFrame;
import net.papierkorb2292.command_crafter.editor.debugger.server.functions.tags.FunctionTagDebugFrame;
import net.papierkorb2292.command_crafter.mixin.editor.CommandManagerAccessor;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3050.class})
public abstract class ExecuteCommandMixin {
    @Inject(method={"enqueueExecutions"}, at={@At(value="HEAD")})
    private static <T extends class_8839<T>> void command_crafter$initCommandInfo(T baseSource, List<T> sources, Function<T, T> functionSourceGetter, IntPredicate predicate, ContextChain<T> contextChain, @Nullable class_2487 args, class_8855<T> control, class_10618<CommandContext<T>, Collection<class_2158<T>>> functionNamesGetter, class_8936 flags, CallbackInfo ci, @Share(value="commandInfo") LocalRef<FunctionDebugFrame.CommandInfo> commandInfo, @Share(value="debugFrame") LocalRef<FunctionDebugFrame> debugFrameRef) {
        if (!(baseSource instanceof class_2168)) {
            return;
        }
        PauseContext pauseContext = PauseContext.Companion.getCurrentPauseContext().get();
        if (pauseContext == null) {
            return;
        }
        PauseContext.DebugFrame debugFrame = pauseContext.peekDebugFrame();
        if (!(debugFrame instanceof FunctionDebugFrame)) {
            return;
        }
        FunctionDebugFrame functionDebugFrame = (FunctionDebugFrame)debugFrame;
        commandInfo.set((Object)functionDebugFrame.getCommandInfo((CommandContext<class_2168>)contextChain.getTopContext()));
        debugFrameRef.set((Object)functionDebugFrame);
    }

    @ModifyVariable(method={"enqueueExecutions"}, at=@At(value="STORE"), ordinal=1)
    private static <T extends class_8839<T>> List<T> command_crafter$createNextSectionSources(List<T> sources, @Share(value="commandInfo") LocalRef<FunctionDebugFrame.CommandInfo> commandInfo, @Share(value="debugFrame") LocalRef<FunctionDebugFrame> debugFrameRef) {
        FunctionDebugFrame debugFrame = (FunctionDebugFrame)debugFrameRef.get();
        if (debugFrame == null) {
            return sources;
        }
        int sectionIndex = 1 + ((FunctionDebugFrame.CommandInfo)commandInfo.get()).getSectionOffset();
        if (debugFrame.getSectionSources().size() > sectionIndex) {
            return debugFrame.getSectionSources().get(sectionIndex).getSources();
        }
        debugFrame.getSectionSources().add(new FunctionDebugFrame.SectionSources(sources, new ArrayList<Integer>(), 0));
        return sources;
    }

    @ModifyArg(method={"enqueueExecutions"}, at=@At(value="INVOKE", target="Lnet/minecraft/command/IsolatedCommandAction;<init>(Ljava/util/function/Consumer;Lnet/minecraft/command/ReturnValueConsumer;)V"))
    private static <T extends class_8839<T>> Consumer<class_8855<T>> command_crafter$wrapIsolatedToCheckFunctionPause(Consumer<class_8855<T>> original, @Share(value="commandInfo") LocalRef<FunctionDebugFrame.CommandInfo> commandInfoRef, @Share(value="debugFrame") LocalRef<FunctionDebugFrame> debugFrameRef, @Local(argsOnly=true) ContextChain<T> contextChain, @Local(ordinal=2) T source) {
        FunctionDebugFrame debugFrame = (FunctionDebugFrame)debugFrameRef.get();
        if (debugFrame == null) {
            return original;
        }
        FunctionDebugFrame.CommandInfo commandInfo = (FunctionDebugFrame.CommandInfo)commandInfoRef.get();
        return control -> {
            debugFrame.setCurrentSectionIndex(commandInfo.getSectionOffset());
            debugFrame.checkPause(commandInfo, contextChain.getTopContext(), (class_2168)source);
            FunctionDebugFrame.SectionSources sectionSources = debugFrame.getCurrentSectionSources();
            sectionSources.setCurrentSourceIndex(sectionSources.getCurrentSourceIndex() + 1);
            boolean isTag = FunctionTagDebugFrame.Companion.pushFrameForCommandArgumentIfIsTag((CommandContext<class_2168>)contextChain.getTopContext().copyFor((Object)source), "name", debugFrame.getPauseContext(), null, new CommandExecutionContextContinueCallback(CommandManagerAccessor.getCURRENT_CONTEXT().get()));
            original.accept((class_8855)control);
            if (isTag) {
                control.method_54402(FunctionTagDebugFrame.Companion.getLastTagPauseCommandAction());
                control.method_54402(FunctionTagDebugFrame.Companion.getCOPY_TAG_RESULT_TO_COMMAND_RESULT_COMMAND_ACTION());
                control.method_54402((class_8853)new ExitDebugFrameCommandAction(debugFrame.getPauseContext().getDebugFrameDepth() - 1, debugFrame.getPauseContext(), true, null));
            }
        };
    }

    @ModifyVariable(method={"enqueueExecutions"}, at=@At(value="STORE"))
    private static <T extends class_8839<T>> class_8935 command_crafter$setParentSourceIndex(class_8935 original, T baseSource, List<T> sources, Function<T, T> functionSourceGetter, IntPredicate predicate, @Share(value="debugFrame") LocalRef<FunctionDebugFrame> debugFrameRef) {
        FunctionDebugFrame debugFrame = (FunctionDebugFrame)debugFrameRef.get();
        if (debugFrame == null) {
            return original;
        }
        return (success, returnValue) -> {
            if (predicate.test(returnValue)) {
                FunctionDebugFrame.SectionSources sectionSources = debugFrame.getCurrentSectionSources();
                int currentSourceIndex = sectionSources.getCurrentSourceIndex() - 1;
                debugFrame.getSectionSources().get(debugFrame.getCurrentSectionIndex() + 1).getParentSourceIndices().add(currentSourceIndex);
            }
            original.onResult(success, returnValue);
        };
    }

    @ModifyArg(method={"enqueueExecutions"}, at=@At(value="INVOKE:LAST", target="Lnet/minecraft/command/ExecutionControl;enqueueAction(Lnet/minecraft/command/CommandAction;)V"))
    private static <T extends class_8839<T>> class_8853<T> command_crafter$advanceCurrentSectionIndex(class_8853<T> original, @Share(value="debugFrame") LocalRef<FunctionDebugFrame> debugFrameRef, @Share(value="commandInfo") LocalRef<FunctionDebugFrame.CommandInfo> commandInfoRef) {
        FunctionDebugFrame debugFrame = (FunctionDebugFrame)debugFrameRef.get();
        if (debugFrame == null) {
            return original;
        }
        return (context, frame) -> {
            debugFrame.setCurrentSectionIndex(((FunctionDebugFrame.CommandInfo)commandInfoRef.get()).getSectionOffset() + 1);
            original.execute(context, frame);
        };
    }

    @ModifyArg(method={"method_54852"}, at=@At(value="INVOKE", target="Lnet/minecraft/command/ExecutionControl;enqueueAction(Lnet/minecraft/command/CommandAction;)V", ordinal=0))
    private static <T extends class_8839<T>> class_8853<T> command_crafter$addTagPauseCheck(class_8853<T> original, @Share(value="entryIndex") LocalIntRef entryIndexRef) {
        class_8853<T> wrappedAction = FunctionTagDebugFrame.Companion.wrapCommandActionWithTagPauseCheck(original, entryIndexRef.get());
        entryIndexRef.set(entryIndexRef.get() + 1);
        return wrappedAction;
    }
}

