/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.parser;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 \u000e2\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u001d\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;", "", "", "keepDirectives", "", "permissionLevel", "<init>", "(ZLjava/lang/Integer;)V", "Z", "getKeepDirectives", "()Z", "Ljava/lang/Integer;", "getPermissionLevel", "()Ljava/lang/Integer;", "Companion", "DatapackBuildArgsParser", "DatapackBuildArgsBuilder", "BuildArg", "command-crafter"})
public final class DatapackBuildArgs {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean keepDirectives;
    @Nullable
    private final Integer permissionLevel;
    @NotNull
    private static final Map<String, BuildArg> ARGUMENTS = new HashMap();

    public DatapackBuildArgs(boolean keepDirectives, @Nullable Integer permissionLevel) {
        this.keepDirectives = keepDirectives;
        this.permissionLevel = permissionLevel;
    }

    public /* synthetic */ DatapackBuildArgs(boolean bl, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        this(bl, n);
    }

    public final boolean getKeepDirectives() {
        return this.keepDirectives;
    }

    @Nullable
    public final Integer getPermissionLevel() {
        return this.permissionLevel;
    }

    public DatapackBuildArgs() {
        this(false, null, 3, null);
    }

    static {
        Companion.registerArgument("keepDirectives", new BuildArg(){

            public String getNameSuggestion() {
                return "keepDirectives";
            }

            public void parse(StringReader reader, DatapackBuildArgsBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                if (builder.getKeepDirectives()) {
                    throw DatapackBuildArgsParser.INSTANCE.getARG_ALREADY_SPECIFIED_EXCEPTION().createWithContext((ImmutableStringReader)reader, (Object)"keepDirectives");
                }
                builder.setKeepDirectives(true);
            }

            public boolean suggest(StringReader reader, StringBuilder prefix, SuggestionsBuilder builder) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                if (!reader.canRead()) {
                    builder.suggest(prefix.toString());
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        });
        Companion.registerArgument("functionPermissionLevel", new BuildArg(){

            public String getNameSuggestion() {
                return "functionPermissionLevel=";
            }

            public void parse(StringReader reader, DatapackBuildArgsBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                if (builder.getPermissionLevel() != null) {
                    throw DatapackBuildArgsParser.INSTANCE.getARG_ALREADY_SPECIFIED_EXCEPTION().createWithContext((ImmutableStringReader)reader, (Object)"permissionLevel");
                }
                reader.skipWhitespace();
                reader.expect('=');
                reader.skipWhitespace();
                builder.setPermissionLevel(reader.readInt());
            }

            public boolean suggest(StringReader reader, StringBuilder prefix, SuggestionsBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                reader.skipWhitespace();
                if (!reader.canRead() || reader.read() != '=') {
                    builder.suggest(prefix + "=");
                    return true;
                }
                int start = reader.getCursor();
                while (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
                    reader.skip();
                }
                if (start == reader.getCursor()) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().createWithContext((ImmutableStringReader)reader);
                }
                StringBuilder stringBuilder = prefix.append('=');
                String string = reader.getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                String string2 = string;
                int n = reader.getCursor();
                String string3 = string2.substring(start, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                stringBuilder.append(string3);
                return false;
            }
        });
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\n\u0010\u000b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\fH&\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00108&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$BuildArg;", "", "Lcom/mojang/brigadier/StringReader;", "reader", "Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$DatapackBuildArgsBuilder;", "builder", "", "parse", "(Lcom/mojang/brigadier/StringReader;Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$DatapackBuildArgsBuilder;)V", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "prefix", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "", "suggest", "(Lcom/mojang/brigadier/StringReader;Ljava/lang/StringBuilder;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Z", "", "getNameSuggestion", "()Ljava/lang/String;", "nameSuggestion", "command-crafter"})
    public static interface BuildArg {
        @NotNull
        public String getNameSuggestion();

        public void parse(@NotNull StringReader var1, @NotNull DatapackBuildArgsBuilder var2);

        public boolean suggest(@NotNull StringReader var1, @NotNull StringBuilder var2, @NotNull SuggestionsBuilder var3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$Companion;", "", "<init>", "()V", "", "name", "Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$BuildArg;", "argument", "", "registerArgument", "(Ljava/lang/String;Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$BuildArg;)V", "", "ARGUMENTS", "Ljava/util/Map;", "command-crafter"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerArgument(@NotNull String name, @NotNull BuildArg argument) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            ARGUMENTS.put(name, argument);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$DatapackBuildArgsBuilder;", "", "<init>", "()V", "Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;", "build", "()Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;", "", "keepDirectives", "Z", "getKeepDirectives", "()Z", "setKeepDirectives", "(Z)V", "", "permissionLevel", "Ljava/lang/Integer;", "getPermissionLevel", "()Ljava/lang/Integer;", "setPermissionLevel", "(Ljava/lang/Integer;)V", "command-crafter"})
    public static final class DatapackBuildArgsBuilder {
        private boolean keepDirectives;
        @Nullable
        private Integer permissionLevel;

        public final boolean getKeepDirectives() {
            return this.keepDirectives;
        }

        public final void setKeepDirectives(boolean bl) {
            this.keepDirectives = bl;
        }

        @Nullable
        public final Integer getPermissionLevel() {
            return this.permissionLevel;
        }

        public final void setPermissionLevel(@Nullable Integer n) {
            this.permissionLevel = n;
        }

        @NotNull
        public final DatapackBuildArgs build() {
            return new DatapackBuildArgs(this.keepDirectives, this.permissionLevel);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$DatapackBuildArgsParser;", "", "<init>", "()V", "Lcom/mojang/brigadier/StringReader;", "reader", "Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$DatapackBuildArgsBuilder;", "parse", "(Lcom/mojang/brigadier/StringReader;)Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs$DatapackBuildArgsBuilder;", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "INVALID_ARG_NAME_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "ARG_ALREADY_SPECIFIED_EXCEPTION", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "getARG_ALREADY_SPECIFIED_EXCEPTION", "()Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "Lnet/minecraft/class_2168;", "SUGGESTION_PROVIDER", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "getSUGGESTION_PROVIDER", "()Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "command-crafter"})
    public static final class DatapackBuildArgsParser {
        @NotNull
        public static final DatapackBuildArgsParser INSTANCE = new DatapackBuildArgsParser();
        @NotNull
        private static final SimpleCommandExceptionType INVALID_ARG_NAME_EXCEPTION = new SimpleCommandExceptionType(DatapackBuildArgsParser::INVALID_ARG_NAME_EXCEPTION$lambda$0);
        @NotNull
        private static final DynamicCommandExceptionType ARG_ALREADY_SPECIFIED_EXCEPTION = new DynamicCommandExceptionType(DatapackBuildArgsParser::ARG_ALREADY_SPECIFIED_EXCEPTION$lambda$1);
        @NotNull
        private static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = DatapackBuildArgsParser::SUGGESTION_PROVIDER$lambda$2;

        private DatapackBuildArgsParser() {
        }

        @NotNull
        public final DynamicCommandExceptionType getARG_ALREADY_SPECIFIED_EXCEPTION() {
            return ARG_ALREADY_SPECIFIED_EXCEPTION;
        }

        @NotNull
        public final SuggestionProvider<class_2168> getSUGGESTION_PROVIDER() {
            return SUGGESTION_PROVIDER;
        }

        @NotNull
        public final DatapackBuildArgsBuilder parse(@NotNull StringReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            DatapackBuildArgsBuilder builder = new DatapackBuildArgsBuilder();
            while (reader.canRead() && reader.peek() != '\n') {
                reader.skipWhitespace();
                String name = reader.readUnquotedString();
                BuildArg buildArg = (BuildArg)ARGUMENTS.get(name);
                if (buildArg == null) {
                    throw INVALID_ARG_NAME_EXCEPTION.createWithContext((ImmutableStringReader)reader);
                }
                buildArg.parse(reader, builder);
                if (!reader.canRead()) continue;
                reader.expect(' ');
            }
            return builder;
        }

        private static final String INVALID_ARG_NAME_EXCEPTION$lambda$0() {
            return "Error while parsing datapack build args: Encountered invalid or empty argument name";
        }

        private static final Message ARG_ALREADY_SPECIFIED_EXCEPTION$lambda$1(Object it) {
            return (Message)class_2561.method_30163((String)("Error while parsing datapack build args: Argument " + it + " is specified multiple times"));
        }

        private static final CompletableFuture SUGGESTION_PROVIDER$lambda$2(CommandContext commandContext, SuggestionsBuilder builder) {
            StringBuilder prefix = new StringBuilder();
            StringReader reader = new StringReader(builder.getRemaining());
            HashMap arguments = new HashMap(ARGUMENTS);
            while (!reader.canRead() || reader.peek() != '\n') {
                String name;
                BuildArg completedArg;
                if (reader.getCursor() != 0) {
                    if (reader.canRead()) {
                        reader.skip();
                    }
                    prefix.append(' ');
                }
                if ((completedArg = (BuildArg)arguments.get(name = reader.readUnquotedString())) == null) {
                    for (Map.Entry entry : ((Map)arguments).entrySet()) {
                        String argName = (String)entry.getKey();
                        BuildArg arg = (BuildArg)entry.getValue();
                        Intrinsics.checkNotNull((Object)argName);
                        Intrinsics.checkNotNull((Object)name);
                        if (!StringsKt.startsWith$default((String)argName, (String)name, (boolean)false, (int)2, null)) continue;
                        builder.suggest(prefix + arg.getNameSuggestion());
                    }
                    break;
                }
                arguments.remove(name);
                prefix.append(name);
                Intrinsics.checkNotNull((Object)builder);
                if (!completedArg.suggest(reader, prefix, builder)) continue;
                break;
            }
            return builder.buildFuture();
        }
    }
}

