/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.helper.IntList;
import net.papierkorb2292.command_crafter.helper.UtilKt;
import net.papierkorb2292.command_crafter.parser.FileMappingInfo;
import net.papierkorb2292.command_crafter.parser.helper.ProcessedInputCursorMapper;
import net.papierkorb2292.command_crafter.parser.helper.SplitProcessedInputCursorMapper;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\t\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR\u0017\u0010 \u001a\u00020\u001f8\u0006\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u0011\u0010%\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001a\u00a8\u0006&"}, d2={"Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "", "", "", "lines", "Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;", "cursorMapper", "", "readCharacters", "skippedChars", "<init>", "(Ljava/util/List;Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;II)V", "copy", "()Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "startCursor", "Ljava/io/Reader;", "getReader", "(I)Ljava/io/Reader;", "Ljava/util/List;", "getLines", "()Ljava/util/List;", "Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;", "getCursorMapper", "()Lnet/papierkorb2292/command_crafter/parser/helper/SplitProcessedInputCursorMapper;", "I", "getReadCharacters", "()I", "setReadCharacters", "(I)V", "getSkippedChars", "setSkippedChars", "Lnet/papierkorb2292/command_crafter/helper/IntList;", "accumulatedLineLengths", "Lnet/papierkorb2292/command_crafter/helper/IntList;", "getAccumulatedLineLengths", "()Lnet/papierkorb2292/command_crafter/helper/IntList;", "getReadSkippingChars", "readSkippingChars", "command-crafter"})
public final class FileMappingInfo {
    @NotNull
    private final List<String> lines;
    @NotNull
    private final SplitProcessedInputCursorMapper cursorMapper;
    private int readCharacters;
    private int skippedChars;
    @NotNull
    private final IntList accumulatedLineLengths;

    public FileMappingInfo(@NotNull List<String> lines, @NotNull SplitProcessedInputCursorMapper cursorMapper, int readCharacters, int skippedChars) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)cursorMapper, (String)"cursorMapper");
        this.lines = lines;
        this.cursorMapper = cursorMapper;
        this.readCharacters = readCharacters;
        this.skippedChars = skippedChars;
        this.accumulatedLineLengths = new IntList(this.lines.size());
        int accumulatedLength = 0;
        for (String line : this.lines) {
            this.accumulatedLineLengths.add(accumulatedLength += line.length() + 1);
        }
    }

    public /* synthetic */ FileMappingInfo(List list, SplitProcessedInputCursorMapper splitProcessedInputCursorMapper, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            splitProcessedInputCursorMapper = new SplitProcessedInputCursorMapper();
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(list, splitProcessedInputCursorMapper, n, n2);
    }

    @NotNull
    public final List<String> getLines() {
        return this.lines;
    }

    @NotNull
    public final SplitProcessedInputCursorMapper getCursorMapper() {
        return this.cursorMapper;
    }

    public final int getReadCharacters() {
        return this.readCharacters;
    }

    public final void setReadCharacters(int n) {
        this.readCharacters = n;
    }

    public final int getSkippedChars() {
        return this.skippedChars;
    }

    public final void setSkippedChars(int n) {
        this.skippedChars = n;
    }

    @NotNull
    public final IntList getAccumulatedLineLengths() {
        return this.accumulatedLineLengths;
    }

    public final int getReadSkippingChars() {
        return this.readCharacters - this.skippedChars;
    }

    @NotNull
    public final FileMappingInfo copy() {
        return new FileMappingInfo(this.lines, this.cursorMapper, this.readCharacters, this.skippedChars);
    }

    @NotNull
    public final Reader getReader(int startCursor) {
        return new Reader(startCursor, this){
            private boolean isClosed;
            private int currentCursor;
            private int currentMappingIndex;
            private Position pos;
            private final int endCursor;
            final /* synthetic */ FileMappingInfo this$0;
            {
                this.this$0 = $receiver;
                this.currentCursor = $startCursor;
                this.currentMappingIndex = UtilKt.binarySearch$default($receiver.getCursorMapper().getTargetCursors(), 0, 0, arg_0 -> getReader.1.currentMappingIndex$lambda$0($receiver, $startCursor, arg_0), 3, null);
                if (this.currentMappingIndex < 0) {
                    this.currentMappingIndex = -this.currentMappingIndex - 2;
                }
                this.pos = AnalyzingResult.Companion.getPositionFromCursor$default(AnalyzingResult.Companion, $startCursor - $receiver.getCursorMapper().getTargetCursors().get(this.currentMappingIndex) + $receiver.getCursorMapper().getSourceCursors().get(this.currentMappingIndex), $receiver, false, 4, null);
                this.endCursor = ProcessedInputCursorMapper.DefaultImpls.mapToTarget$default((ProcessedInputCursorMapper)$receiver.getCursorMapper(), $receiver.getAccumulatedLineLengths().last(), false, 2, null);
            }

            public final boolean canRead() {
                return this.currentCursor < this.endCursor;
            }

            private final char readChar() {
                if (!this.canRead()) {
                    throw new IOException("End of stream reached");
                }
                String line = this.this$0.getLines().get(this.pos.getLine());
                char c = this.pos.getCharacter() >= line.length() ? (char)'\n' : (char)line.charAt(this.pos.getCharacter());
                int n = this.currentCursor;
                this.currentCursor = n + 1;
                if (this.currentCursor == this.endCursor) {
                    return c;
                }
                if (this.currentMappingIndex + 1 >= this.this$0.getCursorMapper().getTargetCursors().getSize()) {
                    this.skipSourceChars(1);
                    return c;
                }
                int nextMappingStart = this.this$0.getCursorMapper().getTargetCursors().get(this.currentMappingIndex + 1);
                if (this.currentCursor == nextMappingStart) {
                    int n2;
                    if (this.currentMappingIndex >= 0) {
                        int relativeCursor = this.currentCursor - 1 - this.this$0.getCursorMapper().getTargetCursors().get(this.currentMappingIndex);
                        n2 = this.this$0.getCursorMapper().getSourceCursors().get(this.currentMappingIndex) + relativeCursor;
                    } else {
                        n2 = this.currentCursor;
                    }
                    int currentSourceCursor = n2;
                    this.skipSourceChars(this.this$0.getCursorMapper().getSourceCursors().get(this.currentMappingIndex + 1) - currentSourceCursor);
                    int n3 = this.currentMappingIndex;
                    this.currentMappingIndex = n3 + 1;
                } else {
                    this.skipSourceChars(1);
                }
                return c;
            }

            private final void skipSourceChars(int sourceCharCount) {
                int remainingChars = sourceCharCount;
                while (true) {
                    String line;
                    int remainingLineChars;
                    if ((remainingLineChars = (line = this.this$0.getLines().get(this.pos.getLine())).length() - this.pos.getCharacter()) >= remainingChars) {
                        this.pos = net.papierkorb2292.command_crafter.editor.processing.helper.UtilKt.advance(this.pos, remainingChars);
                        return;
                    }
                    this.pos = net.papierkorb2292.command_crafter.editor.processing.helper.UtilKt.advanceLine(this.pos);
                    remainingChars -= remainingLineChars + 1;
                }
            }

            public int read(char[] cbuf, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
                if (this.isClosed) {
                    throw new IOException("Stream closed");
                }
                Objects.checkFromIndexSize(off, len, cbuf.length);
                if (len == 0) {
                    return 0;
                }
                if (!this.canRead()) {
                    return -1;
                }
                int bufIndex = 0;
                while (this.canRead() && bufIndex < len) {
                    cbuf[off + bufIndex++] = this.readChar();
                }
                return bufIndex;
            }

            public void close() {
                this.isClosed = true;
            }

            private static final int currentMappingIndex$lambda$0(FileMappingInfo this$0, int $startCursor, int index) {
                return this$0.getCursorMapper().getTargetCursors().get(index) > $startCursor ? 1 : (this$0.getCursorMapper().getTargetCursors().get(index) + this$0.getCursorMapper().getLengths().get(index) <= $startCursor ? -1 : 0);
            }
        };
    }
}

