/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.parser.helper;

import com.mojang.brigadier.context.StringRange;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.papierkorb2292.command_crafter.editor.processing.helper.UtilKt;
import net.papierkorb2292.command_crafter.parser.helper.ProcessedInputCursorMapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u0010B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lnet/papierkorb2292/command_crafter/parser/helper/CombinedProcessedInputCursorMapper;", "Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;", "", "Lnet/papierkorb2292/command_crafter/parser/helper/CombinedProcessedInputCursorMapper$Entry;", "entries", "<init>", "(Ljava/util/List;)V", "", "sourceCursor", "", "clampInGaps", "mapToTarget", "(IZ)I", "targetCursor", "mapToSource", "Ljava/util/List;", "Entry", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nCombinedProcessedInputCursorMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedProcessedInputCursorMapper.kt\nnet/papierkorb2292/command_crafter/parser/helper/CombinedProcessedInputCursorMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1056#2:52\n*S KotlinDebug\n*F\n+ 1 CombinedProcessedInputCursorMapper.kt\nnet/papierkorb2292/command_crafter/parser/helper/CombinedProcessedInputCursorMapper\n*L\n7#1:52\n*E\n"})
public final class CombinedProcessedInputCursorMapper
implements ProcessedInputCursorMapper {
    @NotNull
    private final List<Entry> entries;

    public CombinedProcessedInputCursorMapper(@NotNull List<Entry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Iterable $this$sortedBy$iv = entries;
        boolean $i$f$sortedBy = false;
        this.entries = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Entry it = (Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getSourceRange().getStart());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getSourceRange().getStart()));
            }
        });
        int n = entries.size();
        for (int i2 = 1; i2 < n; ++i2) {
            Entry previous = entries.get(i2 - 1);
            Entry current = entries.get(i2);
            if (previous.getSourceRange().getEnd() <= current.getSourceRange().getStart() && previous.getTargetRange().getEnd() <= current.getTargetRange().getStart()) continue;
            boolean bl = false;
            String string = "Entries must not overlap and target cursors must be in the same order as source cursors: " + previous + " and " + current;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public int mapToTarget(int sourceCursor, boolean clampInGaps) {
        Entry entry;
        int entryIndex = CollectionsKt.binarySearch$default(this.entries, (int)0, (int)0, arg_0 -> CombinedProcessedInputCursorMapper.mapToTarget$lambda$2(sourceCursor, arg_0), (int)3, null);
        if (entryIndex < 0) {
            int insertionPoint = -entryIndex - 1;
            if (insertionPoint == 0) {
                return sourceCursor;
            }
            Entry entry2 = this.entries.get(insertionPoint - 1);
            if (clampInGaps) {
                return entry2.getMapper().mapToTarget(0, true) + entry2.getTargetRange().getStart();
            }
            entry = entry2;
        } else {
            entry = this.entries.get(entryIndex);
        }
        Entry entry3 = entry;
        return entry3.getMapper().mapToTarget(sourceCursor - entry3.getSourceRange().getStart(), clampInGaps) + entry3.getTargetRange().getStart();
    }

    @Override
    public int mapToSource(int targetCursor, boolean clampInGaps) {
        Entry entry;
        int entryIndex = CollectionsKt.binarySearch$default(this.entries, (int)0, (int)0, arg_0 -> CombinedProcessedInputCursorMapper.mapToSource$lambda$3(targetCursor, arg_0), (int)3, null);
        if (entryIndex < 0) {
            int insertionPoint = -entryIndex - 1;
            if (insertionPoint == 0) {
                return targetCursor;
            }
            Entry entry2 = this.entries.get(insertionPoint - 1);
            if (clampInGaps) {
                return entry2.getMapper().mapToSource(0, true) + entry2.getSourceRange().getStart();
            }
            entry = entry2;
        } else {
            entry = this.entries.get(entryIndex);
        }
        Entry entry3 = entry;
        return entry3.getMapper().mapToSource(targetCursor - entry3.getTargetRange().getStart(), clampInGaps) + entry3.getSourceRange().getStart();
    }

    @Override
    @NotNull
    public StringRange mapToTarget(@NotNull StringRange sourceRange, boolean clampInGaps) {
        return ProcessedInputCursorMapper.DefaultImpls.mapToTarget(this, sourceRange, clampInGaps);
    }

    @Override
    @NotNull
    public StringRange mapToSource(@NotNull StringRange targetRange, boolean clampInGaps) {
        return ProcessedInputCursorMapper.DefaultImpls.mapToSource(this, targetRange, clampInGaps);
    }

    private static final int mapToTarget$lambda$2(int $sourceCursor, Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return -UtilKt.compareTo($sourceCursor, it.getSourceRange());
    }

    private static final int mapToSource$lambda$3(int $targetCursor, Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.compare((int)it.getTargetRange().getStart(), (int)$targetCursor);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/papierkorb2292/command_crafter/parser/helper/CombinedProcessedInputCursorMapper$Entry;", "", "Lcom/mojang/brigadier/context/StringRange;", "sourceRange", "targetRange", "Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;", "mapper", "<init>", "(Lcom/mojang/brigadier/context/StringRange;Lcom/mojang/brigadier/context/StringRange;Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;)V", "Lcom/mojang/brigadier/context/StringRange;", "getSourceRange", "()Lcom/mojang/brigadier/context/StringRange;", "getTargetRange", "Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;", "getMapper", "()Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;", "command-crafter"})
    public static final class Entry {
        @NotNull
        private final StringRange sourceRange;
        @NotNull
        private final StringRange targetRange;
        @NotNull
        private final ProcessedInputCursorMapper mapper;

        public Entry(@NotNull StringRange sourceRange, @NotNull StringRange targetRange, @NotNull ProcessedInputCursorMapper mapper) {
            Intrinsics.checkNotNullParameter((Object)sourceRange, (String)"sourceRange");
            Intrinsics.checkNotNullParameter((Object)targetRange, (String)"targetRange");
            Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
            this.sourceRange = sourceRange;
            this.targetRange = targetRange;
            this.mapper = mapper;
        }

        @NotNull
        public final StringRange getSourceRange() {
            return this.sourceRange;
        }

        @NotNull
        public final StringRange getTargetRange() {
            return this.targetRange;
        }

        @NotNull
        public final ProcessedInputCursorMapper getMapper() {
            return this.mapper;
        }
    }
}

