/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.client.editor.debugger;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_8710;
import net.papierkorb2292.command_crafter.client.NetworkServerConnection;
import net.papierkorb2292.command_crafter.editor.debugger.DebugPauseActions;
import net.papierkorb2292.command_crafter.networking.packets.DebugPauseActionC2SPacket;
import net.papierkorb2292.command_crafter.networking.packets.StepInTargetsRequestC2SPacket;
import org.eclipse.lsp4j.debug.StepInTargetsResponse;
import org.eclipse.lsp4j.debug.SteppingGranularity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\fJ\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0012\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001f\u00a8\u0006 "}, d2={"Lnet/papierkorb2292/command_crafter/client/editor/debugger/NetworkDebugPauseActions;", "Lnet/papierkorb2292/command_crafter/editor/debugger/DebugPauseActions;", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "packetSender", "Ljava/util/UUID;", "pauseId", "<init>", "(Lnet/fabricmc/fabric/api/networking/v1/PacketSender;Ljava/util/UUID;)V", "Lorg/eclipse/lsp4j/debug/SteppingGranularity;", "granularity", "", "next", "(Lorg/eclipse/lsp4j/debug/SteppingGranularity;)V", "", "targetId", "stepIn", "(Lorg/eclipse/lsp4j/debug/SteppingGranularity;Ljava/lang/Integer;)V", "stepOut", "frameId", "Ljava/util/concurrent/CompletableFuture;", "Lorg/eclipse/lsp4j/debug/StepInTargetsResponse;", "stepInTargets", "(I)Ljava/util/concurrent/CompletableFuture;", "continue_", "()V", "Lnet/papierkorb2292/command_crafter/networking/packets/DebugPauseActionC2SPacket$DebugPauseActionType;", "action", "additionalInfo", "sendAction", "(Lnet/papierkorb2292/command_crafter/networking/packets/DebugPauseActionC2SPacket$DebugPauseActionType;Lorg/eclipse/lsp4j/debug/SteppingGranularity;Ljava/lang/Integer;)V", "Lnet/fabricmc/fabric/api/networking/v1/PacketSender;", "Ljava/util/UUID;", "command-crafter_client"})
@Environment(value=EnvType.CLIENT)
public final class NetworkDebugPauseActions
implements DebugPauseActions {
    @NotNull
    private final PacketSender packetSender;
    @NotNull
    private final UUID pauseId;

    public NetworkDebugPauseActions(@NotNull PacketSender packetSender, @NotNull UUID pauseId) {
        Intrinsics.checkNotNullParameter((Object)packetSender, (String)"packetSender");
        Intrinsics.checkNotNullParameter((Object)pauseId, (String)"pauseId");
        this.packetSender = packetSender;
        this.pauseId = pauseId;
    }

    @Override
    public void next(@NotNull SteppingGranularity granularity) {
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        NetworkDebugPauseActions.sendAction$default(this, DebugPauseActionC2SPacket.DebugPauseActionType.NEXT, granularity, null, 4, null);
    }

    @Override
    public void stepIn(@NotNull SteppingGranularity granularity, @Nullable Integer targetId) {
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        this.sendAction(DebugPauseActionC2SPacket.DebugPauseActionType.STEP_IN, granularity, targetId);
    }

    @Override
    public void stepOut(@NotNull SteppingGranularity granularity) {
        Intrinsics.checkNotNullParameter((Object)granularity, (String)"granularity");
        NetworkDebugPauseActions.sendAction$default(this, DebugPauseActionC2SPacket.DebugPauseActionType.STEP_OUT, granularity, null, 4, null);
    }

    @Override
    @NotNull
    public CompletableFuture<StepInTargetsResponse> stepInTargets(int frameId) {
        UUID requestId = UUID.randomUUID();
        CompletableFuture<StepInTargetsResponse> future = new CompletableFuture<StepInTargetsResponse>();
        NetworkServerConnection.Companion.getCurrentStepInTargetsRequests().put(requestId, future);
        Intrinsics.checkNotNull((Object)requestId);
        this.packetSender.sendPacket((class_8710)new StepInTargetsRequestC2SPacket(frameId, this.pauseId, requestId));
        return future;
    }

    @Override
    public void continue_() {
        NetworkDebugPauseActions.sendAction$default(this, DebugPauseActionC2SPacket.DebugPauseActionType.CONTINUE, null, null, 4, null);
    }

    private final void sendAction(DebugPauseActionC2SPacket.DebugPauseActionType action, SteppingGranularity granularity, Integer additionalInfo) {
        this.packetSender.sendPacket((class_8710)new DebugPauseActionC2SPacket(action, granularity, additionalInfo, this.pauseId));
    }

    static /* synthetic */ void sendAction$default(NetworkDebugPauseActions networkDebugPauseActions, DebugPauseActionC2SPacket.DebugPauseActionType debugPauseActionType, SteppingGranularity steppingGranularity, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        networkDebugPauseActions.sendAction(debugPauseActionType, steppingGranularity, n);
    }
}

