/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.debugger.server;

import com.mojang.brigadier.context.StringRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.papierkorb2292.command_crafter.editor.debugger.helper.Positionable;
import net.papierkorb2292.command_crafter.parser.helper.CombinedProcessedInputCursorMapper;
import net.papierkorb2292.command_crafter.parser.helper.OffsetProcessedInputCursorMapper;
import net.papierkorb2292.command_crafter.parser.helper.ProcessedInputCursorMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u00072\u00020\u0001:\u0004\u0007\b\t\nJ\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer;", "", "", "path", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$ReplacementDataProvider;", "getReplacementData", "(Ljava/lang/String;)Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$ReplacementDataProvider;", "Companion", "ReplacementDataProvider", "Replacement", "Document", "command-crafter"})
public interface FileContentReplacer {
    @NotNull
    public static final Companion Companion = net.papierkorb2292.command_crafter.editor.debugger.server.FileContentReplacer$Companion.$$INSTANCE;

    @Nullable
    public ReplacementDataProvider getReplacementData(@NotNull String var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0007\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$Companion;", "", "<init>", "()V", "", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$ReplacementDataProvider;", "data", "concatReplacementData", "(Ljava/util/List;)Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$ReplacementDataProvider;", "command-crafter"})
    @SourceDebugExtension(value={"SMAP\nFileContentReplacer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContentReplacer.kt\nnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1387#2:209\n1475#2,5:210\n1387#2:215\n1475#2,5:216\n1869#2,2:221\n*S KotlinDebug\n*F\n+ 1 FileContentReplacer.kt\nnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$Companion\n*L\n15#1:209\n15#1:210,5\n16#1:215\n16#1:216,5\n18#1:221,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ReplacementDataProvider concatReplacementData(@NotNull List<ReplacementDataProvider> data) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (data.isEmpty()) {
                return null;
            }
            if (data.size() == 1) {
                return (ReplacementDataProvider)CollectionsKt.single(data);
            }
            Iterable $this$flatMap$iv = data;
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                ReplacementDataProvider it = (ReplacementDataProvider)element$iv$iv;
                boolean bl = false;
                Sequence<Replacement> list$iv$iv = it.getReplacements();
                CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
            }
            Sequence replacements = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
            Iterable $this$flatMap$iv2 = data;
            boolean $i$f$flatMapSequence2 = false;
            destination$iv$iv = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapSequenceTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ReplacementDataProvider it = (ReplacementDataProvider)element$iv$iv;
                boolean bl = false;
                Sequence<Positionable> list$iv$iv = it.getPositionables();
                CollectionsKt.addAll((Collection)destination$iv$iv2, list$iv$iv);
            }
            Sequence positionables = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv2));
            return new ReplacementDataProvider((Sequence<Replacement>)replacements, (Sequence<? extends Positionable>)positionables, (Function1<? super Integer, Unit>)((Function1)arg_0 -> Companion.concatReplacementData$lambda$3(data, arg_0)));
        }

        private static final Unit concatReplacementData$lambda$3(List $data, int sourceReference) {
            Iterable $this$forEach$iv = $data;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReplacementDataProvider it = (ReplacementDataProvider)element$iv;
                boolean bl = false;
                it.getSourceReferenceCallback().invoke((Object)sourceReference);
            }
            return Unit.INSTANCE;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J5\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$Document;", "", "", "", "lines", "Lkotlin/sequences/Sequence;", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/Positionable;", "positionables", "<init>", "(Ljava/util/List;Lkotlin/sequences/Sequence;)V", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$Replacement;", "replacements", "Lkotlin/Pair;", "Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;", "applyReplacements", "(Lkotlin/sequences/Sequence;)Lkotlin/Pair;", "lineSeparator", "concatLines", "(Ljava/lang/String;)Ljava/lang/String;", "", "startLine", "startChar", "endLine", "endChar", "lineSeparatorLength", "countCharsBetweenPos", "(IIIII)I", "Ljava/util/List;", "getLines", "()Ljava/util/List;", "Lkotlin/sequences/Sequence;", "getPositionables", "()Lkotlin/sequences/Sequence;", "command-crafter"})
    @SourceDebugExtension(value={"SMAP\nFileContentReplacer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileContentReplacer.kt\nnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$Document\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1#2:209\n*E\n"})
    public static final class Document {
        @NotNull
        private final List<String> lines;
        @NotNull
        private final Sequence<Positionable> positionables;

        public Document(@NotNull List<String> lines, @NotNull Sequence<? extends Positionable> positionables) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter(positionables, (String)"positionables");
            this.lines = lines;
            this.positionables = positionables;
        }

        @NotNull
        public final List<String> getLines() {
            return this.lines;
        }

        @NotNull
        public final Sequence<Positionable> getPositionables() {
            return this.positionables;
        }

        @NotNull
        public final Pair<Document, ProcessedInputCursorMapper> applyReplacements(@NotNull Sequence<Replacement> replacements) {
            Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
            if (!replacements.iterator().hasNext()) {
                return TuplesKt.to((Object)this, (Object)new OffsetProcessedInputCursorMapper(0));
            }
            List replacementsSorted = SequencesKt.toList((Sequence)SequencesKt.sortedWith(replacements, (arg_0, arg_1) -> Document.applyReplacements$lambda$1(Document::applyReplacements$lambda$0, arg_0, arg_1)));
            List positionablesSorted = SequencesKt.toList((Sequence)SequencesKt.sortedWith(this.positionables, (arg_0, arg_1) -> Document.applyReplacements$lambda$3(Document::applyReplacements$lambda$2, arg_0, arg_1)));
            Ref.IntRef positionablesIndex = new Ref.IntRef();
            Ref.IntRef currentCursorMappingSourceChar = new Ref.IntRef();
            Ref.IntRef currentCursorMappingTargetChar = new Ref.IntRef();
            List resultCursorMapperEntries = new ArrayList();
            Object[] objectArray = new String[]{""};
            List resultLines = CollectionsKt.mutableListOf((Object[])objectArray);
            List resultPositionables = new ArrayList();
            Replacement first = (Replacement)CollectionsKt.first((List)replacementsSorted);
            Document.applyReplacements$addExisting(positionablesIndex, positionablesSorted, resultLines, resultPositionables, this, resultCursorMapperEntries, currentCursorMappingSourceChar, currentCursorMappingTargetChar, 0, first.getStartLine(), 0, first.getStartChar());
            int n = replacementsSorted.size() - 1;
            for (int i2 = 0; i2 < n; ++i2) {
                Replacement replacement = (Replacement)replacementsSorted.get(i2);
                Replacement nextRepl = (Replacement)replacementsSorted.get(i2 + 1);
                if (!(replacement.getEndLine() <= nextRepl.getStartLine() && (replacement.getEndLine() != nextRepl.getStartLine() || replacement.getEndChar() <= nextRepl.getStartChar()))) {
                    boolean bl = false;
                    String string = "Replacements must not overlap: " + replacement + " and " + nextRepl;
                    throw new IllegalArgumentException(string.toString());
                }
                Document.applyReplacements$addReplacement(positionablesIndex, positionablesSorted, this, resultLines, resultPositionables, resultCursorMapperEntries, currentCursorMappingSourceChar, currentCursorMappingTargetChar, replacement);
                Document.applyReplacements$addExisting(positionablesIndex, positionablesSorted, resultLines, resultPositionables, this, resultCursorMapperEntries, currentCursorMappingSourceChar, currentCursorMappingTargetChar, replacement.getEndLine(), nextRepl.getStartLine(), replacement.getEndChar(), nextRepl.getStartChar());
            }
            Replacement last = (Replacement)CollectionsKt.last((List)replacementsSorted);
            Document.applyReplacements$addReplacement(positionablesIndex, positionablesSorted, this, resultLines, resultPositionables, resultCursorMapperEntries, currentCursorMappingSourceChar, currentCursorMappingTargetChar, last);
            int endChar = ((String)CollectionsKt.last(this.lines)).length();
            Document.applyReplacements$addExisting(positionablesIndex, positionablesSorted, resultLines, resultPositionables, this, resultCursorMapperEntries, currentCursorMappingSourceChar, currentCursorMappingTargetChar, last.getEndLine(), this.lines.size() - 1, last.getEndChar(), endChar);
            return TuplesKt.to((Object)new Document(resultLines, (Sequence<? extends Positionable>)CollectionsKt.asSequence((Iterable)resultPositionables)), (Object)new CombinedProcessedInputCursorMapper(resultCursorMapperEntries));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String concatLines(@NotNull String lineSeparator) {
            Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
            int separatorLength = lineSeparator.length();
            Iterable iterable = this.lines;
            int n = 0;
            for (Object t : iterable) {
                void it;
                String string = (String)t;
                int n2 = n;
                boolean bl = false;
                int n3 = it.length() + separatorLength;
                n = n2 + n3;
            }
            int length = n - separatorLength;
            StringBuilder builder = new StringBuilder(length);
            int n4 = this.lines.size() - 1;
            for (int i2 = 0; i2 < n4; ++i2) {
                builder.append(this.lines.get(i2)).append(lineSeparator);
            }
            builder.append((String)CollectionsKt.last(this.lines));
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public static /* synthetic */ String concatLines$default(Document document, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "\r\n";
            }
            return document.concatLines(string);
        }

        /*
         * WARNING - void declaration
         */
        public final int countCharsBetweenPos(int startLine, int startChar, int endLine, int endChar, int lineSeparatorLength) {
            if (startLine > endLine) {
                throw new IllegalArgumentException("startLine must be <= endLine");
            }
            if (startLine == endLine) {
                if (startChar > endChar) {
                    throw new IllegalArgumentException("startChar must be <= endChar if startLine == endLine");
                }
                return endChar - startChar;
            }
            int startLineLength = this.lines.get(startLine).length() + lineSeparatorLength - startChar;
            Iterable iterable = (Iterable)RangesKt.until((int)(startLine + 1), (int)endLine);
            int n = 0;
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                void it;
                int n2;
                int n3 = n2 = ((IntIterator)iterator).nextInt();
                int n4 = n;
                boolean bl = false;
                int n5 = this.lines.get((int)it).length() + lineSeparatorLength;
                n = n4 + n5;
            }
            int betweenLineLengths = n;
            return startLineLength + betweenLineLengths + endChar;
        }

        private static final int applyReplacements$lambda$0(Replacement a, Replacement b) {
            int lineCmp = Intrinsics.compare((int)a.getStartLine(), (int)b.getStartLine());
            return lineCmp != 0 ? lineCmp : Intrinsics.compare((int)a.getStartChar(), (int)b.getStartChar());
        }

        private static final int applyReplacements$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        private static final int applyReplacements$lambda$2(Positionable a, Positionable b) {
            int lineCmp = Intrinsics.compare((int)a.getLine(), (int)b.getLine());
            return lineCmp != 0 ? lineCmp : Intrinsics.compare((int)a.getChar(), (int)b.getChar());
        }

        private static final int applyReplacements$lambda$3(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        private static final void applyReplacements$addExisting(Ref.IntRef positionablesIndex, List<? extends Positionable> positionablesSorted, List<String> resultLines, List<Positionable> resultPositionables, Document this$0, List<CombinedProcessedInputCursorMapper.Entry> resultCursorMapperEntries, Ref.IntRef currentCursorMappingSourceChar, Ref.IntRef currentCursorMappingTargetChar, int startLine, int endLine, int startChar, int endChar) {
            Positionable pos;
            while (positionablesIndex.element < positionablesSorted.size() && (pos = positionablesSorted.get(positionablesIndex.element)).getLine() <= endLine + 1 && (pos.getLine() != endLine + 1 || pos.getChar() < endChar + 1)) {
                int n;
                if (pos.getLine() < startLine + 1 || pos.getLine() == startLine + 1 && pos.getChar() < startChar + 1) {
                    n = positionablesIndex.element;
                    positionablesIndex.element = n + 1;
                    continue;
                }
                pos.setPos(pos.getLine() - startLine + resultLines.size() - 1, pos.getChar() - (pos.getLine() == startLine ? startChar + resultLines.get(startLine).length() : 0));
                ((Collection)resultPositionables).add(pos);
                n = positionablesIndex.element;
                positionablesIndex.element = n + 1;
            }
            int contentLength = 0;
            String startLineString = this$0.lines.get(startLine);
            if (startLine == endLine) {
                String string = startLineString.substring(startChar, endChar);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String content = string;
                int n = CollectionsKt.getLastIndex(resultLines);
                resultLines.set(n, resultLines.get(n) + content);
                contentLength += content.length();
            } else {
                contentLength += startLineString.length() - startChar + 1;
                int content = CollectionsKt.getLastIndex(resultLines);
                String string = resultLines.get(content);
                String string2 = startLineString.substring(startChar);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                resultLines.set(content, string + string2);
                for (int i2 = startLine + 1; i2 < endLine; ++i2) {
                    String currentLine = this$0.lines.get(i2);
                    resultLines.add(currentLine);
                    contentLength += currentLine.length() + 1;
                }
                String string3 = this$0.lines.get(endLine).substring(0, endChar);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                resultLines.add(string3);
                contentLength += endChar;
            }
            ((Collection)resultCursorMapperEntries).add(new CombinedProcessedInputCursorMapper.Entry(new StringRange(currentCursorMappingSourceChar.element, currentCursorMappingSourceChar.element + contentLength), new StringRange(currentCursorMappingTargetChar.element, currentCursorMappingTargetChar.element + contentLength), new OffsetProcessedInputCursorMapper(0)));
            currentCursorMappingSourceChar.element += contentLength;
            currentCursorMappingTargetChar.element += contentLength;
        }

        private static final boolean applyReplacements$addReplacement$addUntilLength(Ref.IntRef addedLength, List<String> lines, List<String> resultLines, int length) {
            while (addedLength.element < length) {
                String line;
                if ((String)CollectionsKt.removeFirstOrNull(lines) == null) {
                    return false;
                }
                if (line.length() + addedLength.element > length) {
                    int n = length - addedLength.element;
                    String string = line.substring(0, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String content = string;
                    String string2 = line.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    lines.add(0, string2);
                    int n2 = CollectionsKt.getLastIndex(resultLines);
                    resultLines.set(n2, resultLines.get(n2) + content);
                    addedLength.element += content.length();
                    return true;
                }
                int n = CollectionsKt.getLastIndex(resultLines);
                resultLines.set(n, resultLines.get(n) + line);
                addedLength.element += line.length() + 1;
            }
            return true;
        }

        private static final void applyReplacements$addReplacement(Ref.IntRef positionablesIndex, List<? extends Positionable> positionablesSorted, Document this$0, List<String> resultLines, List<Positionable> resultPositionables, List<CombinedProcessedInputCursorMapper.Entry> resultCursorMapperEntries, Ref.IntRef currentCursorMappingSourceChar, Ref.IntRef currentCursorMappingTargetChar, Replacement replacement) {
            char[] cArray = new char[]{'\n'};
            List lines = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)replacement.getString(), (char[])cArray, (boolean)false, (int)0, (int)6, null));
            int countedLength = 0;
            int startLine = replacement.getStartLine();
            int startChar = replacement.getStartChar();
            Ref.IntRef addedLength = new Ref.IntRef();
            while (positionablesIndex.element < positionablesSorted.size()) {
                Positionable pos = positionablesSorted.get(positionablesIndex.element);
                int posLine = pos.getLine() - 1;
                int posChar = pos.getChar() - 1;
                if (posLine > replacement.getEndLine() || posLine == replacement.getEndLine() && posChar >= replacement.getEndChar()) break;
                if (posLine < replacement.getStartLine() || posLine == replacement.getStartLine() && posChar < replacement.getStartChar()) {
                    int n = positionablesIndex.element;
                    positionablesIndex.element = n + 1;
                    continue;
                }
                startLine = posLine;
                startChar = posChar;
                int posTargetCursor = replacement.getCursorMapper().mapToTarget(countedLength += this$0.countCharsBetweenPos(startLine, startChar, posLine, posChar, 1), true);
                if (!(posTargetCursor >= 0)) {
                    boolean $i$a$-require-FileContentReplacer$Document$applyReplacements$addReplacement$42 = false;
                    String $i$a$-require-FileContentReplacer$Document$applyReplacements$addReplacement$42 = "Replacement CursorMapper mapped positionable to before the replacement (positionable: " + pos + ")";
                    throw new IllegalArgumentException($i$a$-require-FileContentReplacer$Document$applyReplacements$addReplacement$42.toString());
                }
                if (!(posTargetCursor >= addedLength.element)) {
                    boolean $i$a$-require-FileContentReplacer$Document$applyReplacements$addReplacement$52 = false;
                    String $i$a$-require-FileContentReplacer$Document$applyReplacements$addReplacement$52 = "Replacement CursorMapper is not allowed to change order of cursors (happened when mapping positionable: " + pos + ")";
                    throw new IllegalArgumentException($i$a$-require-FileContentReplacer$Document$applyReplacements$addReplacement$52.toString());
                }
                if (!Document.applyReplacements$addReplacement$addUntilLength(addedLength, lines, resultLines, posTargetCursor)) {
                    boolean bl = false;
                    String string = "Replacement CursorMapper mapped positionable to after the replacement (positionable: " + pos + ")";
                    throw new IllegalArgumentException(string.toString());
                }
                pos.setPos(resultLines.size(), ((String)CollectionsKt.last(resultLines)).length() + 1);
                ((Collection)resultPositionables).add(pos);
                int n = positionablesIndex.element;
                positionablesIndex.element = n + 1;
            }
            ((Collection)resultCursorMapperEntries).add(new CombinedProcessedInputCursorMapper.Entry(new StringRange(currentCursorMappingSourceChar.element, currentCursorMappingSourceChar.element + (countedLength += this$0.countCharsBetweenPos(startLine, startChar, replacement.getEndLine(), replacement.getEndChar(), 1))), new StringRange(currentCursorMappingTargetChar.element, currentCursorMappingTargetChar.element + replacement.getString().length()), replacement.getCursorMapper()));
            currentCursorMappingTargetChar.element += replacement.getString().length();
            currentCursorMappingSourceChar.element += countedLength;
            Document.applyReplacements$addReplacement$addUntilLength(addedLength, lines, resultLines, replacement.getString().length());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015JL\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u000eJ\u0010\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\u000eR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b \u0010\u000eR\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b!\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001e\u001a\u0004\b\"\u0010\u000eR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010#\u001a\u0004\b$\u0010\u0013R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010%\u001a\u0004\b&\u0010\u0015\u00a8\u0006'"}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$Replacement;", "", "", "startLine", "startChar", "endLine", "endChar", "", "string", "Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;", "cursorMapper", "<init>", "(IIIILjava/lang/String;Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;)V", "component1", "()I", "component2", "component3", "component4", "component5", "()Ljava/lang/String;", "component6", "()Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;", "copy", "(IIIILjava/lang/String;Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;)Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$Replacement;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "I", "getStartLine", "getStartChar", "getEndLine", "getEndChar", "Ljava/lang/String;", "getString", "Lnet/papierkorb2292/command_crafter/parser/helper/ProcessedInputCursorMapper;", "getCursorMapper", "command-crafter"})
    public static final class Replacement {
        private final int startLine;
        private final int startChar;
        private final int endLine;
        private final int endChar;
        @NotNull
        private final String string;
        @NotNull
        private final ProcessedInputCursorMapper cursorMapper;

        public Replacement(int startLine, int startChar, int endLine, int endChar, @NotNull String string, @NotNull ProcessedInputCursorMapper cursorMapper) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)cursorMapper, (String)"cursorMapper");
            this.startLine = startLine;
            this.startChar = startChar;
            this.endLine = endLine;
            this.endChar = endChar;
            this.string = string;
            this.cursorMapper = cursorMapper;
        }

        public final int getStartLine() {
            return this.startLine;
        }

        public final int getStartChar() {
            return this.startChar;
        }

        public final int getEndLine() {
            return this.endLine;
        }

        public final int getEndChar() {
            return this.endChar;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        @NotNull
        public final ProcessedInputCursorMapper getCursorMapper() {
            return this.cursorMapper;
        }

        public final int component1() {
            return this.startLine;
        }

        public final int component2() {
            return this.startChar;
        }

        public final int component3() {
            return this.endLine;
        }

        public final int component4() {
            return this.endChar;
        }

        @NotNull
        public final String component5() {
            return this.string;
        }

        @NotNull
        public final ProcessedInputCursorMapper component6() {
            return this.cursorMapper;
        }

        @NotNull
        public final Replacement copy(int startLine, int startChar, int endLine, int endChar, @NotNull String string, @NotNull ProcessedInputCursorMapper cursorMapper) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)cursorMapper, (String)"cursorMapper");
            return new Replacement(startLine, startChar, endLine, endChar, string, cursorMapper);
        }

        public static /* synthetic */ Replacement copy$default(Replacement replacement, int n, int n2, int n3, int n4, String string, ProcessedInputCursorMapper processedInputCursorMapper, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = replacement.startLine;
            }
            if ((n5 & 2) != 0) {
                n2 = replacement.startChar;
            }
            if ((n5 & 4) != 0) {
                n3 = replacement.endLine;
            }
            if ((n5 & 8) != 0) {
                n4 = replacement.endChar;
            }
            if ((n5 & 0x10) != 0) {
                string = replacement.string;
            }
            if ((n5 & 0x20) != 0) {
                processedInputCursorMapper = replacement.cursorMapper;
            }
            return replacement.copy(n, n2, n3, n4, string, processedInputCursorMapper);
        }

        @NotNull
        public String toString() {
            return "Replacement(startLine=" + this.startLine + ", startChar=" + this.startChar + ", endLine=" + this.endLine + ", endChar=" + this.endChar + ", string=" + this.string + ", cursorMapper=" + this.cursorMapper + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.startLine);
            result = result * 31 + Integer.hashCode(this.startChar);
            result = result * 31 + Integer.hashCode(this.endLine);
            result = result * 31 + Integer.hashCode(this.endChar);
            result = result * 31 + this.string.hashCode();
            result = result * 31 + this.cursorMapper.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Replacement)) {
                return false;
            }
            Replacement replacement = (Replacement)other;
            if (this.startLine != replacement.startLine) {
                return false;
            }
            if (this.startChar != replacement.startChar) {
                return false;
            }
            if (this.endLine != replacement.endLine) {
                return false;
            }
            if (this.endChar != replacement.endChar) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.string, (Object)replacement.string)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cursorMapper, (Object)replacement.cursorMapper);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011JF\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001e\u0010\u000eR\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001d\u001a\u0004\b\u001f\u0010\u000eR#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078\u0006\u00a2\u0006\f\n\u0004\b\n\u0010 \u001a\u0004\b!\u0010\u0011\u00a8\u0006\""}, d2={"Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$ReplacementDataProvider;", "", "Lkotlin/sequences/Sequence;", "Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$Replacement;", "replacements", "Lnet/papierkorb2292/command_crafter/editor/debugger/helper/Positionable;", "positionables", "Lkotlin/Function1;", "", "", "sourceReferenceCallback", "<init>", "(Lkotlin/sequences/Sequence;Lkotlin/sequences/Sequence;Lkotlin/jvm/functions/Function1;)V", "component1", "()Lkotlin/sequences/Sequence;", "component2", "component3", "()Lkotlin/jvm/functions/Function1;", "copy", "(Lkotlin/sequences/Sequence;Lkotlin/sequences/Sequence;Lkotlin/jvm/functions/Function1;)Lnet/papierkorb2292/command_crafter/editor/debugger/server/FileContentReplacer$ReplacementDataProvider;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lkotlin/sequences/Sequence;", "getReplacements", "getPositionables", "Lkotlin/jvm/functions/Function1;", "getSourceReferenceCallback", "command-crafter"})
    public static final class ReplacementDataProvider {
        @NotNull
        private final Sequence<Replacement> replacements;
        @NotNull
        private final Sequence<Positionable> positionables;
        @NotNull
        private final Function1<Integer, Unit> sourceReferenceCallback;

        public ReplacementDataProvider(@NotNull Sequence<Replacement> replacements, @NotNull Sequence<? extends Positionable> positionables, @NotNull Function1<? super Integer, Unit> sourceReferenceCallback) {
            Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
            Intrinsics.checkNotNullParameter(positionables, (String)"positionables");
            Intrinsics.checkNotNullParameter(sourceReferenceCallback, (String)"sourceReferenceCallback");
            this.replacements = replacements;
            this.positionables = positionables;
            this.sourceReferenceCallback = sourceReferenceCallback;
        }

        @NotNull
        public final Sequence<Replacement> getReplacements() {
            return this.replacements;
        }

        @NotNull
        public final Sequence<Positionable> getPositionables() {
            return this.positionables;
        }

        @NotNull
        public final Function1<Integer, Unit> getSourceReferenceCallback() {
            return this.sourceReferenceCallback;
        }

        @NotNull
        public final Sequence<Replacement> component1() {
            return this.replacements;
        }

        @NotNull
        public final Sequence<Positionable> component2() {
            return this.positionables;
        }

        @NotNull
        public final Function1<Integer, Unit> component3() {
            return this.sourceReferenceCallback;
        }

        @NotNull
        public final ReplacementDataProvider copy(@NotNull Sequence<Replacement> replacements, @NotNull Sequence<? extends Positionable> positionables, @NotNull Function1<? super Integer, Unit> sourceReferenceCallback) {
            Intrinsics.checkNotNullParameter(replacements, (String)"replacements");
            Intrinsics.checkNotNullParameter(positionables, (String)"positionables");
            Intrinsics.checkNotNullParameter(sourceReferenceCallback, (String)"sourceReferenceCallback");
            return new ReplacementDataProvider(replacements, positionables, sourceReferenceCallback);
        }

        public static /* synthetic */ ReplacementDataProvider copy$default(ReplacementDataProvider replacementDataProvider, Sequence sequence, Sequence sequence2, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                sequence = replacementDataProvider.replacements;
            }
            if ((n & 2) != 0) {
                sequence2 = replacementDataProvider.positionables;
            }
            if ((n & 4) != 0) {
                function1 = replacementDataProvider.sourceReferenceCallback;
            }
            return replacementDataProvider.copy(sequence, sequence2, function1);
        }

        @NotNull
        public String toString() {
            return "ReplacementDataProvider(replacements=" + this.replacements + ", positionables=" + this.positionables + ", sourceReferenceCallback=" + this.sourceReferenceCallback + ")";
        }

        public int hashCode() {
            int result = this.replacements.hashCode();
            result = result * 31 + this.positionables.hashCode();
            result = result * 31 + this.sourceReferenceCallback.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReplacementDataProvider)) {
                return false;
            }
            ReplacementDataProvider replacementDataProvider = (ReplacementDataProvider)other;
            if (!Intrinsics.areEqual(this.replacements, replacementDataProvider.replacements)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.positionables, replacementDataProvider.positionables)) {
                return false;
            }
            return Intrinsics.areEqual(this.sourceReferenceCallback, replacementDataProvider.sourceReferenceCallback);
        }
    }
}

