/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.papierkorb2292.command_crafter.editor.processing.SimpleCompletionItemProvider;
import net.papierkorb2292.command_crafter.parser.FileMappingInfo;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00030\u0001j\u0002`\u0006:\u0001\u001aBE\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\b\u00a2\u0006\u0004\b\u0011\u0010\u0012J$\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u0006\u0010\u0013\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0016R\u001c\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0017R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0018R\u0016\u0010\r\u001a\u0004\u0018\u00010\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0019R \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/StreamCompletionItemProvider;", "Lkotlin/Function1;", "", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/eclipse/lsp4j/CompletionItem;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingCompletionProvider;", "insertStart", "Lkotlin/Function0;", "replaceEndProvider", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "mappingInfo", "Lorg/eclipse/lsp4j/CompletionItemKind;", "kind", "Ljava/util/stream/Stream;", "Lnet/papierkorb2292/command_crafter/editor/processing/StreamCompletionItemProvider$Completion;", "completionsCallback", "<init>", "(ILkotlin/jvm/functions/Function0;Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;Lorg/eclipse/lsp4j/CompletionItemKind;Lkotlin/jvm/functions/Function0;)V", "sourceCursor", "invoke", "(I)Ljava/util/concurrent/CompletableFuture;", "I", "Lkotlin/jvm/functions/Function0;", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "Lorg/eclipse/lsp4j/CompletionItemKind;", "Completion", "command-crafter"})
public final class StreamCompletionItemProvider
implements Function1<Integer, CompletableFuture<List<? extends CompletionItem>>> {
    private final int insertStart;
    @NotNull
    private final Function0<Integer> replaceEndProvider;
    @NotNull
    private final FileMappingInfo mappingInfo;
    @Nullable
    private final CompletionItemKind kind;
    @NotNull
    private final Function0<Stream<Completion>> completionsCallback;

    public StreamCompletionItemProvider(int insertStart, @NotNull Function0<Integer> replaceEndProvider, @NotNull FileMappingInfo mappingInfo, @Nullable CompletionItemKind kind, @NotNull Function0<? extends Stream<Completion>> completionsCallback) {
        Intrinsics.checkNotNullParameter(replaceEndProvider, (String)"replaceEndProvider");
        Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
        Intrinsics.checkNotNullParameter(completionsCallback, (String)"completionsCallback");
        this.insertStart = insertStart;
        this.replaceEndProvider = replaceEndProvider;
        this.mappingInfo = mappingInfo;
        this.kind = kind;
        this.completionsCallback = completionsCallback;
    }

    @NotNull
    public CompletableFuture<List<CompletionItem>> invoke(int sourceCursor) {
        CompletionItem base = new SimpleCompletionItemProvider("", this.insertStart, this.replaceEndProvider, this.mappingInfo, null, this.kind, 16, null).createCompletionItem(sourceCursor);
        CompletableFuture<List<CompletionItem>> completableFuture = CompletableFuture.completedFuture(((Stream)this.completionsCallback.invoke()).map(arg_0 -> StreamCompletionItemProvider.invoke$lambda$6(arg_0 -> StreamCompletionItemProvider.invoke$lambda$5(base, this, arg_0), arg_0)).toList());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    private static final Either invoke$lambda$5$lambda$4$lambda$0(Completion $completion, TextEdit textEdit) {
        return Either.forLeft((Object)new TextEdit(textEdit.getRange(), $completion.getText()));
    }

    private static final Either invoke$lambda$5$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        return (Either)$tmp0.invoke(p0);
    }

    private static final Either invoke$lambda$5$lambda$4$lambda$2(Completion $completion, InsertReplaceEdit insertReplaceEdit) {
        return Either.forRight((Object)new InsertReplaceEdit($completion.getText(), insertReplaceEdit.getInsert(), insertReplaceEdit.getReplace()));
    }

    private static final Either invoke$lambda$5$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Either)$tmp0.invoke(p0);
    }

    private static final CompletionItem invoke$lambda$5(CompletionItem $base, StreamCompletionItemProvider this$0, Completion completion) {
        CompletionItem completionItem;
        CompletionItem it = completionItem = new CompletionItem();
        boolean bl = false;
        it.setLabel(completion.getLabel());
        it.setFilterText(completion.getText());
        it.setSortText($base.getSortText() + completion.getText());
        it.setKind(this$0.kind);
        it.setTextEdit((Either)$base.getTextEdit().map(arg_0 -> StreamCompletionItemProvider.invoke$lambda$5$lambda$4$lambda$1(arg_0 -> StreamCompletionItemProvider.invoke$lambda$5$lambda$4$lambda$0(completion, arg_0), arg_0), arg_0 -> StreamCompletionItemProvider.invoke$lambda$5$lambda$4$lambda$3(arg_0 -> StreamCompletionItemProvider.invoke$lambda$5$lambda$4$lambda$2(completion, arg_0), arg_0)));
        return completionItem;
    }

    private static final CompletionItem invoke$lambda$6(Function1 $tmp0, Object p0) {
        return (CompletionItem)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/StreamCompletionItemProvider$Completion;", "", "", "text", "label", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lnet/papierkorb2292/command_crafter/editor/processing/StreamCompletionItemProvider$Completion;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getText", "getLabel", "command-crafter"})
    public static final class Completion {
        @NotNull
        private final String text;
        @NotNull
        private final String label;

        public Completion(@NotNull String text, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.text = text;
            this.label = label;
        }

        public /* synthetic */ Completion(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = string;
            }
            this(string, string2);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final String component2() {
            return this.label;
        }

        @NotNull
        public final Completion copy(@NotNull String text, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            return new Completion(text, label);
        }

        public static /* synthetic */ Completion copy$default(Completion completion, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = completion.text;
            }
            if ((n & 2) != 0) {
                string2 = completion.label;
            }
            return completion.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Completion(text=" + this.text + ", label=" + this.label + ")";
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = result * 31 + this.label.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Completion)) {
                return false;
            }
            Completion completion = (Completion)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)completion.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.label, (Object)completion.label);
        }
    }
}

