/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.mixin.client.editor;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.KeyCompressor;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapLike;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11723;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.papierkorb2292.command_crafter.editor.processing.StringRangeTree;
import net.papierkorb2292.command_crafter.helper.UtilKt;
import net.papierkorb2292.command_crafter.mixin.client.editor.SpriteAtlasTextureAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_11723.class})
public class AtlasTextObjectContentsMixin {
    @ModifyExpressionValue(method={"<clinit>"}, at={@At(value="INVOKE", target="Lcom/mojang/serialization/codecs/RecordCodecBuilder;mapCodec(Ljava/util/function/Function;)Lcom/mojang/serialization/MapCodec;")}, remap=false)
    private static <O> MapCodec<O> command_crafter$addAtlasObjectSuggestions(final MapCodec<O> original) {
        return MapCodec.of(original, (MapDecoder)new MapDecoder<O>(){

            public <T> DataResult<O> decode(DynamicOps<T> ops, MapLike<T> input) {
                StringRangeTree.AnalyzingDynamicOps<?> analyzingOps = UtilKt.getOrNull(StringRangeTree.AnalyzingDynamicOps.Companion.getCURRENT_ANALYZING_OPS());
                if (analyzingOps != null) {
                    StringRangeTree.AnalyzingDynamicOps<?> castedOps = analyzingOps;
                    Object atlasInput = input.get("atlas");
                    Object spriteInput = input.get("sprite");
                    if (atlasInput != null) {
                        castedOps.getNodeStartSuggestions(atlasInput).add(() -> {
                            ArrayList atlasSuggestions = new ArrayList();
                            class_310.method_1551().method_72703().method_73156((id, texture) -> atlasSuggestions.add(new StringRangeTree.Suggestion<Object>(ops.createString(id.toString()), false)));
                            return atlasSuggestions.stream();
                        });
                    }
                    if (spriteInput != null) {
                        castedOps.getNodeStartSuggestions(spriteInput).add(() -> {
                            class_2960 atlasId;
                            Optional atlasIdString;
                            Stream<Object> atlasCandidates = null;
                            if (atlasInput != null && (atlasIdString = ops.getStringValue(atlasInput).resultOrPartial()).isPresent() && (atlasId = class_2960.method_12829((String)((String)atlasIdString.get()))) != null) {
                                try {
                                    atlasCandidates = Stream.of(class_310.method_1551().method_72703().method_73025(atlasId));
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                            if (atlasCandidates == null) {
                                ArrayList atlasTextureList = new ArrayList();
                                class_310.method_1551().method_72703().method_73156((id, texture) -> atlasTextureList.add(texture));
                                atlasCandidates = atlasTextureList.stream();
                            }
                            return atlasCandidates.flatMap(texture -> ((SpriteAtlasTextureAccessor)texture).getSprites().keySet().stream()).map(id -> new StringRangeTree.Suggestion<Object>(ops.createString(id.toString()), false));
                        });
                    }
                }
                return original.decode(ops, input);
            }

            public <T> KeyCompressor<T> compressor(DynamicOps<T> ops) {
                return original.compressor(ops);
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return original.keys(ops);
            }
        });
    }
}

