/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.transformer;

import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.transformer.MixinCoprocessor;

class CommandCrafterDecoderOutputTrackerMixinCoprocessor
extends MixinCoprocessor {
    private final String decoderMethodName = "decode";
    private final String decoderMethodDesc = "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;";
    private final String callbackObjectName = "net/papierkorb2292/command_crafter/editor/processing/PreLaunchDecoderOutputTracker";
    private final String callbackObjectDesc = "Lnet/papierkorb2292/command_crafter/editor/processing/PreLaunchDecoderOutputTracker;";

    CommandCrafterDecoderOutputTrackerMixinCoprocessor() {
    }

    String getName() {
        return "command_crafter_decoder_output_tracker";
    }

    public boolean couldTransform(String className) {
        return true;
    }

    public boolean postProcess(String name, ClassNode classNode) {
        MethodNode decodeMethod = null;
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("decode") || !method.desc.equals("(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;") || (method.access & 0x400) != 0) continue;
            decodeMethod = method;
            break;
        }
        if (decodeMethod == null) {
            return false;
        }
        this.addOnDecodeStartCall(decodeMethod);
        this.addOnDecodedCalls(decodeMethod);
        return true;
    }

    private void addOnDecodeStartCall(MethodNode decodeMethod) {
        InsnList callbackInjection = new InsnList();
        callbackInjection.add((AbstractInsnNode)new FieldInsnNode(178, "net/papierkorb2292/command_crafter/editor/processing/PreLaunchDecoderOutputTracker", "INSTANCE", "Lnet/papierkorb2292/command_crafter/editor/processing/PreLaunchDecoderOutputTracker;"));
        callbackInjection.add((AbstractInsnNode)new VarInsnNode(25, 2));
        callbackInjection.add((AbstractInsnNode)new MethodInsnNode(182, "net/papierkorb2292/command_crafter/editor/processing/PreLaunchDecoderOutputTracker", "onDecodeStart", "(Ljava/lang/Object;)V", false));
        decodeMethod.instructions.insert(callbackInjection);
    }

    private void addOnDecodedCalls(MethodNode decodeMethod) {
        ArrayList<InsnNode> returnInsns = new ArrayList<InsnNode>();
        for (AbstractInsnNode insnNode = decodeMethod.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
            if (insnNode.getOpcode() != 176) continue;
            returnInsns.add((InsnNode)insnNode);
        }
        for (InsnNode returnInsn : returnInsns) {
            InsnList callbackInjection = new InsnList();
            callbackInjection.add((AbstractInsnNode)new InsnNode(89));
            callbackInjection.add((AbstractInsnNode)new FieldInsnNode(178, "net/papierkorb2292/command_crafter/editor/processing/PreLaunchDecoderOutputTracker", "INSTANCE", "Lnet/papierkorb2292/command_crafter/editor/processing/PreLaunchDecoderOutputTracker;"));
            callbackInjection.add((AbstractInsnNode)new InsnNode(95));
            callbackInjection.add((AbstractInsnNode)new VarInsnNode(25, 2));
            callbackInjection.add((AbstractInsnNode)new MethodInsnNode(182, "net/papierkorb2292/command_crafter/editor/processing/PreLaunchDecoderOutputTracker", "onDecoded", "(Lcom/mojang/serialization/DataResult;Ljava/lang/Object;)V", false));
            decodeMethod.instructions.insertBefore((AbstractInsnNode)returnInsn, callbackInjection);
        }
    }
}

