/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.render;

import games.polarbearbytes.walktheline.WalkTheLine;
import games.polarbearbytes.walktheline.config.WalkTheLineClientConfig;
import games.polarbearbytes.walktheline.render.LineBase;
import games.polarbearbytes.walktheline.state.LockedAxisData;
import games.polarbearbytes.walktheline.util.Utils;
import java.awt.Color;
import java.time.LocalTime;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_761;
import net.minecraft.class_9801;

@Environment(value=EnvType.CLIENT)
public class RainbowLine
extends LineBase {
    public static final RainbowLine INSTANCE = new RainbowLine();

    private RainbowLine() {
        this.lineThickness = 8.0f;
    }

    @Override
    public boolean shouldUpdate(class_1297 entity, class_310 client) {
        return true;
    }

    @Override
    public void render(class_243 cameraPos, class_1297 entity, class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        LockedAxisData axisData = WalkTheLineClientConfig.getLockedAxisData((class_1937)client.field_1687);
        if (this.lastEntityPosition == null || axisData == null) {
            return;
        }
        double tolerance = WalkTheLineClientConfig.tolerance;
        class_287 lineBuilder = this.renderContext.init();
        Integer distance = (Integer)client.field_1690.method_42503().method_41753();
        WalkTheLineClientConfig config = WalkTheLineClientConfig.getConfig();
        float lineWidth = (float)config.lineWidth / 100.0f;
        class_2350[] directions = (axisData.axis() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048).method_64924();
        class_2350[] perpendicularDirections = axisData.axis().method_64924();
        class_243 lineStart = entity.method_73189().method_43206(directions[0], (double)(16 * distance));
        class_243 lineEnd = entity.method_73189().method_43206(directions[1], (double)(16 * distance));
        if (axisData.axis() == class_2350.class_2351.field_11051) {
            lineStart = new class_243(lineStart.method_10216(), lineStart.method_10214(), axisData.coordinate());
            lineEnd = new class_243(lineEnd.method_10216(), lineEnd.method_10214(), axisData.coordinate());
        } else {
            lineStart = new class_243(axisData.coordinate(), lineStart.method_10214(), lineStart.method_10215());
            lineEnd = new class_243(axisData.coordinate(), lineEnd.method_10214(), lineEnd.method_10215());
        }
        float lineOffset = (float)(-WalkTheLineClientConfig.tolerance) - lineWidth;
        class_243 leftStart = lineStart.method_43206(perpendicularDirections[0], (double)lineOffset);
        class_243 leftEnd = lineEnd.method_43206(perpendicularDirections[0], -tolerance);
        class_243 rightStart = lineStart.method_43206(perpendicularDirections[1], (double)lineOffset);
        class_243 rightEnd = lineEnd.method_43206(perpendicularDirections[1], -tolerance);
        this.buildFace(leftStart, leftEnd, lineBuilder, cameraPos, config, entity.method_73183());
        this.buildFace(rightStart, rightEnd, lineBuilder, cameraPos, config, entity.method_73183());
        try {
            class_9801 lineMeshData = lineBuilder.method_60794();
            if (lineMeshData != null) {
                this.renderContext.upload(lineMeshData);
                lineMeshData.close();
            }
        }
        catch (Exception e) {
            WalkTheLine.LOGGER.error("RainbowLine#render() error: {}", (Object)e.getMessage());
        }
    }

    public void buildFace(class_243 start, class_243 end, class_287 builder, class_243 cameraPos, WalkTheLineClientConfig config, class_1937 world) {
        int lineColor;
        float x1 = (float)(start.method_10216() - cameraPos.field_1352);
        float y1 = (float)(start.method_10214() - cameraPos.field_1351);
        float z1 = (float)(start.method_10215() - cameraPos.field_1350);
        float x2 = (float)(end.method_10216() - cameraPos.field_1352);
        float y2 = (float)(end.method_10214() - cameraPos.field_1351);
        float z2 = (float)(end.method_10215() - cameraPos.field_1350);
        if (config.rotatingColor) {
            float speed = 0.2f;
            float seconds = (float)((double)LocalTime.now().toNanoOfDay() / 1.0E9);
            float hue = seconds * speed % 1.0f;
            lineColor = Color.HSBtoRGB(hue, 1.0f, 1.0f);
            lineColor = lineColor & 0xFFFFFF | 255 * (config.rotatingColorAlpha / 100) << 24;
        } else {
            lineColor = Utils.colorHexToInt(config.singleColor.replace("#", ""));
        }
        class_2338 pos = class_2338.method_49637((double)x1, (double)y1, (double)z1);
        int light = class_761.method_23794((class_1920)world, (class_2338)pos);
        builder.method_22912(x1, y1 + 0.0f, z1).method_39415(lineColor).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        pos = class_2338.method_49637((double)x2, (double)y1, (double)z1);
        light = class_761.method_23794((class_1920)world, (class_2338)pos);
        builder.method_22912(x2, y1 + 0.01f, z1).method_39415(lineColor).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        pos = class_2338.method_49637((double)x2, (double)y1, (double)z2);
        light = class_761.method_23794((class_1920)world, (class_2338)pos);
        builder.method_22912(x2, y1 + 0.01f, z2).method_39415(lineColor).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
        pos = class_2338.method_49637((double)x1, (double)y1, (double)z2);
        light = class_761.method_23794((class_1920)world, (class_2338)pos);
        builder.method_22912(x1, y1 + 0.01f, z2).method_39415(lineColor).method_60803(light).method_22914(0.0f, 1.0f, 0.0f);
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 client) {
        this.render(cameraPos, entity, client);
    }
}

