/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.render;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import games.polarbearbytes.walktheline.WalkTheLine;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_9799;
import net.minecraft.class_9801;

@Environment(value=EnvType.CLIENT)
public class RenderContext
implements AutoCloseable {
    public int indexCount;
    public GpuBuffer vertexBuffer;
    public GpuBuffer indexBuffer;
    public VertexFormat.class_5595 indexType;
    public final String name = "WalkTheLine.RenderContext";
    public RenderSystem.class_5590 shapeIndex;
    public int textureId;
    private class_9799 alloc;
    private class_287 builder;
    private final RenderPipeline pipeline;
    public BufferUsage usage;

    public RenderContext(RenderPipeline pipeline, BufferUsage usage) {
        this.pipeline = pipeline;
        this.alloc = new class_9799(pipeline.getVertexFormat().getVertexSize() * 4);
        this.builder = new class_287(this.alloc, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
        this.shapeIndex = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
        this.indexType = this.shapeIndex.method_31924();
        this.usage = usage;
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.indexCount = -1;
        this.textureId = -1;
    }

    public class_287 getBuilder() {
        return this.builder;
    }

    public void draw(class_9801 meshData) {
        try {
            if (RenderSystem.isOnRenderThread()) {
                if (meshData == null) {
                    this.indexCount = 0;
                } else if (this.indexCount < 1) {
                    this.writeVertexToBuffer(meshData);
                }
                if (this.indexCount > 0) {
                    this.renderPass();
                }
            }
            if (meshData != null) {
                meshData.close();
            }
            this.reset();
        }
        catch (Exception err) {
            WalkTheLine.LOGGER.error("renderBlockTargetingOverlay():1: Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public void writeVertexToBuffer(class_9801 meshData) {
        if (RenderSystem.isOnRenderThread() && meshData != null) {
            GpuDevice device;
            int expectedSize = meshData.method_60818().remaining();
            if (this.vertexBuffer != null) {
                this.vertexBuffer.close();
            }
            if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            if ((device = RenderSystem.tryGetDevice()) == null) {
                WalkTheLine.LOGGER.warn("RenderContext#upload: GpuDevice is null for renderer '{}'", (Object)this.name);
                return;
            }
            if (this.vertexBuffer == null) {
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name + " VertexBuffer", BufferType.VERTICES, this.usage, expectedSize);
            } else if (this.vertexBuffer.size() < expectedSize) {
                this.vertexBuffer.close();
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name + " VertexBuffer", BufferType.VERTICES, this.usage, expectedSize);
            }
            CommandEncoder encoder = device.createCommandEncoder();
            if (this.vertexBuffer.isClosed()) {
                throw new RuntimeException("Vertex Buffer is closed!");
            }
            encoder.writeToBuffer(this.vertexBuffer, meshData.method_60818(), 0);
            if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            this.indexCount = meshData.method_60822().comp_751();
            this.indexType = meshData.method_60822().comp_753();
        }
    }

    public void renderPass() {
        if (RenderSystem.isOnRenderThread()) {
            class_276 mainFb = class_310.method_1551().method_1522();
            GpuTexture texture1 = mainFb.method_30277();
            GpuTexture texture2 = mainFb.field_1478 ? mainFb.method_30278() : null;
            GpuBuffer indexBuffer = this.shapeIndex.method_68274(this.indexCount);
            try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(texture1, OptionalInt.empty(), texture2, OptionalDouble.empty());){
                pass.setPipeline(this.pipeline);
                pass.setVertexBuffer(0, this.vertexBuffer);
                if (this.indexBuffer == null) {
                    pass.setIndexBuffer(indexBuffer, this.shapeIndex.method_31924());
                } else {
                    pass.setIndexBuffer(this.indexBuffer, this.indexType);
                }
                pass.drawIndexed(0, this.indexCount);
            }
        }
    }

    public void reset() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.close();
            this.indexBuffer = null;
        }
        if (this.builder != null) {
            try {
                class_9801 meshData = this.builder.method_60794();
                if (meshData != null) {
                    meshData.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.builder = null;
        }
        if (this.alloc != null) {
            this.alloc.close();
            this.alloc = null;
        }
        this.builder = null;
        this.shapeIndex = null;
        this.indexType = null;
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.indexCount = -1;
        this.textureId = -1;
    }

    @Override
    public void close() {
        this.reset();
    }
}

