/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import games.polarbearbytes.walktheline.WalkTheLine;
import games.polarbearbytes.walktheline.config.WalkTheLineConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "walk-the-line.json");
    private static WalkTheLineConfig config;

    public static void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            config = new WalkTheLineConfig();
            ConfigManager.saveConfig();
        } else {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (WalkTheLineConfig)GSON.fromJson((Reader)reader, WalkTheLineConfig.class);
            }
            catch (IOException e) {
                WalkTheLine.LOGGER.error(e.getMessage());
                config = new WalkTheLineConfig();
            }
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            WalkTheLine.LOGGER.warn(e.getMessage());
        }
    }

    public static WalkTheLineConfig getConfig() {
        return config;
    }
}

