/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.movement;

import com.mojang.datafixers.util.Pair;
import games.polarbearbytes.walktheline.config.ConfigManager;
import games.polarbearbytes.walktheline.network.SyncPacket;
import games.polarbearbytes.walktheline.state.LockedAxisData;
import games.polarbearbytes.walktheline.state.PlayerState;
import games.polarbearbytes.walktheline.state.WorldsData;
import games.polarbearbytes.walktheline.util.Utils;
import games.polarbearbytes.walktheline.world.StrongholdLocator;
import java.util.EnumSet;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class AxisLockManager {
    private static final double tolerance = ConfigManager.getConfig().coordinateTolerance;
    private static final double teleportTolerance = ConfigManager.getConfig().teleportTolerance;

    public static void register() {
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, from, to) -> {
            WorldsData worldsData = PlayerState.get().getWorldsData(player);
            LockedAxisData lockedAxisData = PlayerState.get().getLockedAxisData(player);
            AxisLockManager.syncToClient(player, (class_5321<class_1937>)to.method_27983(), lockedAxisData, worldsData.enabled());
        });
        ServerPlayerEvents.JOIN.register(player -> {
            WorldsData worldsData = PlayerState.get().getWorldsData(player);
            class_5321 worldKey = player.method_51469().method_27983();
            LockedAxisData lockedAxisData = worldsData.worldData().get(worldKey);
            if (lockedAxisData == null) {
                return;
            }
            AxisLockManager.syncToClient(player, (class_5321<class_1937>)worldKey, lockedAxisData, worldsData.enabled());
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                AxisLockManager.handlePlayerTick((class_1657)player);
            }
        });
    }

    public static void handlePlayerTick(class_1657 player) {
        if (player.method_31481() || !player.method_5805() || player.method_37908().method_8608() || player.method_6113()) {
            return;
        }
        if (!PlayerState.get().getEnabled((class_3222)player)) {
            return;
        }
        LockedAxisData lockedAxisData = PlayerState.get().getLockedAxisData((class_3222)player);
        if (lockedAxisData == null) {
            return;
        }
        AxisLockManager.checkDistanceFromLockedAxis((class_3222)player, lockedAxisData);
    }

    private static void checkDistanceFromLockedAxis(class_3222 player, LockedAxisData data) {
        double coordinate = Utils.getPlayerCoordAlongLockedAxis((class_1657)player, data.axis());
        double distance = coordinate - data.coordinate();
        Object entity = player.method_5765() ? player.method_5854() : player;
        if (entity == null) {
            return;
        }
        if (Math.abs(distance) <= tolerance) {
            return;
        }
        if (Math.abs(distance) >= teleportTolerance) {
            class_3218 world = (class_3218)entity.method_37908();
            class_243 pos = entity.method_19538();
            player.method_18800(0.0, 0.0, 0.0);
            switch (data.axis()) {
                case field_11048: {
                    class_243 newPos = new class_243(data.coordinate(), pos.method_10214(), pos.method_10215());
                    double y = AxisLockManager.findSafeYAbove(player, newPos);
                    entity.method_48105(world, newPos.method_10216(), y, newPos.method_10215(), EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
                    break;
                }
                case field_11051: {
                    class_243 newPos = new class_243(pos.method_10216(), pos.method_10214(), data.coordinate());
                    double y = AxisLockManager.findSafeYAbove(player, newPos);
                    entity.method_48105(world, newPos.method_10216(), y, newPos.method_10215(), EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
                }
            }
            return;
        }
        AxisLockManager.applyPushback((class_1297)entity, data.axis(), distance);
    }

    private static void applyPushback(class_1297 player, class_2350.class_2351 axis, double distance) {
        class_243 velocity = player.method_18798();
        double overshoot = Math.abs(distance) - tolerance;
        double direction = -Math.signum(distance);
        double velocityAmount = direction * overshoot * 0.3;
        class_243 newVelocity = switch (axis) {
            case class_2350.class_2351.field_11048 -> new class_243(velocityAmount, velocity.field_1351, velocity.field_1350);
            case class_2350.class_2351.field_11051 -> new class_243(velocity.field_1352, velocity.field_1351, velocityAmount);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(axis));
        };
        player.method_18799(newVelocity);
        player.field_6037 = true;
    }

    private static double findSafeYAbove(class_3222 player, class_243 position) {
        class_3218 world = player.method_51469();
        class_2338.class_2339 mutablePosition = new class_2338.class_2339((int)Math.floor(position.method_10216()), world.method_31605(), (int)Math.floor(position.method_10215()));
        int bottom = world.method_31607();
        boolean isHeadAir = world.method_8320((class_2338)mutablePosition).method_26215();
        boolean isFootAir = world.method_8320((class_2338)mutablePosition.method_10098(class_2350.field_11033)).method_26215();
        while (mutablePosition.method_10264() >= bottom) {
            boolean isBelowAir = world.method_8320((class_2338)mutablePosition.method_10098(class_2350.field_11033)).method_26215();
            if (!isBelowAir && isFootAir && isHeadAir) {
                return mutablePosition.method_10264() + 1;
            }
            isHeadAir = isFootAir;
            isFootAir = isBelowAir;
        }
        return position.method_10214();
    }

    public static LockedAxisData determineDimensionLocks(class_3222 player, class_5321<class_1937> worldKey) {
        double coordinate;
        class_2350.class_2351 axis;
        PlayerState state = PlayerState.get();
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return null;
        }
        String saveName = server.method_27728().method_150();
        switch (worldKey.method_29177().method_12832()) {
            case "overworld": {
                class_2338 spawnPosition = player.method_5682().method_30002().method_43126();
                Pair<class_2338, class_2350> locationPair = StrongholdLocator.getClosestStrongHoldPortalroom(spawnPosition);
                if (locationPair == null || locationPair.getFirst() == null) {
                    return null;
                }
                class_2338 pos = (class_2338)locationPair.getFirst();
                axis = ((class_2350)locationPair.getSecond()).method_10166();
                axis = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
                coordinate = (double)pos.method_30558(axis) + 0.5;
                break;
            }
            case "the_nether": {
                class_3218 nether = player.method_5682().method_3847(class_1937.field_25180);
                if (nether == null) {
                    return null;
                }
                LockedAxisData data = state.getLockedAxisData(player, saveName, (class_5321<class_1937>)class_1937.field_25179);
                axis = data.axis();
                coordinate = Math.floor(player.method_19538().method_18043(axis)) + 0.5;
                break;
            }
            default: {
                axis = class_2350.class_2351.field_11051;
                coordinate = 0.5;
            }
        }
        return new LockedAxisData(axis, coordinate);
    }

    public static void syncToClient(class_3222 player, class_5321<class_1937> worldKey, LockedAxisData data, Boolean enabled) {
        SyncPacket packet = new SyncPacket(worldKey, data, enabled);
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }
}

