/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.render;

import games.polarbearbytes.walktheline.render.ILine;
import java.awt.Color;
import java.time.LocalTime;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_287;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class RainbowLine
implements ILine {
    private class_243 currentPosition;
    private final int size;
    private final Vector3f[] vertexes;
    private final int colorRotationTiming;
    private int lineColor;

    public RainbowLine(int size, int colorRotationTiming) {
        this.size = size;
        this.vertexes = new Vector3f[8];
        this.colorRotationTiming = colorRotationTiming;
    }

    @Override
    public void tick() {
        float delta = (float)LocalTime.now().toNanoOfDay() / 1.0E9f % (float)this.colorRotationTiming;
        this.updateColor(delta / (float)this.colorRotationTiming);
    }

    @Override
    public void updateVertexes(class_243 position, class_2350.class_2351 axis) {
        Vector3f end;
        Vector3f start;
        if (position.equals((Object)this.currentPosition)) {
            return;
        }
        this.currentPosition = position;
        if (Objects.requireNonNull(axis) == class_2350.class_2351.field_11051) {
            start = new Vector3f((float)position.method_10216(), (float)position.method_10214() + (float)this.size, (float)position.method_10215());
            end = new Vector3f((float)position.method_10216(), (float)position.method_10214() - (float)this.size, (float)position.method_10215());
        } else {
            start = new Vector3f((float)position.method_10216() + (float)this.size, (float)position.method_10214(), (float)position.method_10215());
            end = new Vector3f((float)position.method_10216() - (float)this.size, (float)position.method_10214(), (float)position.method_10215());
        }
        this.vertexes[0] = new Vector3f((float)((double)end.x - 0.5), (float)((double)end.y - 0.5), end.z);
        this.vertexes[1] = new Vector3f((float)((double)end.x - 0.47), (float)((double)end.y - 0.5), end.z);
        this.vertexes[2] = new Vector3f((float)((double)start.x - 0.47), (float)((double)start.y + 0.5), start.z);
        this.vertexes[3] = new Vector3f((float)((double)start.x - 0.5), (float)((double)start.y + 0.5), start.z);
        this.vertexes[4] = new Vector3f((float)((double)start.x + 0.5), (float)((double)start.y + 0.5), start.z);
        this.vertexes[5] = new Vector3f((float)((double)start.x + 0.47), (float)((double)start.y + 0.5), start.z);
        this.vertexes[6] = new Vector3f((float)((double)end.x + 0.47), (float)((double)end.y - 0.5), end.z);
        this.vertexes[7] = new Vector3f((float)((double)end.x + 0.5), (float)((double)end.y - 0.5), end.z);
    }

    public void updateColor(float hue) {
        this.lineColor = Color.HSBtoRGB(hue, 1.0f, 1.0f);
        this.lineColor = this.lineColor & 0xFFFFFF | 0xFF000000;
    }

    @Override
    public void addToBuffer(class_287 builder) {
        builder.method_22912(this.vertexes[0].x, this.vertexes[0].y, this.vertexes[0].z).method_39415(this.lineColor);
        builder.method_22912(this.vertexes[1].x, this.vertexes[1].y, this.vertexes[1].z).method_39415(this.lineColor);
        builder.method_22912(this.vertexes[2].x, this.vertexes[2].y, this.vertexes[2].z).method_39415(this.lineColor);
        builder.method_22912(this.vertexes[3].x, this.vertexes[3].y, this.vertexes[3].z).method_39415(this.lineColor);
        builder.method_22912(this.vertexes[4].x, this.vertexes[4].y, this.vertexes[4].z).method_39415(this.lineColor);
        builder.method_22912(this.vertexes[5].x, this.vertexes[5].y, this.vertexes[5].z).method_39415(this.lineColor);
        builder.method_22912(this.vertexes[6].x, this.vertexes[6].y, this.vertexes[6].z).method_39415(this.lineColor);
        builder.method_22912(this.vertexes[7].x, this.vertexes[7].y, this.vertexes[7].z).method_39415(this.lineColor);
    }
}

