/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import games.polarbearbytes.walktheline.WalkTheLine;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11219;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class RenderContext
implements AutoCloseable {
    public int indexCount;
    public GpuBuffer vertexBuffer;
    public GpuBuffer indexBuffer;
    public VertexFormat.class_5595 indexType;
    public final String name = "WalkTheLine.RenderContext";
    public RenderSystem.class_5590 shapeIndex;
    public int textureId;
    private class_9799 alloc;
    private class_287 builder;
    private final RenderPipeline pipeline;

    public RenderContext(RenderPipeline pipeline) {
        this.pipeline = pipeline;
        this.alloc = new class_9799(pipeline.getVertexFormat().getVertexSize() * 4);
        this.builder = new class_287(this.alloc, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
        this.shapeIndex = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
        this.indexType = this.shapeIndex.method_31924();
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.indexCount = -1;
        this.textureId = -1;
    }

    public class_287 getBuilder() {
        return this.builder;
    }

    public void draw(class_9801 meshData) {
        try {
            if (RenderSystem.isOnRenderThread()) {
                if (meshData == null) {
                    this.indexCount = 0;
                } else if (this.indexCount < 1) {
                    this.writeVertexToBuffer(meshData);
                }
                if (this.indexCount > 0) {
                    this.renderPass();
                }
            }
            if (meshData != null) {
                meshData.close();
            }
            this.reset();
        }
        catch (Exception err) {
            WalkTheLine.LOGGER.error("renderBlockTargetingOverlay():1: Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public void writeVertexToBuffer(class_9801 meshData) {
        if (RenderSystem.isOnRenderThread() && meshData != null) {
            GpuDevice device;
            int expectedSize = meshData.method_60818().remaining();
            if (this.vertexBuffer != null) {
                this.vertexBuffer.close();
            }
            if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            if ((device = RenderSystem.tryGetDevice()) == null) {
                WalkTheLine.LOGGER.warn("RenderContext#upload: GpuDevice is null for renderer '{}'", (Object)this.name);
                return;
            }
            if (this.vertexBuffer == null) {
                this.vertexBuffer = device.createBuffer(() -> this.name + " VertexBuffer", 40, expectedSize);
            } else if (this.vertexBuffer.size() < expectedSize) {
                this.vertexBuffer.close();
                this.vertexBuffer = device.createBuffer(() -> this.name + " VertexBuffer", 40, expectedSize);
            }
            CommandEncoder encoder = device.createCommandEncoder();
            if (this.vertexBuffer.isClosed()) {
                throw new RuntimeException("Vertex Buffer is closed!");
            }
            encoder.writeToBuffer(this.vertexBuffer.slice(), meshData.method_60818());
            if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            this.indexCount = meshData.method_60822().comp_751();
            this.indexType = meshData.method_60822().comp_753();
        }
    }

    public void renderPass() {
        if (RenderSystem.isOnRenderThread()) {
            Vector4f colorMod = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
            Vector3f modelOffset = new Vector3f();
            Matrix4f texMatrix = new Matrix4f();
            float line = 0.0f;
            GpuDevice device = RenderSystem.getDevice();
            if (device == null) {
                WalkTheLine.LOGGER.warn("RenderContext#drawInternal: GpuDevice is null for renderer '{}'", (Object)this.name);
                return;
            }
            class_276 mainFb = class_310.method_1551().method_1522();
            GpuTextureView texture1 = mainFb.method_71639();
            GpuTextureView texture2 = mainFb.field_1478 ? mainFb.method_71640() : null;
            GpuBuffer indexBuffer = this.shapeIndex.method_68274(this.indexCount);
            GpuBufferSlice gpuSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)colorMod, (Vector3fc)modelOffset, (Matrix4fc)texMatrix, line);
            try (RenderPass pass = device.createCommandEncoder().createRenderPass(() -> this.name, texture1, OptionalInt.empty(), texture2, OptionalDouble.empty());){
                pass.setPipeline(this.pipeline);
                class_11219 scissorState = RenderSystem.getScissorStateForRenderTypeDraws();
                if (scissorState.method_72091()) {
                    pass.enableScissor(scissorState.method_72092(), scissorState.method_72093(), scissorState.method_72094(), scissorState.method_72095());
                }
                RenderSystem.bindDefaultUniforms((RenderPass)pass);
                pass.setUniform("DynamicTransforms", gpuSlice);
                if (this.indexBuffer == null) {
                    pass.setIndexBuffer(indexBuffer, this.shapeIndex.method_31924());
                } else {
                    pass.setIndexBuffer(this.indexBuffer, this.indexType);
                }
                pass.setVertexBuffer(0, this.vertexBuffer);
                pass.drawIndexed(0, 0, this.indexCount, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void reset() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.close();
            this.indexBuffer = null;
        }
        if (this.builder != null) {
            try {
                class_9801 meshData = this.builder.method_60794();
                if (meshData != null) {
                    meshData.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.builder = null;
        }
        if (this.alloc != null) {
            this.alloc.close();
            this.alloc = null;
        }
        this.builder = null;
        this.shapeIndex = null;
        this.indexType = null;
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.indexCount = -1;
        this.textureId = -1;
    }

    @Override
    public void close() {
        this.reset();
    }
}

