/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.state;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.polarbearbytes.walktheline.WalkTheLine;
import games.polarbearbytes.walktheline.movement.AxisLockManager;
import games.polarbearbytes.walktheline.state.LockedAxisData;
import games.polarbearbytes.walktheline.state.SavesData;
import games.polarbearbytes.walktheline.state.WorldsData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class PlayerState
extends class_18 {
    public static final Codec<PlayerState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_4844.field_40825, SavesData.CODEC).fieldOf("players").forGetter(PlayerState::getRawMap)).apply((Applicative)instance, PlayerState::new));
    public static final class_10741<PlayerState> TYPE = new class_10741("walk_the_line_state", PlayerState::new, CODEC, class_4284.field_19213);
    private HashMap<UUID, SavesData> playersData = new HashMap();

    public PlayerState() {
    }

    public PlayerState(Map<UUID, SavesData> playersData) {
        this.playersData = new HashMap();
        this.playersData.putAll(playersData);
    }

    public static PlayerState get() {
        return (PlayerState)WalkTheLine.server.method_30002().method_17983().method_17924(TYPE);
    }

    public SavesData getPlayerSaves(class_3222 player) {
        return this.playersData.computeIfAbsent(player.method_5667(), uuid -> new SavesData(new ConcurrentHashMap<String, WorldsData>()));
    }

    public WorldsData getWorldsData(class_3222 player, String saveName) {
        return this.getPlayerSaves(player).savesData().computeIfAbsent(saveName, savedName -> new WorldsData(new ConcurrentHashMap<class_5321<class_1937>, LockedAxisData>(), (Boolean)false));
    }

    public LockedAxisData getLockedAxisData(class_3222 player, String saveName, class_5321<class_1937> worldKey) {
        return this.getWorldsData(player, saveName).worldData().computeIfAbsent(worldKey, worlds -> AxisLockManager.determineDimensionLocks(player, worldKey));
    }

    public WorldsData getWorldsData(class_3222 player) {
        String saveName = Objects.requireNonNull(player.method_5682()).method_27728().method_150();
        return this.getWorldsData(player, saveName);
    }

    public LockedAxisData getLockedAxisData(class_3222 player) {
        String saveName = Objects.requireNonNull(player.method_5682()).method_27728().method_150();
        class_5321 worldKey = player.method_51469().method_27983();
        return this.getLockedAxisData(player, saveName, (class_5321<class_1937>)worldKey);
    }

    public void setEnabled(class_3222 player, Boolean enabled) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        String saveName = server.method_27728().method_150();
        this.getPlayerSaves(player).savesData().compute(saveName, (savedName, worldsData) -> {
            if (worldsData == null) {
                return new WorldsData(new ConcurrentHashMap<class_5321<class_1937>, LockedAxisData>(), enabled);
            }
            return new WorldsData(worldsData.worldData(), enabled);
        });
        this.method_80();
        class_5321 key = player.method_51469().method_27983();
        LockedAxisData data = PlayerState.get().getLockedAxisData(player);
        if (data == null) {
            return;
        }
        AxisLockManager.syncToClient(player, (class_5321<class_1937>)key, data, enabled);
    }

    public boolean getEnabled(class_3222 player) {
        return this.getWorldsData(player).enabled();
    }

    private Map<UUID, SavesData> getRawMap() {
        return new HashMap<UUID, SavesData>(this.playersData);
    }
}

