/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.world;

import com.mojang.datafixers.util.Pair;
import games.polarbearbytes.walktheline.WalkTheLine;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3421;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7151;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class StrongholdLocator {
    public static class_6885<class_3195> getStrongholdList() {
        class_5455 registryManager = WalkTheLine.server.method_30002().method_30349();
        class_7225.class_7226 structureRegistry = registryManager.method_46762(class_7924.field_41246);
        class_5321 strongholdKey = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)class_2960.method_60654((String)"stronghold"));
        class_6880 strongholdEntry = (class_6880)structureRegistry.method_46746(strongholdKey).orElseThrow(() -> new IllegalStateException("Stronghold not found in registry"));
        return class_6885.method_40246((class_6880[])new class_6880[]{strongholdEntry});
    }

    public static Pair<class_2338, class_2350> getClosestStrongHoldPortalroom(class_2338 locationPos) {
        class_3218 serverWorld = WalkTheLine.server.method_30002();
        class_6885<class_3195> list = StrongholdLocator.getStrongholdList();
        Pair pair = serverWorld.method_14178().method_12129().method_12103(serverWorld, list, locationPos, 100, false);
        if (pair == null) {
            WalkTheLine.LOGGER.error("No Stronghold Structures Found");
            return null;
        }
        class_2818 chunk = StrongholdLocator.getWorldChunk((Pair<class_2338, class_6880<class_3195>>)pair, serverWorld);
        if (chunk == null) {
            return null;
        }
        Map startList = chunk.method_12016();
        List pieceList = null;
        for (class_3449 structureStart : startList.values()) {
            class_3195 structure = structureStart.method_16656();
            if (structure.method_41618() != class_7151.field_37765) continue;
            pieceList = structureStart.method_14963();
            break;
        }
        if (pieceList == null) {
            WalkTheLine.LOGGER.warn("Piece list is empty?");
            return null;
        }
        for (class_3443 piece : pieceList) {
            if (!(piece instanceof class_3421.class_3428)) continue;
            class_2350 facingDirection = piece.method_14934();
            class_3341 box = piece.method_14935();
            class_2338 center = new class_2338((box.method_35415() + box.method_35418()) / 2, (box.method_35416() + box.method_35419()) / 2, (box.method_35417() + box.method_35420()) / 2).method_10079(piece.method_14934(), 2);
            return new Pair((Object)center, (Object)facingDirection);
        }
        return null;
    }

    @Nullable
    private static class_2818 getWorldChunk(Pair<class_2338, class_6880<class_3195>> pair, class_3218 serverWorld) {
        class_2338 pos = (class_2338)pair.getFirst();
        class_1923 chunkPos = new class_1923(pos);
        class_3215 chunkManager = serverWorld.method_14178();
        chunkManager.method_12124(chunkPos, true);
        class_2818 chunk = chunkManager.method_21730(chunkPos.field_9181, chunkPos.field_9180);
        return chunk;
    }
}

