/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline;

import games.polarbearbytes.walktheline.config.WalkTheLineClientConfig;
import games.polarbearbytes.walktheline.network.SyncPacket;
import games.polarbearbytes.walktheline.render.LineBase;
import games.polarbearbytes.walktheline.render.LineRenderer;
import games.polarbearbytes.walktheline.render.RendererHandler;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.api.v0.IrisProgram;

@Environment(value=EnvType.CLIENT)
public class WalkTheLineClient
implements ClientModInitializer {
    public void onInitializeClient() {
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            IrisApi.getInstance().assignPipeline(LineBase.renderPipeline, IrisProgram.BASIC);
        }
        WalkTheLineClientConfig.register();
        RendererHandler.getInstance().register(LineRenderer.getINSTANCE());
        ClientPlayNetworking.registerGlobalReceiver(SyncPacket.PAYLOAD_ID, (packet, context) -> context.client().execute(() -> {
            WalkTheLineClientConfig.setLockedAxisData(packet.data(), packet.worldKey());
            WalkTheLineClientConfig.tolerance = packet.coordTolerance();
            WalkTheLineClientConfig.modEnabled = packet.enabled();
        }));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> WalkTheLineClientConfig.reset());
    }
}

