/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.config;

import games.polarbearbytes.walktheline.state.LockedAxisData;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

@Config(name="walk-the-line-client")
@Environment(value=EnvType.CLIENT)
public class WalkTheLineClientConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    public boolean rotatingColor = true;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=1L, max=100L)
    public int rotatingColorAlpha = 100;
    @ConfigEntry.Gui.Tooltip
    public String singleColor = "#FF0000FF";
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=1L, max=100L)
    public int lineWidth = 25;
    @ConfigEntry.Gui.Excluded
    private static final Map<class_5321<class_1937>, LockedAxisData> CLIENT_LOCKED_AXES = new HashMap<class_5321<class_1937>, LockedAxisData>();
    @ConfigEntry.Gui.Excluded
    public static double tolerance = 0.5;
    @ConfigEntry.Gui.Excluded
    public static boolean modEnabled = false;

    public static LockedAxisData getLockedAxisData(class_1937 world) {
        return CLIENT_LOCKED_AXES.get(world.method_27983());
    }

    public static void setLockedAxisData(LockedAxisData data, class_5321<class_1937> worldKey) {
        CLIENT_LOCKED_AXES.put(worldKey, data);
    }

    public static WalkTheLineClientConfig getConfig() {
        return (WalkTheLineClientConfig)AutoConfig.getConfigHolder(WalkTheLineClientConfig.class).getConfig();
    }

    public static void reset() {
        modEnabled = false;
        tolerance = 0.5;
        CLIENT_LOCKED_AXES.clear();
    }

    public static void register() {
        AutoConfig.register(WalkTheLineClientConfig.class, GsonConfigSerializer::new);
    }
}

