/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.movement;

import com.mojang.datafixers.util.Pair;
import games.polarbearbytes.walktheline.config.ConfigManager;
import games.polarbearbytes.walktheline.config.WalkTheLineConfig;
import games.polarbearbytes.walktheline.network.SyncPacket;
import games.polarbearbytes.walktheline.state.LockedAxisData;
import games.polarbearbytes.walktheline.state.PlayerState;
import games.polarbearbytes.walktheline.state.WorldsData;
import games.polarbearbytes.walktheline.util.Utils;
import games.polarbearbytes.walktheline.world.StrongholdLocator;
import java.util.EnumSet;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class AxisLockManager {
    private static final double tolerance = ConfigManager.getConfig().coordinateTolerance;
    private static final double teleportTolerance = ConfigManager.getConfig().teleportTolerance;

    public static void register() {
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, from, to) -> {
            if (!PlayerState.get().getEnabled(player)) {
                return;
            }
            WorldsData worldsData = PlayerState.get().getWorldsData(player);
            LockedAxisData lockedAxisData = PlayerState.get().getLockedAxisData(player);
            AxisLockManager.syncToClient(player, (class_5321<class_1937>)to.method_27983(), lockedAxisData, worldsData.enabled());
        });
        ServerPlayerEvents.JOIN.register(player -> {
            if (!PlayerState.get().getEnabled(player)) {
                return;
            }
            WorldsData worldsData = PlayerState.get().getWorldsData(player);
            class_5321 worldKey = player.method_51469().method_27983();
            LockedAxisData lockedAxisData = worldsData.worldData().get(worldKey);
            if (lockedAxisData == null) {
                return;
            }
            AxisLockManager.syncToClient(player, (class_5321<class_1937>)worldKey, lockedAxisData, worldsData.enabled());
        });
    }

    public static boolean checkDistanceFromLockedAxis(class_3222 player, LockedAxisData data) {
        double coordinate = Utils.getPlayerCoordAlongLockedAxis((class_1657)player, data.axis());
        double distance = coordinate - data.coordinate();
        Object entity = player.method_5765() ? player.method_5854() : player;
        if (entity == null) {
            return true;
        }
        if (Math.abs(distance) <= tolerance) {
            return true;
        }
        if (Math.abs(distance) >= teleportTolerance) {
            class_3218 world = (class_3218)entity.method_73183();
            class_243 pos = entity.method_73189();
            player.method_18800(0.0, 0.0, 0.0);
            switch (data.axis()) {
                case field_11048: {
                    class_243 newPos = new class_243(data.coordinate(), pos.method_10214(), pos.method_10215());
                    double y = AxisLockManager.findSafeYAbove(player, newPos);
                    entity.method_48105(world, newPos.method_10216(), y, newPos.method_10215(), EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
                    break;
                }
                case field_11051: {
                    class_243 newPos = new class_243(pos.method_10216(), pos.method_10214(), data.coordinate());
                    double y = AxisLockManager.findSafeYAbove(player, newPos);
                    entity.method_48105(world, newPos.method_10216(), y, newPos.method_10215(), EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
                }
            }
            return false;
        }
        AxisLockManager.applyPushback((class_1297)entity, data.axis(), distance);
        return true;
    }

    private static void applyPushback(class_1297 player, class_2350.class_2351 axis, double distance) {
        class_243 velocity = player.method_18798();
        double overshoot = Math.abs(distance) - tolerance;
        double direction = -Math.signum(distance);
        double velocityAmount = direction * overshoot * 0.3;
        class_243 newVelocity = switch (axis) {
            case class_2350.class_2351.field_11048 -> new class_243(velocityAmount, velocity.field_1351, velocity.field_1350);
            case class_2350.class_2351.field_11051 -> new class_243(velocity.field_1352, velocity.field_1351, velocityAmount);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(axis));
        };
        player.method_18799(newVelocity);
        player.field_6037 = true;
    }

    private static double findSafeYAbove(class_3222 player, class_243 position) {
        class_3218 world = player.method_51469();
        class_2338.class_2339 mutablePosition = new class_2338.class_2339((int)Math.floor(position.method_10216()), world.method_31605(), (int)Math.floor(position.method_10215()));
        int bottom = world.method_31607();
        boolean isHeadAir = world.method_8320((class_2338)mutablePosition).method_26215();
        boolean isFootAir = world.method_8320((class_2338)mutablePosition.method_10098(class_2350.field_11033)).method_26215();
        while (mutablePosition.method_10264() >= bottom) {
            class_2680 state = world.method_8320((class_2338)mutablePosition.method_10098(class_2350.field_11033));
            boolean isBelowAir = state.method_26215();
            String name = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
            boolean isBelowBedrock = name.equals("minecraft:bedrock");
            if (!isBelowAir && isFootAir && isHeadAir && !isBelowBedrock) {
                return mutablePosition.method_10264() + 1;
            }
            isHeadAir = isFootAir;
            isFootAir = isBelowAir;
        }
        return position.method_10214();
    }

    public static LockedAxisData determineDimensionLocks(class_3222 player, class_5321<class_1937> worldKey) {
        double coordinate;
        class_2350.class_2351 axis;
        PlayerState state = PlayerState.get();
        MinecraftServer server = player.method_51469().method_8503();
        String saveName = server.method_27728().method_150();
        switch (worldKey.method_29177().method_12832()) {
            case "overworld": {
                class_2338 spawnPosition = player.method_51469().method_74854().method_74897();
                Pair<class_2338, class_2350> locationPair = StrongholdLocator.getClosestStrongHoldPortalroom(spawnPosition);
                if (locationPair == null || locationPair.getFirst() == null) {
                    return null;
                }
                class_2338 pos = (class_2338)locationPair.getFirst();
                axis = ((class_2350)locationPair.getSecond()).method_10166();
                axis = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
                coordinate = pos.method_46558().method_18043(axis);
                break;
            }
            case "the_nether": {
                class_3218 nether = player.method_51469().method_8503().method_3847(class_1937.field_25180);
                if (nether == null) {
                    return null;
                }
                LockedAxisData data = state.getLockedAxisData(player, saveName, (class_5321<class_1937>)class_1937.field_25179);
                if (data == null) {
                    return null;
                }
                axis = data.axis();
                coordinate = Math.floor(player.method_73189().method_18043(axis)) + 0.5;
                break;
            }
            default: {
                axis = class_2350.class_2351.field_11051;
                coordinate = 0.5;
            }
        }
        LockedAxisData data = new LockedAxisData(axis, coordinate);
        AxisLockManager.syncToClient(player, worldKey, data, PlayerState.get().getEnabled(player));
        return data;
    }

    public static void syncToClient(class_3222 player, class_5321<class_1937> worldKey, LockedAxisData data, Boolean enabled) {
        WalkTheLineConfig cfg = ConfigManager.getConfig();
        SyncPacket packet = new SyncPacket(worldKey, data, cfg.coordinateTolerance, enabled);
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }
}

