/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.render;

import com.mojang.blaze3d.systems.RenderSystem;
import games.polarbearbytes.walktheline.config.WalkTheLineClientConfig;
import games.polarbearbytes.walktheline.render.IRenderer;
import games.polarbearbytes.walktheline.render.LineBase;
import games.polarbearbytes.walktheline.render.RainbowLine;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_9909;
import net.minecraft.class_9960;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

@Environment(value=EnvType.CLIENT)
public class LineRenderer
implements IRenderer {
    private final List<LineBase> lineRenderers = new ArrayList<LineBase>();
    public static final LineRenderer INSTANCE = new LineRenderer();

    private LineRenderer() {
        this.lineRenderers.add(RainbowLine.INSTANCE);
    }

    @Override
    public void render(class_276 framebuffer, Matrix4f positionMatrix, Matrix4f projectionMatrix, class_310 client, class_9909 frameGraphBuilder, class_9960 fbSet, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
        if (!WalkTheLineClientConfig.modEnabled) {
            return;
        }
        class_1297 cameraEntity = client.method_1560();
        this.update(camera.method_19326(), cameraEntity, client);
        this.draw(camera.method_19326());
    }

    public void update(class_243 cameraPos, class_1297 entity, class_310 client) {
        for (LineBase renderer : this.lineRenderers) {
            if (!renderer.shouldUpdate(entity, client)) {
                return;
            }
            renderer.lastEntityPosition = class_2338.method_49638((class_2374)entity.method_73189());
            renderer.update(cameraPos, entity, client);
            renderer.setLastCameraPosition(cameraPos);
        }
    }

    public void draw(class_243 cameraPos) {
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        for (LineBase renderer : this.lineRenderers) {
            class_243 updatePosition = renderer.getLastCameraPosition();
            matrix4fstack.pushMatrix();
            matrix4fstack.translate((float)(updatePosition.field_1352 - cameraPos.field_1352), (float)(updatePosition.field_1351 - cameraPos.field_1351), (float)(updatePosition.field_1350 - cameraPos.field_1350));
            renderer.draw(cameraPos);
            matrix4fstack.popMatrix();
        }
    }

    public void reset() {
        for (LineBase renderer : this.lineRenderers) {
            renderer.reset();
        }
    }

    @Generated
    public static LineRenderer getINSTANCE() {
        return INSTANCE;
    }
}

