/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import games.polarbearbytes.walktheline.WalkTheLineClient;
import games.polarbearbytes.walktheline.config.ConfigManager;
import games.polarbearbytes.walktheline.config.WalkTheLineConfig;
import games.polarbearbytes.walktheline.render.ILine;
import games.polarbearbytes.walktheline.render.RainbowLine;
import games.polarbearbytes.walktheline.render.RenderContext;
import games.polarbearbytes.walktheline.state.LockedAxisData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_10799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_9801;
import org.joml.Matrix4fStack;

@Environment(value=EnvType.CLIENT)
public class AxisLineRenderer {
    private static final BlendFunction BLENDER = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ZERO);
    public static RenderPipeline AXIS_LINE_RENDERPIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60125}).withVertexShader("core/position_color").withFragmentShader("core/position_color").withBlend(BLENDER).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382).withLocation(class_2960.method_60655((String)"walk-the-line", (String)"pipeline")).withCull(true).withDepthWrite(true).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
    private static AxisLineRenderer INSTANCE = null;
    private final class_310 mc = class_310.method_1551();
    private class_243 blockPos;
    private class_2350 axisDirection;
    private final ILine line;

    public static void register() {
        WorldRenderEvents.AFTER_ENTITIES.register(context -> AxisLineRenderer.getInstance().render());
    }

    private AxisLineRenderer() {
        WalkTheLineConfig config = ConfigManager.getConfig();
        this.line = new RainbowLine(config.lineLength, config.lineColorRotateTiming);
    }

    public static AxisLineRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AxisLineRenderer();
        }
        return INSTANCE;
    }

    public static float matrix4fRotateFix(float ang) {
        return ang * ((float)Math.PI / 180);
    }

    public void update() {
        if (this.mc.field_1724 == null) {
            return;
        }
        LockedAxisData lockedAxisData = WalkTheLineClient.getLockedAxis((class_5321<class_1937>)this.mc.field_1724.method_37908().method_27983());
        if (lockedAxisData == null) {
            return;
        }
        this.axisDirection = lockedAxisData.axis() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051.method_64924()[1] : class_2350.class_2351.field_11048.method_64924()[0];
        class_2338 pos = this.mc.field_1724.method_24515();
        class_243 cameraPos = this.mc.field_1773.method_19418().method_71156();
        switch (lockedAxisData.axis()) {
            case field_11048: {
                pos = new class_2338((int)Math.round(lockedAxisData.coordinate()) - 1, pos.method_10264(), pos.method_10260());
                break;
            }
            case field_11051: {
                pos = new class_2338(pos.method_10263(), pos.method_10264(), (int)Math.round(lockedAxisData.coordinate()) - 1);
            }
        }
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351 - 1.0;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        this.blockPos = new class_243(x, y, z);
        class_2350.class_2351 k = lockedAxisData.axis();
        if (this.axisDirection == class_2350.field_11043) {
            k = lockedAxisData.axis() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        }
        this.line.tick();
        this.line.updateVertexes(this.blockPos, k);
    }

    public void render() {
        if (!WalkTheLineClient.modEnabled) {
            return;
        }
        this.update();
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        this.translateToFace(matrix, this.blockPos, class_2350.field_11036, this.axisDirection);
        RenderContext ctx = new RenderContext(AXIS_LINE_RENDERPIPELINE);
        class_287 builder = ctx.getBuilder();
        this.line.addToBuffer(builder);
        class_9801 meshData = builder.method_60794();
        if (meshData != null) {
            ctx.draw(meshData);
            meshData.close();
        }
        ctx.reset();
        matrix.popMatrix();
    }

    public void translateToFace(Matrix4fStack matrixStack, class_243 pos, class_2350 side, class_2350 facing) {
        matrixStack.translate((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350);
        switch (side) {
            case field_11033: {
                matrixStack.rotateY(AxisLineRenderer.matrix4fRotateFix(180.0f - facing.method_10144()));
                matrixStack.rotateX(AxisLineRenderer.matrix4fRotateFix(90.0f));
                break;
            }
            case field_11036: {
                matrixStack.rotateY(AxisLineRenderer.matrix4fRotateFix(180.0f - facing.method_10144()));
                matrixStack.rotateX(AxisLineRenderer.matrix4fRotateFix(-90.0f));
                break;
            }
            case field_11043: {
                matrixStack.rotateY(AxisLineRenderer.matrix4fRotateFix(180.0f));
                break;
            }
            case field_11035: {
                break;
            }
            case field_11039: {
                matrixStack.rotateY(AxisLineRenderer.matrix4fRotateFix(-90.0f));
                break;
            }
            case field_11034: {
                matrixStack.rotateY(AxisLineRenderer.matrix4fRotateFix(90.0f));
            }
        }
        matrixStack.translate((float)(-pos.field_1352), (float)(-pos.field_1351), (float)(-pos.field_1350 + 0.51));
    }
}

