/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline;

import games.polarbearbytes.walktheline.WalkTheLineClient;
import games.polarbearbytes.walktheline.config.ConfigManager;
import games.polarbearbytes.walktheline.state.LockedAxisData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ParticleLineRenderer {
    private static final int LINE_LENGTH = 16;
    private static final double PARTICLE_SPACING = (double)0.3f;
    private static final class_2394 particleEffect = ParticleLineRenderer.getParticleFromString(ConfigManager.getConfig().particleType);
    private static final double tolerance = ConfigManager.getConfig().coordinateTolerance;

    public static void register() {
        WorldRenderEvents.END.register(context -> {
            if (!WalkTheLineClient.modEnabled) {
                return;
            }
            class_310 client = class_310.method_1551();
            class_638 world = client.field_1687;
            if (world == null || client.field_1724 == null) {
                return;
            }
            LockedAxisData data = WalkTheLineClient.getLockedAxis((class_5321<class_1937>)world.method_27983());
            if (data == null) {
                return;
            }
            double axisCoord = data.coordinate();
            class_2350.class_2351 axis = data.axis();
            int centerX = (int)client.field_1724.method_23317();
            int centerY = (int)client.field_1724.method_23318();
            int centerZ = (int)client.field_1724.method_23321();
            for (double offset = -16.0; offset <= 16.0; offset += (double)0.3f) {
                double x = axis == class_2350.class_2351.field_11048 ? axisCoord : (double)centerX + offset;
                double z = axis == class_2350.class_2351.field_11051 ? axisCoord : (double)centerZ + offset;
                double y = (double)centerY + 0.2;
                world.method_8406(particleEffect, x + tolerance, y, z + tolerance, 0.0, 0.0, 0.0);
                world.method_8406(particleEffect, x - tolerance, y, z - tolerance, 0.0, 0.0, 0.0);
            }
        });
    }

    public static class_2394 getParticleFromString(String id) {
        class_2960 particleId = class_2960.method_60654((String)id);
        class_2394 effect = (class_2394)class_7923.field_41180.method_63535(particleId);
        return effect != null ? effect : class_2398.field_11207;
    }
}

