/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.render;

import games.polarbearbytes.walktheline.render.ILine;
import java.awt.Color;
import java.time.LocalTime;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_287;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class RainbowLine
implements ILine {
    private class_243 currentPosition;
    private final int size;
    private final Vector3f[] vertexes;
    private final int colorRotationTiming;
    private int lineColor;

    public RainbowLine(int size, int colorRotationTiming) {
        this.size = size;
        this.vertexes = new Vector3f[8];
        this.colorRotationTiming = colorRotationTiming;
    }

    @Override
    public void tick() {
        float delta = (float)LocalTime.now().toNanoOfDay() / 1.0E9f % (float)this.colorRotationTiming;
        this.updateColor(delta / (float)this.colorRotationTiming);
    }

    @Override
    public void updateVertexes(class_243 position, class_2350.class_2351 axis, class_287 buffer) {
        if (position.equals((Object)this.currentPosition)) {
            return;
        }
        this.currentPosition = position;
        this.vertexes[0] = new Vector3f((float)(position.field_1352 - 0.5), (float)(position.field_1351 - 0.5) - (float)this.size, (float)position.field_1350);
        this.vertexes[1] = new Vector3f((float)(position.field_1352 - 0.4), (float)(position.field_1351 - 0.5) - (float)this.size, (float)position.field_1350);
        this.vertexes[2] = new Vector3f((float)(position.field_1352 - 0.4), (float)(position.field_1351 + 0.5) + (float)this.size, (float)position.field_1350);
        this.vertexes[3] = new Vector3f((float)(position.field_1352 - 0.5), (float)(position.field_1351 + 0.5) + (float)this.size, (float)position.field_1350);
        this.vertexes[4] = new Vector3f((float)(position.field_1352 + 0.5), (float)(position.field_1351 + 0.5) + (float)this.size, (float)position.field_1350);
        this.vertexes[5] = new Vector3f((float)(position.field_1352 + 0.4), (float)(position.field_1351 + 0.5) + (float)this.size, (float)position.field_1350);
        this.vertexes[6] = new Vector3f((float)(position.field_1352 + 0.4), (float)(position.field_1351 - 0.5) - (float)this.size, (float)position.field_1350);
        this.vertexes[7] = new Vector3f((float)(position.field_1352 + 0.5), (float)(position.field_1351 - 0.5) - (float)this.size, (float)position.field_1350);
    }

    public void updateColor(float hue) {
        this.lineColor = Color.HSBtoRGB(hue, 1.0f, 1.0f);
        this.lineColor = this.lineColor & 0xFFFFFF | 0xFF000000;
    }

    @Override
    public void addToBuffer(class_287 builder) {
        int a = this.lineColor >> 24 & 0xFF;
        int r = this.lineColor >> 16 & 0xFF;
        int g = this.lineColor >> 8 & 0xFF;
        int b = this.lineColor & 0xFF;
        builder.method_22912((double)this.vertexes[0].x, (double)this.vertexes[0].y, (double)this.vertexes[0].z).method_1336(r, g, b, a).method_22916(0xF000F0).method_1344();
        builder.method_22912((double)this.vertexes[1].x, (double)this.vertexes[1].y, (double)this.vertexes[1].z).method_1336(r, g, b, a).method_1344();
        builder.method_22912((double)this.vertexes[2].x, (double)this.vertexes[2].y, (double)this.vertexes[2].z).method_1336(r, g, b, a).method_1344();
        builder.method_22912((double)this.vertexes[3].x, (double)this.vertexes[3].y, (double)this.vertexes[3].z).method_1336(r, g, b, a).method_1344();
        builder.method_22912((double)this.vertexes[4].x, (double)this.vertexes[4].y, (double)this.vertexes[4].z).method_1336(r, g, b, a).method_1344();
        builder.method_22912((double)this.vertexes[5].x, (double)this.vertexes[5].y, (double)this.vertexes[5].z).method_1336(r, g, b, a).method_1344();
        builder.method_22912((double)this.vertexes[6].x, (double)this.vertexes[6].y, (double)this.vertexes[6].z).method_1336(r, g, b, a).method_1344();
        builder.method_22912((double)this.vertexes[7].x, (double)this.vertexes[7].y, (double)this.vertexes[7].z).method_1336(r, g, b, a).method_1344();
    }
}

