/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.walktheline.state;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.polarbearbytes.walktheline.WalkTheLine;
import games.polarbearbytes.walktheline.movement.AxisLockManager;
import games.polarbearbytes.walktheline.state.LockedAxisData;
import games.polarbearbytes.walktheline.state.SavesData;
import games.polarbearbytes.walktheline.state.WorldsData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class PlayerState
extends class_18 {
    public static final String ID = "walk_the_line_state";
    public static final Codec<PlayerState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)class_4844.field_40825, SavesData.CODEC).fieldOf("players").forGetter(PlayerState::getRawMap)).apply((Applicative)instance, PlayerState::new));
    public static final class_18.class_8645<PlayerState> TYPE = new class_18.class_8645(PlayerState::new, PlayerState::create, class_4284.field_19213);
    private HashMap<UUID, SavesData> playersData = new HashMap();

    private static PlayerState create(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        return (PlayerState)((Object)CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbtCompound).getOrThrow());
    }

    public PlayerState() {
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        DataResult result = CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this);
        return (class_2487)result.getOrThrow(error -> {
            throw new RuntimeException("Failed to encode MyData: " + error);
        });
    }

    public PlayerState(Map<UUID, SavesData> playersData) {
        this.playersData = new HashMap();
        this.playersData.putAll(playersData);
    }

    public static PlayerState get() {
        return (PlayerState)WalkTheLine.server.method_30002().method_17983().method_17924(TYPE, ID);
    }

    public SavesData getPlayerSaves(class_3222 player) {
        return this.playersData.computeIfAbsent(player.method_5667(), uuid -> new SavesData(new ConcurrentHashMap<String, WorldsData>()));
    }

    public WorldsData getWorldsData(class_3222 player, String saveName) {
        return this.getPlayerSaves(player).savesData().computeIfAbsent(saveName, savedName -> new WorldsData(new ConcurrentHashMap<class_5321<class_1937>, LockedAxisData>(), (Boolean)false));
    }

    public LockedAxisData getLockedAxisData(class_3222 player, String saveName, class_5321<class_1937> worldKey) {
        LockedAxisData retrieved = this.getWorldsData(player, saveName).worldData().computeIfAbsent(worldKey, worlds -> AxisLockManager.determineDimensionLocks(player, worldKey));
        if (retrieved == null) {
            return null;
        }
        AxisLockManager.syncToClient(player, worldKey, retrieved, this.getEnabled(player));
        return retrieved;
    }

    public WorldsData getWorldsData(class_3222 player) {
        String saveName = Objects.requireNonNull(player.method_5682()).method_27728().method_150();
        return this.getWorldsData(player, saveName);
    }

    public LockedAxisData getLockedAxisData(class_3222 player) {
        String saveName = Objects.requireNonNull(player.method_5682()).method_27728().method_150();
        class_5321 worldKey = player.method_37908().method_27983();
        return this.getLockedAxisData(player, saveName, (class_5321<class_1937>)worldKey);
    }

    public void setEnabled(class_3222 player, Boolean enabled) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        String saveName = server.method_27728().method_150();
        this.getPlayerSaves(player).savesData().compute(saveName, (savedName, worldsData) -> {
            if (worldsData == null) {
                return new WorldsData(new ConcurrentHashMap<class_5321<class_1937>, LockedAxisData>(), enabled);
            }
            return new WorldsData(worldsData.worldData(), enabled);
        });
        this.method_80();
        class_5321 key = player.method_37908().method_27983();
        LockedAxisData data = PlayerState.get().getLockedAxisData(player);
        if (data == null) {
            return;
        }
        AxisLockManager.syncToClient(player, (class_5321<class_1937>)key, data, enabled);
    }

    public boolean getEnabled(class_3222 player) {
        return this.getWorldsData(player).enabled();
    }

    private Map<UUID, SavesData> getRawMap() {
        return this.playersData;
    }
}

