/*
 * Decompiled with CFR 0.152.
 */
package com.lumyverse.cobbleversebadges.screen.custom;

import com.lumyverse.cobbleversebadges.item.ModItems;
import com.lumyverse.cobbleversebadges.item.custom.SinnohBadgeBox;
import com.lumyverse.cobbleversebadges.screen.ModScreenHandlers;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class SinnohBadgeBoxScreenHandler
extends class_1703 {
    private final class_1799 badgeBoxStack;
    private final class_1263 inventory;
    private final class_7225.class_7874 registryLookup;
    private final class_1268 handUsed;
    private final int stackSlotIndex;
    private static final int BADGE_TROPHY_X = 20;
    private static final int BADGE_TROPHY_Y = 34;
    private static final int BADGE_ROW_X_START = 54;
    private static final int BADGE_ROW_1_Y = 23;
    private static final int BADGE_ROW_2_Y = 47;
    private static final int PLAYER_INVENTORY_X = 8;
    private static final int PLAYER_INVENTORY_Y = 86;
    private static final int HOTBAR_OFFSET_Y = 58;
    private static final int SLOT_SIZE_PX = 18;
    private static final int BADGE_SLOT_SPACING_X = 27;
    private static final String INVENTORY_KEY = "BadgeBoxInventory";
    private static final String SLOT_KEY = "Slot";

    public SinnohBadgeBoxScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_1799.field_8037, class_1268.field_5808);
    }

    public SinnohBadgeBoxScreenHandler(int syncId, class_1661 playerInventory, class_1799 badgeBoxStack) {
        this(syncId, playerInventory, badgeBoxStack, class_1268.field_5808);
    }

    public SinnohBadgeBoxScreenHandler(int syncId, class_1661 playerInventory, class_1799 badgeBoxStack, class_1268 hand) {
        super(ModScreenHandlers.SINNOH_BADGE_BOX_SCREEN_HANDLER, syncId);
        int i;
        this.handUsed = hand;
        this.badgeBoxStack = badgeBoxStack.method_7960() ? playerInventory.field_7546.method_5998(hand) : badgeBoxStack;
        this.stackSlotIndex = SinnohBadgeBoxScreenHandler.calculateStackSlot(playerInventory, this.badgeBoxStack, hand);
        class_1937 world = playerInventory.field_7546.method_37908();
        this.registryLookup = world.method_30349();
        this.inventory = new class_1277(9){

            public boolean method_5437(int slot, class_1799 stack) {
                return SinnohBadgeBoxScreenHandler.this.isValidForSlot(slot, stack);
            }
        };
        SinnohBadgeBoxScreenHandler.loadInventoryFromNbt(this.registryLookup, this.badgeBoxStack, this.inventory);
        this.method_7621(new BadgeBoxSlot(this.inventory, 0, 20, 34));
        for (i = 0; i < 4; ++i) {
            this.method_7621(new BadgeBoxSlot(this.inventory, i + 1, 54 + i * 27, 23));
        }
        for (i = 0; i < 4; ++i) {
            this.method_7621(new BadgeBoxSlot(this.inventory, i + 5, 54 + i * 27, 47));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int index = col + row * 9 + 9;
                int x = 8 + col * 18;
                int y = 86 + row * 18;
                this.addPlayerSlot(playerInventory, index, x, y);
            }
        }
        for (i = 0; i < 9; ++i) {
            int x = 8 + i * 18;
            int y = 144;
            this.addPlayerSlot(playerInventory, i, x, y);
        }
    }

    private void addPlayerSlot(class_1661 playerInventory, int index, int x, int y) {
        if (index == this.stackSlotIndex) {
            this.method_7621(new LockedSlot((class_1263)playerInventory, index, x, y));
        } else {
            this.method_7621(new class_1735((class_1263)playerInventory, index, x, y));
        }
    }

    private static int calculateStackSlot(class_1661 playerInventory, class_1799 stack, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return playerInventory.field_7545;
        }
        class_2371 mainInventory = playerInventory.field_7547;
        for (int i = 0; i < mainInventory.size(); ++i) {
            if (mainInventory.get(i) != stack) continue;
            return i;
        }
        if (playerInventory.field_7544.getFirst() == stack) {
            return 40;
        }
        return -1;
    }

    private boolean isValidForSlot(int slot, class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof SinnohBadgeBox) {
            return false;
        }
        return SinnohBadgeBoxScreenHandler.getExpectedItemForSlot(slot) == item;
    }

    public static class_1792 getExpectedItemForSlot(int slot) {
        return switch (slot) {
            case 0 -> ModItems.SINNOH_LEAGUE_TROPHY;
            case 1 -> ModItems.SINNOH_COAL_BADGE;
            case 2 -> ModItems.SINNOH_FOREST_BADGE;
            case 3 -> ModItems.SINNOH_COBBLE_BADGE;
            case 4 -> ModItems.SINNOH_FEN_BADGE;
            case 5 -> ModItems.SINNOH_RELIC_BADGE;
            case 6 -> ModItems.SINNOH_MINE_BADGE;
            case 7 -> ModItems.SINNOH_ICICLE_BADGE;
            case 8 -> ModItems.SINNOH_BEACON_BADGE;
            default -> null;
        };
    }

    public boolean method_7597(class_1657 player) {
        class_1799 stackAtSlot = player.method_31548().method_5438(this.stackSlotIndex);
        return !stackAtSlot.method_7960() && stackAtSlot.method_7909() instanceof SinnohBadgeBox;
    }

    public void method_7595(class_1657 player) {
        class_1735 targetSlot;
        super.method_7595(player);
        SinnohBadgeBoxScreenHandler.saveInventoryToNbt(this.registryLookup, this.badgeBoxStack, this.inventory);
        class_1799 stackInHand = player.method_5998(this.handUsed);
        if (stackInHand.method_7909() instanceof SinnohBadgeBox) {
            player.method_6122(this.handUsed, this.badgeBoxStack.method_7972());
        } else if (this.stackSlotIndex >= 0 && (targetSlot = (class_1735)this.field_7761.stream().filter(slot -> slot.field_7871 == player.method_31548() && slot.method_34266() == this.stackSlotIndex).findFirst().orElse(null)) != null && targetSlot.method_7677().method_7909() instanceof SinnohBadgeBox) {
            targetSlot.method_53512(this.badgeBoxStack.method_7972());
        }
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 originalStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot.method_7681()) {
            class_1799 stackInSlot = slot.method_7677();
            originalStack = stackInSlot.method_7972();
            if (slotIndex < 9) {
                if (!this.method_7616(stackInSlot, 9, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else {
                if (slotIndex == this.stackSlotIndex) {
                    return class_1799.field_8037;
                }
                if (!this.method_7616(stackInSlot, 0, 9, false) && (slotIndex < this.field_7761.size() - 9 ? !this.method_7616(stackInSlot, this.field_7761.size() - 9, this.field_7761.size(), false) : slotIndex < this.field_7761.size() && !this.method_7616(stackInSlot, 9, this.field_7761.size() - 9, false))) {
                    return class_1799.field_8037;
                }
            }
            if (stackInSlot.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stackInSlot.method_7947() == originalStack.method_7947()) {
                return class_1799.field_8037;
            }
            this.inventory.method_5431();
            slot.method_7667(player, stackInSlot);
        }
        return originalStack;
    }

    public static void saveInventoryToNbt(class_7225.class_7874 registryLookup, class_1799 stack, class_1263 inventory) {
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            DataResult result = class_1799.field_24671.encodeStart((DynamicOps)registryLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)itemStack);
            int currentSlotIndex = i;
            result.result().filter(class_2487.class::isInstance).map(class_2487.class::cast).ifPresent(nbtCompound -> {
                nbtCompound.method_10567(SLOT_KEY, (byte)currentSlotIndex);
                nbtList.add(nbtCompound);
            });
        }
        class_2487 customNbt = new class_2487();
        customNbt.method_10566(INVENTORY_KEY, (class_2520)nbtList);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customNbt));
    }

    public static void loadInventoryFromNbt(class_7225.class_7874 registryLookup, class_1799 stack, class_1263 inventory) {
        class_2487 nbt;
        class_9279 nbtComponent = (class_9279)stack.method_57824(class_9334.field_49628);
        if (nbtComponent != null && (nbt = nbtComponent.method_57461()).method_10545(INVENTORY_KEY)) {
            class_2499 nbtList = nbt.method_10554(INVENTORY_KEY, 10);
            inventory.method_5448();
            for (int i = 0; i < nbtList.size(); ++i) {
                int slot;
                class_2487 nbtCompound = nbtList.method_10602(i);
                if (!nbtCompound.method_10545(SLOT_KEY) || (slot = nbtCompound.method_10571(SLOT_KEY) & 0xFF) >= inventory.method_5439()) continue;
                class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbtCompound).ifPresent(loadedStack -> inventory.method_5447(slot, loadedStack));
            }
        }
    }

    private class BadgeBoxSlot
    extends class_1735 {
        private final int slotIndex;

        public BadgeBoxSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.slotIndex = index;
        }

        public boolean method_7680(class_1799 stack) {
            return SinnohBadgeBoxScreenHandler.this.isValidForSlot(this.slotIndex, stack);
        }

        public int method_7675() {
            return 1;
        }

        public int method_7676(class_1799 stack) {
            return 1;
        }
    }

    private static class LockedSlot
    extends class_1735 {
        public LockedSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public boolean method_7674(class_1657 playerEntity) {
            return false;
        }
    }
}

