/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.mikebartosh.minecraft.CoinBlock;
import us.mikebartosh.minecraft.CoinBlocks;
import us.mikebartosh.minecraft.CoinItems.Copper;
import us.mikebartosh.minecraft.CoinItems.Gold;
import us.mikebartosh.minecraft.CoinItems.Silver;
import us.mikebartosh.minecraft.Config;

public class CopperCoins
implements ModInitializer {
    public static final String MOD_ID = "copper-coins";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"copper-coins");
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("copper-coins.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Config CONFIG;
    public static class_1792 COPPER_COIN;
    public static class_1792 SILVER_COIN;
    public static class_1792 GOLD_COIN;
    public static class_2248 COPPER_COIN_BLOCK;
    public static class_2248 SILVER_COIN_BLOCK;
    public static class_2248 GOLD_COIN_BLOCK;

    public void onInitialize() {
        this.loadConfig();
        if (CopperCoins.CONFIG.enableCopper) {
            COPPER_COIN = new Copper(new class_1792.class_1793().method_7889(CopperCoins.CONFIG.maxCopperStack).method_7894(class_1814.field_8906));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "copper_coin"), (Object)COPPER_COIN);
            if (CopperCoins.CONFIG.enableCopperBlock) {
                COPPER_COIN_BLOCK = CoinBlocks.register((class_2248)new CoinBlock(class_4970.class_2251.method_9637().method_9626(class_2498.field_27204)), "copper_coins");
            }
        }
        if (CopperCoins.CONFIG.enableSilver) {
            SILVER_COIN = new Silver(new class_1792.class_1793().method_7889(CopperCoins.CONFIG.maxSilverStack).method_7894(class_1814.field_8907));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "silver_coin"), (Object)SILVER_COIN);
            if (CopperCoins.CONFIG.enableSilverBlock) {
                SILVER_COIN_BLOCK = CoinBlocks.register((class_2248)new CoinBlock(class_4970.class_2251.method_9637().method_9626(class_2498.field_11533)), "silver_coins");
            }
        }
        if (CopperCoins.CONFIG.enableGold) {
            GOLD_COIN = new Gold(new class_1792.class_1793().method_7889(CopperCoins.CONFIG.maxGoldStack).method_7894(class_1814.field_8904));
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960(MOD_ID, "gold_coin"), (Object)GOLD_COIN);
            if (CopperCoins.CONFIG.enableGoldBlock) {
                GOLD_COIN_BLOCK = CoinBlocks.register((class_2248)new CoinBlock(class_4970.class_2251.method_9637().method_9626(class_2498.field_11533)), "gold_coins");
            }
        }
        LOGGER.info("Mike's Copper Coins Loaded!");
    }

    private void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                CONFIG = (Config)GSON.fromJson(json, Config.class);
                LOGGER.info("Loaded config: {}", (Object)CONFIG_PATH);
            } else {
                CONFIG = new Config();
                this.saveConfig();
                LOGGER.info("Created default config: {}", (Object)CONFIG_PATH);
            }
        }
        catch (JsonSyntaxException | IOException e) {
            LOGGER.error("Failed to load config, using defaults", e);
            CONFIG = new Config();
        }
    }

    private void saveConfig() {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)CONFIG), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }
}

