/*
 * Decompiled with CFR 0.152.
 */
package net.armory_rpgs.datagen.recipe;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public record SmithingUpgradeRecipe(@SerializedName(value="fabric:load_conditions") List<FabricLoadCondition> fabricLoadConditions, @SerializedName(value="neoforge:conditions") List<NeoForgeCondition> neoforgeConditions, String type, ItemIngredient template, ItemIngredient base, ItemIngredient addition, ItemResult result) {
    public static final String TYPE = "minecraft:smithing_transform";

    public static SmithingUpgradeRecipe of(Item template, Item base, Item addition, Item result) {
        return new SmithingUpgradeRecipe(null, null, TYPE, ItemIngredient.of(template), ItemIngredient.of(base), ItemIngredient.of(addition), ItemResult.of(result));
    }

    public static SmithingUpgradeRecipe of(ItemLike template, ItemLike base, ItemLike addition, ItemLike result) {
        return SmithingUpgradeRecipe.of(template.asItem(), base.asItem(), addition.asItem(), result.asItem());
    }

    public static SmithingUpgradeRecipe ofStrings(String templateId, String baseId, String additionId, String resultId) {
        return new SmithingUpgradeRecipe(null, null, TYPE, new ItemIngredient(templateId), new ItemIngredient(baseId), new ItemIngredient(additionId), new ItemResult(resultId, 1));
    }

    public static SmithingUpgradeRecipe ofStringsWithConditions(String templateId, String baseId, String additionId, String resultId, String ... requiredModIds) {
        List<FabricLoadCondition> fabricConditions = null;
        List<NeoForgeCondition> neoforgeConditions = null;
        if (requiredModIds != null && requiredModIds.length > 0) {
            fabricConditions = List.of(FabricLoadCondition.allModsLoaded(requiredModIds));
            neoforgeConditions = List.of(requiredModIds).stream().map(NeoForgeCondition::modLoaded).toList();
        }
        return new SmithingUpgradeRecipe(fabricConditions, neoforgeConditions, TYPE, new ItemIngredient(templateId), new ItemIngredient(baseId), new ItemIngredient(additionId), new ItemResult(resultId, 1));
    }

    public static SmithingUpgradeRecipe withConditions(Item template, Item base, Item addition, Item result, List<FabricLoadCondition> fabricConditions, List<NeoForgeCondition> neoforgeConditions) {
        return new SmithingUpgradeRecipe(fabricConditions, neoforgeConditions, TYPE, ItemIngredient.of(template), ItemIngredient.of(base), ItemIngredient.of(addition), ItemResult.of(result));
    }

    public record ItemIngredient(String item) {
        public static ItemIngredient of(Item item) {
            return new ItemIngredient(BuiltInRegistries.ITEM.getKey((Object)item).toString());
        }

        public static ItemIngredient of(ItemLike item) {
            return ItemIngredient.of(item.asItem());
        }

        public static ItemIngredient of(ResourceLocation id) {
            return new ItemIngredient(id.toString());
        }
    }

    public record ItemResult(String id, int count) {
        public static ItemResult of(Item item, int count) {
            return new ItemResult(BuiltInRegistries.ITEM.getKey((Object)item).toString(), count);
        }

        public static ItemResult of(ItemLike item, int count) {
            return ItemResult.of(item.asItem(), count);
        }

        public static ItemResult of(Item item) {
            return ItemResult.of(item, 1);
        }

        public static ItemResult of(ItemLike item) {
            return ItemResult.of(item.asItem(), 1);
        }
    }

    public record FabricLoadCondition(String condition, List<String> values) {
        public static FabricLoadCondition allModsLoaded(String ... modIds) {
            return new FabricLoadCondition("fabric:all_mods_loaded", List.of(modIds));
        }

        public static FabricLoadCondition allModsLoaded(List<String> modIds) {
            return new FabricLoadCondition("fabric:all_mods_loaded", modIds);
        }
    }

    public record NeoForgeCondition(String type, String modid) {
        public static NeoForgeCondition modLoaded(String modId) {
            return new NeoForgeCondition("neoforge:mod_loaded", modId);
        }
    }
}

