/*
 * Decompiled with CFR 0.152.
 */
package net.armory_rpgs.datagen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.armory_rpgs.datagen.recipe.SmithingRecipeProvider;
import net.armory_rpgs.datagen.recipe.SmithingUpgradeRecipe;
import net.armory_rpgs.item.ArmorSets;
import net.armory_rpgs.item.FightClass;
import net.armory_rpgs.item.Group;
import net.armory_rpgs.item.SmithingTemplates;
import net.armory_rpgs.item.SmtihingIngredients;
import net.armory_rpgs.spell.ArmoryEffects;
import net.armory_rpgs.spell.ArmorySounds;
import net.armory_rpgs.spell.ArmorySpells;
import net.armory_rpgs.spell.SetBonuses;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4943;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.set.EquipmentSet;
import net.spell_engine.api.item.set.EquipmentSetRegistry;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;

public class ArmoryDataGen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(SpellTagGenerator::new);
        pack.addProvider(LangGenerator::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(SpellGen::new);
        pack.addProvider(SoundGen::new);
        pack.addProvider(EquipmentSetGenerator::new);
        pack.addProvider(RecipeGenerator::new);
        pack.addProvider(SmithGen::new);
    }

    private static List<class_1792> allArmorPieces() {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        for (Armor.Entry entry : ArmorSets.entries) {
            entry.armorSet().pieces().forEach(item -> items.add((class_1792)item));
        }
        return items;
    }

    public static class SmithGen
    extends SmithingRecipeProvider {
        public Map<FightClass, List<Upgrade>> UPGRADES = Map.of(FightClass.ARCHER, List.of(new Upgrade(new ArmorIdSet("archers", "ranger_armor"), ArmorSets.strider.armorSet(), null)), FightClass.ARCANE_WIZARD, List.of(new Upgrade(new ArmorIdSet("wizards", "arcane_robe"), ArmorSets.astral.armorSet(), null)), FightClass.FIRE_WIZARD, List.of(new Upgrade(new ArmorIdSet("wizards", "fire_robe"), ArmorSets.scarlet.armorSet(), null)), FightClass.FROST_WIZARD, List.of(new Upgrade(new ArmorIdSet("wizards", "frost_robe"), ArmorSets.glacier.armorSet(), null)), FightClass.PRIEST, List.of(new Upgrade(new ArmorIdSet("paladins", "prior_robe"), ArmorSets.avatar.armorSet(), null)), FightClass.PALADIN, List.of(new Upgrade(new ArmorIdSet("paladins", "crusader_armor"), ArmorSets.justicar.armorSet(), null)), FightClass.ROGUE, List.of(new Upgrade(new ArmorIdSet("rogues", "assassin_armor"), ArmorSets.deathmantle.armorSet(), null)), FightClass.WARRIOR, List.of(new Upgrade(new ArmorIdSet("rogues", "berserker_armor"), ArmorSets.destroyer.armorSet(), null)));

        public SmithGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        @Override
        public void generateRecipes(SmithingRecipeProvider.Builder builder) {
            HashMap autoAssignedUpgrades = new HashMap();
            this.UPGRADES.forEach((fightClass, upgrades) -> {
                ArrayList<Upgrade> newList = new ArrayList<Upgrade>();
                for (Upgrade upgrade : upgrades) {
                    if (upgrade.ingredient != null) continue;
                    SmtihingIngredients.UpgradeCrystal ingredient = ((SmtihingIngredients.Entry)SmtihingIngredients.ENTRIES.stream().filter(entry -> entry.classes().contains(fightClass)).findFirst().orElse(null)).item().get();
                    newList.add(new Upgrade(upgrade.from, upgrade.to, ingredient));
                }
                autoAssignedUpgrades.put(fightClass, newList);
            });
            boolean includeNetherite = true;
            for (SmithingTemplates.Entry template : SmithingTemplates.ENTRIES) {
                for (Map.Entry entry : autoAssignedUpgrades.entrySet()) {
                    class_2960 id;
                    class_2960 itemId;
                    SmithingUpgradeRecipe builderEntry;
                    String ingredientId;
                    FightClass figthClass = (FightClass)((Object)entry.getKey());
                    ArrayList<Upgrade> upgrades2 = (ArrayList<Upgrade>)entry.getValue();
                    if (upgrades2 == null) continue;
                    if (includeNetherite) {
                        ArrayList<Upgrade> list = new ArrayList<Upgrade>(upgrades2);
                        for (Upgrade upgrade : upgrades2) {
                            list.add(upgrade.prefixVariant("netherite"));
                        }
                        upgrades2 = list;
                    }
                    for (Upgrade upgradeType : upgrades2) {
                        ingredientId = ((class_5321)upgradeType.ingredient().method_40131().method_40230().get()).method_29177().toString();
                        builderEntry = SmithingUpgradeRecipe.ofStringsWithConditions(template.id().toString(), upgradeType.from.headId().toString(), ingredientId, upgradeType.to.idOf(upgradeType.to.head).toString(), upgradeType.from.namespace());
                        itemId = upgradeType.to.idOf(upgradeType.to.head);
                        id = class_2960.method_60655((String)itemId.method_12836(), (String)("smithing_" + itemId.method_12832() + "_" + upgradeType.from.headId().method_12832()));
                        builder.entries.add(new SmithingRecipeProvider.Entry(id, builderEntry));
                    }
                    for (Upgrade upgradeType : upgrades2) {
                        ingredientId = ((class_5321)upgradeType.ingredient().method_40131().method_40230().get()).method_29177().toString();
                        builderEntry = SmithingUpgradeRecipe.ofStringsWithConditions(template.id().toString(), upgradeType.from.chestId().toString(), ingredientId, upgradeType.to.idOf(upgradeType.to.chest).toString(), upgradeType.from.namespace());
                        itemId = upgradeType.to.idOf(upgradeType.to.chest);
                        id = class_2960.method_60655((String)itemId.method_12836(), (String)("smithing_" + itemId.method_12832() + "_" + upgradeType.from.chestId().method_12832()));
                        builder.entries.add(new SmithingRecipeProvider.Entry(id, builderEntry));
                    }
                    for (Upgrade upgradeType : upgrades2) {
                        ingredientId = ((class_5321)upgradeType.ingredient().method_40131().method_40230().get()).method_29177().toString();
                        builderEntry = SmithingUpgradeRecipe.ofStringsWithConditions(template.id().toString(), upgradeType.from.legsId().toString(), ingredientId, upgradeType.to.idOf(upgradeType.to.legs).toString(), upgradeType.from.namespace());
                        itemId = upgradeType.to.idOf(upgradeType.to.legs);
                        id = class_2960.method_60655((String)itemId.method_12836(), (String)("smithing_" + itemId.method_12832() + "_" + upgradeType.from.legsId().method_12832()));
                        builder.entries.add(new SmithingRecipeProvider.Entry(id, builderEntry));
                    }
                    for (Upgrade upgradeType : upgrades2) {
                        ingredientId = ((class_5321)upgradeType.ingredient().method_40131().method_40230().get()).method_29177().toString();
                        builderEntry = SmithingUpgradeRecipe.ofStringsWithConditions(template.id().toString(), upgradeType.from.feetId().toString(), ingredientId, upgradeType.to.idOf(upgradeType.to.feet).toString(), upgradeType.from.namespace());
                        itemId = upgradeType.to.idOf(upgradeType.to.feet);
                        id = class_2960.method_60655((String)itemId.method_12836(), (String)("smithing_" + itemId.method_12832() + "_" + upgradeType.from.feetId().method_12832()));
                        builder.entries.add(new SmithingRecipeProvider.Entry(id, builderEntry));
                    }
                }
            }
        }

        public record Upgrade(ArmorIdSet from, Armor.Set to, class_1792 ingredient) {
            public Upgrade prefixVariant(String variant) {
                return new Upgrade(new ArmorIdSet(this.from.namespace(), variant + "_" + this.from.name()), this.to, this.ingredient);
            }
        }

        public record ArmorIdSet(String namespace, String name) {
            public class_2960 headId() {
                return class_2960.method_60655((String)this.namespace, (String)(this.name + "_" + class_1304.field_6169.method_15434().toLowerCase()));
            }

            public class_2960 chestId() {
                return class_2960.method_60655((String)this.namespace, (String)(this.name + "_" + class_1304.field_6174.method_15434().toLowerCase()));
            }

            public class_2960 legsId() {
                return class_2960.method_60655((String)this.namespace, (String)(this.name + "_" + class_1304.field_6172.method_15434().toLowerCase()));
            }

            public class_2960 feetId() {
                return class_2960.method_60655((String)this.namespace, (String)(this.name + "_" + class_1304.field_6166.method_15434().toLowerCase()));
            }
        }
    }

    public static class RecipeGenerator
    extends FabricRecipeProvider {
        public RecipeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 recipeExporter) {
            SmithingTemplates.ENTRIES.forEach(entry -> FabricRecipeProvider.method_48533((class_8790)recipeExporter, (class_1935)((class_1935)entry.item().get()), (class_1935)class_1802.field_8477));
        }
    }

    public static class EquipmentSetGenerator
    extends FabricDynamicRegistryProvider {
        public EquipmentSetGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void configure(class_7225.class_7874 registries, FabricDynamicRegistryProvider.Entries entries) {
            class_7871 itemLookup = registries.method_46758().method_46751(class_7924.field_41197);
            for (SetBonuses.Entry set : SetBonuses.all) {
                class_6885.class_6886 items = class_6885.method_40242(set.itemSupplier().get().stream().map(id -> itemLookup.method_46747(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)id))).toList());
                entries.add(class_5321.method_29179((class_5321)EquipmentSetRegistry.KEY, (class_2960)set.id()), (Object)new EquipmentSet.Definition(set.id().method_12832(), (class_6885)items, set.bonuses()));
            }
        }

        public String method_10321() {
            return "Equipment Set Generator";
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("armory_rpgs", ArmorySounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().method_12832(), (int)entry.variants())).toList()));
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (ArmorySpells.Entry entry : ArmorySpells.all) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class ModelProvider
    extends FabricModelProvider {
        public ModelProvider(FabricDataOutput output) {
            super(output);
        }

        public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        }

        public void generateItemModels(class_4915 itemModelGenerator) {
            SmtihingIngredients.ENTRIES.forEach(entry -> itemModelGenerator.method_25733((class_1792)entry.item().get(), class_4943.field_22938));
            SmithingTemplates.ENTRIES.forEach(entry -> itemModelGenerator.method_25733((class_1792)entry.item().get(), class_4943.field_22938));
            ArmorSets.entries.forEach(entry -> {
                for (Object piece : entry.armorSet().pieces()) {
                    itemModelGenerator.method_25733((class_1792)piece, class_4943.field_22938);
                }
            });
        }
    }

    public static class LangGenerator
    extends FabricLanguageProvider {
        protected LangGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, "en_us", registryLookup);
        }

        public void generateTranslations(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
            translationBuilder.add(Group.translationKey, "Armory");
            translationBuilder.add(SmtihingIngredients.UpgradeCrystal.HINT_TRANSLATION_KEY, "Armor upgrade crystal");
            SmtihingIngredients.ENTRIES.forEach(entry -> {
                translationBuilder.add(entry.item().get().method_7876(), entry.translations().itemName());
                translationBuilder.add(entry.appliesToTranslationKey(), entry.appliesToClassesTranslation());
            });
            SmithingTemplates.ENTRIES.forEach(entry -> {
                translationBuilder.add(entry.item().get().method_7876(), entry.translations().itemName());
                translationBuilder.add(entry.upgradeTranslationKey(), entry.translations().upgradeName());
                translationBuilder.add(entry.baseSlotDescriptionTranslationKey(), entry.translations().baseSlotDescription());
                translationBuilder.add(entry.additionsSlotDescriptionTranslationKey(), entry.translations().additionsSlotDescription());
                translationBuilder.add(entry.appliesToTranslationKey(), entry.translations().appliesTo());
                translationBuilder.add(entry.ingredientsTranslationKey(), entry.translations().ingredients());
            });
            ArmorSets.entries.forEach(entry -> {
                LinkedHashMap<String, String> translations = new LinkedHashMap<String, String>();
                translations.put(entry.armorSet().head.method_7876(), entry.armorSet().headTranslation);
                translations.put(entry.armorSet().chest.method_7876(), entry.armorSet().chestTranslation);
                translations.put(entry.armorSet().legs.method_7876(), entry.armorSet().legsTranslation);
                translations.put(entry.armorSet().feet.method_7876(), entry.armorSet().feetTranslation);
                for (Map.Entry armorEntry : translations.entrySet()) {
                    translationBuilder.add((String)armorEntry.getKey(), (String)armorEntry.getValue());
                }
            });
            SetBonuses.all.forEach(entry -> translationBuilder.add(EquipmentSet.translationKey((class_2960)entry.id()), entry.title()));
            ArmorySpells.all.forEach(entry -> {
                class_2960 id = entry.id();
                translationBuilder.add("spell." + id.method_12836() + "." + id.method_12832() + ".name", entry.title());
                translationBuilder.add("spell." + id.method_12836() + "." + id.method_12832() + ".description", entry.description());
            });
            ArmoryEffects.entries.forEach(entry -> {
                translationBuilder.add(entry.effect.method_5567(), entry.title);
                translationBuilder.add(entry.effect.method_5567() + ".description", entry.description);
            });
        }
    }

    public static class SpellTagGenerator
    extends FabricTagProvider<Spell> {
        public SpellTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, SpellRegistry.KEY, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            ArmorySpells.all.forEach(entry -> {
                for (ArmorySpells.Category category : entry.categories()) {
                    class_6862 tagKey = class_6862.method_40092((class_5321)SpellRegistry.KEY, (class_2960)class_2960.method_60655((String)"armory_rpgs", (String)category.toString().toLowerCase()));
                    FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tagKey);
                    tag.addOptional(entry.id());
                }
            });
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            this.generateArmorTags(ArmorSets.entries.stream().filter(entry -> entry.name().contains("archer")).toList(), RPGSeriesItemTags.ArmorMetaType.ARCHERY);
            this.generateArmorTags(ArmorSets.entries.stream().filter(entry -> entry.name().contains("armor")).toList(), RPGSeriesItemTags.ArmorMetaType.MELEE);
            this.generateArmorTags(ArmorSets.entries.stream().filter(entry -> entry.name().contains("robe")).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC);
            class_6862 tierTag = RPGSeriesItemTags.LootTiers.get((int)ArmorSets.astral.lootProperties().tier(), (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS);
            SmithingTemplates.ENTRIES.forEach(entry -> {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tierTag);
                tag.addOptional(entry.id());
            });
            SmtihingIngredients.ENTRIES.forEach(entry -> {
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(tierTag);
                tag.addOptional(entry.id());
            });
        }
    }
}

