/*
 * Decompiled with CFR 0.152.
 */
package net.armory_rpgs.datagen.recipe;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public record SmithingUpgradeRecipe(@SerializedName(value="fabric:load_conditions") List<FabricLoadCondition> fabricLoadConditions, @SerializedName(value="neoforge:conditions") List<NeoForgeCondition> neoforgeConditions, String type, ItemIngredient template, ItemIngredient base, ItemIngredient addition, ItemResult result) {
    public static final String TYPE = "minecraft:smithing_transform";

    public static SmithingUpgradeRecipe of(class_1792 template, class_1792 base, class_1792 addition, class_1792 result) {
        return new SmithingUpgradeRecipe(null, null, TYPE, ItemIngredient.of(template), ItemIngredient.of(base), ItemIngredient.of(addition), ItemResult.of(result));
    }

    public static SmithingUpgradeRecipe of(class_1935 template, class_1935 base, class_1935 addition, class_1935 result) {
        return SmithingUpgradeRecipe.of(template.method_8389(), base.method_8389(), addition.method_8389(), result.method_8389());
    }

    public static SmithingUpgradeRecipe ofStrings(String templateId, String baseId, String additionId, String resultId) {
        return new SmithingUpgradeRecipe(null, null, TYPE, new ItemIngredient(templateId), new ItemIngredient(baseId), new ItemIngredient(additionId), new ItemResult(resultId, 1));
    }

    public static SmithingUpgradeRecipe ofStringsWithConditions(String templateId, String baseId, String additionId, String resultId, String ... requiredModIds) {
        List<FabricLoadCondition> fabricConditions = null;
        List<NeoForgeCondition> neoforgeConditions = null;
        if (requiredModIds != null && requiredModIds.length > 0) {
            fabricConditions = List.of(FabricLoadCondition.allModsLoaded(requiredModIds));
            neoforgeConditions = List.of(requiredModIds).stream().map(NeoForgeCondition::modLoaded).toList();
        }
        return new SmithingUpgradeRecipe(fabricConditions, neoforgeConditions, TYPE, new ItemIngredient(templateId), new ItemIngredient(baseId), new ItemIngredient(additionId), new ItemResult(resultId, 1));
    }

    public static SmithingUpgradeRecipe withConditions(class_1792 template, class_1792 base, class_1792 addition, class_1792 result, List<FabricLoadCondition> fabricConditions, List<NeoForgeCondition> neoforgeConditions) {
        return new SmithingUpgradeRecipe(fabricConditions, neoforgeConditions, TYPE, ItemIngredient.of(template), ItemIngredient.of(base), ItemIngredient.of(addition), ItemResult.of(result));
    }

    public record ItemIngredient(String item) {
        public static ItemIngredient of(class_1792 item) {
            return new ItemIngredient(class_7923.field_41178.method_10221((Object)item).toString());
        }

        public static ItemIngredient of(class_1935 item) {
            return ItemIngredient.of(item.method_8389());
        }

        public static ItemIngredient of(class_2960 id) {
            return new ItemIngredient(id.toString());
        }
    }

    public record ItemResult(String id, int count) {
        public static ItemResult of(class_1792 item, int count) {
            return new ItemResult(class_7923.field_41178.method_10221((Object)item).toString(), count);
        }

        public static ItemResult of(class_1935 item, int count) {
            return ItemResult.of(item.method_8389(), count);
        }

        public static ItemResult of(class_1792 item) {
            return ItemResult.of(item, 1);
        }

        public static ItemResult of(class_1935 item) {
            return ItemResult.of(item.method_8389(), 1);
        }
    }

    public record FabricLoadCondition(String condition, List<String> values) {
        public static FabricLoadCondition allModsLoaded(String ... modIds) {
            return new FabricLoadCondition("fabric:all_mods_loaded", List.of(modIds));
        }

        public static FabricLoadCondition allModsLoaded(List<String> modIds) {
            return new FabricLoadCondition("fabric:all_mods_loaded", modIds);
        }
    }

    public record NeoForgeCondition(String type, String modid) {
        public static NeoForgeCondition modLoaded(String modId) {
            return new NeoForgeCondition("neoforge:mod_loaded", modId);
        }
    }
}

